/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDto;

public class ChildEntityDtoResultTransformer
implements TupleTransformer<ChildEntityDto>,
ResultListTransformer<ChildEntityDto> {
    private final Map<Long, ChildEntityDto> childEntityDtoMap = new LinkedHashMap<Long, ChildEntityDto>();
    private final ClipboardPayload clipboardPayload;
    private int entitiesCount = 0;

    public ChildEntityDtoResultTransformer(ClipboardPayload clipboardPayload) {
        this.clipboardPayload = clipboardPayload;
    }

    public ChildEntityDto transformTuple(Object[] tuple, String[] aliases) {
        TreeNode treeNode = (TreeNode)tuple[0];
        Long id = (Long)tuple[1];
        ++this.entitiesCount;
        if (!this.clipboardPayload.shouldWhiteListBeIgnored() && !this.clipboardPayload.getWhiteListNodeIds().contains(treeNode.getId())) {
            return null;
        }
        ChildEntityDto childEntityDto = this.childEntityDtoMap.computeIfAbsent(id, k -> new ChildEntityDto(id));
        childEntityDto.getChildren().add(treeNode);
        return childEntityDto;
    }

    public List<ChildEntityDto> transformList(List<ChildEntityDto> collection) {
        return new ArrayList<ChildEntityDto>(this.childEntityDtoMap.values());
    }

    public int getEntitiesCount() {
        return this.entitiesCount;
    }
}

