/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.chart;

import com.google.common.collect.ImmutableMap;
import com.querydsl.core.Tuple;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.chart.AxisColumn;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartSeries;
import org.squashtest.tm.domain.chart.MeasureColumn;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.InfoListItemDao;

@Component
@Scope(value="prototype")
class TupleProcessor {
    private static final String TRUE_COLOR = "#277da1";
    private static final String FALSE_COLOR = "#f9c74f";
    private static final Map<ExecutionStatus, Integer> EXECUTION_STATUS_ORDER = new ImmutableMap.Builder().put((Object)ExecutionStatus.READY, (Object)1).put((Object)ExecutionStatus.RUNNING, (Object)2).put((Object)ExecutionStatus.SUCCESS, (Object)3).put((Object)ExecutionStatus.SETTLED, (Object)4).put((Object)ExecutionStatus.WARNING, (Object)5).put((Object)ExecutionStatus.FAILURE, (Object)6).put((Object)ExecutionStatus.BLOCKED, (Object)7).put((Object)ExecutionStatus.ERROR, (Object)8).put((Object)ExecutionStatus.UNTESTABLE, (Object)9).put((Object)ExecutionStatus.NOT_RUN, (Object)10).put((Object)ExecutionStatus.NOT_FOUND, (Object)11).build();
    @Inject
    private InfoListItemDao infoListItemDao;
    @Inject
    private CustomFieldDao customFieldDao;
    ChartDefinition definition;
    private boolean initialized = false;
    private Comparator<Tuple> tupleComparator = null;
    private Consumer<Object[]> abscissaValuePostProcessor = null;
    private List<Object[]> abscissa;
    private List<List<Object>> series;
    private List<String> colours = new ArrayList<String>();

    TupleProcessor() {
    }

    TupleProcessor setDefinition(ChartDefinition definition) {
        this.definition = definition;
        return this;
    }

    TupleProcessor initialize() {
        if (this.definition == null) {
            throw new IllegalStateException("no definition given to the TupleProcessor, this is a programming error");
        }
        this.initializeTupleSorter();
        this.initializeAbscissaPostProcessors();
        this.initialized = true;
        return this;
    }

    TupleProcessor process(List<Tuple> tuples) {
        if (!this.initialized) {
            throw new IllegalStateException("TupleProcessor is not initialized, this is a programming error");
        }
        List<Tuple> sortedTuples = this.sortTuples(tuples);
        this.extractAbscissaAndSeries(sortedTuples);
        this.extractColours();
        this.postProcessAbscissa();
        return this;
    }

    ChartSeries createChartSeries() {
        if (this.abscissa == null) {
            throw new IllegalStateException("TupleProcessor has not yet processed anything, this is a programming error");
        }
        int nbMeasures = this.definition.getMeasures().size();
        ChartSeries chartSeries = new ChartSeries();
        chartSeries.setAbscissa(this.abscissa);
        chartSeries.setColours(this.colours);
        int mIdx = 0;
        while (mIdx < nbMeasures) {
            MeasureColumn measure = (MeasureColumn)this.definition.getMeasures().get(mIdx);
            chartSeries.addSerie(measure.getLabel(), this.series.get(mIdx));
            ++mIdx;
        }
        return chartSeries;
    }

    private void initializeTupleSorter() {
        List axisColumn = this.definition.getAxis();
        Comparator<Tuple> mainComparator = null;
        int idx = 0;
        while (idx < axisColumn.size()) {
            Comparator<Tuple> inLoopComparator;
            AxisColumn axis = (AxisColumn)axisColumn.get(idx);
            switch (axis.getDataType()) {
                case LEVEL_ENUM: 
                case REQUIREMENT_STATUS: {
                    Comparator<Tuple> comparator = Comparator.comparing(this.levelExtractor(idx), Comparator.nullsFirst(this::compareLevelEnum));
                    break;
                }
                case EXECUTION_STATUS: {
                    Comparator<Tuple> comparator = Comparator.comparing(this.execStatusExtractor(idx), Comparator.nullsFirst(this::compareExecutionStatus));
                    break;
                }
                case EXISTENCE: 
                case BOOLEAN: {
                    Comparator<Tuple> comparator = Comparator.comparing(this.boolExtractor(idx), Comparator.nullsFirst(this::compareBoolean));
                    break;
                }
                case BOOLEAN_AS_STRING: {
                    Comparator<Tuple> comparator = Comparator.comparing(this.boolAsStringExtractor(idx), Comparator.nullsFirst(this::compareBoolean));
                    break;
                }
                default: {
                    Comparator<Tuple> comparator = inLoopComparator = Comparator.comparing(this.defaultExtractor(idx), Comparator.nullsFirst(Comparator.naturalOrder()));
                }
            }
            if (inLoopComparator != null) {
                mainComparator = mainComparator == null ? inLoopComparator : mainComparator.thenComparing(inLoopComparator);
            }
            ++idx;
        }
        this.tupleComparator = mainComparator;
    }

    private void initializeAbscissaPostProcessors() {
        List axisColumns = this.definition.getAxis();
        Consumer<Object[]> mainPostprocessor = null;
        int idx = 0;
        while (idx < axisColumns.size()) {
            AxisColumn axis = (AxisColumn)axisColumns.get(idx);
            Consumer<Object[]> inLoopPostProcessor = null;
            if (Objects.requireNonNull(axis.getDataType()) == DataType.INFO_LIST_ITEM) {
                inLoopPostProcessor = this.fnReplaceCodeWithLabel(idx);
            }
            if (inLoopPostProcessor != null) {
                mainPostprocessor = mainPostprocessor == null ? inLoopPostProcessor : mainPostprocessor.andThen(inLoopPostProcessor);
            }
            ++idx;
        }
        this.abscissaValuePostProcessor = mainPostprocessor;
    }

    private boolean isResortableType(DataType type) {
        return type.isAssignableToLevelEnum() || type == DataType.BOOLEAN || type == DataType.EXISTENCE || type == DataType.BOOLEAN_AS_STRING;
    }

    private boolean isResortRequired() {
        List axisColumns = this.definition.getAxis();
        return axisColumns.stream().map(AxisColumn::getDataType).anyMatch(this::isResortableType);
    }

    private List<Tuple> sortTuples(List<Tuple> original) {
        if (this.isResortRequired()) {
            ArrayList<Tuple> sorted = new ArrayList<Tuple>(original);
            sorted.sort(this.tupleComparator);
            return sorted;
        }
        return original;
    }

    private boolean isPostProcessableType(DataType type) {
        return type == DataType.INFO_LIST_ITEM;
    }

    private boolean isPostProcessingRequired() {
        List aggregationColumns = this.definition.getAxis();
        return aggregationColumns.stream().map(AxisColumn::getDataType).anyMatch(this::isPostProcessableType);
    }

    private void postProcessAbscissa() {
        if (this.isPostProcessingRequired()) {
            for (Object[] entry : this.abscissa) {
                this.abscissaValuePostProcessor.accept(entry);
            }
        }
    }

    private void extractColours() {
        List axis = this.definition.getAxis();
        int lastIndex = axis.size() - 1;
        AxisColumn lastAxis = (AxisColumn)axis.get(lastIndex);
        switch (lastAxis.getDataType()) {
            case LIST: {
                this.extractListColours(lastIndex, lastAxis);
                break;
            }
            case INFO_LIST_ITEM: {
                this.extractInfoListItemColours(lastIndex);
                break;
            }
            case BOOLEAN_AS_STRING: {
                this.extractBooleanAsStringColours(lastIndex);
                break;
            }
            case EXISTENCE: 
            case BOOLEAN: {
                this.extractBooleanColours(lastIndex);
                break;
            }
        }
    }

    private void extractListColours(int lastIndex, AxisColumn lastAxis) {
        SingleSelectField cuf = this.customFieldDao.findSingleSelectFieldById(lastAxis.getCufId());
        List<String> axisValues = ((Stream)this.abscissa.stream().sequential()).map(entry -> entry[lastIndex].toString()).distinct().toList();
        this.colours = ((Stream)axisValues.stream().sequential()).map(arg_0 -> ((SingleSelectField)cuf).findColourOf(arg_0)).toList();
    }

    private void extractInfoListItemColours(int lastIndex) {
        List<String> axisValues = ((Stream)this.abscissa.stream().sequential()).map(entry -> entry[lastIndex].toString()).distinct().toList();
        List<InfoListItem> items = this.infoListItemDao.findByCodeIn(axisValues);
        for (String code : axisValues) {
            for (InfoListItem item : items) {
                if (!item.getCode().equals(code)) continue;
                this.colours.add(item.getColour());
            }
        }
    }

    private void extractBooleanAsStringColours(int lastIndex) {
        this.colours = this.abscissa.stream().map(entry -> entry[lastIndex].toString()).distinct().map(this::findColourOfBooleanAsString).toList();
    }

    private void extractBooleanColours(int lastIndex) {
        this.colours = this.abscissa.stream().map(entry -> (Boolean)entry[lastIndex]).distinct().map(this::findColourOfBoolean).toList();
    }

    private String findColourOfBooleanAsString(String booleanAsStringValue) {
        return this.findColourOfBoolean(Boolean.TRUE.toString().equals(booleanAsStringValue));
    }

    private String findColourOfBoolean(Boolean booleanValue) {
        return Boolean.TRUE.equals(booleanValue) ? TRUE_COLOR : FALSE_COLOR;
    }

    private void extractAbscissaAndSeries(List<Tuple> tuples) {
        int nbAxes = this.definition.getAxis().size();
        int nbMeasures = this.definition.getMeasures().size();
        this.abscissa = new ArrayList<Object[]>();
        this.series = new ArrayList<List<Object>>();
        int me = 0;
        while (me < nbMeasures) {
            ArrayList serie = new ArrayList(tuples.size());
            this.series.add(serie);
            ++me;
        }
        for (Tuple tuple : tuples) {
            Object[] axis = new Object[nbAxes];
            int aIdx = 0;
            while (aIdx < nbAxes) {
                axis[aIdx] = tuple.get(aIdx, Object.class);
                ++aIdx;
            }
            this.abscissa.add(axis);
            int sIdx = 0;
            while (sIdx < nbMeasures) {
                List<Object> serie = this.series.get(sIdx);
                Object measureValue = tuple.get(sIdx + nbAxes, Object.class);
                serie.add(measureValue);
                ++sIdx;
            }
        }
    }

    private Function<Tuple, Comparable> defaultExtractor(int index) {
        return tuple -> (Comparable)tuple.get(index, Comparable.class);
    }

    private Function<Tuple, Level> levelExtractor(int index) {
        return tuple -> (Level)tuple.get(index, Level.class);
    }

    private Function<Tuple, ExecutionStatus> execStatusExtractor(int index) {
        return tuple -> (ExecutionStatus)tuple.get(index, ExecutionStatus.class);
    }

    private Function<Tuple, Boolean> boolExtractor(int index) {
        return tuple -> (Boolean)tuple.get(index, Boolean.class);
    }

    private Function<Tuple, Boolean> boolAsStringExtractor(int index) {
        return tuple -> Boolean.TRUE.toString().equals(tuple.get(index, String.class));
    }

    private int compareLevelEnum(Level level1, Level level2) {
        return level1.getLevel() - level2.getLevel();
    }

    private int compareExecutionStatus(ExecutionStatus status1, ExecutionStatus status2) {
        Integer order1 = EXECUTION_STATUS_ORDER.get(status1);
        Integer order2 = EXECUTION_STATUS_ORDER.get(status2);
        return order1 - order2;
    }

    private int compareBoolean(boolean value1, boolean value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 ? -1 : 1;
    }

    private Consumer<Object[]> fnReplaceCodeWithLabel(int index) {
        return aObject -> {
            String code = (String)aObject[index];
            if (code != null) {
                InfoListItem infoListItem = this.infoListItemDao.findByCode(code);
                String label = infoListItem.getLabel();
                aObject[n] = label;
            }
        };
    }
}

