/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.internal.campaign.SprintManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.deletion.JdbcSprintReqVersionDeletionHandlerFactory;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.dto.SprintReqVersionsBindingExceptionSummary;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.SprintRequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Transactional
@Service(value="SprintManagerService")
public class SprintManagerServiceImpl
implements SprintManagerService {
    @Inject
    private SprintReqVersionDao sprintReqVersionDao;
    @Inject
    private SprintDao sprintDao;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao;
    @Inject
    SprintDisplayDao sprintDisplayDao;
    @Inject
    private JdbcSprintReqVersionDeletionHandlerFactory sprintReqVersionDeletionHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'LINK') or hasRole('ROLE_ADMIN')")
    public List<SprintReqVersionDto> bindRequirementsByRlnIds(Long sprintId, List<Long> rlnIds, SprintReqVersionsBindingExceptionSummary summary) {
        List<RequirementVersion> reqVersions = this.findRequirementVersionsFromRlnIds(rlnIds);
        return this.bindRequirements(sprintId, reqVersions, summary);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'LINK') or hasRole('ROLE_ADMIN')")
    public List<SprintReqVersionDto> bindRequirementsByReqVersionIds(Long sprintId, List<Long> reqVersionIds, SprintReqVersionsBindingExceptionSummary summary) {
        List<RequirementVersion> reqVersions = this.findRequirementVersions(reqVersionIds);
        return this.bindRequirements(sprintId, reqVersions, summary);
    }

    private List<SprintReqVersionDto> bindRequirements(Long sprintId, List<RequirementVersion> reqVersions, SprintReqVersionsBindingExceptionSummary summary) {
        ArrayList<RequirementVersion> reqVersionsToSave = new ArrayList<RequirementVersion>(reqVersions);
        List<String> existingSprintReqVersionNames = this.retrieveExistingSprintReqVersions(sprintId, reqVersions, reqVersionsToSave);
        summary.setReqVersionsAlreadyLinkedToSprint(existingSprintReqVersionNames);
        List<String> highLevelReqVersionNames = this.retrieveHighLevelReqVersions(reqVersions, reqVersionsToSave);
        summary.setHighLevelReqVersionsInSelection(highLevelReqVersionNames);
        List<String> obsoleteReqVersionNames = this.retrieveObsoleteReqVersions(reqVersions, reqVersionsToSave);
        summary.setObsoleteReqVersionsInSelection(obsoleteReqVersionNames);
        Sprint sprint = (Sprint)this.sprintDao.findById(sprintId);
        sprint.checkLinkable();
        List<SprintReqVersion> sprintReqVersions = reqVersionsToSave.stream().map(reqVersion -> new SprintReqVersion(reqVersion, sprint)).toList();
        if (!reqVersionsToSave.isEmpty()) {
            sprint.updateLastModificationWithCurrentUser();
        }
        List savedSprintReqVersions = this.sprintReqVersionDao.saveAll(sprintReqVersions);
        return this.convertToSprintReqVersionDto(savedSprintReqVersions);
    }

    @Override
    public void deleteSprintReqVersions(long sprintId, Collection<Long> sprintReqVersionIds) {
        this.performDeleteSprintReqVersions(sprintId, sprintReqVersionIds, true);
    }

    @Override
    public void deleteSprintReqVersionsWithoutException(long sprintId, Collection<Long> sprintReqVersionIds) {
        this.performDeleteSprintReqVersions(sprintId, sprintReqVersionIds, false);
    }

    private void performDeleteSprintReqVersions(long sprintId, Collection<Long> sprintReqVersionIds, boolean shouldThrowException) {
        Sprint sprint = (Sprint)this.sprintDao.findById(sprintId);
        sprint.checkLinkable();
        List<Long> allowedSprintReqVersionIds = this.checkAllowedSprintReqVersionIds(sprintReqVersionIds, sprintId, shouldThrowException);
        if (!allowedSprintReqVersionIds.isEmpty()) {
            this.deleteSprintReqVersions(allowedSprintReqVersionIds, sprint);
        }
    }

    private List<Long> checkAllowedSprintReqVersionIds(Collection<Long> sprintReqVersionIds, long sprintId, boolean shouldThrowException) {
        HashSet<Long> sprintReqVersionsWithExecutions = new HashSet<Long>(this.sprintReqVersionDao.findSprintReqVersionWithExecutions(sprintReqVersionIds));
        ArrayList<Long> allowedSprintReqVersionIds = new ArrayList<Long>();
        for (Long id : sprintReqVersionIds) {
            boolean hasPermission;
            boolean bl = hasPermission = sprintReqVersionsWithExecutions.contains(id) ? this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.EXTENDED_DELETE.name(), (Long)sprintId, "org.squashtest.tm.domain.campaign.Sprint") : this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.LINK.name(), (Long)sprintId, "org.squashtest.tm.domain.campaign.Sprint");
            if (hasPermission) {
                allowedSprintReqVersionIds.add(id);
                continue;
            }
            if (!shouldThrowException) continue;
            throw new AccessDeniedException("The current user cannot delete this sprint req version: " + String.valueOf(id));
        }
        return allowedSprintReqVersionIds;
    }

    private void deleteSprintReqVersions(List<Long> sprintReqVersionIds, Sprint sprint) {
        this.sprintReqVersionDeletionHandler.build(sprintReqVersionIds).deleteSprintRequirementVersions();
        sprint.updateLastModificationWithCurrentUser();
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public Sprint findById(long sprintId) {
        return (Sprint)this.sprintDao.findById(sprintId);
    }

    private List<RequirementVersion> findRequirementVersionsFromRlnIds(List<Long> rlnIds) {
        List<Requirement> requirements = this.requirementDao.findRequirementsNodeRootAndInFolderByNodeIds(rlnIds);
        if (!requirements.isEmpty()) {
            return requirements.stream().map(Requirement::getCurrentVersion).toList();
        }
        return Collections.emptyList();
    }

    private List<RequirementVersion> findRequirementVersions(List<Long> ids) {
        List<Long> list = ids;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        SprintManagerServiceImpl$AjcClosure1 sprintManagerServiceImpl$AjcClosure1 = new SprintManagerServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(sprintManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    private List<String> retrieveExistingSprintReqVersions(Long sprintId, List<RequirementVersion> reqVersions, List<RequirementVersion> reqVersionsToSave) {
        ArrayList<String> existingSprintReqVersionNames = new ArrayList<String>();
        List<Long> reqVersionIds = reqVersions.stream().map(Resource::getId).toList();
        List<SprintReqVersion> existingSprintReqVersions = this.sprintReqVersionDao.findAllBySprintIdAndRequirementVersionIdInOrderByRequirementVersionId(sprintId, reqVersionIds);
        existingSprintReqVersions.forEach(existingSprintReqVersion -> {
            RequirementVersion reqVersion = existingSprintReqVersion.getRequirementVersion();
            reqVersionsToSave.remove(reqVersion);
            existingSprintReqVersionNames.add(reqVersion.getName());
        });
        return existingSprintReqVersionNames;
    }

    private List<String> retrieveHighLevelReqVersions(List<RequirementVersion> reqVersions, List<RequirementVersion> reqVersionsToSave) {
        ArrayList<String> highLevelReqNames = new ArrayList<String>();
        List<Long> reqVersionIds = reqVersions.stream().map(Resource::getId).toList();
        List<Long> highLevelReqVersionIds = this.requirementDao.fetchHighLevelRequirementVersionIds(reqVersionIds);
        reqVersions.forEach(reqVersion -> {
            boolean isHighLevelRequirement = highLevelReqVersionIds.contains(reqVersion.getId());
            if (isHighLevelRequirement) {
                String reqVersionName = reqVersion.getName();
                highLevelReqNames.add(reqVersionName);
                reqVersionsToSave.remove(reqVersion);
            }
        });
        return highLevelReqNames;
    }

    private List<String> retrieveObsoleteReqVersions(List<RequirementVersion> reqVersions, List<RequirementVersion> reqVersionsToSave) {
        return reqVersions.stream().filter(reqVersion -> !reqVersion.isNotObsolete()).map(obsoleteReqVersion -> {
            reqVersionsToSave.remove(obsoleteReqVersion);
            return obsoleteReqVersion.getName();
        }).toList();
    }

    private List<SprintReqVersionDto> convertToSprintReqVersionDto(List<SprintReqVersion> sprintReqVersions) {
        return sprintReqVersions.stream().map(SprintReqVersionDto::new).toList();
    }

    @Override
    public SprintStatus getSprintStatusByExecutionId(long testPlanItemId) {
        return this.sprintDisplayDao.getSprintStatusByExecutionId(testPlanItemId);
    }

    @Override
    public SprintStatus getSprintStatusBySprintReqVersionId(long sprintReqVersionId) {
        return this.sprintDisplayDao.getSprintStatusBySprintReqVersionId(sprintReqVersionId);
    }

    @Override
    public void deleteSprintSynchronisation(long sprintId) {
        this.sprintReqVersionDao.setAllSprintReqVersionsToNativeBySprintId(sprintId);
        this.sprintDao.deleteRemoteSynchronisationFromSprintId(sprintId);
        this.sprintRequirementSyncExtenderDao.deleteAllSprintReqSyncExtendersBySprintId(sprintId);
    }

    static {
        SprintManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllById_aroundBody0(SprintManagerServiceImpl sprintManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SprintManagerServiceImpl.java", SprintManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 265);
    }
}

