/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker;

import gherkin.ast.GherkinDocument;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.tools.StringUtils;
import org.springframework.context.MessageSource;
import org.squashtest.tm.bugtracker.definition.context.ExecutionInfo;
import org.squashtest.tm.bugtracker.definition.context.ExecutionSubItemInfo;
import org.squashtest.tm.bugtracker.definition.context.ExploratorySessionNoteInfo;
import org.squashtest.tm.bugtracker.definition.context.KeywordExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.bugtracker.definition.context.ScriptedExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.StandardExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.TestCaseInfo;
import org.squashtest.tm.bugtracker.definition.context.formatter.DefaultRemoteIssueContextFormatter;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ConsumerForExploratoryExecution;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.script.GherkinParser;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testcase.ConsumerForScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.internal.testcase.scripted.gherkin.ScriptedExecutionModelGenerator;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public final class RemoteIssueContextHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIssueContextHelper.class);

    private RemoteIssueContextHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static RemoteIssueContext getRemoteIssueContext(Execution execution, String squashPublicUrl, MessageSource messageSource) {
        RemoteIssueContext ctx = new RemoteIssueContext(execution.getProject().getId(), RemoteIssueContextHelper.getExecutionStepsInfo(execution), null, RemoteIssueContextHelper.getTestCaseInfo(execution.getReferencedTestCase()), RemoteIssueContextHelper.getExecutionInfo(execution, squashPublicUrl), null);
        String defaultDescription = DefaultRemoteIssueContextFormatter.getDefaultDescription((RemoteIssueContext)ctx, (MessageSource)messageSource);
        return ctx.withDefaultDescription(defaultDescription);
    }

    public static RemoteIssueContext getRemoteIssueContext(ExecutionStep buggedStep, String squashPublicUrl, MessageSource messageSource) {
        return RemoteIssueContextHelper.getRemoteIssueContextFromExecutionItem(squashPublicUrl, messageSource, buggedStep.getExecution(), buggedStep.getId());
    }

    public static RemoteIssueContext getRemoteIssueContext(SessionNote sessionNote, String squashPublicUrl, MessageSource messageSource) {
        return RemoteIssueContextHelper.getRemoteIssueContextFromExecutionItem(squashPublicUrl, messageSource, (Execution)sessionNote.getExecution(), sessionNote.getId());
    }

    public static RemoteIssueContext getRemoteIssueContext(String squashPublicUrl, FailureDetail failureDetail, Execution execution, MessageSource messageSource) {
        return RemoteIssueContextHelper.getRemoteIssueContextFromFailureDetail(squashPublicUrl, messageSource, failureDetail, execution);
    }

    private static RemoteIssueContext getRemoteIssueContextFromExecutionItem(String squashPublicUrl, MessageSource messageSource, Execution parentExecution, Long itemId) {
        RemoteIssueContext ctx = new RemoteIssueContext(parentExecution.getProject().getId(), RemoteIssueContextHelper.getExecutionStepsInfo(parentExecution), itemId, RemoteIssueContextHelper.getTestCaseInfo(parentExecution.getReferencedTestCase()), RemoteIssueContextHelper.getExecutionInfo(parentExecution, squashPublicUrl), null);
        String defaultDescription = DefaultRemoteIssueContextFormatter.getDefaultDescription((RemoteIssueContext)ctx, (MessageSource)messageSource);
        return ctx.withDefaultDescription(defaultDescription);
    }

    private static RemoteIssueContext getRemoteIssueContextFromFailureDetail(String squashPublicUrl, MessageSource messageSource, FailureDetail failureDetail, Execution execution) {
        RemoteIssueContext ctx = new RemoteIssueContext(execution.getProject().getId(), RemoteIssueContextHelper.getExecutionStepsInfo(execution), null, RemoteIssueContextHelper.getTestCaseInfo(failureDetail.getReferencedTestCase()), RemoteIssueContextHelper.getExecutionInfo(execution, squashPublicUrl), failureDetail.getMessage());
        String defaultDescription = DefaultRemoteIssueContextFormatter.getDefaultDescription((RemoteIssueContext)ctx, (MessageSource)messageSource);
        return ctx.withDefaultDescription(defaultDescription);
    }

    private static ExecutionInfo getExecutionInfo(Execution execution, String squashPublicUrl) {
        return new ExecutionInfo(execution.getId(), RemoteIssueContextHelper.getExecutionUrl(execution, squashPublicUrl), HTMLCleanupUtils.htmlToText(RemoteIssueContextHelper.getExecutionPrerequisite(execution)), RemoteIssueContextHelper.getExecutionPrerequisite(execution));
    }

    private static String getExecutionPrerequisite(Execution execution) {
        TestCaseKind kind = TestCaseKind.fromTestCase((TestCase)execution.getReferencedTestCase());
        if (kind.isScripted()) {
            StringBuilder stringBuilder = new StringBuilder();
            execution.getReferencedTestCase().accept((TestCaseVisitor)new ConsumerForScriptedTestCaseVisitor(scriptedTestCase -> {
                GherkinDocument doc = GherkinParser.parseDocument((String)scriptedTestCase.getScript());
                ScriptedExecutionModelGenerator.Model model = new ScriptedExecutionModelGenerator().buildModel(doc);
                stringBuilder.append(RemoteIssueContextHelper.buildScriptedExecutionPrerequisite(model));
            }));
            return stringBuilder.toString();
        }
        return execution.getPrerequisite();
    }

    private static String getExecutionUrl(Execution execution, String squashPublicUrl) {
        String url = squashPublicUrl.endsWith("/") ? squashPublicUrl + "execution/" + String.valueOf(execution.getId()) : squashPublicUrl + "/execution/" + String.valueOf(execution.getId());
        try {
            return new URI(url).normalize().toString();
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("Cannot normalize candidate execution URL. Proceed with '%s'.", url);
            LOGGER.error(errorMessage, (Throwable)e);
            return url;
        }
    }

    private static TestCaseInfo getTestCaseInfo(TestCase referencedTestCase) {
        return new TestCaseInfo(referencedTestCase.getId(), referencedTestCase.getReference(), referencedTestCase.getName(), RemoteIssueContextHelper.getTestCaseKind(referencedTestCase));
    }

    private static TestCaseInfo.Kind getTestCaseKind(TestCase referencedTestCase) {
        TestCaseKind testCaseKind = TestCaseKind.fromTestCase((TestCase)referencedTestCase);
        return TestCaseInfo.Kind.valueOf((String)testCaseKind.name());
    }

    private static List<ExecutionSubItemInfo> getExecutionStepsInfo(Execution execution) {
        ArrayList<ExecutionSubItemInfo> executionStepInfos = new ArrayList<ExecutionSubItemInfo>();
        TestCaseKind testCaseKind = TestCaseKind.fromTestCase((TestCase)execution.getReferencedTestCase());
        List executionSteps = execution.getSteps();
        switch (testCaseKind) {
            case STANDARD: {
                for (ExecutionStep step : executionSteps) {
                    RemoteIssueContextHelper.addStandardStepToExecutionSubItemInfo(executionStepInfos, step);
                }
                break;
            }
            case GHERKIN: {
                execution.getReferencedTestCase().accept((TestCaseVisitor)new ConsumerForScriptedTestCaseVisitor(scriptedTestCase -> RemoteIssueContextHelper.addScriptedStepToExecutionSubItemInfo(executionStepInfos, executionSteps, scriptedTestCase)));
                break;
            }
            case KEYWORD: {
                for (ExecutionStep step : executionSteps) {
                    RemoteIssueContextHelper.addKeywordStepToExecutionSubItemInfo(executionStepInfos, step);
                }
                break;
            }
            case EXPLORATORY: {
                execution.accept((ExecutionVisitor)new ConsumerForExploratoryExecution(exploratoryExecution -> {
                    for (SessionNote note : exploratoryExecution.getSessionNotes()) {
                        RemoteIssueContextHelper.addSessionNoteToExecutionStepInfo(executionStepInfos, note);
                    }
                }));
                break;
            }
            default: {
                throw new IllegalArgumentException("The kind " + String.valueOf(testCaseKind) + " for a Test Case is not handled.");
            }
        }
        return executionStepInfos;
    }

    private static void addStandardStepToExecutionSubItemInfo(List<ExecutionSubItemInfo> executionStepInfos, ExecutionStep step) {
        executionStepInfos.add((ExecutionSubItemInfo)new StandardExecutionStepInfo(step.getId(), step.getExecutionStepOrder().intValue(), HTMLCleanupUtils.htmlToText(step.getAction()), step.getAction(), HTMLCleanupUtils.htmlToText(step.getExpectedResult()), step.getExpectedResult()));
    }

    private static void addScriptedStepToExecutionSubItemInfo(List<ExecutionSubItemInfo> executionStepInfos, List<ExecutionStep> executionSteps, ScriptedTestCase scriptedTestCase) {
        GherkinDocument doc = GherkinParser.parseDocument((String)scriptedTestCase.getScript());
        ScriptedExecutionModelGenerator.Model model = new ScriptedExecutionModelGenerator().buildModel(doc);
        int i = 0;
        while (i < executionSteps.size()) {
            ExecutionStep step = executionSteps.get(i);
            String script = RemoteIssueContextHelper.buildExecutionStepScript(model.getSteps().get(i));
            int executionStepOrder = step.getExecutionStepOrder();
            executionStepInfos.add((ExecutionSubItemInfo)new ScriptedExecutionStepInfo(step.getId(), executionStepOrder, script));
            ++i;
        }
    }

    private static void addKeywordStepToExecutionSubItemInfo(List<ExecutionSubItemInfo> executionStepInfos, ExecutionStep step) {
        executionStepInfos.add((ExecutionSubItemInfo)new KeywordExecutionStepInfo(step.getId(), step.getExecutionStepOrder().intValue(), step.getAction(), HTMLCleanupUtils.htmlToText(step.getAction())));
    }

    private static void addSessionNoteToExecutionStepInfo(List<ExecutionSubItemInfo> executionStepInfos, SessionNote note) {
        executionStepInfos.add((ExecutionSubItemInfo)new ExploratorySessionNoteInfo(note.getId().longValue(), HTMLCleanupUtils.htmlToText(note.getContent()), note.getContent(), ExploratorySessionNoteInfo.Kind.valueOf((String)note.getKind().name())));
    }

    private static String buildExecutionStepScript(ScriptedExecutionModelGenerator.ExecutionStep executionStep) {
        List lines = executionStep.getSteps().stream().map(step -> String.join((CharSequence)" ", step.getKeyword().trim(), ":", step.getText().trim(), RemoteIssueContextHelper.buildArgument(step.getArgument(), "\t"))).map(str -> "\t" + str).collect(Collectors.toList());
        List<String> firstLineElements = Stream.of(executionStep.getKeyword(), ":", executionStep.getName(), executionStep.getDescription()).filter(Objects::nonNull).toList();
        String first = String.join((CharSequence)" ", firstLineElements);
        lines.add(0, first);
        return String.join((CharSequence)"\n", lines);
    }

    private static String buildArgument(ScriptedExecutionModelGenerator.ArgumentModel argument, String prefix) {
        if (argument == null) {
            return "";
        }
        return switch (argument.getKind()) {
            case ScriptedExecutionModelGenerator.ArgumentModel.Kind.DOCSTRING -> "\n" + prefix + argument.getValue();
            case ScriptedExecutionModelGenerator.ArgumentModel.Kind.DATATABLE -> "\n" + prefix + String.join((CharSequence)("\n" + prefix), RemoteIssueContextHelper.prettyPrintDataTable(argument.getDataTable()));
            default -> throw new MatchException(null, null);
        };
    }

    private static List<String> prettyPrintDataTable(ScriptedExecutionModelGenerator.DataTableModel dataTable) {
        HashMap<Integer, Integer> maxContentLengthByColumnIndex = new HashMap<Integer, Integer>();
        for (List<String> row : dataTable.getCells()) {
            int c = 0;
            while (c < row.size()) {
                int currentMax = maxContentLengthByColumnIndex.getOrDefault(c, 0);
                maxContentLengthByColumnIndex.put(c, Math.max(currentMax, row.get(c).length()));
                ++c;
            }
        }
        ArrayList<String> processedRows = new ArrayList<String>();
        for (List<String> row : dataTable.getCells()) {
            ArrayList<String> processedCells = new ArrayList<String>();
            int c = 0;
            while (c < row.size()) {
                processedCells.add(StringUtils.rightPad((String)row.get(c), (int)((Integer)maxContentLengthByColumnIndex.get(c) + 1)));
                ++c;
            }
            processedRows.add("| " + String.join((CharSequence)"| ", processedCells));
        }
        return processedRows;
    }

    private static String buildScriptedExecutionPrerequisite(ScriptedExecutionModelGenerator.Model model) {
        if (model.getPrerequisite() == null) {
            return "";
        }
        List<String> lines = model.getPrerequisite().stream().map(step -> String.join((CharSequence)"", step.getKeyword(), step.getText())).toList();
        return String.join((CharSequence)"\n", lines);
    }
}

