/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction.targets;

import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;

public class RequirementVersionTarget
implements Target,
WithPath {
    private RequirementTarget requirement;
    private Integer version;
    private String unconsistentName;
    private Long id;
    private boolean rejectedMilestone = false;
    private RequirementStatus importedRequirementStatus = RequirementStatus.WORK_IN_PROGRESS;

    public RequirementVersionTarget(RequirementTarget requirement, Integer version) {
        this.requirement = requirement;
        this.version = version;
    }

    public RequirementVersionTarget() {
        this.requirement = new RequirementTarget();
    }

    @Override
    public EntityType getType() {
        return EntityType.REQUIREMENT_VERSION;
    }

    @Override
    public boolean isWellFormed() {
        return this.requirement != null && this.requirement.isWellFormed();
    }

    @Override
    public String getProject() {
        return this.requirement.getProject();
    }

    @Override
    public String getPath() {
        return this.requirement.getPath();
    }

    @Override
    public String getSourcePath() {
        return this.requirement.getSourcePath();
    }

    public void setPath(String path) {
        this.requirement.setPath(path);
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public RequirementTarget getRequirement() {
        return this.requirement;
    }

    public String getUnconsistentName() {
        return this.unconsistentName;
    }

    public void setUnconsistentName(String unconsistentName) {
        this.unconsistentName = unconsistentName;
    }

    public RequirementStatus getImportedRequirementStatus() {
        return this.importedRequirementStatus;
    }

    public void setImportedRequirementStatus(RequirementStatus importedRequirementStatus) {
        this.importedRequirementStatus = importedRequirementStatus;
    }

    public boolean isRejectedMilestone() {
        return this.rejectedMilestone;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Deprecated
    public void rejectedMilestone() {
        this.rejectedMilestone = true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.requirement == null ? 0 : this.requirement.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementVersionTarget other = (RequirementVersionTarget)obj;
        if (this.requirement == null ? other.requirement != null : !this.requirement.equals(other.requirement)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

