/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;

public class OptionalIntegerCellCoercer
extends AbstractTypeBasedCellValueCoercer<Integer>
implements CellValueCoercer<Integer> {
    public static final OptionalIntegerCellCoercer INSTANCE = new OptionalIntegerCellCoercer();

    protected OptionalIntegerCellCoercer() {
    }

    @Override
    protected Integer coerceStringCell(Cell cell) throws NumberFormatException {
        Integer res;
        String val = cell.getStringCellValue();
        try {
            res = Integer.valueOf(val, 10);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                res = this.round(Double.valueOf(val));
            }
            catch (NumberFormatException ex) {
                throw new CannotCoerceException(ex, "message.import.log.error.field.notInteger");
            }
        }
        return res;
    }

    @Override
    protected Integer coerceNumericCell(Cell cell) {
        double val = cell.getNumericCellValue();
        Integer res = this.round(val);
        return res;
    }

    @Override
    protected Integer coerceBlankCell(Cell cell) {
        return null;
    }
}

