/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayConfiguration;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.grid.ColumnIds;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementExportModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementModelFromJooq;
import org.squashtest.tm.service.internal.batchimport.column.TemplateWorksheet;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.plugin.PluginFinderService;

@Component
@Scope(value="prototype")
public class RequirementSearchExcelExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementSearchExcelExporter.class);
    private static final String REQUIREMENT_SHEET = TemplateWorksheet.REQUIREMENT_SHEET.sheetName;
    private static final String CRITICALITY = "requirement.criticality.";
    private static final String STATUS = "requirement.status.";
    private static final String LABEL_NO = "label.No";
    private static final String LABEL_YES = "label.Yes";
    private List<ColumnIds> customColumnOrder = new ArrayList<ColumnIds>(Arrays.asList(ColumnIds.PROJECT_NAME, ColumnIds.REQUIREMENT_ID, ColumnIds.ID, ColumnIds.REFERENCE, ColumnIds.NAME, ColumnIds.STATUS, ColumnIds.REQUIREMENT_CRITICALITY, ColumnIds.REQUIREMENT_CATEGORY, ColumnIds.CREATED_BY, ColumnIds.LAST_MODIFIED_BY, ColumnIds.VERSION_COUNT, ColumnIds.VERSION_NUMBER));
    private List<ColumnIds> optionalColumns = new ArrayList<ColumnIds>(Arrays.asList(ColumnIds.ATTACHMENTS, ColumnIds.COVERAGE_OF_ASSOCIATED_TEST_CASE, ColumnIds.MILESTONES));
    List<ColumnIds> premiumColumnList = new ArrayList<ColumnIds>(Arrays.asList(ColumnIds.PROJECT_NAME, ColumnIds.REQUIREMENT_ID, ColumnIds.ID, ColumnIds.REFERENCE, ColumnIds.NAME, ColumnIds.STATUS, ColumnIds.REQUIREMENT_CRITICALITY, ColumnIds.REQUIREMENT_CATEGORY, ColumnIds.REQUIREMENT_NATURE, ColumnIds.DESCRIPTION, ColumnIds.REQUIREMENT_VERSION_HAS_CHILDREN, ColumnIds.REQUIREMENT_VERSION_HAS_PARENT, ColumnIds.REQUIREMENT_VERSION_HAS_LINK_TYPE, ColumnIds.REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT, ColumnIds.LINKED_STANDARD_REQUIREMENT, ColumnIds.MILESTONES_LABELS, ColumnIds.MILESTONES_STATUS, ColumnIds.MILESTONES_END_DATE, ColumnIds.CREATED_ON, ColumnIds.CREATED_BY, ColumnIds.LAST_MODIFIED_ON, ColumnIds.LAST_MODIFIED_BY, ColumnIds.VERSION_COUNT, ColumnIds.VERSION_NUMBER, ColumnIds.ATTACHMENTS, ColumnIds.COVERAGE_OF_ASSOCIATED_TEST_CASE, ColumnIds.MILESTONES));
    private Workbook workbook;
    protected boolean milestonesEnabled;
    @Inject
    private MessageSource messageSource;
    private String errorCellTooLargeMessage;
    private final PluginFinderService pluginFinderService;
    private final GridConfigurationService gridConfigurationService;
    private Map<Long, Integer> cufColumnsById = new HashMap<Long, Integer>();

    public RequirementSearchExcelExporter(FeatureManager featureManager, MessageSource messageSource, GridConfigurationService gridConfigurationService, PluginFinderService pluginFinderService) {
        this.milestonesEnabled = featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
        this.gridConfigurationService = gridConfigurationService;
        this.pluginFinderService = pluginFinderService;
        this.getMessageSource(messageSource);
        this.createWorkbook();
    }

    void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.errorCellTooLargeMessage = this.messageSource.getMessage("test-case.export.errors.celltoolarge", null, LocaleContextHolder.getLocale());
    }

    public void createHeaders(boolean simplifiedColumnDisplay) {
        this.createSheetHeaders(REQUIREMENT_SHEET, simplifiedColumnDisplay);
    }

    public void appendToWorkbook(RequirementExportModel model, boolean keepRteFormat, boolean simplifiedColumnDisplay) {
        if (!keepRteFormat) {
            this.removeRteFormat(model);
        }
        this.sort(model);
        this.appendRequirementModel(model, simplifiedColumnDisplay);
    }

    private void sort(RequirementExportModel model) {
        Collections.sort(model.getRequirementsModels(), RequirementModel.COMPARATOR);
    }

    private void appendRequirementModel(RequirementExportModel model, boolean simplifiedColumnDisplay) {
        List<RequirementModelFromJooq> models = model.getRequirementModelFromJooqs();
        Sheet reqSheet = this.workbook.getSheet(REQUIREMENT_SHEET);
        int rowIndex = reqSheet.getLastRowNum() + 1;
        List<String> activeColumns = this.gridConfigurationService.findActiveColumnIdsForUser("requirement-search");
        List<ExportModel.CustomField> allCufs = models.stream().flatMap(tcm -> tcm.getCufs().stream()).sorted(Comparator.comparing(c -> c.getLabel().toLowerCase())).toList();
        for (RequirementModelFromJooq reqModel : models) {
            Row row = reqSheet.createRow(rowIndex);
            try {
                this.insertValues(row, reqModel, activeColumns, simplifiedColumnDisplay);
                this.appendCustomFields(row, reqModel.getCufs(), activeColumns, allCufs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                reqSheet.removeRow(row);
                row = reqSheet.createRow(rowIndex);
                row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
            }
            ++rowIndex;
        }
    }

    private void createSheetHeaders(String sheetName, boolean simplifiedColumnDisplay) {
        Sheet dsSheet = this.workbook.getSheet(sheetName);
        Row h = dsSheet.createRow(0);
        List<String> activeColumns = this.gridConfigurationService.findActiveColumnIdsForUser("requirement-search");
        int cIdx = 0;
        List<String> columnsToProcess = this.columnList(activeColumns, simplifiedColumnDisplay);
        Map<String, String> customLabels = this.createColumnIdsMap();
        for (String columnName : columnsToProcess) {
            this.insertActiveColumnHeader(h, cIdx, columnName, customLabels);
            ++cIdx;
        }
    }

    private List<ColumnIds> genericColumnList(List<String> activeColumns, List<ColumnIds> columnsToProcess, boolean simplifiedColumnDisplayForTest) {
        if (!this.pluginFinderService.isPremiumPluginInstalled()) {
            if (!simplifiedColumnDisplayForTest) {
                columnsToProcess.addAll(this.optionalColumns);
            }
        } else if (!activeColumns.isEmpty()) {
            columnsToProcess = this.premiumColumnList;
        }
        if (!this.milestonesEnabled) {
            columnsToProcess.removeAll(ColumnIds.COLUMN_IDS_LINKED_TO_MILESTONES);
        }
        return columnsToProcess;
    }

    private List<String> columnList(List<String> activeColumns, boolean simplifiedColumnDisplayForTest) {
        ArrayList<ColumnIds> columnsToProcess = new ArrayList<ColumnIds>(this.customColumnOrder);
        List<ColumnIds> initialList = this.genericColumnList(activeColumns, columnsToProcess, simplifiedColumnDisplayForTest);
        List<String> columnIdStrings = initialList.stream().map(ColumnIds::getColumnId).collect(Collectors.toList());
        if (this.pluginFinderService.isPremiumPluginInstalled() && !activeColumns.isEmpty()) {
            columnIdStrings.retainAll(activeColumns);
            activeColumns.forEach(column -> {
                if (column.startsWith("cuf|")) {
                    columnIdStrings.add((String)column);
                }
            });
        }
        return columnIdStrings;
    }

    private Map<String, String> createColumnIdsMap() {
        HashMap<String, String> customLabels = new HashMap<String, String>();
        ArrayList<ColumnIds> columnsToProcess = new ArrayList<ColumnIds>(this.premiumColumnList);
        if (!this.milestonesEnabled) {
            columnsToProcess.removeAll(ColumnIds.COLUMN_IDS_LINKED_TO_MILESTONES);
        }
        for (ColumnIds columnName : columnsToProcess) {
            this.putCustomLabel(customLabels, columnName);
        }
        return customLabels;
    }

    private void putCustomLabel(Map<String, String> customLabels, ColumnIds columnId) {
        customLabels.put(columnId.getColumnId(), columnId.getLabel());
    }

    private void insertActiveColumnHeader(Row headerRow, int cIdx, String activeColumn, Map<String, String> customLabels) {
        if (customLabels.containsKey(activeColumn)) {
            headerRow.createCell(cIdx).setCellValue(this.getMessage(customLabels.get(activeColumn)));
        } else if (activeColumn.startsWith("cuf|")) {
            this.gridConfigurationService.registerCuf(headerRow, cIdx, activeColumn, this.cufColumnsById);
        }
    }

    private void insertValues(Row row, RequirementModelFromJooq reqModel, List<String> activeColumns, Boolean simplifiedColumnDisplay) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("Criticality", this.handleMessages(CRITICALITY + reqModel.getCriticality().toString()));
        fieldValues.put("Category", this.handleMessages(reqModel.getCategory()));
        fieldValues.put("Status", this.handleMessages(STATUS + reqModel.getStatus().toString()));
        fieldValues.put("Description", this.handleMessages("".equals(reqModel.getDescription()) ? LABEL_NO : LABEL_YES));
        fieldValues.put("IsHighLevel", this.handleMessages(reqModel.isHighLevel() ? "requirement.high-level.label" : "test-case.format.standard"));
        fieldValues.put("HasParent", this.handleMessages(Boolean.TRUE.equals(reqModel.getHasParent()) ? LABEL_YES : LABEL_NO));
        fieldValues.put("HasLinkType", this.handleMessages(Boolean.TRUE.equals(reqModel.getHasLinkType()) ? LABEL_YES : LABEL_NO));
        fieldValues.put("RequirementBoundToHighLevelRequirement", this.handleMessages(Boolean.TRUE.equals(reqModel.getRequirementBoundToHighLevelRequirement()) ? LABEL_YES : LABEL_NO));
        Map<String, BiConsumer<Row, Integer>> columnValueHandlers = this.createColumnValueHandlers(reqModel, fieldValues);
        int colIndex = 0;
        List<String> columnsToProcess = this.columnList(activeColumns, simplifiedColumnDisplay);
        for (String columnName : columnsToProcess) {
            if (columnValueHandlers.containsKey(columnName)) {
                columnValueHandlers.get(columnName).accept(row, colIndex);
            }
            ++colIndex;
        }
    }

    private Map<String, BiConsumer<Row, Integer>> createColumnValueHandlers(RequirementModelFromJooq reqModel, Map<String, String> fieldValues) {
        HashMap<String, BiConsumer<Row, Integer>> handlers = new HashMap<String, BiConsumer<Row, Integer>>();
        this.putCustomHandlers(handlers, ColumnIds.PROJECT_NAME, reqModel.getProjectName());
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_ID, reqModel.getRequirementId());
        this.putCustomHandlers(handlers, ColumnIds.ID, reqModel.getId());
        this.putCustomHandlers(handlers, ColumnIds.REFERENCE, reqModel.getReference());
        this.putCustomHandlers(handlers, ColumnIds.NAME, reqModel.getName());
        this.putCustomHandlers(handlers, ColumnIds.STATUS, fieldValues.get("Status"));
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_CRITICALITY, fieldValues.get("Criticality"));
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_CATEGORY, fieldValues.get("Category"));
        this.putCustomHandlers(handlers, ColumnIds.CREATED_BY, reqModel.getCreatedBy());
        this.putCustomHandlers(handlers, ColumnIds.LAST_MODIFIED_BY, reqModel.getLastModifiedBy());
        this.putCustomHandlers(handlers, ColumnIds.VERSION_COUNT, reqModel.getRequirementVersionNumber());
        this.putCustomHandlers(handlers, ColumnIds.VERSION_NUMBER, reqModel.getVersionsCount());
        this.putCustomHandlers(handlers, ColumnIds.COVERAGE_OF_ASSOCIATED_TEST_CASE, reqModel.getCoverages() != null ? reqModel.getCoverages() : 0L);
        this.putCustomHandlers(handlers, ColumnIds.ATTACHMENTS, reqModel.getAttachments());
        this.putCustomHandlers(handlers, ColumnIds.CREATED_ON, this.gridConfigurationService.reformatSimpleDateForExport(reqModel.getCreatedOn()));
        this.putCustomHandlers(handlers, ColumnIds.LAST_MODIFIED_ON, this.gridConfigurationService.reformatSimpleDateForExport(reqModel.getLastModifiedOn()));
        this.putCustomHandlers(handlers, ColumnIds.DESCRIPTION, fieldValues.get("Description"));
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_NATURE, fieldValues.get("IsHighLevel"));
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_VERSION_HAS_PARENT, fieldValues.get("HasParent"));
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_VERSION_HAS_CHILDREN, reqModel.getChildOfRequirement());
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_VERSION_HAS_LINK_TYPE, fieldValues.get("HasLinkType"));
        this.putCustomHandlers(handlers, ColumnIds.REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT, fieldValues.get("RequirementBoundToHighLevelRequirement"));
        this.putCustomHandlers(handlers, ColumnIds.LINKED_STANDARD_REQUIREMENT, reqModel.getLinkedStandardRequirement());
        if (this.milestonesEnabled) {
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES, reqModel.getMilestones() != null ? reqModel.getMilestones() : 0L);
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES_LABELS, reqModel.getMilestoneLabels());
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES_STATUS, this.reformatStatusForExport(reqModel.getMilestoneStatus()));
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES_END_DATE, this.gridConfigurationService.reformatMultipleDateForExport(reqModel.getMilestoneEndDate()));
        }
        return handlers;
    }

    private void putCustomHandlers(Map<String, BiConsumer<Row, Integer>> handlers, ColumnIds columnId, Object value) {
        handlers.put(columnId.getColumnId(), (row, colIndex) -> {
            Cell cell = row.createCell(colIndex.intValue());
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
            } else if (value instanceof Long) {
                cell.setCellValue((double)((Long)value).longValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            }
        });
    }

    private String reformatStatusForExport(String concatenatedStatus) {
        List<Object> formattedStatus = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)concatenatedStatus)) {
            String[] statuses = concatenatedStatus.split("\\|");
            formattedStatus = Arrays.stream(statuses).map(st -> this.handleMessages("milestone.status." + st)).toList();
        }
        return String.join((CharSequence)", ", formattedStatus);
    }

    private void removeRteFormat(RequirementExportModel model) {
        this.removeRteFormatFromRequirement(model.getRequirementsModels());
    }

    private void removeRteFormatFromRequirement(List<RequirementModel> requirementsModels) {
        for (RequirementModel requirementModel : requirementsModels) {
            requirementModel.setDescription(this.removeHtml(requirementModel.getDescription()));
            for (ExportModel.CustomField cf : requirementModel.getCufs()) {
                cf.setValue(this.removeHtml(cf.getValue()));
            }
        }
    }

    private String removeHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        return html.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", "");
    }

    public File print() {
        try {
            File temp = File.createTempFile("req_export_", "xls");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            this.workbook.write((OutputStream)fos);
            fos.close();
            return temp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void createWorkbook() {
        HSSFWorkbook wb = new HSSFWorkbook();
        wb.createSheet(REQUIREMENT_SHEET);
        this.workbook = wb;
    }

    private String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, locale);
    }

    public void getMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    private String handleMessages(String key) {
        try {
            return this.getMessage(key);
        }
        catch (NoSuchMessageException e) {
            LOGGER.debug("No corresponding message for key '{}'", new Object[]{key, e});
            return key;
        }
    }

    private void appendCustomFields(Row row, List<ExportModel.CustomField> requirementCufs, List<String> activeColumns, List<ExportModel.CustomField> allCufs) {
        for (ExportModel.CustomField cuf : allCufs) {
            Integer index;
            ExportModel.CustomField requirementCufValue;
            Long id = cuf.getCufId();
            String columnName = GridColumnDisplayConfiguration.getCufColumnNameFromCufId((Long)id);
            if (!activeColumns.contains(columnName) || (requirementCufValue = this.gridConfigurationService.findCufById(requirementCufs, id, index = this.cufColumnsById.get(id))) == null) continue;
            this.setCellValue(requirementCufValue, index, row);
        }
    }

    private void setCellValue(ExportModel.CustomField cuf, Integer idx, Row r) {
        Cell c = r.createCell(idx.intValue());
        String value = this.gridConfigurationService.nullSafeValue(cuf);
        switch (cuf.getType()) {
            case NUMERIC: {
                value = NumericCufHelper.formatOutputNumericCufValue(value);
                break;
            }
            case CHECKBOX: {
                value = this.handleMessages("label." + StringUtils.capitalize((String)value));
                break;
            }
            case TAG: {
                value = this.gridConfigurationService.reformatLabelForExport(value);
                break;
            }
        }
        c.setCellValue(value);
    }
}

