/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.batchexport.models.DatasetModel;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.ParameterModel;
import org.squashtest.tm.service.internal.batchexport.models.TestCaseModel;
import org.squashtest.tm.service.internal.batchexport.models.TestStepModel;
import org.squashtest.tm.service.internal.batchimport.column.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.column.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.DatasetSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.project.ProjectFinder;

@Component
@Scope(value="prototype")
class ExcelExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExporter.class);
    private static final String DATA_EXCEED_MAX_CELL_SIZE_MESSAGE = "some data exceed the maximum size of an excel cell";
    private static final String DATASET_SHEET = TemplateWorksheet.DATASETS_SHEET.sheetName;
    private static final String PARAMETER_SHEET = TemplateWorksheet.PARAMETERS_SHEET.sheetName;
    private static final String TEST_STEP_SHEET = TemplateWorksheet.STEPS_SHEET.sheetName;
    private static final String COVERAGE_SHEET = TemplateWorksheet.COVERAGE_SHEET.sheetName;
    private static final List<CoverageSheetColumn> COVERAGE_COLUMNS = Arrays.asList(CoverageSheetColumn.REQ_PATH, CoverageSheetColumn.REQ_VERSION_NUM, CoverageSheetColumn.TC_PATH);
    private static final List<DatasetSheetColumn> DS_COLUMNS = Arrays.asList(DatasetSheetColumn.TC_OWNER_PATH, DatasetSheetColumn.TC_OWNER_ID, DatasetSheetColumn.TC_DATASET_ID, DatasetSheetColumn.TC_DATASET_NAME, DatasetSheetColumn.TC_PARAM_OWNER_PATH, DatasetSheetColumn.TC_PARAM_OWNER_ID, DatasetSheetColumn.TC_DATASET_PARAM_NAME, DatasetSheetColumn.TC_DATASET_PARAM_VALUE);
    private static final List<ParameterSheetColumn> PRM_COLUMNS = Arrays.asList(ParameterSheetColumn.TC_OWNER_PATH, ParameterSheetColumn.TC_OWNER_ID, ParameterSheetColumn.TC_PARAM_ID, ParameterSheetColumn.TC_PARAM_NAME, ParameterSheetColumn.TC_PARAM_DESCRIPTION);
    private static final List<StepSheetColumn> ST_COLUMNS = Arrays.asList(StepSheetColumn.TC_OWNER_PATH, StepSheetColumn.TC_OWNER_ID, StepSheetColumn.TC_STEP_ID, StepSheetColumn.TC_STEP_NUM, StepSheetColumn.TC_STEP_IS_CALL_STEP, StepSheetColumn.TC_STEP_CALL_DATASET, StepSheetColumn.TC_STEP_ACTION, StepSheetColumn.TC_STEP_EXPECTED_RESULT, StepSheetColumn.TC_STEP_NB_REQ, StepSheetColumn.TC_STEP_NB_ATTACHMENT);
    private static final TestCaseSheetColumn[] BASIC_TC_COLUMNS = new TestCaseSheetColumn[]{TestCaseSheetColumn.PROJECT_ID, TestCaseSheetColumn.PROJECT_NAME, TestCaseSheetColumn.TC_PATH, TestCaseSheetColumn.TC_NUM, TestCaseSheetColumn.TC_ID, TestCaseSheetColumn.TC_UUID, TestCaseSheetColumn.TC_REFERENCE, TestCaseSheetColumn.TC_NAME, TestCaseSheetColumn.TC_WEIGHT_AUTO, TestCaseSheetColumn.TC_WEIGHT, TestCaseSheetColumn.TC_NATURE, TestCaseSheetColumn.TC_TYPE, TestCaseSheetColumn.TC_STATUS, TestCaseSheetColumn.TC_DESCRIPTION, TestCaseSheetColumn.TC_PRE_REQUISITE, TestCaseSheetColumn.TC_NB_REQ, TestCaseSheetColumn.TC_NB_CALLED_BY, TestCaseSheetColumn.TC_NB_ATTACHMENT, TestCaseSheetColumn.TC_CREATED_ON, TestCaseSheetColumn.TC_CREATED_BY, TestCaseSheetColumn.TC_LAST_MODIFIED_ON, TestCaseSheetColumn.TC_LAST_MODIFIED_BY, TestCaseSheetColumn.DRAFTED_BY_AI, TestCaseSheetColumn.TC_KIND, TestCaseSheetColumn.TC_SCRIPT};
    private static final List<TestCaseSheetColumn> TC_COLUMNS_MILESTONES = new ArrayList<TestCaseSheetColumn>(Arrays.asList((TestCaseSheetColumn[])ArrayUtils.insert((int)8, (Object[])BASIC_TC_COLUMNS, (Object[])new TestCaseSheetColumn[]{TestCaseSheetColumn.TC_MILESTONE})));
    private static final List<TestCaseSheetColumn> TC_COLUMNS = Arrays.asList(BASIC_TC_COLUMNS);
    protected static final String TC_SHEET = TemplateWorksheet.TEST_CASES_SHEET.sheetName;
    private final Map<String, Integer> cufColumnsByCode = new HashMap<String, Integer>();
    protected Workbook workbook;
    protected boolean isMilestoneModeEnabled;
    private MessageSource messageSource;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private ProjectDisplayDao projectDisplayDao;
    private String errorCellTooLargeMessage;

    @Inject
    public ExcelExporter(FeatureManager featureManager, MessageSource messageSource) {
        this.isMilestoneModeEnabled = featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
    }

    @PostConstruct
    public void init() {
        this.createWorkbook();
        this.createHeaders();
    }

    void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.errorCellTooLargeMessage = this.messageSource.getMessage("test-case.export.errors.celltoolarge", null, LocaleContextHolder.getLocale());
    }

    public void appendToWorkbook(ExportModel model, boolean keepRteFormat) {
        if (!keepRteFormat) {
            this.removeRteFormat(model);
        }
        this.appendTestCases(model, keepRteFormat);
        this.appendTestSteps(model, keepRteFormat);
        this.appendParameters(model, keepRteFormat);
        this.appendDatasets(model, keepRteFormat);
        this.appendCoverage(model);
    }

    private void removeRteFormat(ExportModel model) {
        this.removeRteFormatFromParameters(model.getParameters());
        this.removeRteFormatFromTestCases(model.getTestCases());
        this.removeRteFormatFromTestSteps(model.getTestSteps());
    }

    private void removeRteFormatFromTestCases(List<TestCaseModel> testCaseModels) {
        for (TestCaseModel testCaseModel : testCaseModels) {
            testCaseModel.setDescription(HTMLCleanupUtils.removeHtml(testCaseModel.getDescription()));
            testCaseModel.setPrerequisite(HTMLCleanupUtils.removeHtml(testCaseModel.getPrerequisite()));
            for (ExportModel.CustomField cuf : testCaseModel.getCufs()) {
                cuf.setValue(HTMLCleanupUtils.removeHtml(cuf.getValue()));
            }
        }
    }

    private void removeRteFormatFromParameters(List<ParameterModel> parameterModels) {
        for (ParameterModel parameterModel : parameterModels) {
            parameterModel.setDescription(HTMLCleanupUtils.removeHtml(parameterModel.getDescription()));
        }
    }

    private void removeRteFormatFromTestSteps(List<TestStepModel> testStepModels) {
        for (TestStepModel testStepModel : testStepModels) {
            testStepModel.setAction(HTMLCleanupUtils.removeHtml(testStepModel.getAction()));
            testStepModel.setResult(HTMLCleanupUtils.removeHtml(testStepModel.getResult()));
        }
    }

    public File print() {
        try {
            File temp = File.createTempFile("tc_export_", "xls");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            this.workbook.write((OutputStream)fos);
            fos.close();
            return temp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void appendTestCases(ExportModel model, boolean keepRteFormat) {
        List<TestCaseModel> testCaseModels = model.getTestCases();
        Sheet testCaseSheet = this.workbook.getSheet(TC_SHEET);
        int rowIndex = testCaseSheet.getLastRowNum() + 1;
        boolean shouldAddAutomationWorkflowColumn = this.projectFinder.countProjectsAllowAutomationWorkflow() > 0;
        List<Long> projectIdsInExport = testCaseModels.stream().map(TestCaseModel::getProjectId).distinct().toList();
        Map<Long, Boolean> allowAutomationWorkflowByProjectId = this.projectDisplayDao.allowAutomationWorkflowByProjectId(projectIdsInExport);
        for (TestCaseModel testCaseModel : testCaseModels) {
            Row row = testCaseSheet.createRow(rowIndex);
            int cellIndex = 0;
            try {
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getProjectId().longValue());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getProjectName());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getPath());
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getOrder().intValue());
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getId().longValue());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getUuid());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getReference());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getName());
                if (this.isMilestoneModeEnabled) {
                    row.createCell(cellIndex++).setCellValue(testCaseModel.getMilestone());
                }
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getWeightAuto());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getWeight().toString());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getNature().getCode());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getType().getCode());
                row.createCell(cellIndex++).setCellValue(testCaseModel.getStatus().toString());
                row.createCell(cellIndex++).setCellValue(this.formatRichTextField(testCaseModel.getDescription(), keepRteFormat));
                row.createCell(cellIndex++).setCellValue(this.formatRichTextField(testCaseModel.getPrerequisite(), keepRteFormat));
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getNbReq().longValue());
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getNbCaller().longValue());
                row.createCell(cellIndex++).setCellValue((double)testCaseModel.getNbAttachments().longValue());
                row.createCell(cellIndex++).setCellValue(this.format(testCaseModel.getCreatedOn()));
                row.createCell(cellIndex++).setCellValue(testCaseModel.getCreatedBy());
                row.createCell(cellIndex++).setCellValue(this.format(testCaseModel.getLastModifiedOn()));
                row.createCell(cellIndex++).setCellValue(testCaseModel.getLastModifiedBy());
                row.createCell(cellIndex++).setCellValue(String.valueOf(testCaseModel.getDraftedByAi() ? 1 : 0));
                cellIndex = this.appendScriptedTestCaseExtender(row, cellIndex, testCaseModel);
                this.appendCustomFields(row, "TC_CUF_", testCaseModel.getCufs(), keepRteFormat);
                this.doOptionalAppendTestCases(shouldAddAutomationWorkflowColumn, allowAutomationWorkflowByProjectId, row, cellIndex, testCaseModel);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("cannot export content for test case '{}': {}", new Object[]{testCaseModel.getId(), DATA_EXCEED_MAX_CELL_SIZE_MESSAGE, e});
                testCaseSheet.removeRow(row);
                row = testCaseSheet.createRow(rowIndex);
                row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
            }
            ++rowIndex;
        }
    }

    private int appendScriptedTestCaseExtender(Row row, int cellIndex, TestCaseModel testCaseModel) {
        TestCaseKind testCaseKind = testCaseModel.getTestCaseKind();
        row.createCell(cellIndex++).setCellValue(testCaseKind.name());
        if (testCaseKind.isScripted()) {
            row.createCell(cellIndex++).setCellValue(testCaseModel.getTcScript());
        } else {
            row.createCell(cellIndex++).setCellValue("");
        }
        return cellIndex;
    }

    protected int doOptionalAppendTestCases(boolean shouldAddAutomationWorkflowColumn, Map<Long, Boolean> allowAutomationWorkflowByProjectId, Row row, int cellIndex, TestCaseModel testCaseModel) {
        if (shouldAddAutomationWorkflowColumn) {
            boolean allowAutomationWorkflow = allowAutomationWorkflowByProjectId.get(testCaseModel.getProjectId());
            return this.appendAutomationWorkflow(allowAutomationWorkflow, row, cellIndex, testCaseModel);
        }
        return cellIndex;
    }

    protected int appendAutomationWorkflow(boolean allowAutomationWorkflow, Row row, int cellIndex, TestCaseModel testCaseModel) {
        if (allowAutomationWorkflow) {
            row.createCell(cellIndex++).setCellValue(testCaseModel.getAutomatable().name());
        } else {
            row.createCell(cellIndex++).setCellValue("-");
        }
        return cellIndex;
    }

    private void appendTestSteps(ExportModel model, boolean keepRteFormat) {
        List<TestStepModel> testStepModels = model.getTestSteps();
        Sheet testStepSheet = this.workbook.getSheet(TEST_STEP_SHEET);
        int rowIndex = testStepSheet.getLastRowNum() + 1;
        for (TestStepModel testStepModel : testStepModels) {
            Row row = testStepSheet.createRow(rowIndex);
            int cellIndex = 0;
            try {
                row.createCell(cellIndex++).setCellValue(testStepModel.getTcOwnerPath());
                row.createCell(cellIndex++).setCellValue((double)testStepModel.getTcOwnerId());
                row.createCell(cellIndex++).setCellValue((double)testStepModel.getId());
                row.createCell(cellIndex++).setCellValue((double)testStepModel.getOrder());
                row.createCell(cellIndex++).setCellValue((double)testStepModel.getIsCallStep().intValue());
                row.createCell(cellIndex++).setCellValue(testStepModel.getDsName());
                row.createCell(cellIndex++).setCellValue(this.formatRichTextField(testStepModel.getAction(), keepRteFormat));
                row.createCell(cellIndex++).setCellValue(this.formatRichTextField(testStepModel.getResult(), keepRteFormat));
                row.createCell(cellIndex++).setCellValue((double)testStepModel.getNbReq().longValue());
                row.createCell(cellIndex).setCellValue((double)testStepModel.getNbAttach().longValue());
                this.appendCustomFields(row, "TC_STEP_CUF_", testStepModel.getCufs(), keepRteFormat);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("cannot export content for test step '{}': {}", new Object[]{testStepModel.getId(), DATA_EXCEED_MAX_CELL_SIZE_MESSAGE, e});
                }
                testStepSheet.removeRow(row);
                row = testStepSheet.createRow(rowIndex);
                row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
            }
            ++rowIndex;
        }
    }

    private void appendParameters(ExportModel model, boolean keepRteFormat) {
        List<ParameterModel> parameterModels = model.getParameters();
        Sheet parameterSheet = this.workbook.getSheet(PARAMETER_SHEET);
        int rowIndex = parameterSheet.getLastRowNum() + 1;
        for (ParameterModel parameterModel : parameterModels) {
            Row row = parameterSheet.createRow(rowIndex);
            int cellIndex = 0;
            try {
                row.createCell(cellIndex++).setCellValue(parameterModel.getTcOwnerPath());
                row.createCell(cellIndex++).setCellValue((double)parameterModel.getTcOwnerId());
                row.createCell(cellIndex++).setCellValue((double)parameterModel.getId());
                row.createCell(cellIndex++).setCellValue(parameterModel.getName());
                row.createCell(cellIndex).setCellValue(this.formatRichTextField(parameterModel.getDescription(), keepRteFormat));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("cannot export content for parameter '{}': {}", new Object[]{parameterModel.getId(), DATA_EXCEED_MAX_CELL_SIZE_MESSAGE, e});
                parameterSheet.removeRow(row);
                row = parameterSheet.createRow(rowIndex);
                row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
            }
            ++rowIndex;
        }
    }

    private void appendDatasets(ExportModel model, boolean keepRteFormat) {
        List<DatasetModel> datasetModels = model.getDatasets();
        Sheet datasetSheet = this.workbook.getSheet(DATASET_SHEET);
        int rowIndex = datasetSheet.getLastRowNum() + 1;
        for (DatasetModel datasetModel : datasetModels) {
            Row row = datasetSheet.createRow(rowIndex);
            int cellIndex = 0;
            try {
                row.createCell(cellIndex++).setCellValue(datasetModel.getTcOwnerPath());
                row.createCell(cellIndex++).setCellValue((double)datasetModel.getOwnerId());
                row.createCell(cellIndex++).setCellValue((double)datasetModel.getId());
                row.createCell(cellIndex++).setCellValue(datasetModel.getName());
                row.createCell(cellIndex++).setCellValue(datasetModel.getParamOwnerPath());
                row.createCell(cellIndex++).setCellValue((double)datasetModel.getParamOwnerId());
                row.createCell(cellIndex++).setCellValue(datasetModel.getParamName());
                row.createCell(cellIndex).setCellValue(this.formatRichTextField(datasetModel.getParamValue(), keepRteFormat));
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("cannot export content for dataset '{}': {}", new Object[]{datasetModel.getId(), DATA_EXCEED_MAX_CELL_SIZE_MESSAGE, e});
                }
                datasetSheet.removeRow(row);
                row = datasetSheet.createRow(rowIndex);
                row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
            }
            ++rowIndex;
        }
    }

    private String formatRichTextField(String text, boolean keepRteFormat) {
        return keepRteFormat ? text : HtmlUtils.htmlUnescape((String)text);
    }

    private void appendCustomFields(Row row, String codePrefix, List<ExportModel.CustomField> cufs, boolean keepRteFormat) {
        for (ExportModel.CustomField cuf : cufs) {
            String code = codePrefix + cuf.getCode();
            Integer idx = this.cufColumnsByCode.get(code);
            if (idx == null) {
                idx = this.registerCuf(row.getSheet(), code);
            }
            Cell cell = row.createCell(idx.intValue());
            String value = this.nullSafeValue(cuf);
            if (cuf.getType().equals((Object)InputType.NUMERIC)) {
                value = NumericCufHelper.formatOutputNumericCufValue(value);
            } else if (cuf.getType().equals((Object)InputType.RICH_TEXT)) {
                value = this.formatRichTextField(value, keepRteFormat);
            }
            cell.setCellValue(value);
        }
    }

    private void appendCoverage(ExportModel model) {
        List<CoverageModel> coverageModels = model.getCoverages();
        Sheet coverageSheet = this.workbook.getSheet(COVERAGE_SHEET);
        int rowIndex = coverageSheet.getLastRowNum() + 1;
        for (CoverageModel coverageModel : coverageModels) {
            Row row = coverageSheet.createRow(rowIndex);
            int cellIndex = 0;
            row.createCell(cellIndex++).setCellValue(coverageModel.getReqPath());
            row.createCell(cellIndex++).setCellValue((double)coverageModel.getReqVersion());
            row.createCell(cellIndex).setCellValue(coverageModel.getTcPath());
            ++rowIndex;
        }
    }

    private String nullSafeValue(ExportModel.CustomField customField) {
        String value = customField.getValue();
        return value == null ? "" : value;
    }

    private int registerCuf(Sheet sheet, String code) {
        Row headers = sheet.getRow(0);
        short nextIdx = headers.getLastCellNum();
        headers.createCell((int)nextIdx).setCellValue(code);
        this.cufColumnsByCode.put(code, Integer.valueOf(nextIdx));
        return nextIdx;
    }

    private String format(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.formatIso8601Date((Date)date);
    }

    private void createWorkbook() {
        HSSFWorkbook wb = new HSSFWorkbook();
        wb.createSheet(TC_SHEET);
        wb.createSheet(TEST_STEP_SHEET);
        wb.createSheet(PARAMETER_SHEET);
        wb.createSheet(DATASET_SHEET);
        wb.createSheet(COVERAGE_SHEET);
        this.workbook = wb;
    }

    private void createHeaders() {
        this.createTestCaseSheetHeaders();
        this.createStepSheetHeaders();
        this.createParameterSheetHeaders();
        this.createDatasetSheetHeaders();
        this.createCoverageSheetHeaders();
    }

    private void createCoverageSheetHeaders() {
        this.createSheetHeaders(COVERAGE_SHEET, COVERAGE_COLUMNS);
    }

    private void createSheetHeaders(String sheetName, List<? extends TemplateColumn> templateColumns) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        Row header = sheet.createRow(0);
        int cellIndex = 0;
        for (TemplateColumn templateColumn : templateColumns) {
            header.createCell(cellIndex++).setCellValue(templateColumn.getHeader());
        }
    }

    private void createDatasetSheetHeaders() {
        this.createSheetHeaders(DATASET_SHEET, DS_COLUMNS);
    }

    private void createParameterSheetHeaders() {
        this.createSheetHeaders(PARAMETER_SHEET, PRM_COLUMNS);
    }

    private void createStepSheetHeaders() {
        this.createSheetHeaders(TEST_STEP_SHEET, ST_COLUMNS);
    }

    private void createTestCaseSheetHeaders() {
        List<TestCaseSheetColumn> columns = this.isMilestoneModeEnabled ? TC_COLUMNS_MILESTONES : TC_COLUMNS;
        this.createSheetHeaders(TC_SHEET, columns);
        this.createOptionalTestCaseSheetHeaders();
    }

    protected void createOptionalTestCaseSheetHeaders() {
        Sheet testCaseSheet = this.workbook.getSheet(TC_SHEET);
        Row header = testCaseSheet.getRow(0);
        short cellIndex = header.getLastCellNum();
        if (this.projectFinder.countProjectsAllowAutomationWorkflow() > 0) {
            header.createCell((int)cellIndex).setCellValue(TestCaseSheetColumn.TC_AUTOMATABLE.name());
        }
    }
}

