/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.bugtracker;

import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.servers.ManageableCredentials;

@Transactional
public interface BugTrackersLocalService {
    public RemoteIssue createIssue(IssueDetector var1, RemoteIssue var2);

    public URL getIssueUrl(String var1, BugTracker var2);

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor(BugTracker var1);

    public AuthenticationStatus checkBugTrackerStatus(Long var1);

    public AuthenticationStatus checkAuthenticationStatus(Long var1);

    public void validateCredentials(BugTracker var1, Credentials var2, boolean var3) throws BugTrackerRemoteException;

    public void validateCredentials(Long var1, Credentials var2, boolean var3) throws BugTrackerRemoteException;

    public void validateManageableCredentials(long var1, ManageableCredentials var3, boolean var4) throws BugTrackerRemoteException;

    public RemoteIssue createReportIssueTemplate(String var1, BugTracker var2, RemoteIssueContext var3);

    @UsedInPlugin(names={PluginName.CAMPAIGN_ASSISTANT})
    public List<? extends RemoteIssue> getIssues(Long var1, List<String> var2, BugTracker var3);

    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest var1, BugTracker var2);

    @UsedInPlugin(names={PluginName.API_REST})
    public Optional<Issue> searchAndAttachIssueToExecution(RemoteIssueSearchRequest var1, Long var2);

    public Issue attachIssue(RemoteIssue var1, IssueDetector var2, String var3);

    public Set<String> getProviderKinds();

    public void detachIssues(List<Long> var1);

    public void forwardAttachments(String var1, String var2, List<Attachment> var3);

    public Object forwardDelegateCommand(DelegateCommand var1, String var2);

    public List<RemoteRequirementAndProjectId> findAllRemoteReqIdByServerUrlVerifiedByATestCase(String var1, Long var2);

    public void linkIssueToRemoteRequirements(String var1, List<RemoteRequirementAndProjectId> var2, BugTracker var3);

    public void detachIssuesAndUpdateAutomationFlag(List<Long> var1, Long var2);
}

