/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service;

import io.jsonwebtoken.security.Keys;
import java.util.Base64;
import javax.crypto.SecretKey;

public final class RestApiJwtSecretKeyManager {
    private static volatile SecretKey cachedJwtSecretKey = null;

    private RestApiJwtSecretKeyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecretKey getRestApiJwtSecretKey(String base64EncodedSecret) {
        if (cachedJwtSecretKey != null) return cachedJwtSecretKey;
        Class<RestApiJwtSecretKeyManager> clazz = RestApiJwtSecretKeyManager.class;
        synchronized (RestApiJwtSecretKeyManager.class) {
            if (cachedJwtSecretKey != null) return cachedJwtSecretKey;
            try {
                cachedJwtSecretKey = Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(base64EncodedSecret));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The provided secret is not encoded in Base64.", e);
            }
            return cachedJwtSecretKey;
        }
    }
}

