/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.resultpublisher;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.testautomation.execution.dto.ExecutionStatus;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFailureDetailService;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFlagService;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.dto.AutomatedExecutionUpdateData;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.testautomation.AutomatedExecutionManagerService;
import org.squashtest.tm.service.testautomation.model.Attachment;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.model.TfTestExecutionStatus;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuitePublisherService;

@Service
@Transactional
public class ExecutionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionService.class);
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private AutomatedSuitePublisherService automatedSuitePublisherService;
    @Inject
    private AutomatedExecutionManagerService automatedExecutionManager;
    @Inject
    private AutomatedExecutionFailureDetailService failureDetailService;
    @Inject
    private AutomatedExecutionExtenderDao automatedExecutionExtenderDao;
    @Inject
    private PluginFinderService pluginFinderService;
    @Inject
    private FailureDetailDao failureDetailDao;
    @Inject
    private AutomatedExecutionFlagService automatedExecutionFlagService;
    @PersistenceContext
    private EntityManager entityManager;

    public void updateExecutionAndClearSession(Long itemId, Long newSuiteId, AutomatedExecutionState stateChange) {
        AutomatedExecutionUpdateData executionData = this.executionDao.findAutomatedExecutionUpdateData(itemId, newSuiteId);
        if (executionData == null) {
            throw new NoSuchElementException("No execution found with requested id : " + String.valueOf(itemId));
        }
        this.addAttachments(stateChange, executionData);
        this.updateExecutionStatus(stateChange, executionData);
        this.updateExecutionStepsStatuses(stateChange, executionData);
        if (this.pluginFinderService.isPremiumPluginInstalled()) {
            this.updateExecutionFailureDetails(stateChange, executionData);
            this.automatedExecutionFlagService.updateExecutionFlag(stateChange, executionData);
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addAttachments(AutomatedExecutionState stateChange, AutomatedExecutionUpdateData updater) {
        Optional.ofNullable(stateChange.getAttachments()).ifPresent(attachments -> attachments.forEach(attachment -> {
            AttachmentDto attachmentDto = this.automatedSuitePublisherService.updateAttachments(updater.attachmentId(), (Attachment)attachment, EntityType.EXECUTION);
        }));
    }

    protected void updateExecutionFailureDetails(AutomatedExecutionState stateChange, AutomatedExecutionUpdateData updater) {
        List<String> failureDetailMessages = stateChange.getTfTestExecutionStatus().getFailureDetails();
        AutomatedExecutionExtender extender = (AutomatedExecutionExtender)this.automatedExecutionExtenderDao.findById(updater.extenderId()).orElseThrow();
        ExecutionStatus status = stateChange.getTfTestExecutionStatus().getStatus();
        if (!ExecutionStatus.RUNNING.equals((Object)status)) {
            this.resetExtenderFailureDetailsAndFlagIfOrchestratorRetry(stateChange, updater, extender);
        }
        if (failureDetailMessages == null || failureDetailMessages.isEmpty()) {
            return;
        }
        List<String> uniqueFailureMessages = failureDetailMessages.stream().distinct().toList();
        TestPlanItem testPlanItem = extender.getTestPlanItem();
        List<FailureDetail> matchingFailureDetails = this.failureDetailDao.findByTestPlanItemIdAndMessageIn(testPlanItem.getId(), uniqueFailureMessages);
        for (String failureDetailMessage : uniqueFailureMessages) {
            this.failureDetailService.upsertFailureDetail(failureDetailMessage, matchingFailureDetails, extender, testPlanItem);
        }
    }

    protected void resetExtenderFailureDetailsAndFlagIfOrchestratorRetry(AutomatedExecutionState stateChange, AutomatedExecutionUpdateData updater, AutomatedExecutionExtender extender) {
        if (!extender.getFailureDetailList().isEmpty()) {
            this.failureDetailService.resetExtenderFailureDetail(extender);
            this.automatedExecutionFlagService.updateExecutionFlag(stateChange, updater);
        }
    }

    private void updateExecutionStatus(AutomatedExecutionState stateChange, AutomatedExecutionUpdateData updater) {
        TestExecutionStatus status = stateChange.getTfTestExecutionStatus().tfTestExecutionStatusToTmTestExecutionStatus();
        this.automatedExecutionManager.changeExecutionState(updater.extenderId(), status);
    }

    private void updateExecutionStepsStatuses(AutomatedExecutionState stateChange, AutomatedExecutionUpdateData updater) {
        List<ExecutionStep> executionSteps = this.executionDao.findSteps(updater.id());
        Map<Integer, TfTestExecutionStatus> testStepExecutionStatuses = stateChange.getTestStepExecutionStatuses();
        this.setStepExecutionStatuses(executionSteps, testStepExecutionStatuses);
    }

    private void setStepExecutionStatuses(List<ExecutionStep> executionSteps, Map<Integer, TfTestExecutionStatus> testStepExecutionStatuses) {
        if (this.shouldPublishStatuses(executionSteps, testStepExecutionStatuses)) {
            int i = 0;
            while (i < executionSteps.size()) {
                TfTestExecutionStatus tfStepStatus = testStepExecutionStatuses.get(i + 1);
                if (tfStepStatus != null) {
                    executionSteps.get(i).setExecutionStatus(org.squashtest.tm.domain.execution.ExecutionStatus.valueOf((String)tfStepStatus.getStatus().name()));
                }
                ++i;
            }
        }
    }

    private boolean shouldPublishStatuses(List<ExecutionStep> executionSteps, Map<Integer, TfTestExecutionStatus> tfTestExecutionStatuses) {
        if (tfTestExecutionStatuses == null) {
            return false;
        }
        if (executionSteps.isEmpty()) {
            return false;
        }
        if (executionSteps.get(0).getReferencedTestStep().getTestCase().getKind() != TestCaseKind.KEYWORD) {
            return false;
        }
        if (executionSteps.size() != tfTestExecutionStatuses.size()) {
            LOGGER.warn("Mismatch between the number of test steps in SquashTM and in the test report: {} steps were defined in SquashTM, but {} steps statuses were send by SquashTM Orchestrator. No step status will be published in SquashTM.", new Object[]{executionSteps.size(), tfTestExecutionStatuses.size()});
            return false;
        }
        return true;
    }
}

