/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;

public class ChannelDeserializer
extends JsonDeserializer<AutomatedExecutionEnvironment> {
    public AutomatedExecutionEnvironment deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode channelNode = (JsonNode)parser.getCodec().readTree(parser);
        AutomatedExecutionEnvironment environment = new AutomatedExecutionEnvironment();
        environment.setName(channelNode.get("metadata").get("name").textValue());
        String namespacesText = channelNode.get("metadata").get("namespaces").textValue();
        environment.setNamespaces(Arrays.asList(namespacesText.split(",")));
        ArrayNode tagArrayNode = (ArrayNode)channelNode.get("spec").get("tags");
        environment.setTags(this.getStringValuesFromArrayNode(tagArrayNode));
        environment.setStatus(channelNode.get("status").get("phase").textValue());
        return environment;
    }

    private List<String> getStringValuesFromArrayNode(ArrayNode arrayNode) {
        ArrayList<String> outputValues = new ArrayList<String>();
        Iterator inputValues = arrayNode.elements();
        while (inputValues.hasNext()) {
            outputValues.add(((JsonNode)inputValues.next()).textValue());
        }
        return outputValues;
    }
}

