/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.assistance.scoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.TestCandidateAnalysis;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.internal.repository.TestCandidateAnalysisDao;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.AnalysisContext;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.ExecutionStatistics;
import org.squashtest.tm.service.internal.testautomation.assistance.scoring.ProjectTestCasesExecutionsData;
import org.squashtest.tm.service.testautomation.assistance.analysis.TestCandidateAnalysisService;
import org.squashtest.tm.service.testautomation.assistance.scoring.TestCandidateScoringCoordinator;
import org.squashtest.tm.service.testautomation.assistance.scoring.TestCandidateScoringProcessor;

@Service
@Transactional
public class TestCandidateScoringCoordinatorImpl
implements TestCandidateScoringCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCandidateScoringCoordinatorImpl.class);
    private final TestCandidateAnalysisDao testCandidateAnalysisDao;
    private final TestCandidateAnalysisService testCandidateAnalysisService;
    private final TestAutomationCandidateDao testAutomationCandidateDao;
    private final TestCandidateScoringProcessor testCandidateScoringProcessor;

    public TestCandidateScoringCoordinatorImpl(TestCandidateAnalysisDao testCandidateAnalysisDao, TestCandidateAnalysisService testCandidateAnalysisService, TestAutomationCandidateDao testAutomationCandidateDao, TestCandidateScoringProcessor testCandidateScoringProcessor) {
        this.testCandidateAnalysisDao = testCandidateAnalysisDao;
        this.testCandidateAnalysisService = testCandidateAnalysisService;
        this.testAutomationCandidateDao = testAutomationCandidateDao;
        this.testCandidateScoringProcessor = testCandidateScoringProcessor;
    }

    @Override
    @Transactional
    public void executeAutomationScoringAnalysisAsync(List<Long> projectIds, long analysisId, String evaluatedBy) {
        LOGGER.debug("Starting async processing for analysis {} with projects: {}", new Object[]{analysisId, projectIds});
        TestCandidateAnalysis analysis = (TestCandidateAnalysis)this.testCandidateAnalysisDao.findById(analysisId).orElseThrow();
        try {
            Map<Long, List<Long>> testCaseIdsByProject = this.testAutomationCandidateDao.findEligibleTestCaseIdsByProjectIds(projectIds);
            int totalTestCases = testCaseIdsByProject.values().stream().mapToInt(List::size).sum();
            if (totalTestCases == 0) {
                LOGGER.debug("No eligible test cases found for analysis {}, completing task", new Object[]{analysisId});
                this.testCandidateAnalysisService.completeAnalysis(analysis);
                return;
            }
            LOGGER.info("Processing {} test cases for analysis {}", new Object[]{totalTestCases, analysisId});
            this.coordinateMultiProjectScoring(testCaseIdsByProject, analysis, evaluatedBy);
            LOGGER.debug("Successfully completed async processing for analysis {}", new Object[]{analysisId});
            this.testCandidateAnalysisService.completeAnalysis(analysis);
        }
        catch (Exception e) {
            LOGGER.error("Error during async processing for analysis {}: {}", new Object[]{analysisId, e.getMessage(), e});
            this.testCandidateAnalysisService.markAnalysisAsFailed(analysis, "Async processing failed: " + e.getMessage());
            throw e;
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void coordinateMultiProjectScoring(Map<Long, List<Long>> testCaseIdsByProject, TestCandidateAnalysis analysis, String evaluatedBy) {
        int totalTestCases = testCaseIdsByProject.values().stream().mapToInt(List::size).sum();
        LOGGER.debug("Creating test automation candidates for {} test cases across {} projects", new Object[]{totalTestCases, testCaseIdsByProject.size()});
        AtomicInteger globalProcessedCount = new AtomicInteger(0);
        for (Map.Entry<Long, List<Long>> entry : testCaseIdsByProject.entrySet()) {
            Long projectId = entry.getKey();
            List<Long> projectTestCaseIds = entry.getValue();
            LOGGER.info("Processing project {} with {} test cases", new Object[]{projectId, projectTestCaseIds.size()});
            this.coordinateSingleProjectScoring(projectId, projectTestCaseIds, analysis.getId(), evaluatedBy, globalProcessedCount, totalTestCases);
        }
        LOGGER.debug("Test automation candidates creation completed", new Object[0]);
    }

    private void coordinateSingleProjectScoring(long projectId, List<Long> eligibleTestCaseIds, long analysisId, String evaluatedBy, AtomicInteger globalProcessedCount, int totalTestCases) {
        Map<Long, Integer> executionCounts = this.testAutomationCandidateDao.countExecutionsByTestCasesForProject(projectId);
        Map<Long, Integer> successCountInLastExecutionsByTestCase = this.testAutomationCandidateDao.countSuccessfulExecutionsInLastRunsByTestCase(projectId, 10);
        ArrayList<Long> allTestCasesIds = new ArrayList<Long>(executionCounts.keySet());
        ExecutionStatistics projectStats = this.testCandidateScoringProcessor.calculateExecutionStatistics(allTestCasesIds, executionCounts);
        Lists.partition(eligibleTestCaseIds, (int)500).forEach(batchIds -> {
            try {
                ProjectTestCasesExecutionsData executionData = new ProjectTestCasesExecutionsData((List<Long>)batchIds, executionCounts, successCountInLastExecutionsByTestCase, projectStats);
                AnalysisContext analysisContext = new AnalysisContext(analysisId, evaluatedBy, globalProcessedCount, totalTestCases);
                this.testCandidateScoringProcessor.processTestCaseBatch(executionData, analysisContext);
                LOGGER.debug("Successfully processed batch of {} test cases for project {}", new Object[]{batchIds.size(), projectId});
            }
            catch (Exception e) {
                LOGGER.error("Error processing batch for project {}: {}", new Object[]{projectId, e.getMessage(), e});
                throw e;
            }
        });
    }
}

