/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.messages.Status;
import org.squashtest.squash.automation.tm.commons.ExpectedSuiteDefinition;
import org.squashtest.squash.automation.tm.testplan.library.model.ExecutionConfiguration;
import org.squashtest.squash.automation.tm.testplan.library.model.TestPlan;
import org.squashtest.squash.automation.tm.testplan.library.model.testspecs.Test;
import org.squashtest.squash.automation.tm.testplan.library.model.testspecs.TestSuite;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.testautomation.BuildDef;
import org.squashtest.tm.service.internal.testautomation.httpclient.BusClientFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.MessageRefusedException;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomBusClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomWorkflowClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.WorkflowClientFactory;
import org.squashtest.tm.service.internal.testautomation.model.TestPlanContext;
import org.squashtest.tm.service.internal.testautomation.model.messages.ExecutionError;
import org.squashtest.tm.service.internal.testautomation.model.messages.PublicationStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.Workflow;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowHandle;
import org.squashtest.tm.service.internal.testautomation.resultpublisher.ExpectedSuiteDefinitionBuilder;
import org.squashtest.tm.service.testautomation.model.EnvironmentVariableValue;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;

public class StartTestExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestExecution.class);
    private static final String API_VERSION = "opentestfactory.org/v1alpha1";
    private static final String EXECUTION_ERROR_NAME = "Failed.squashAutomExecution";
    private static final String WORKFLOW_NAME_FORMAT = "Workflow for SquashTM %s: %s";
    private static final String TS_CUF_PREFIX = "TS_CUF";
    private static final String CPG_CUF_PREFIX = "CPG_CUF";
    private static final String IT_CUF_PREFIX = "IT_CUF";
    private static final String TC_EXECUTION_ID = "TC_EXECUTION_ID";
    private final BuildDef buildDef;
    private final Collection<SquashAutomExecutionConfiguration> configurations;
    private final String uuid;
    private final Long numericalSuiteId;
    private final String callbackUrl;
    private final String automatedServerToken;
    private final SquashAutomWorkflowClient workflowClient;
    private final SquashAutomBusClient busClient;
    private final TestPlanContext testPlanContext;
    private final EntityPathHeaderDao entityPathHeaderDao;
    boolean isUltimateLicenseAvailable;

    public StartTestExecution(BuildDef buildDef, Collection<SquashAutomExecutionConfiguration> configurations, String uuid, Long numericalSuiteId, TestPlanContext testPlanContext, String callbackUrl, String automatedServerToken, WorkflowClientFactory workflowClientFactory, BusClientFactory busClientFactory, EntityPathHeaderDao entityPathHeaderDao, int requestTimeoutSeconds, boolean isUltimateLicenseAvailable) {
        this.buildDef = buildDef;
        this.configurations = configurations;
        this.uuid = uuid;
        this.numericalSuiteId = numericalSuiteId;
        this.testPlanContext = testPlanContext;
        this.workflowClient = this.getWorkflowClient(buildDef, workflowClientFactory, requestTimeoutSeconds);
        this.busClient = busClientFactory.getClient(this.getBusUrl(buildDef.getServer()), buildDef.getCredentials().getToken(), requestTimeoutSeconds);
        this.entityPathHeaderDao = entityPathHeaderDao;
        this.callbackUrl = callbackUrl;
        this.automatedServerToken = automatedServerToken;
        this.isUltimateLicenseAvailable = isUltimateLicenseAvailable;
    }

    private SquashAutomWorkflowClient getWorkflowClient(BuildDef buildDef, WorkflowClientFactory workflowClientFactory, int requestTimeoutSeconds) {
        return workflowClientFactory.getClient(buildDef.getServer().getUrl(), buildDef.getServer().getObserverUrl(), buildDef.getServer().getKillswitchUrl(), buildDef.getCredentials().getToken(), requestTimeoutSeconds);
    }

    public String run() throws MessageRefusedException {
        TestPlan testPlan = this.createTestPlan();
        Workflow workflow = this.createWorkflow(testPlan);
        String workflowId = this.launchWorkflow(workflow);
        this.transmitExpectedSuiteData(workflowId, testPlan, workflow, this.callbackUrl, this.automatedServerToken, this.testPlanContext.getSquashTMVersion());
        return workflowId;
    }

    private Workflow createWorkflow(TestPlan testPlan) {
        String workflowName = String.format(WORKFLOW_NAME_FORMAT, this.testPlanContext.getEntityTypeAsString(), this.testPlanContext.getEntityPath());
        String additionalConfiguration = this.getAutomationServerAdditionalConfiguration(testPlan);
        return new Workflow(API_VERSION, workflowName, testPlan, this.testPlanContext, additionalConfiguration);
    }

    private String getAutomationServerAdditionalConfiguration(TestPlan testPlan) {
        List tests = testPlan.getTestSuite().getTest();
        if (tests.isEmpty()) {
            return "";
        }
        Long projectId = ((Test)tests.get(0)).getTmProjectId();
        ExecutionConfiguration execConf = testPlan.getConfigurations().stream().filter(conf -> conf.getTmProjectId().equals(projectId)).findFirst().orElse(null);
        if (execConf != null) {
            return execConf.getAdditionalConfiguration();
        }
        return "";
    }

    private TestPlan createTestPlan() {
        TestPlan testPlan = new TestPlan();
        testPlan.setSuiteId(this.uuid);
        testPlan.setNumericalSuiteId(this.numericalSuiteId);
        List<Test> tests = this.createTestList();
        testPlan.setTestSuite(new TestSuite(tests));
        testPlan.setNamespace(this.buildDef.getNamespace());
        testPlan.setConfigurations(this.createConfigurations(this.configurations));
        return testPlan;
    }

    private List<ExecutionConfiguration> createConfigurations(Collection<SquashAutomExecutionConfiguration> sourceConfigurations) {
        return sourceConfigurations.stream().map(sourceConfiguration -> new ExecutionConfiguration(sourceConfiguration.getProjectId(), sourceConfiguration.getEnvironmentTags(), this.adaptVariables(sourceConfiguration.getEnvironmentVariables()), sourceConfiguration.getAdditionalConfiguration())).toList();
    }

    private Map<String, Object> adaptVariables(Map<String, EnvironmentVariableValue> environmentVariables) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        environmentVariables.forEach((variableKey, variableValue) -> {
            if (variableValue.isVerbatim().booleanValue()) {
                Pattern pattern = Pattern.compile("^[a-zA-Z0-9-._\\s]*$");
                Matcher matcher = pattern.matcher(variableValue.getValue());
                if (matcher.matches()) {
                    result.put((String)variableKey, variableValue.getValue());
                } else {
                    result.put((String)variableKey, variableValue);
                }
            } else {
                result.put((String)variableKey, variableValue.getValue());
            }
        });
        return result;
    }

    private List<Test> createTestList() {
        Set<Long> testCaseIds = this.buildDef.getParameterizedItems().stream().map(param -> param.getIterationTestPlanItem().getReferencedTestCase().getId()).collect(Collectors.toSet());
        Map<Long, String> testCasePaths = this.entityPathHeaderDao.buildTestCasePathByIds(testCaseIds);
        return this.buildDef.getParameterizedItems().stream().map(paramedItem -> {
            Test test = new Test();
            TestPlanItem item = paramedItem.getIterationTestPlanItem();
            test.setId(item.getId().toString());
            TestCase testCase = item.getReferencedTestCase();
            test.setTmProjectId(testCase.getProject().getId());
            Map<String, String> optimizedForPluginVersionMap = this.removeCampaignCustomFieldsIfCommunity(paramedItem.getCustomFields());
            test.setParam(optimizedForPluginVersionMap);
            String testCasePath = (String)testCasePaths.get(testCase.getId());
            this.buildTestCaseMetadata(test, testCase, testCasePath);
            return test;
        }).toList();
    }

    private Map<String, String> removeCampaignCustomFieldsIfCommunity(Map<String, Object> customFields) {
        if (this.isUltimateLicenseAvailable) {
            return customFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        }
        return customFields.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(TS_CUF_PREFIX) && !((String)entry.getKey()).startsWith(CPG_CUF_PREFIX) && !((String)entry.getKey()).startsWith(IT_CUF_PREFIX) && !((String)entry.getKey()).equals(TC_EXECUTION_ID)).collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    private void buildTestCaseMetadata(Test test, TestCase testCase, String path) {
        test.addMetadata("name", (Object)testCase.getName());
        test.addMetadata("reference", (Object)testCase.getAutomatedTestReference());
        test.addMetadata("uuid", (Object)testCase.getUuid());
        test.addMetadata("nature", (Object)testCase.getNature().getCode());
        test.addMetadata("importance", (Object)testCase.getImportance().name());
        test.addMetadata("type", (Object)testCase.getType().getCode());
        test.addMetadata("technology", (Object)testCase.getAutomatedTestTechnology().getName());
        test.addMetadata("path", this.getPathAsArray(path));
    }

    private List<String> getPathAsArray(String testCasePath) {
        return new ArrayList<String>(Arrays.asList(testCasePath.split(" > ")));
    }

    private String launchWorkflow(Workflow workflow) throws MessageRefusedException {
        WorkflowHandle wfHandle = this.workflowClient.launch(workflow);
        String workflowStartLog = "Workflow '" + workflow.name() + "' sent and received with workflow_id '" + wfHandle.getWorkflowId() + "'";
        LOGGER.info(workflowStartLog, new Object[0]);
        return wfHandle.getWorkflowId();
    }

    private void transmitExpectedSuiteData(String workflowId, TestPlan plan, Workflow workflow, String callbackUrl, String automatedServerToken, String squashTmVersion) throws MessageRefusedException {
        ExpectedSuiteDefinitionBuilder suiteDefBuilder = new ExpectedSuiteDefinitionBuilder();
        ExpectedSuiteDefinition suiteDefinition = suiteDefBuilder.buildExpectedSuiteData(plan, workflowId, workflow, callbackUrl, automatedServerToken, squashTmVersion);
        PublicationStatus publicationResult = this.busClient.publish((OTFMessage)suiteDefinition);
        if (publicationResult.getStatus() == Status.StatusValue.Failure) {
            LOGGER.error("Failed to publish AutomatedSuite definition for generator {} in workflow {} : {}, {}", new Object[]{workflow.name(), workflowId, publicationResult.getReason(), publicationResult.getDetails()});
            HashMap<String, Object> details = new HashMap<String, Object>(publicationResult.getDetails());
            details.put("publisher.error", "failed to publish ExpectedSuite definition.");
            this.busClient.publish(new ExecutionError(API_VERSION, EXECUTION_ERROR_NAME, workflowId, details));
        } else {
            LOGGER.info("Successfully published AutomatedSuite definition for workflow {}", new Object[]{workflowId});
        }
    }

    private String getBusUrl(TestAutomationServer testAutomationServer) {
        return Optional.ofNullable(testAutomationServer.getEventBusUrl()).orElse(testAutomationServer.getUrl());
    }
}

