/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;

public class SquashUserDetailsManagerProxyFactory
implements FactoryBean<SquashUserDetailsManager>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashUserDetailsManagerProxyFactory.class);
    private SquashUserDetailsManager caseSensitiveManager;
    private SquashUserDetailsManager caseInsensitiveManager;
    private FeatureManager features;
    private SquashUserDetailsManager proxy;

    public void setCaseSensitiveManager(SquashUserDetailsManager caseSensitiveManager) {
        this.caseSensitiveManager = caseSensitiveManager;
    }

    public void setCaseInsensitiveManager(SquashUserDetailsManager caseInsensitiveManager) {
        this.caseInsensitiveManager = caseInsensitiveManager;
    }

    public void setFeatures(FeatureManager features) {
        this.features = features;
    }

    private SquashUserDetailsManager getCurrentManager() {
        return this.features.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN) ? this.caseInsensitiveManager : this.caseSensitiveManager;
    }

    public SquashUserDetailsManager getObject() {
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return SquashUserDetailsManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.proxy == null) {
            this.proxy = (SquashUserDetailsManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{SquashUserDetailsManager.class}, (InvocationHandler)new ManagerDelegator(this));
        }
    }

    private static final class ManagerDelegator
    implements InvocationHandler {
        private final SquashUserDetailsManagerProxyFactory context;

        private ManagerDelegator(SquashUserDetailsManagerProxyFactory context) {
            this.context = context;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.context.getCurrentManager(), args);
            }
            catch (InvocationTargetException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e.getCause();
            }
        }
    }
}

