/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCoverageStat;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionStatus;
import org.squashtest.tm.exception.requirement.AbstractVerifiedRequirementException;
import org.squashtest.tm.exception.requirement.RequirementAlreadyVerifiedException;
import org.squashtest.tm.exception.requirement.RequirementVersionNotLinkableException;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.JooqIterationDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.requirement.VerifiedRequirementsManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.requirement.VerifiedRequirementsManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.VerifiedRequirement;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Service(value="squashtest.tm.service.VerifiedRequirementsManagerService")
@Transactional
public class VerifiedRequirementsManagerServiceImpl
implements VerifiedRequirementsManagerService {
    private static final Logger LOGGER;
    private static final String LINK_TC_OR_ROLE_ADMIN = "hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'LINK') or hasRole('ROLE_ADMIN')";
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private TestStepDao testStepDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private TestCaseCallTreeFinder callTreeFinder;
    @Inject
    private RequirementVersionCoverageDao requirementVersionCoverageDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private JooqIterationDao jooqIterationDao;
    @Inject
    private ExecutionStepDao executionStepDao;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private TestCaseLoader testCaseLoader;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        VerifiedRequirementsManagerServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(VerifiedRequirementsManagerServiceImpl.class);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'LINK') or hasRole('ROLE_ADMIN')")
    public Collection<AbstractVerifiedRequirementException> addVerifiedRequirementsToTestCase(List<Long> requirementLibraryNodeIds, long testCaseId) {
        this.permissionEvaluationService.checkPermission(requirementLibraryNodeIds, Permissions.READ.name(), RequirementLibraryNode.class.getName());
        List<RequirementVersion> requirementVersions = this.findCurrentRequirementVersions(requirementLibraryNodeIds);
        return this.findVerifiedRequirementExceptionsForTestCase(testCaseId, requirementVersions);
    }

    @Override
    public Collection<AbstractVerifiedRequirementException> addVerifiedRequirementsToTestCaseUnsecured(List<Long> requirementsIds, TestCase testCase) {
        List<RequirementVersion> requirementVersions = this.findCurrentRequirementVersions(requirementsIds);
        return this.findVerifiedRequirementExceptionsForTestCase(testCase, requirementVersions);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'LINK') or hasRole('ROLE_ADMIN')")
    public Collection<AbstractVerifiedRequirementException> addRequirementVersionsToTestCase(List<Long> requirementVersionIds, long testCaseId) {
        List<RequirementVersion> requirementVersions = this.getRequirementVersionsInCorrectOrder(requirementVersionIds);
        return this.findVerifiedRequirementExceptionsForTestCase(testCaseId, requirementVersions);
    }

    @Override
    public Collection<AbstractVerifiedRequirementException> addRequirementVersionsToTestCaseUnsecured(List<Long> requirementVersionIds, TestCase testCase) {
        List<RequirementVersion> requirementVersions = this.getRequirementVersionsInCorrectOrder(requirementVersionIds);
        return this.findVerifiedRequirementExceptionsForTestCase(testCase, requirementVersions);
    }

    private Collection<AbstractVerifiedRequirementException> findVerifiedRequirementExceptionsForTestCase(long testCaseId, List<RequirementVersion> requirementVersions) {
        if (!requirementVersions.isEmpty()) {
            TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_REQUIREMENT_VERSION_COVERAGES));
            return this.doAddVerifyingRequirementVersionsToTestCase(requirementVersions, testCase);
        }
        return Collections.emptyList();
    }

    private Collection<AbstractVerifiedRequirementException> findVerifiedRequirementExceptionsForTestCase(TestCase testCase, List<RequirementVersion> requirementVersions) {
        if (!requirementVersions.isEmpty()) {
            return this.doAddVerifyingRequirementVersionsToTestCase(requirementVersions, testCase);
        }
        return Collections.emptyList();
    }

    private List<RequirementVersion> extractVersions(List<Requirement> requirements) {
        ArrayList<RequirementVersion> rvs = new ArrayList<RequirementVersion>(requirements.size());
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        for (Requirement requirement : requirements) {
            if (activeMilestone.isEmpty()) {
                rvs.add(requirement.getResource());
                continue;
            }
            rvs.add(requirement.findByMilestone(activeMilestone.get()));
        }
        return rvs;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeVerifiedRequirementFromTestCase(List<Long> requirementIds, long testCaseId) {
        List<RequirementVersion> requirementVersions = this.findCurrentRequirementVersions(requirementIds);
        List<Long> requirementVersionsIds = requirementVersions.stream().map(Resource::getId).toList();
        this.removeVerifiedRequirementVersionsFromTestCase(requirementVersionsIds, testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeVerifiedRequirementVersionsFromTestCase(List<Long> requirementVersionsIds, long testCaseId) {
        if (!requirementVersionsIds.isEmpty()) {
            List requirementVersionCoverageIds = this.requirementVersionCoverageDao.byTestCaseAndRequirementVersions(requirementVersionsIds, testCaseId);
            this.requirementVersionCoverageDao.delete(requirementVersionCoverageIds);
            this.testCaseImportanceManagerService.changeImportanceIfRelationsRemovedFromTestCase(requirementVersionsIds, testCaseId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeVerifiedRequirementVersionFromTestCase(long requirementVersionId, long testCaseId) {
        RequirementVersionCoverage coverage = this.requirementVersionCoverageDao.byRequirementVersionAndTestCase(requirementVersionId, testCaseId);
        this.requirementVersionCoverageDao.delete(List.of(coverage.getId()));
        this.testCaseImportanceManagerService.changeImportanceIfRelationsRemovedFromTestCase(Arrays.asList(requirementVersionId), testCaseId);
    }

    @Override
    public int changeVerifiedRequirementVersionOnTestCase(long oldVerifiedRequirementVersionId, long newVerifiedRequirementVersionId, long testCaseId) {
        RequirementVersion newReq = (RequirementVersion)this.requirementVersionDao.getReferenceById(newVerifiedRequirementVersionId);
        RequirementVersionCoverage coverage = this.requirementVersionCoverageDao.byRequirementVersionAndTestCase(oldVerifiedRequirementVersionId, testCaseId);
        coverage.setVerifiedRequirementVersion(newReq);
        this.testCaseImportanceManagerService.changeImportanceIfRelationsRemovedFromTestCase(Arrays.asList(newVerifiedRequirementVersionId), testCaseId);
        return newReq.getVersionNumber();
    }

    private Collection<AbstractVerifiedRequirementException> doAddVerifyingRequirementVersionsToTestCase(List<RequirementVersion> requirementVersions, TestCase testCase) {
        ArrayList<AbstractVerifiedRequirementException> rejections = new ArrayList<AbstractVerifiedRequirementException>();
        Iterator<RequirementVersion> iterator = requirementVersions.iterator();
        while (iterator.hasNext()) {
            RequirementVersion requirementVersion = iterator.next();
            try {
                RequirementVersionCoverage coverage = new RequirementVersionCoverage(requirementVersion, testCase);
                this.requirementVersionCoverageDao.persist(coverage);
            }
            catch (RequirementAlreadyVerifiedException | RequirementVersionNotLinkableException ex) {
                LOGGER.warn(ex.getMessage(), new Object[0]);
                rejections.add((AbstractVerifiedRequirementException)ex);
                iterator.remove();
            }
        }
        this.testCaseImportanceManagerService.changeImportanceIfRelationsAddedToTestCase(requirementVersions, testCase);
        return rejections;
    }

    @Override
    public void addVerifiedRequirementVersionsToTestCaseFromReq(RequirementVersion requirementVersion, TestCase testCase) {
        RequirementVersionCoverage coverage = new RequirementVersionCoverage(requirementVersion, testCase, false);
        this.requirementVersionCoverageDao.persist(coverage);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep' , 'LINK') or hasRole('ROLE_ADMIN')")
    public Collection<AbstractVerifiedRequirementException> addVerifiedRequirementsToTestStep(List<Long> requirementLibraryNodeIds, long testStepId) {
        this.permissionEvaluationService.checkPermission(requirementLibraryNodeIds, Permissions.READ.name(), RequirementLibraryNode.class.getName());
        List<RequirementVersion> requirementVersions = this.findCurrentRequirementVersions(requirementLibraryNodeIds);
        return this.findVerifiedRequirementExceptionsForStep(testStepId, requirementVersions);
    }

    @Override
    public Collection<AbstractVerifiedRequirementException> addVerifiedRequirementsToTestStepUnsecured(List<Long> requirementsIds, ActionTestStep actionTestStep, TestCase testCase) {
        List<RequirementVersion> requirementVersions = this.findCurrentRequirementVersions(requirementsIds);
        return this.findVerifiedRequirementExceptionsForStep(actionTestStep, testCase, requirementVersions);
    }

    private Collection<AbstractVerifiedRequirementException> findVerifiedRequirementExceptionsForStep(ActionTestStep actionTestStep, TestCase testCase, List<RequirementVersion> requirementVersions) {
        ArrayList<AbstractVerifiedRequirementException> rejections = new ArrayList<AbstractVerifiedRequirementException>();
        if (!requirementVersions.isEmpty()) {
            this.testAllRequirement(requirementVersions, actionTestStep, testCase, rejections);
            this.testCaseImportanceManagerService.changeImportanceIfRelationsAddedToTestCase(requirementVersions, testCase);
        }
        return rejections;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep' , 'LINK') or hasRole('ROLE_ADMIN')")
    public Collection<AbstractVerifiedRequirementException> addRequirementVersionsToTestStep(List<Long> requirementVersionIds, long testStepId) {
        this.permissionEvaluationService.checkPermission(requirementVersionIds, Permissions.READ.name(), RequirementVersion.class.getName());
        List<RequirementVersion> requirementVersions = this.getRequirementVersionsInCorrectOrder(requirementVersionIds);
        return this.findVerifiedRequirementExceptionsForStep(testStepId, requirementVersions);
    }

    @Override
    public Collection<AbstractVerifiedRequirementException> addRequirementVersionsToTestStepUnsecured(List<Long> requirementVersionIds, ActionTestStep actionTestStep, TestCase testCase) {
        List<RequirementVersion> requirementVersions = this.getRequirementVersionsInCorrectOrder(requirementVersionIds);
        return this.findVerifiedRequirementExceptionsForStep(actionTestStep, testCase, requirementVersions);
    }

    private List<RequirementVersion> getRequirementVersionsInCorrectOrder(List<Long> requirementVersionIds) {
        List<Long> list = requirementVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        VerifiedRequirementsManagerServiceImpl$AjcClosure1 verifiedRequirementsManagerServiceImpl$AjcClosure1 = new VerifiedRequirementsManagerServiceImpl$AjcClosure1(objectArray);
        List requirementVersions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(verifiedRequirementsManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        requirementVersions.sort(Comparator.comparing(RequirementVersion::fetchRequirementId).thenComparing(RequirementVersion::getVersionNumber).reversed());
        return requirementVersions;
    }

    private Collection<AbstractVerifiedRequirementException> findVerifiedRequirementExceptionsForStep(long testStepId, List<RequirementVersion> requirementVersions) {
        ArrayList<AbstractVerifiedRequirementException> rejections = new ArrayList<AbstractVerifiedRequirementException>();
        if (!requirementVersions.isEmpty()) {
            ActionTestStep step = this.testStepDao.findActionTestStepById(testStepId);
            TestCase testCase = step.getTestCase();
            this.testAllRequirement(requirementVersions, step, testCase, rejections);
            this.testCaseImportanceManagerService.changeImportanceIfRelationsAddedToTestCase(requirementVersions, testCase);
        }
        return rejections;
    }

    public void testAllRequirement(List<RequirementVersion> requirementVersions, ActionTestStep step, TestCase testCase, Collection<AbstractVerifiedRequirementException> rejections) {
        Iterator<RequirementVersion> iterator = requirementVersions.iterator();
        while (iterator.hasNext()) {
            try {
                RequirementVersion requirementVersion = iterator.next();
                boolean newReqCoverage = this.addVerifiedRequirementVersionToTestStep(requirementVersion, step, testCase);
                if (newReqCoverage) continue;
                iterator.remove();
            }
            catch (RequirementAlreadyVerifiedException | RequirementVersionNotLinkableException ex) {
                LOGGER.warn(ex.getMessage(), new Object[0]);
                iterator.remove();
                rejections.add((AbstractVerifiedRequirementException)ex);
            }
        }
    }

    private boolean addVerifiedRequirementVersionToTestStep(RequirementVersion requirementVersion, ActionTestStep step, TestCase testCase) {
        RequirementVersionCoverage coverage = this.requirementVersionCoverageDao.byRequirementVersionAndTestCase(requirementVersion.getId(), testCase.getId());
        if (coverage == null) {
            RequirementVersionCoverage newCoverage = new RequirementVersionCoverage(requirementVersion, testCase);
            newCoverage.addAllVerifyingSteps(Arrays.asList(step));
            this.requirementVersionCoverageDao.persist(newCoverage);
            return true;
        }
        if (coverage.hasStepAsVerifying(step.getId().longValue())) {
            throw new RequirementAlreadyVerifiedException(requirementVersion, testCase);
        }
        coverage.addAllVerifyingSteps(Arrays.asList(step));
        return false;
    }

    private List<RequirementVersion> findCurrentRequirementVersions(List<Long> requirementsIds) {
        List<Requirement> requirements = this.requirementDao.findRequirementsNodeRootAndInFolderByNodeIds(requirementsIds);
        if (!requirements.isEmpty()) {
            return this.extractVersions(requirements);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(readOnly=true)
    public PagedCollectionHolder<List<VerifiedRequirement>> findAllVerifiedRequirementsByTestCaseId(long testCaseId, PagingAndSorting pas) {
        LOGGER.debug("Looking for verified requirements of TestCase[id:{}]", new Object[]{testCaseId});
        Set<Long> calleesIds = this.callTreeFinder.getTestCaseCallTree(testCaseId);
        calleesIds.add(testCaseId);
        LOGGER.debug("Fetching Requirements verified by TestCases {}", new Object[]{calleesIds.toString()});
        List pagedVersionVerifiedByCalles = this.requirementVersionCoverageDao.findDistinctRequirementVersionsByTestCases(calleesIds, pas);
        TestCase mainTestCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_REQUIREMENT_VERSION_COVERAGES));
        List<VerifiedRequirement> pagedVerifiedReqs = this.buildVerifiedRequirementList(mainTestCase, pagedVersionVerifiedByCalles);
        Set<Long> set = calleesIds;
        RequirementVersionCoverageDao requirementVersionCoverageDao = this.requirementVersionCoverageDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)requirementVersionCoverageDao, set);
        Object[] objectArray = new Object[]{this, requirementVersionCoverageDao, set, joinPoint};
        VerifiedRequirementsManagerServiceImpl$AjcClosure3 verifiedRequirementsManagerServiceImpl$AjcClosure3 = new VerifiedRequirementsManagerServiceImpl$AjcClosure3(objectArray);
        long totalVerified = Conversions.longValue((Object)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(verifiedRequirementsManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        LOGGER.debug("Total count of verified requirements : {}", new Object[]{totalVerified});
        return new PagingBackedPagedCollectionHolder((Paging)pas, totalVerified, pagedVerifiedReqs);
    }

    @Override
    public List<VerifiedRequirement> findAllVerifiedRequirementsByTestCaseId(long testCaseId) {
        LOGGER.debug("Looking for verified requirements of TestCase[id:{}]", new Object[]{testCaseId});
        Set<Long> calleesIds = this.callTreeFinder.getTestCaseCallTree(testCaseId);
        calleesIds.add(testCaseId);
        LOGGER.debug("Fetching Requirements verified by TestCases {}", new Object[]{calleesIds.toString()});
        List pagedVersionVerifiedByCalles = this.requirementVersionCoverageDao.findDistinctRequirementVersionsByTestCases(calleesIds);
        TestCase mainTestCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_REQUIREMENT_VERSION_COVERAGES));
        return this.buildVerifiedRequirementList(mainTestCase, pagedVersionVerifiedByCalles);
    }

    @Override
    public Map<Long, Boolean> findisReqCoveredOfCallingTCWhenisReqCoveredChanged(long updatedTestCaseId, Collection<Long> toUpdateIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(toUpdateIds.size());
        if (this.testCaseHasDirectCoverage(updatedTestCaseId) || this.testCaseHasUndirectRequirementCoverage(updatedTestCaseId)) {
            for (Long id : toUpdateIds) {
                result.put(id, Boolean.TRUE);
            }
        } else {
            for (Long id : toUpdateIds) {
                Boolean value = this.testCaseHasDirectCoverage(id) || this.testCaseHasUndirectRequirementCoverage(id);
                result.put(id, value);
            }
        }
        return result;
    }

    @Override
    public boolean testCaseHasUndirectRequirementCoverage(long updatedTestCaseId) {
        List<Long> calledTestCaseIds = this.testCaseDao.findAllDistinctTestCasesIdsCalledByTestCase(updatedTestCaseId);
        if (!calledTestCaseIds.isEmpty()) {
            for (Long id : calledTestCaseIds) {
                if (!this.testCaseHasDirectCoverage(id) && !this.testCaseHasUndirectRequirementCoverage(id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean testCaseHasDirectCoverage(long updatedTestCaseId) {
        return this.requirementVersionDao.countVerifiedByTestCase(updatedTestCaseId) > 0L;
    }

    private List<VerifiedRequirement> buildVerifiedRequirementList(TestCase main, List<RequirementVersion> pagedVersionVerifiedByCalles) {
        ArrayList<VerifiedRequirement> toReturn = new ArrayList<VerifiedRequirement>(pagedVersionVerifiedByCalles.size());
        for (RequirementVersion rVersion : pagedVersionVerifiedByCalles) {
            boolean isDirect = main.verifies(rVersion);
            toReturn.add(new VerifiedRequirement(rVersion, isDirect).withVerifyingStepsFrom(main));
        }
        return toReturn;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep' , 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeVerifiedRequirementVersionsFromTestStep(List<Long> requirementVersionsIds, long testStepId) {
        this.permissionEvaluationService.checkPermission(requirementVersionsIds, Permissions.READ.name(), RequirementVersion.class.getName());
        List coverageIds = this.requirementVersionCoverageDao.byRequirementVersionsAndTestStep(requirementVersionsIds, testStepId);
        this.requirementVersionCoverageDao.removeTestStepCoverageByCoverageIdsAndTestStepId(coverageIds, testStepId);
        TestCase tc = this.testStepDao.findTestCaseFromActionTestStep(testStepId);
        this.auditModificationService.updateAuditable((AuditableMixin)tc);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion' , 'READ') or hasRole('ROLE_ADMIN')")
    public void findCoverageStat(Long requirementVersionId, List<Long> iterationsIds, RequirementCoverageStat stats) {
        RequirementVersion mainVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        Requirement mainRequirement = mainVersion.getRequirement();
        List<RequirementVersion> descendants = this.findValidDescendants(mainRequirement);
        this.findCoverageRate(mainVersion, descendants, stats);
        if (!iterationsIds.isEmpty()) {
            this.checkPerimeter(iterationsIds, stats);
            if (!stats.isCorruptedPerimeter()) {
                this.findExecutionRate(mainVersion, descendants, stats, iterationsIds);
            }
        }
        stats.convertRatesToPercent();
    }

    private void checkPerimeter(List<Long> iterationsIds, RequirementCoverageStat stats) {
        List iterations = this.iterationDao.findAllByIds(iterationsIds);
        if (iterations.size() != iterationsIds.size()) {
            stats.setCorruptedPerimeter(true);
        }
    }

    private void findExecutionRate(RequirementVersion mainVersion, List<RequirementVersion> descendants, RequirementCoverageStat stats, List<Long> iterationsIds) {
        boolean hasDescendant = !descendants.isEmpty();
        RequirementCoverageStat.Rate verificationRate = new RequirementCoverageStat.Rate();
        RequirementCoverageStat.Rate validationRate = new RequirementCoverageStat.Rate();
        Long[] mainUntestedElementsCount = new Long[]{0L};
        EnumMap<ExecutionStatus, Long> mainStatusMap = new EnumMap<ExecutionStatus, Long>(ExecutionStatus.class);
        this.makeStatusMap(mainVersion.getRequirementVersionCoverages(), mainUntestedElementsCount, mainStatusMap, iterationsIds);
        verificationRate.setRequirementVersionRate(this.doRateVerifiedCalculation(mainStatusMap, mainUntestedElementsCount[0]));
        validationRate.setRequirementVersionRate(this.doRateValidatedCalculation(mainStatusMap));
        if (hasDescendant) {
            verificationRate.setAncestor(true);
            validationRate.setAncestor(true);
            Set<RequirementVersionCoverage> descendantCoverages = this.getDescendantCoverages(descendants);
            Long[] descendantUntestedElementsCount = new Long[]{0L};
            EnumMap<ExecutionStatus, Long> descendantStatusMap = new EnumMap<ExecutionStatus, Long>(ExecutionStatus.class);
            this.makeStatusMap(descendantCoverages, descendantUntestedElementsCount, descendantStatusMap, iterationsIds);
            verificationRate.setRequirementVersionChildrenRate(this.doRateVerifiedCalculation(descendantStatusMap, descendantUntestedElementsCount[0]));
            validationRate.setRequirementVersionChildrenRate(this.doRateValidatedCalculation(descendantStatusMap));
            Long[] allUntestedElementsCount = new Long[]{0L};
            allUntestedElementsCount[0] = mainUntestedElementsCount[0] + descendantUntestedElementsCount[0];
            Map<ExecutionStatus, Long> allStatusMap = this.mergeMapResult(mainStatusMap, descendantStatusMap);
            verificationRate.setRequirementVersionGlobalRate(this.doRateVerifiedCalculation(allStatusMap, allUntestedElementsCount[0]));
            validationRate.setRequirementVersionGlobalRate(this.doRateValidatedCalculation(allStatusMap));
        }
        stats.addRate("verification", verificationRate);
        stats.addRate("validation", validationRate);
    }

    private Map<ExecutionStatus, Long> mergeMapResult(Map<ExecutionStatus, Long> mainStatusMap, Map<ExecutionStatus, Long> descendantStatusMap) {
        EnumMap<ExecutionStatus, Long> mergedStatusMap = new EnumMap<ExecutionStatus, Long>(ExecutionStatus.class);
        EnumSet<ExecutionStatus> allStatus = EnumSet.allOf(ExecutionStatus.class);
        for (ExecutionStatus executionStatus : allStatus) {
            Long mainCount = mainStatusMap.get(executionStatus) == null ? Long.valueOf(0L) : mainStatusMap.get(executionStatus);
            Long descendantCount = descendantStatusMap.get(executionStatus) == null ? Long.valueOf(0L) : descendantStatusMap.get(executionStatus);
            Long totalCount = mainCount + descendantCount;
            mergedStatusMap.put(executionStatus, totalCount);
        }
        return mergedStatusMap;
    }

    private void fusionMapResult(Map<ExecutionStatus, Long> statusMap, Map<ExecutionStatus, Long> statusMapToMerge) {
        for (Map.Entry<ExecutionStatus, Long> mergeEntry : statusMapToMerge.entrySet()) {
            ExecutionStatus executionStatus = mergeEntry.getKey();
            Long originalValue = statusMap.get(executionStatus);
            Long mergedValue = mergeEntry.getValue();
            if (mergedValue != null && originalValue == null) {
                statusMap.put(executionStatus, mergedValue);
            }
            if (mergedValue == null || originalValue == null) continue;
            statusMap.put(executionStatus, mergedValue + originalValue);
        }
    }

    private Set<RequirementVersionCoverage> getDescendantCoverages(List<RequirementVersion> descendants) {
        HashSet<RequirementVersionCoverage> covs = new HashSet<RequirementVersionCoverage>();
        for (RequirementVersion requirementVersion : descendants) {
            Set coverages = requirementVersion.getRequirementVersionCoverages();
            if (coverages.isEmpty()) continue;
            covs.addAll(coverages);
        }
        return covs;
    }

    private List<Long> filterTCIds(List<Long> tcIds, List<Long> tCWithItpiIds) {
        ArrayList<Long> filtered = new ArrayList<Long>();
        filtered.addAll(tcIds);
        filtered.removeAll(tCWithItpiIds);
        return filtered;
    }

    private List<Long> convertSetToList(Map<Long, Long> nbSimpleCoverageByTestCase) {
        ArrayList<Long> testCaseIds = new ArrayList<Long>();
        testCaseIds.addAll(nbSimpleCoverageByTestCase.keySet());
        return testCaseIds;
    }

    private List<Long> findTCWithItpi(List<Long> tcIds, List<Long> iterationsIds) {
        return this.jooqIterationDao.getVerifiedTcIdsInIterations(tcIds, iterationsIds);
    }

    private void makeStatusMap(Set<RequirementVersionCoverage> covs, Long[] untestedElementsCount, Map<ExecutionStatus, Long> statusMap, List<Long> iterationsIds) {
        ArrayList<RequirementVersionCoverage> simpleCoverage = new ArrayList<RequirementVersionCoverage>();
        ArrayList<RequirementVersionCoverage> stepedCoverage = new ArrayList<RequirementVersionCoverage>();
        HashMap<Long, Long> nbSimpleCoverageByTestCase = new HashMap<Long, Long>();
        HashMap<Long, Long> nbSteppedCoverageByTestCase = new HashMap<Long, Long>();
        this.partRequirementVersionCoverage(covs, simpleCoverage, stepedCoverage, nbSimpleCoverageByTestCase, nbSteppedCoverageByTestCase);
        List<Long> simpleCoverageTCIds = this.convertSetToList(nbSimpleCoverageByTestCase);
        List<Long> simpleTCWithItpiIds = this.findTCWithItpi(simpleCoverageTCIds, iterationsIds);
        List<Long> mainVersionTCWithoutItpiIds = this.filterTCIds(simpleCoverageTCIds, simpleTCWithItpiIds);
        Map<ExecutionStatus, Long> statusMapForSimple = this.findResultsForSimpleCoverage(simpleTCWithItpiIds, iterationsIds, nbSimpleCoverageByTestCase);
        List<Long> steppedCoverageTCIds = this.convertSetToList(nbSteppedCoverageByTestCase);
        List<Long> steppedCoverageTCIdsWithITPI = this.jooqIterationDao.getVerifiedTcIdsInIterations(steppedCoverageTCIds, iterationsIds);
        List<Long> steppedCoverageTCIdsWithExecution = this.jooqIterationDao.getVerifiedAndExecutedTcIdsInIterations(steppedCoverageTCIds, iterationsIds);
        List<Long> steppedCoverageTCIdsWithoutITPI = this.filterTCIds(steppedCoverageTCIds, steppedCoverageTCIdsWithITPI);
        List<Long> steppedCoverageTCIdsWithoutExecution = this.filterTCIds(steppedCoverageTCIdsWithITPI, steppedCoverageTCIdsWithExecution);
        Map<ExecutionStatus, Long> statusMapForSteppedNoExecution = this.findResultsForSteppedCoverageWithoutExecution(stepedCoverage, steppedCoverageTCIdsWithoutExecution, iterationsIds);
        untestedElementsCount[0] = this.calculateUntestedElementCount(mainVersionTCWithoutItpiIds, nbSimpleCoverageByTestCase, stepedCoverage, steppedCoverageTCIdsWithoutITPI);
        Map<ExecutionStatus, Long> statusMapForSteppedWithExecution = this.findResultsForSteppedCoverageWithExecution(stepedCoverage, steppedCoverageTCIdsWithExecution);
        this.fusionMapResult(statusMap, statusMapForSimple);
        this.fusionMapResult(statusMap, statusMapForSteppedNoExecution);
        this.fusionMapResult(statusMap, statusMapForSteppedWithExecution);
    }

    private Map<ExecutionStatus, Long> findResultsForSteppedCoverageWithoutExecution(List<RequirementVersionCoverage> stepedCoverage, List<Long> testCaseIds, List<Long> iterationsIds) {
        Map<Long, List<TestCaseExecutionStatus>> testCaseExecutionStatus = this.jooqIterationDao.findItemsStatusByTestCaseId(testCaseIds, iterationsIds);
        EnumMap<ExecutionStatus, Long> result = new EnumMap<ExecutionStatus, Long>(ExecutionStatus.class);
        for (RequirementVersionCoverage cov : stepedCoverage) {
            Long tcId = cov.getVerifyingTestCase().getId();
            List<TestCaseExecutionStatus> tcsStatus = testCaseExecutionStatus.get(tcId);
            if (tcsStatus == null) continue;
            for (TestCaseExecutionStatus tcStatus : tcsStatus) {
                result.put(tcStatus.getStatus(), Long.valueOf(cov.getVerifyingSteps().size()));
            }
        }
        return result;
    }

    private Map<ExecutionStatus, Long> findResultsForSteppedCoverageWithExecution(List<RequirementVersionCoverage> stepedCoverage, List<Long> mainVersionTCWithItpiIds) {
        ArrayList<Long> testStepsIds = new ArrayList<Long>();
        EnumMap<ExecutionStatus, Long> result = new EnumMap<ExecutionStatus, Long>(ExecutionStatus.class);
        for (RequirementVersionCoverage cov : stepedCoverage) {
            Long tcId = cov.getVerifyingTestCase().getId();
            if (!mainVersionTCWithItpiIds.contains(tcId)) continue;
            for (ActionTestStep step : cov.getVerifyingSteps()) {
                testStepsIds.add(step.getId());
            }
        }
        MultiMap executionsStatus = this.executionStepDao.findStepExecutionsStatus(mainVersionTCWithItpiIds, testStepsIds);
        for (Long testStepsId : testStepsIds) {
            if (!executionsStatus.containsKey((Object)testStepsId)) continue;
            List executionSteps = (List)executionsStatus.get((Object)testStepsId);
            this.fillingResult(executionSteps, result);
        }
        return result;
    }

    private void fillingResult(List<ExecutionStep> executionSteps, Map<ExecutionStatus, Long> result) {
        for (ExecutionStep executionStep : executionSteps) {
            Long memo;
            Execution execution = executionStep.getExecution();
            TestPlanItem testPlanItem = execution.getTestPlanItem();
            Date itpiDateLastExecutedOn = testPlanItem.getLastExecutedOn();
            Date execDateLastExecutedOn = execution.getLastExecutedOn();
            ExecutionStatus status = ExecutionStatus.READY;
            if (itpiDateLastExecutedOn != null && execDateLastExecutedOn != null) {
                DateTime itpiLastExecutedOn = new DateTime(testPlanItem.getLastExecutedOn().getTime());
                DateTime execLastExecutedOn = new DateTime(execution.getLastExecutedOn().getTime());
                Interval interval = new Interval((ReadableInstant)execLastExecutedOn, (ReadableInstant)itpiLastExecutedOn);
                boolean fastPass = interval.toDuration().isLongerThan((ReadableDuration)new Duration(2000L));
                ExecutionStatus executionStatus = status = fastPass ? testPlanItem.getExecutionStatus() : executionStep.getExecutionStatus();
            }
            if ((memo = result.get(status)) == null) {
                result.put(status, 1L);
                continue;
            }
            result.put(status, memo + 1L);
        }
    }

    private Long calculateUntestedElementCount(List<Long> mainVersionTCWithoutItpiIds, Map<Long, Long> nbSimpleCoverageByTestCase, List<RequirementVersionCoverage> stepedCoverage, List<Long> steppedCoverageTCIdsWithoutITPI) {
        Long total = 0L;
        for (Long tcId : mainVersionTCWithoutItpiIds) {
            Long nbCovegrage = nbSimpleCoverageByTestCase.get(tcId);
            if (nbCovegrage == null || nbCovegrage == 0L) continue;
            total = total + nbCovegrage;
        }
        for (Long tcId : steppedCoverageTCIdsWithoutITPI) {
            for (RequirementVersionCoverage cov : stepedCoverage) {
                if (!cov.getVerifyingTestCase().getId().equals(tcId)) continue;
                total = total + (long)cov.getVerifyingSteps().size();
            }
        }
        return total;
    }

    private double doRateVerifiedCalculation(Map<ExecutionStatus, Long> fullCoverageResult, Long untestedElementsCount) {
        Set<ExecutionStatus> statusSet = this.getVerifiedStatus();
        return this.doRateCalculation(statusSet, fullCoverageResult, untestedElementsCount);
    }

    private double doRateValidatedCalculation(Map<ExecutionStatus, Long> fullCoverageResult) {
        Set<ExecutionStatus> validStatusSet = this.getValidatedStatus();
        Set<ExecutionStatus> verifiedStatusSet = this.getVerifiedStatus();
        return this.doRateCalculation(validStatusSet, verifiedStatusSet, fullCoverageResult);
    }

    private double doRateCalculation(Set<ExecutionStatus> numeratorStatus, Set<ExecutionStatus> denominatorStatus, Map<ExecutionStatus, Long> fullCoverageResult) {
        double numerator = this.countforStatus(fullCoverageResult, numeratorStatus).longValue();
        double denominator = this.countforStatus(fullCoverageResult, denominatorStatus).longValue();
        return numerator / denominator;
    }

    private double doRateCalculation(Set<ExecutionStatus> statusSet, Map<ExecutionStatus, Long> fullCoverageResult, Long untestedElementsCount) {
        double execWithRequiredStatus = this.countforStatus(fullCoverageResult, statusSet).longValue();
        double allExecutionCount = this.getCandidateExecCount(fullCoverageResult).longValue();
        double nbTCWithoutItpi = untestedElementsCount.longValue();
        return execWithRequiredStatus / (allExecutionCount + nbTCWithoutItpi);
    }

    private Long getCandidateExecCount(Map<ExecutionStatus, Long> fullCoverageResult) {
        Long nbStatus = 0L;
        for (Long countForOneStatus : fullCoverageResult.values()) {
            nbStatus = nbStatus + countForOneStatus;
        }
        return nbStatus;
    }

    private Long countforStatus(Map<ExecutionStatus, Long> fullCoverageResult, Set<ExecutionStatus> statusSet) {
        Long count = 0L;
        for (Map.Entry<ExecutionStatus, Long> executionStatus : fullCoverageResult.entrySet()) {
            if (!statusSet.contains(executionStatus.getKey())) continue;
            count = count + executionStatus.getValue();
        }
        return count;
    }

    private Set<ExecutionStatus> getVerifiedStatus() {
        HashSet<ExecutionStatus> verifiedStatus = new HashSet<ExecutionStatus>();
        verifiedStatus.add(ExecutionStatus.SUCCESS);
        verifiedStatus.add(ExecutionStatus.SETTLED);
        verifiedStatus.add(ExecutionStatus.FAILURE);
        verifiedStatus.add(ExecutionStatus.BLOCKED);
        verifiedStatus.add(ExecutionStatus.UNTESTABLE);
        verifiedStatus.add(ExecutionStatus.SKIPPED);
        verifiedStatus.add(ExecutionStatus.CANCELLED);
        return verifiedStatus;
    }

    private Set<ExecutionStatus> getValidatedStatus() {
        HashSet<ExecutionStatus> verifiedStatus = new HashSet<ExecutionStatus>();
        verifiedStatus.add(ExecutionStatus.SUCCESS);
        verifiedStatus.add(ExecutionStatus.SETTLED);
        return verifiedStatus;
    }

    private Map<ExecutionStatus, Long> findResultsForSimpleCoverage(List<Long> testCaseIds, List<Long> iterationIds, Map<Long, Long> nbSimpleCoverageByTestCase) {
        List<TestCaseExecutionStatus> testCaseExecutionStatus = this.jooqIterationDao.getExecStatusForIterationsAndTestCases(testCaseIds, iterationIds);
        EnumMap<ExecutionStatus, Long> computedResults = new EnumMap<ExecutionStatus, Long>(ExecutionStatus.class);
        for (TestCaseExecutionStatus oneTCES : testCaseExecutionStatus) {
            ExecutionStatus status = oneTCES.getStatus();
            Long nbCoverage = nbSimpleCoverageByTestCase.get(oneTCES.getTestCaseId());
            if (computedResults.containsKey(status)) {
                computedResults.put(status, (Long)computedResults.get(status) + nbCoverage);
                continue;
            }
            computedResults.put(status, nbCoverage);
        }
        return computedResults;
    }

    private void partRequirementVersionCoverage(Set<RequirementVersionCoverage> requirementVersionCoverages, List<RequirementVersionCoverage> simpleCoverage, List<RequirementVersionCoverage> stepedCoverage, Map<Long, Long> nbSimpleCoverageByTestCase, Map<Long, Long> nbSteppedCoverageByTestCase) {
        for (RequirementVersionCoverage requirementVersionCoverage : requirementVersionCoverages) {
            Long tcId = requirementVersionCoverage.getVerifyingTestCase().getId();
            if (requirementVersionCoverage.hasSteps()) {
                stepedCoverage.add(requirementVersionCoverage);
                if (nbSteppedCoverageByTestCase.containsKey(tcId)) {
                    nbSteppedCoverageByTestCase.put(tcId, nbSteppedCoverageByTestCase.get(tcId) + 1L);
                    continue;
                }
                nbSteppedCoverageByTestCase.put(tcId, 1L);
                continue;
            }
            simpleCoverage.add(requirementVersionCoverage);
            if (nbSimpleCoverageByTestCase.containsKey(tcId)) {
                nbSimpleCoverageByTestCase.put(tcId, nbSimpleCoverageByTestCase.get(tcId) + 1L);
                continue;
            }
            nbSimpleCoverageByTestCase.put(tcId, 1L);
        }
    }

    private void findCoverageRate(RequirementVersion mainVersion, List<RequirementVersion> descendants, RequirementCoverageStat stats) {
        RequirementCoverageStat.Rate coverageRate = new RequirementCoverageStat.Rate();
        boolean hasValidDescendant = !descendants.isEmpty();
        coverageRate.setRequirementVersionRate((double)this.calculateCoverageRate(mainVersion).longValue());
        if (hasValidDescendant) {
            coverageRate.setRequirementVersionChildrenRate(this.calculateCoverageRate(descendants));
            List<RequirementVersion> all = this.getAllRequirementVersion(mainVersion, descendants);
            coverageRate.setRequirementVersionGlobalRate(this.calculateCoverageRate(all));
            coverageRate.setAncestor(true);
        }
        stats.addRate("coverage", coverageRate);
        stats.setAncestor(hasValidDescendant);
    }

    private List<RequirementVersion> getAllRequirementVersion(RequirementVersion mainVersion, List<RequirementVersion> descendants) {
        ArrayList<RequirementVersion> all = new ArrayList<RequirementVersion>();
        all.add(mainVersion);
        all.addAll(descendants);
        return all;
    }

    private double calculateCoverageRate(List<RequirementVersion> rvs) {
        double total = 0.0;
        double size = rvs.size();
        for (RequirementVersion rv : rvs) {
            total += (double)this.calculateCoverageRate(rv).longValue();
        }
        return total / size;
    }

    private Long calculateCoverageRate(RequirementVersion mainVersion) {
        if (!mainVersion.getRequirementVersionCoverages().isEmpty()) {
            return 1L;
        }
        return 0L;
    }

    private List<RequirementVersion> findValidDescendants(Requirement requirement) {
        List<Long> candidatesIds = this.requirementDao.findDescendantRequirementIds(Arrays.asList(requirement.getId()));
        List<Requirement> candidates = this.requirementDao.findAllByIds(candidatesIds);
        return this.extractCurrentVersions(candidates);
    }

    private List<RequirementVersion> extractCurrentVersions(List<Requirement> requirements) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        ArrayList<RequirementVersion> rvs = new ArrayList<RequirementVersion>(requirements.size());
        for (Requirement requirement : requirements) {
            RequirementVersion rv = requirement.getResource();
            if (!rv.isNotObsolete() || activeMilestone.isPresent() && !rv.getMilestones().contains(activeMilestone.get())) continue;
            rvs.add(rv);
        }
        return rvs;
    }

    static final /* synthetic */ List findAllById_aroundBody0(VerifiedRequirementsManagerServiceImpl verifiedRequirementsManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ long numberDistinctVerifiedByTestCases_aroundBody2(VerifiedRequirementsManagerServiceImpl verifiedRequirementsManagerServiceImpl, RequirementVersionCoverageDao requirementVersionCoverageDao, Collection collection, JoinPoint joinPoint) {
        return requirementVersionCoverageDao.numberDistinctVerifiedByTestCases(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VerifiedRequirementsManagerServiceImpl.java", VerifiedRequirementsManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "arg0", "", "java.util.List"), 362);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "numberDistinctVerifiedByTestCases", "org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao", "java.util.Collection", "arg0", "", "long"), 475);
    }
}

