/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionBundleStatsDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionStatsDto;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.statistics.helpers.WorkspaceStatisticsHelper;
import org.squashtest.tm.service.statistics.requirement.RequirementBoundDescriptionStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementBoundTestCasesStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementCoverageStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementCriticalityStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementStatisticsBundle;
import org.squashtest.tm.service.statistics.requirement.RequirementStatusesStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementValidationStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementVersionBundleStat;

@Service(value="RequirementStatisticsService")
@Transactional(readOnly=true)
public class RequirementStatisticsServiceImpl
implements RequirementStatisticsService {
    private static final String CRITICALITY_STATISTICS_NAMED_QUERY = "RequirementStatistics.criticalityStatistics";
    private static final String CRITICALITY_STATISTICS_BY_VERSION_IDS_NAMED_QUERY = "RequirementStatistics.criticalityStatisticsByVersionIds";
    private static final String STATUSES_STATISTICS_NAMED_QUERY = "RequirementStatistics.statusesStatistics";
    private static final String STATUSES_STATISTICS_BY_VERSION_IDS_NAMED_QUERY = "RequirementStatistics.statusesStatisticsByVersionIds";
    private static final String UNDEFINED = "UNDEFINED";
    private static final String MINOR = "MINOR";
    private static final String MAJOR = "MAJOR";
    private static final String CRITICAL = "CRITICAL";
    private static final String CRITICALITY_ERROR_MESSAGE = "RequirementStatisticsService cannot handle the following RequirementCriticality value : ";
    private static final String REQUIREMENT_IDS = "requirementIds";
    private static final String REQUIREMENT_VERSION_IDS = "requirementVersionIds";
    private static final String CRITICALITY = "criticality";
    private static final String VALIDATION_STATUS = "validationStatus";
    private static final String OBSOLETE = "OBSOLETE";
    @Value(value="${squash.legacy.requirement.validation.chart:false}")
    private boolean withLegacyValidationStatistics;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private RequirementDao requirementDao;

    @Override
    public RequirementStatisticsBundle gatherRequirementStatisticsBundle(Collection<Long> requirementIds) {
        RequirementBoundTestCasesStatistics tcs = this.gatherBoundTestCaseStatistics(requirementIds);
        RequirementStatusesStatistics status = this.gatherRequirementStatusesStatistics(requirementIds);
        RequirementCriticalityStatistics criticality = this.gatherRequirementCriticalityStatistics(requirementIds);
        RequirementBoundDescriptionStatistics description = this.gatherRequirementBoundDescriptionStatistics(requirementIds);
        RequirementCoverageStatistics coverage = this.gatherRequirementCoverageStatistics(requirementIds);
        RequirementValidationStatistics validation = this.gatherRequirementValidationStatistics(requirementIds);
        return new RequirementStatisticsBundle(tcs, status, criticality, description, coverage, validation, requirementIds);
    }

    @Override
    public RequirementStatisticsBundle gatherRequirementStatisticsBundleForActiveMilestone(Collection<Long> requirementIds, Milestone activeMilestone) {
        List<Long> reqVersionIdsInMilestoneAndSelection = this.findAllReqVersionIdsInMilestoneAndSelectedReqIds(activeMilestone, requirementIds);
        RequirementBoundTestCasesStatistics tcs = this.gatherBoundTestCaseStatisticsByVersionIds(reqVersionIdsInMilestoneAndSelection);
        RequirementStatusesStatistics status = this.gatherRequirementStatusesStatisticsByVersionIds(reqVersionIdsInMilestoneAndSelection);
        RequirementCriticalityStatistics criticality = this.gatherRequirementCriticalityStatisticsByVersionIds(reqVersionIdsInMilestoneAndSelection);
        RequirementBoundDescriptionStatistics description = this.gatherRequirementBoundDescriptionStatisticsByVersionIds(reqVersionIdsInMilestoneAndSelection);
        RequirementCoverageStatistics coverage = this.gatherRequirementCoverageStatisticsByVersionIds(reqVersionIdsInMilestoneAndSelection);
        RequirementValidationStatistics validation = this.gatherRequirementValidationStatisticsByVersionIds(reqVersionIdsInMilestoneAndSelection);
        return new RequirementStatisticsBundle(tcs, status, criticality, description, coverage, validation, reqVersionIdsInMilestoneAndSelection);
    }

    @Override
    public RequirementBoundTestCasesStatistics gatherBoundTestCaseStatistics(Collection<Long> requirementIds) {
        return this.doGatherBoundTestCaseStatistics(requirementIds, "Select coverageStats.sizeclass, count(coverageStats.sizeclass) as count\nFrom\n(Select case\n    When count(distinct coverage.tcId) = 0 then 0\n    When count(distinct coverage.tcId) = 1 then 1\n    Else 2\nEnd as sizeclass\nFrom (\n    Select req.rln_id as reqId, tcln.tcln_id as tcId\n    From REQUIREMENT req\n    Left Outer Join REQUIREMENT_VERSION_COVERAGE cov on req.current_version_id = cov.verified_req_version_id\n    left join TEST_CASE_LIBRARY_NODE tcln on cov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\n    Where req.rln_id in (:requirementIds)\n    Union\n    Select linkedLowLevelReq.high_level_requirement_id as reqId,\n           tcln.tcln_id as tcId\n    From REQUIREMENT linkedLowLevelReq\n    Left Outer Join REQUIREMENT_VERSION_COVERAGE cov\n        on linkedLowLevelReq.current_version_id = cov.verified_req_version_id\n    left join TEST_CASE_LIBRARY_NODE tcln on cov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\n    Where linkedLowLevelReq.high_level_requirement_id in (:requirementIds)\n) as coverage\nGroup By coverage.reqId\n) as coverageStats\nGroup By coverageStats.sizeclass\n", REQUIREMENT_IDS);
    }

    @Override
    public RequirementBoundTestCasesStatistics gatherBoundTestCaseStatisticsByVersionIds(Collection<Long> requirementVersionIds) {
        return this.doGatherBoundTestCaseStatistics(requirementVersionIds, "Select coverageStats.sizeclass, count(coverageStats.sizeclass) as count\nFrom\n(Select case\n    When count(distinct coverage.tcId) = 0 then 0\n    When count(distinct coverage.tcId) = 1 then 1\n    Else 2\nEnd as sizeclass\nFrom (\n    Select reqVer.res_id as resId, tcln.tcln_id as tcId\n    From REQUIREMENT_VERSION reqVer\n    Left Outer Join REQUIREMENT_VERSION_COVERAGE cov\n        on reqVer.res_id = cov.verified_req_version_id\n    left join TEST_CASE_LIBRARY_NODE tcln on cov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\n    Where reqVer.res_id in (:requirementVersionIds)\n    Union\n    Select reqVer.res_id as resId, tcln.tcln_id as tcId\n    From REQUIREMENT_VERSION reqVer\n    Left Join REQUIREMENT linkedLowLevelReq\n        on reqVer.requirement_id = linkedLowLevelReq.high_level_requirement_id\n    Left Outer Join REQUIREMENT_VERSION_COVERAGE cov\n        on linkedLowLevelReq.current_version_id = cov.verified_req_version_id\n     left join TEST_CASE_LIBRARY_NODE tcln on cov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\n    Where reqVer.res_id in (:requirementVersionIds)\n) as coverage\nGroup By coverage.resId\n) as coverageStats\nGroup By coverageStats.sizeclass\n", REQUIREMENT_VERSION_IDS);
    }

    private RequirementBoundTestCasesStatistics doGatherBoundTestCaseStatistics(Collection<Long> ids, String queryString, String parameterName) {
        if (ids.isEmpty()) {
            return new RequirementBoundTestCasesStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(queryString, true, parameterName, ids, this.entityManager);
        return this.createRequirementBoundTestCasesStatistics(tuples);
    }

    private RequirementBoundTestCasesStatistics createRequirementBoundTestCasesStatistics(Map<Object, Integer> tuples) {
        RequirementBoundTestCasesStatistics stats = new RequirementBoundTestCasesStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            Integer sizeClass = (Integer)tuple.getKey();
            Integer count = tuple.getValue();
            switch (sizeClass) {
                case 0: {
                    stats.setZeroTestCases(count);
                    break;
                }
                case 1: {
                    stats.setOneTestCase(count);
                    break;
                }
                case 2: {
                    stats.setManyTestCases(count);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("RequirementStatisticsServiceImpl#gatherBoundTestCaseStatistics : there should not be a sizeclass <0 or >2. It's a bug.");
                }
            }
        }
        return stats;
    }

    @Override
    public RequirementCriticalityStatistics gatherRequirementCriticalityStatistics(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return new RequirementCriticalityStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(CRITICALITY_STATISTICS_NAMED_QUERY, false, REQUIREMENT_IDS, requirementIds, this.entityManager);
        return this.createRequirementCriticalityStats(tuples);
    }

    @Override
    public RequirementCriticalityStatistics gatherRequirementCriticalityStatisticsByVersionIds(Collection<Long> requirementVersionIds) {
        if (requirementVersionIds.isEmpty()) {
            return new RequirementCriticalityStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(CRITICALITY_STATISTICS_BY_VERSION_IDS_NAMED_QUERY, false, REQUIREMENT_VERSION_IDS, requirementVersionIds, this.entityManager);
        return this.createRequirementCriticalityStats(tuples);
    }

    private RequirementCriticalityStatistics createRequirementCriticalityStats(Map<Object, Integer> tuples) {
        RequirementCriticalityStatistics stats = new RequirementCriticalityStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            RequirementCriticality criticality = (RequirementCriticality)tuple.getKey();
            Integer cardinality = tuple.getValue();
            switch (criticality) {
                case UNDEFINED: {
                    stats.setUndefined(cardinality);
                    break;
                }
                case MINOR: {
                    stats.setMinor(cardinality);
                    break;
                }
                case MAJOR: {
                    stats.setMajor(cardinality);
                    break;
                }
                case CRITICAL: {
                    stats.setCritical(cardinality);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(CRITICALITY_ERROR_MESSAGE + String.valueOf(tuple.getKey()));
                }
            }
        }
        return stats;
    }

    @Override
    public RequirementStatusesStatistics gatherRequirementStatusesStatistics(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return new RequirementStatusesStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(STATUSES_STATISTICS_NAMED_QUERY, false, REQUIREMENT_IDS, requirementIds, this.entityManager);
        return this.createRequirementStatusesStats(tuples);
    }

    @Override
    public RequirementStatusesStatistics gatherRequirementStatusesStatisticsByVersionIds(Collection<Long> requirementVersionIds) {
        if (requirementVersionIds.isEmpty()) {
            return new RequirementStatusesStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(STATUSES_STATISTICS_BY_VERSION_IDS_NAMED_QUERY, false, REQUIREMENT_VERSION_IDS, requirementVersionIds, this.entityManager);
        return this.createRequirementStatusesStats(tuples);
    }

    private RequirementStatusesStatistics createRequirementStatusesStats(Map<Object, Integer> tuples) {
        RequirementStatusesStatistics stats = new RequirementStatusesStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            RequirementStatus status = (RequirementStatus)tuple.getKey();
            Integer cardinality = tuple.getValue();
            switch (status) {
                case WORK_IN_PROGRESS: {
                    stats.setWorkInProgress(cardinality);
                    break;
                }
                case UNDER_REVIEW: {
                    stats.setUnderReview(cardinality);
                    break;
                }
                case APPROVED: {
                    stats.setApproved(cardinality);
                    break;
                }
                case OBSOLETE: {
                    stats.setObsolete(cardinality);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("RequirmentStatisticsService cannot handle the following RequirementStatus value : '" + String.valueOf(tuple.getKey()) + "'");
                }
            }
        }
        return stats;
    }

    @Override
    public RequirementBoundDescriptionStatistics gatherRequirementBoundDescriptionStatistics(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return new RequirementBoundDescriptionStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap("Select (Case When res.description != '' AND res.description is not null Then 1 Else 0 End) as hasDescription, count(res.res_id)\nFrom REQUIREMENT req\nInner Join REQUIREMENT_VERSION reqVer on req.current_version_id = reqVer.res_id\nInner Join RESOURCE res on reqVer.res_id = res.res_id\nWhere req.rln_id in (:requirementIds)\nGroup By hasDescription\n", true, REQUIREMENT_IDS, requirementIds, this.entityManager);
        return this.createRequirementBoundDescriptionStats(tuples);
    }

    @Override
    public RequirementBoundDescriptionStatistics gatherRequirementBoundDescriptionStatisticsByVersionIds(Collection<Long> requirementVersionIds) {
        if (requirementVersionIds.isEmpty()) {
            return new RequirementBoundDescriptionStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap("Select (Case When res.description != '' AND res.description is not null Then 1 Else 0 End) as hasDescription, count(res.res_id)\nFrom RESOURCE res\nWhere res.res_id in (:requirementVersionIds)\nGroup By hasDescription\n", true, REQUIREMENT_VERSION_IDS, requirementVersionIds, this.entityManager);
        return this.createRequirementBoundDescriptionStats(tuples);
    }

    private RequirementBoundDescriptionStatistics createRequirementBoundDescriptionStats(Map<Object, Integer> tuples) {
        RequirementBoundDescriptionStatistics stats = new RequirementBoundDescriptionStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            boolean hasDescription = (Integer)tuple.getKey() != 0;
            Integer count = tuple.getValue();
            if (hasDescription) {
                stats.setHasDescription(count);
                continue;
            }
            stats.setHasNoDescription(count);
        }
        return stats;
    }

    @Override
    public RequirementCoverageStatistics gatherRequirementCoverageStatistics(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return new RequirementCoverageStatistics();
        }
        Map<String, Object[]> tuples = RequirementStatisticsServiceImpl.retrieveAllRequirementCoverageStatisticsIntoMap("Select totalSelection.criticality, Coalesce(coveredSelection.coverCount, 0), totalSelection.totalCount\nFrom\n(Select coverageStats.criticality as criticality, count(sizeclass) as coverCount\nFrom (Select coverage.criticality as criticality, Case When count(coverage.tcId) = 0 then 0 Else 1 End as sizeclass\nFrom (Select reqVer.criticality as criticality, req.rln_id as reqId, CASE WHEN tcln.tcln_id IS NOT NULL THEN reqVerCov.verified_req_version_id ELSE NULL END as tcId\nFrom REQUIREMENT_VERSION as reqVer\nJoin REQUIREMENT req on reqVer.res_id = req.current_version_id\nLeft Outer Join REQUIREMENT_VERSION_COVERAGE reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\nleft join TEST_CASE_LIBRARY_NODE tcln on reqVerCov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\nWhere req.rln_id in (:requirementIds)\nUnion\nSelect reqVer.criticality as criticality, req.rln_id as reqId, CASE WHEN tcln.tcln_id IS NOT NULL THEN reqVerCov.verified_req_version_id ELSE NULL END as tcId\nFrom REQUIREMENT_VERSION as reqVer\nJoin REQUIREMENT req on reqVer.res_id = req.current_version_id\nJoin REQUIREMENT linkedLowLevelReq on req.rln_id = linkedLowLevelReq.high_level_requirement_id\nLeft Outer Join REQUIREMENT_VERSION_COVERAGE reqVerCov on reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\nleft join TEST_CASE_LIBRARY_NODE tcln on reqVerCov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\nWhere req.rln_id in (:requirementIds)) as coverage\nGroup By coverage.reqId, coverage.criticality) as coverageStats\nWhere sizeclass = 1\nGroup By coverageStats.criticality)\nas coveredSelection\nRight Outer Join\n(Select reqVer2.criticality as criticality, count(reqVer2.res_id) as totalCount\nFrom REQUIREMENT_VERSION as reqVer2\nInner Join REQUIREMENT req2 on reqVer2.res_id = req2.current_version_id\nWhere req2.rln_id in (:requirementIds) Group By reqVer2.criticality)\nas totalSelection\nOn coveredSelection.criticality = totalSelection.criticality\n", true, REQUIREMENT_IDS, requirementIds, this.entityManager);
        return this.createRequirementCoverageStatistics(tuples);
    }

    @Override
    public RequirementCoverageStatistics gatherRequirementCoverageStatisticsByVersionIds(Collection<Long> requirementVersionIds) {
        if (requirementVersionIds.isEmpty()) {
            return new RequirementCoverageStatistics();
        }
        Map<String, Object[]> tuples = RequirementStatisticsServiceImpl.retrieveAllRequirementCoverageStatisticsIntoMap("Select totalSelection.criticality, Coalesce(coveredSelection.coverCount, 0), totalSelection.totalCount\nFrom\n(Select coverageStats.criticality as criticality, count(sizeclass) as coverCount\nFrom (Select coverage.criticality as criticality, Case When count(coverage.tcId) = 0 then 0 Else 1 End as sizeclass\nFrom (Select reqVer.criticality as criticality, reqVer.res_id as resId, CASE WHEN tcln.tcln_id IS NOT NULL THEN reqVerCov.verified_req_version_id ELSE NULL END as tcId\nFrom REQUIREMENT_VERSION as reqVer\nLeft Outer Join REQUIREMENT_VERSION_COVERAGE reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\nleft join TEST_CASE_LIBRARY_NODE tcln on reqVerCov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\nWhere reqVer.res_id in (:requirementVersionIds)\nUnion\nSelect reqVer.criticality as criticality, reqVer.res_id as resId, CASE WHEN tcln.tcln_id IS NOT NULL THEN reqVerCov.verified_req_version_id ELSE NULL END as tcId\nFrom REQUIREMENT_VERSION as reqVer\nJoin REQUIREMENT linkedLowLevelReq on reqVer.requirement_id = linkedLowLevelReq.high_level_requirement_id\nLeft Outer Join REQUIREMENT_VERSION_COVERAGE reqVerCov on reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\nleft join TEST_CASE_LIBRARY_NODE tcln on reqVerCov.verifying_test_case_id = tcln.tcln_id and tcln.deleted_on is null\nWhere reqVer.res_id in (:requirementVersionIds)) as coverage\nGroup By coverage.resId, coverage.criticality) as coverageStats\nWhere sizeclass = 1\nGroup By coverageStats.criticality)\nas coveredSelection\nRight Outer Join\n(Select reqVer2.criticality as criticality, count(reqVer2.res_id) as totalCount\nFrom REQUIREMENT_VERSION as reqVer2\nWhere reqVer2.res_id in (:requirementVersionIds) Group By reqVer2.criticality)\nas totalSelection\nOn coveredSelection.criticality = totalSelection.criticality\n", true, REQUIREMENT_VERSION_IDS, requirementVersionIds, this.entityManager);
        return this.createRequirementCoverageStatistics(tuples);
    }

    private RequirementCoverageStatistics createRequirementCoverageStatistics(Map<String, Object[]> tuples) {
        RequirementCoverageStatistics stats = new RequirementCoverageStatistics();
        for (Map.Entry<String, Object[]> tuple : tuples.entrySet()) {
            String criticality = tuple.getKey();
            int count = ((Long)tuple.getValue()[0]).intValue();
            int total = ((Long)tuple.getValue()[1]).intValue();
            switch (criticality) {
                case "UNDEFINED": {
                    stats.setUndefined(count);
                    stats.setTotalUndefined(total);
                    break;
                }
                case "MINOR": {
                    stats.setMinor(count);
                    stats.setTotalMinor(total);
                    break;
                }
                case "MAJOR": {
                    stats.setMajor(count);
                    stats.setTotalMajor(total);
                    break;
                }
                case "CRITICAL": {
                    stats.setCritical(count);
                    stats.setTotalCritical(total);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(CRITICALITY_ERROR_MESSAGE + tuple.getKey());
                }
            }
        }
        return stats;
    }

    @Override
    public RequirementValidationStatistics gatherRequirementValidationStatistics(Collection<Long> requirementIds) {
        return this.doGatherRequirementValidationStatistics(requirementIds, "Select Selection1.criticality, Selection1.status, count(*)\n        From\n        (Select Distinct req.rln_id as requirement, reqVer.criticality as criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, itpi.execution_status as status, itpi.last_executed_on as execDate\n        From REQUIREMENT as req\n        Inner Join REQUIREMENT_VERSION as reqVer on req.current_version_id = reqVer.res_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET dataset on dataset.dataset_id = itpi.dataset_id\n        Where req.rln_id in (:requirementIds)\n        Union\n        Select Distinct req.rln_id as requirement, reqVer.criticality as criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, itpi.execution_status as status, itpi.last_executed_on as execDate\n        From REQUIREMENT as req\n        Inner Join REQUIREMENT_VERSION as reqVer on req.current_version_id = reqVer.res_id\n        Left Join REQUIREMENT as linkedLowLevelReq on req.rln_id = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET dataset on dataset.dataset_id = itpi.dataset_id\n        Where req.rln_id in (:requirementIds)) as Selection1\n        Inner Join\n        (Select req.rln_id as requirement, reqVer.criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, max(itpi.last_executed_on) as lastDate\n        From REQUIREMENT as req\n        Inner Join REQUIREMENT_VERSION as reqVer on req.current_version_id = reqVer.res_id\n        Left Join REQUIREMENT as linkedLowLevelReq on req.rln_id = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        OR reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET as dataset on dataset.dataset_id = itpi.dataset_id\n        Inner Join\n        (Select Max(stat.requirement) as requirement, stat.criticality as criticality, stat.testCase as testCase\n        From (Select req.rln_id as requirement, reqVer.criticality as criticality, tc.tcln_id as testCase\n        From REQUIREMENT req\n        Inner Join REQUIREMENT_VERSION as reqVer On req.current_version_id = reqVer.res_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov On reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc On tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Where req.rln_id in (:requirementIds)\n        Union\n        Select req.rln_id as requirement, reqVer.criticality as criticality, tc.tcln_id as testCase\n        From REQUIREMENT req\n        Inner Join REQUIREMENT_VERSION as reqVer On req.current_version_id = reqVer.res_id\n        Left Join REQUIREMENT as linkedLowLevelReq on req.rln_id = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov On reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc On tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Where req.rln_id in (:requirementIds)) as stat\n        Group By criticality, testCase) as NoDuplicateTCByCritSelection\n        On NoDuplicateTCByCritSelection.requirement = req.rln_id\n        And NoDuplicateTCByCritSelection.criticality = reqVer.criticality\n        And NoDuplicateTCByCritSelection.testCase = tc.tcln_id\n        Where req.rln_id in (:requirementIds)\n        Group By req.rln_id, reqVer.criticality, tc.tcln_id, dataset.dataset_id) as LastExecutionSelection\n        On Selection1.requirement = LastExecutionSelection.requirement And Selection1.testCase = LastExecutionSelection.testCase\n        And (Selection1.execDate = LastExecutionSelection.lastDate Or (Selection1.execDate is Null And LastExecutionSelection.lastDate Is Null))\n        And (Selection1.dataset = LastExecutionSelection.dataset Or (Selection1.dataset is Null And LastExecutionSelection.dataset Is Null))\n        Group By Selection1.criticality, Selection1.status", "select a.criticality, a.status, count(*)   from (select aa.rln_id,\naa.criticality,\n       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                     when bb.execution_status in ('SUCCESS') then 1\n                     else 0\n                     end) over (partition by aa.rln_id)\n            when 3 then 'FAILURE'\n            when 2 then 'READY'\n            when 1 then 'SUCCESS'\n            when 0 then 'SETTLED'\n            end status\n  from (select a.rln_id, a.high_level_requirement_id hl_rln_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                        left join HIGH_LEVEL_REQUIREMENT z on a.rln_id=z.rln_id\n                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n         where a.rln_id in (:requirementIds) and z.rln_id is null group by a.rln_id,2,3,d.tcln_id,dataset_id) aa\n        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')\nunion\nselect aa.rln_id,\n       aa.criticality,\n       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                     when bb.execution_status in ('SUCCESS') then 1\n                     else 0\n                     end) over (partition by aa.rln_id)\n            when 3 then 'FAILURE'\n            when 2 then 'READY'\n            when 1 then 'SUCCESS'\n            when 0 then 'SETTLED'\n            end status\n  from (select a.rln_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                             join HIGH_LEVEL_REQUIREMENT f on a.rln_id=f.rln_id\n         where a.rln_id in (:requirementIds)\n      group by 1,2,3,4\n        union\n        select a.high_level_requirement_id rln_id, y.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n          from REQUIREMENT z join REQUIREMENT a on a.high_level_requirement_id=z.rln_id\n                             join REQUIREMENT_VERSION y on z.current_version_id=y.res_id\n                             join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                             join HIGH_LEVEL_REQUIREMENT f on a.high_level_requirement_id=f.rln_id\n                            where a.rln_id in (:requirementIds)  group by 1,2,3,4) aa\n        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')) a group by  a.criticality, a.status;", REQUIREMENT_IDS);
    }

    private RequirementValidationStatistics doGatherRequirementValidationStatistics(Collection<Long> requirementIds, String legacyRequirementSqlValidationStatistics, String requirementSqlValidationStatistics, String parameterName) {
        if (requirementIds.isEmpty()) {
            return new RequirementValidationStatistics();
        }
        String query = this.withLegacyValidationStatistics ? legacyRequirementSqlValidationStatistics : requirementSqlValidationStatistics;
        List<Object[]> tuples = RequirementStatisticsServiceImpl.retrieveAllRequirementValidationStatistics(query, true, parameterName, requirementIds, this.entityManager);
        if (this.withLegacyValidationStatistics) {
            RequirementValidationStatistics legacyStatistics = this.createRequirementValidationStats(tuples);
            legacyStatistics.setLegacy(true);
            return legacyStatistics;
        }
        return this.createRequirementValidationStats(tuples);
    }

    @Override
    public RequirementValidationStatistics gatherRequirementValidationStatisticsByVersionIds(Collection<Long> requirementVersionIds) {
        return this.doGatherRequirementValidationStatistics(requirementVersionIds, "Select Selection1.criticality, Selection1.status, count(*)\n        From\n        (Select Distinct reqVer.res_id as requirementVersion, reqVer.criticality as criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, itpi.execution_status as status, itpi.last_executed_on as execDate\n        From REQUIREMENT_VERSION as reqVer\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET dataset on dataset.dataset_id = itpi.dataset_id\n        Where reqVer.res_id in (:requirementVersionIds)\n        Union\n        Select Distinct reqVer.res_id as requirementVersion, reqVer.criticality as criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, itpi.execution_status as status, itpi.last_executed_on as execDate\n        From REQUIREMENT_VERSION as reqVer\n        Inner Join REQUIREMENT as req On reqVer.requirement_id = req.rln_id\n        Left Join REQUIREMENT as linkedLowLevelReq on req.rln_id = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET dataset on dataset.dataset_id = itpi.dataset_id\n        Where reqVer.res_id in (:requirementVersionIds)) as Selection1\n        Inner Join\n        (Select reqVer.res_id as requirementVersion, reqVer.criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, max(itpi.last_executed_on) as lastDate\n        From REQUIREMENT_VERSION as reqVer\n        Left join REQUIREMENT linkedLowLevelReq ON reqVer.requirement_id = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        OR reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET as dataset on dataset.dataset_id = itpi.dataset_id\n        Inner Join\n        (Select Max(stat.requirementVersion) as requirementVersion, stat.criticality as criticality, stat.testCase as testCase\n        From (Select reqVer.res_id as requirementVersion, reqVer.criticality as criticality, tc.tcln_id as testCase\n        From REQUIREMENT_VERSION as reqVer\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov On reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc On tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Where reqVer.res_id in (:requirementVersionIds)\n        Union\n        Select reqVer.res_id as requirementVersion, reqVer.criticality as criticality, tc.tcln_id as testCase\n        From REQUIREMENT_VERSION as reqVer\n        Inner Join REQUIREMENT req On req.rln_id = reqVer.requirement_id\n        Left Join REQUIREMENT as linkedLowLevelReq on req.rln_id = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov On reqVerCov.verified_req_version_id = linkedLowLevelReq.current_version_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc On tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Where reqVer.res_id in (:requirementVersionIds)) as stat\n        Group By criticality, testCase) as NoDuplicateTCByCritSelection\n        On NoDuplicateTCByCritSelection.requirementVersion = reqVer.res_id\n        And NoDuplicateTCByCritSelection.criticality = reqVer.criticality\n        And NoDuplicateTCByCritSelection.testCase = tc.tcln_id\n        Where reqVer.res_id in (:requirementVersionIds)\n        Group By reqVer.res_id, reqVer.criticality, tc.tcln_id, dataset.dataset_id) as LastExecutionSelection\n        On Selection1.requirementVersion = LastExecutionSelection.requirementVersion And Selection1.testCase = LastExecutionSelection.testCase\n        And (Selection1.execDate = LastExecutionSelection.lastDate Or (Selection1.execDate is Null And LastExecutionSelection.lastDate Is Null))\n        And (Selection1.dataset = LastExecutionSelection.dataset Or (Selection1.dataset is Null And LastExecutionSelection.dataset Is Null))\n        Group By Selection1.criticality, Selection1.status", "select a.criticality, a.status, count(*) from (select aa.res_id,\n                       aa.criticality,\n                       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                                     when bb.execution_status in ('SUCCESS') then 1\n                                     else 0\n                                     end) over (partition by aa.res_id)\n                            when 3 then 'FAILURE'\n                            when 2 then 'READY'\n                            when 1 then 'SUCCESS'\n                            when 0 then 'SETTLED'\n                            end status\n                  from (select a.rln_id, a.high_level_requirement_id hl_rln_id, b.res_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n                          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                                        left join HIGH_LEVEL_REQUIREMENT z on a.rln_id=z.rln_id\n                                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                         where a.current_version_id in (:requirementVersionIds) and z.rln_id is null group by 1,2,3,4,5,6) aa\n                        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')\n                union\n                select aa.res_id,\n                       aa.criticality,\n                       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                                     when bb.execution_status in ('SUCCESS') then 1\n                                     else 0\n                                     end) over (partition by aa.rln_id)\n                            when 3 then 'FAILURE'\n                            when 2 then 'READY'\n                            when 1 then 'SUCCESS'\n                            when 0 then 'SETTLED'\n                            end status\n                  from (select b.res_id, a.rln_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n                          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                                             join HIGH_LEVEL_REQUIREMENT f on a.rln_id=f.rln_id\n                         where b.res_id in (:requirementVersionIds)\n                      group by 1,2,3,4,5\n                        union\n                        select y.res_id, a.high_level_requirement_id rln_id, y.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n                          from REQUIREMENT z join REQUIREMENT a on a.high_level_requirement_id=z.rln_id\n                                             join REQUIREMENT_VERSION y on z.current_version_id=y.res_id\n                                             join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                                             join HIGH_LEVEL_REQUIREMENT f on a.high_level_requirement_id=f.rln_id\n                                            where y.res_id in (:requirementVersionIds)  group by 1,2,3,4,5) aa\n                        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')) a group by  a.criticality, a.status;", REQUIREMENT_VERSION_IDS);
    }

    private RequirementValidationStatistics createRequirementValidationStats(List<Object[]> tuples) {
        RequirementValidationStatistics stats = new RequirementValidationStatistics();
        for (Object[] tuple : tuples) {
            String requirementCriticality = (String)tuple[0];
            String executionStatus = (String)tuple[1];
            int count = ((Long)tuple[2]).intValue();
            if (executionStatus == null) {
                executionStatus = "NOT_RUN";
            }
            this.determineValidationStatisticsCount(stats, requirementCriticality, executionStatus, count);
        }
        return stats;
    }

    private void determineValidationStatisticsCount(RequirementValidationStatistics stats, String requirementCriticality, String executionStatus, Integer count) {
        switch (executionStatus) {
            case "SETTLED": 
            case "SUCCESS": {
                this.determineConclusiveValidationCount(stats, requirementCriticality, count);
                break;
            }
            case "FAILURE": {
                this.determineInconclusiveValidationCount(stats, requirementCriticality, count);
                break;
            }
            case "RUNNING": 
            case "NOT_RUN": 
            case "ERROR": 
            case "READY": 
            case "BLOCKED": 
            case "UNTESTABLE": 
            case "NOT_FOUND": 
            case "WARNING": {
                this.determineUndefinedValidationCount(stats, requirementCriticality, count);
                break;
            }
            default: {
                throw new IllegalArgumentException("RequirementStatisticsService cannot handle the following ExecutionStatus value : '" + executionStatus + "'");
            }
        }
    }

    private void determineUndefinedValidationCount(RequirementValidationStatistics stats, String requirementCriticality, Integer count) {
        switch (requirementCriticality) {
            case "UNDEFINED": {
                stats.setUndefinedUndefined(stats.getUndefinedUndefined() + count);
                break;
            }
            case "MINOR": {
                stats.setUndefinedMinor(stats.getUndefinedMinor() + count);
                break;
            }
            case "MAJOR": {
                stats.setUndefinedMajor(stats.getUndefinedMajor() + count);
                break;
            }
            case "CRITICAL": {
                stats.setUndefinedCritical(stats.getUndefinedCritical() + count);
                break;
            }
            default: {
                throw new IllegalArgumentException(CRITICALITY_ERROR_MESSAGE + requirementCriticality);
            }
        }
    }

    private void determineInconclusiveValidationCount(RequirementValidationStatistics stats, String requirementCriticality, Integer count) {
        switch (requirementCriticality) {
            case "UNDEFINED": {
                stats.setInconclusiveUndefined(count);
                break;
            }
            case "MINOR": {
                stats.setInconclusiveMinor(count);
                break;
            }
            case "MAJOR": {
                stats.setInconclusiveMajor(count);
                break;
            }
            case "CRITICAL": {
                stats.setInconclusiveCritical(count);
                break;
            }
            default: {
                throw new IllegalArgumentException(CRITICALITY_ERROR_MESSAGE + requirementCriticality);
            }
        }
    }

    private void determineConclusiveValidationCount(RequirementValidationStatistics stats, String requirementCriticality, Integer count) {
        switch (requirementCriticality) {
            case "UNDEFINED": {
                stats.setConclusiveUndefined(stats.getConclusiveUndefined() + count);
                break;
            }
            case "MINOR": {
                stats.setConclusiveMinor(stats.getConclusiveMinor() + count);
                break;
            }
            case "MAJOR": {
                stats.setConclusiveMajor(stats.getConclusiveMajor() + count);
                break;
            }
            case "CRITICAL": {
                stats.setConclusiveCritical(stats.getConclusiveCritical() + count);
                break;
            }
            default: {
                throw new IllegalArgumentException(CRITICALITY_ERROR_MESSAGE + requirementCriticality);
            }
        }
    }

    @Override
    public List<Long> findAllReqVersionIdsInMilestoneAndSelectedReqIds(Milestone activeMilestone, Collection<Long> requirementIds) {
        if (activeMilestone != null) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            milestoneIds.add(activeMilestone.getId());
            return this.requirementDao.findAllRequirementIdsFromMilestonesAndSelectedReqIds(milestoneIds, requirementIds);
        }
        return new ArrayList<Long>();
    }

    @Override
    public Collection<Long> gatherRequirementIdsFromValidation(Collection<Long> requirementIds, RequirementCriticality criticality, Collection<String> validationStatus) {
        String query = this.withLegacyValidationStatistics ? "Select Distinct Selection1.requirement\n        From (\n        Select Distinct req.rln_id as requirement, reqVer.criticality as criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, Coalesce(itpi.execution_status, 'NOT_FOUND' ) as status, itpi.last_executed_on as execDate\n        From REQUIREMENT as req\n        Inner Join REQUIREMENT_VERSION as reqVer on req.current_version_id = reqVer.res_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET dataset on dataset.dataset_id = itpi.dataset_id\n        Where req.rln_id In (:requirementIds)\n        Union\n        Select Distinct highReq.rln_id as requirement, highReqVer.criticality as criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, Coalesce(itpi.execution_status, 'NOT_FOUND' ) as status, itpi.last_executed_on as execDate\n        From REQUIREMENT as highReq\n        Inner Join REQUIREMENT_VERSION highReqVer on highReq.current_version_id = highReqVer.RES_ID\n        inner join HIGH_LEVEL_REQUIREMENT hlr on highReq.RLN_ID = hlr.RLN_ID\n        left join REQUIREMENT linkedLowLevelReq on hlr.RLN_ID = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION as reqVer on linkedLowLevelReq.current_version_id = reqVer.res_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET dataset on dataset.dataset_id = itpi.dataset_id\n        Where highReq.RLN_ID In (:requirementIds)\n        ) as Selection1\n        Inner Join\n        (Select LastExecutionSubSelection.requirement as requirement, LastExecutionSubSelection.criticality as criticality, LastExecutionSubSelection.testCase as testCase, LastExecutionSubSelection.dataset as dataset, max(LastExecutionSubSelection.lastDate) as lastDate\n        From\n        (Select req.rln_id as requirement, reqVer.criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, max(itpi.last_executed_on) as lastDate\n        From REQUIREMENT as req\n        Inner Join REQUIREMENT_VERSION as reqVer on req.current_version_id = reqVer.res_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET as dataset on dataset.dataset_id = itpi.dataset_id\n        Where req.rln_id In (:requirementIds)\n        Group By req.rln_id, reqVer.criticality, tc.tcln_id, dataset.dataset_id\n        Union\n        Select highReq.rln_id as requirement, highReqVer.criticality, tc.tcln_id as testCase, dataset.dataset_id as dataset, max(itpi.last_executed_on) as lastDate\n        From REQUIREMENT as highReq\n        Inner Join REQUIREMENT_VERSION highReqVer on highReq.current_version_id = highReqVer.RES_ID\n        inner join HIGH_LEVEL_REQUIREMENT hlr on highReq.RLN_ID = hlr.RLN_ID\n        left join REQUIREMENT linkedLowLevelReq on hlr.RLN_ID = linkedLowLevelReq.high_level_requirement_id\n        Inner Join REQUIREMENT_VERSION as reqVer on linkedLowLevelReq.current_version_id = reqVer.res_id\n        Inner Join REQUIREMENT_VERSION_COVERAGE as reqVerCov on reqVerCov.verified_req_version_id = reqVer.res_id\n        Inner Join TEST_CASE_LIBRARY_NODE as tc on tc.tcln_id = reqVerCov.verifying_test_case_id and tc.deleted_on is null\n        Left Outer Join TEST_PLAN_ITEM itpi on itpi.tcln_id = tc.tcln_id\n        Left Outer Join DATASET as dataset on dataset.dataset_id = itpi.dataset_id\n        Where highReq.rln_id In (:requirementIds)\n        Group By highReq.rln_id, highReqVer.criticality, tc.tcln_id, dataset.dataset_id\n        ) as LastExecutionSubSelection\n        Group By LastExecutionSubSelection.requirement, LastExecutionSubSelection.criticality, LastExecutionSubSelection.testCase, LastExecutionSubSelection.dataset\n        ) as LastExecutionSelection\n        On Selection1.requirement = LastExecutionSelection.requirement And Selection1.testCase = LastExecutionSelection.testCase\n        And (Selection1.execDate = LastExecutionSelection.lastDate Or (Selection1.execDate is Null And LastExecutionSelection.lastDate Is Null))\n        And (Selection1.dataset = LastExecutionSelection.dataset Or (Selection1.dataset is Null And LastExecutionSelection.dataset Is Null))\n        Where Selection1.criticality = (:criticality)\n        And Selection1.status In (:validationStatus)" : "Select Distinct a.rln_id   from (select aa.rln_id,\naa.criticality,\n       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                     when bb.execution_status in ('SUCCESS') then 1\n                     else 0\n                     end) over (partition by aa.rln_id)\n            when 3 then 'FAILURE'\n            when 2 then 'READY'\n            when 1 then 'SUCCESS'\n            when 0 then 'SETTLED'\n            end status\n  from (select a.rln_id, a.high_level_requirement_id hl_rln_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                        left join HIGH_LEVEL_REQUIREMENT z on a.rln_id=z.rln_id\n                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n         where a.rln_id in (:requirementIds) and z.rln_id is null group by a.rln_id,2,3,d.tcln_id,dataset_id) aa\n        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')\nunion\nselect aa.rln_id,\n       aa.criticality,\n       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                     when bb.execution_status in ('SUCCESS') then 1\n                     else 0\n                     end) over (partition by aa.rln_id)\n            when 3 then 'FAILURE'\n            when 2 then 'READY'\n            when 1 then 'SUCCESS'\n            when 0 then 'SETTLED'\n            end status\n  from (select a.rln_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                             join HIGH_LEVEL_REQUIREMENT f on a.rln_id=f.rln_id\n         where a.rln_id in (:requirementIds)\n      group by 1,2,3,4\n        union\n        select a.high_level_requirement_id rln_id, y.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n          from REQUIREMENT z join REQUIREMENT a on a.high_level_requirement_id=z.rln_id\n                             join REQUIREMENT_VERSION y on z.current_version_id=y.res_id\n                             join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                             join HIGH_LEVEL_REQUIREMENT f on a.high_level_requirement_id=f.rln_id\n                            where a.rln_id in (:requirementIds)  group by 1,2,3,4) aa\n        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')) a Where a.criticality = (:criticality) And a.status In (:validationStatus);";
        return this.doGatherRequirementIdsFromValidation(requirementIds, criticality, validationStatus, query, REQUIREMENT_IDS);
    }

    @Override
    public Collection<Long> gatherRequirementIdsFromValidationByVersionIds(Collection<Long> requirementVersionIds, RequirementCriticality criticality, Collection<String> validationStatus) {
        return this.doGatherRequirementIdsFromValidation(requirementVersionIds, criticality, validationStatus, "Select Distinct a.res_id from (select aa.res_id,\n                       aa.criticality,\n                       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                                     when bb.execution_status in ('SUCCESS') then 1\n                                     else 0\n                                     end) over (partition by aa.res_id)\n                            when 3 then 'FAILURE'\n                            when 2 then 'READY'\n                            when 1 then 'SUCCESS'\n                            when 0 then 'SETTLED'\n                            end status\n                  from (select a.rln_id, a.high_level_requirement_id hl_rln_id, b.res_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n                          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                                        left join HIGH_LEVEL_REQUIREMENT z on a.rln_id=z.rln_id\n                                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                         where a.current_version_id in (:requirementVersionIds) and z.rln_id is null group by 1,2,3,4,5,6) aa\n                        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')\n                union\n                select aa.res_id,\n                       aa.criticality,\n                       case max(case when bb.execution_status in ('FAILURE','BLOCKED','UNTESTABLE') then 3\n                                     when bb.execution_status in ('READY','RUNNING') or bb.execution_status is null then 2\n                                     when bb.execution_status in ('SUCCESS') then 1\n                                     else 0\n                                     end) over (partition by aa.rln_id)\n                            when 3 then 'FAILURE'\n                            when 2 then 'READY'\n                            when 1 then 'SUCCESS'\n                            when 0 then 'SETTLED'\n                            end status\n                  from (select b.res_id, a.rln_id, b.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n                          from REQUIREMENT a join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                                             join HIGH_LEVEL_REQUIREMENT f on a.rln_id=f.rln_id\n                         where b.res_id in (:requirementVersionIds)\n                      group by 1,2,3,4,5\n                        union\n                        select y.res_id, a.high_level_requirement_id rln_id, y.criticality, d.tcln_id, coalesce(e.dataset_id,0) dataset_id, max(coalesce(e.last_executed_on,'1970-01-01')) last_exec\n                          from REQUIREMENT z join REQUIREMENT a on a.high_level_requirement_id=z.rln_id\n                                             join REQUIREMENT_VERSION y on z.current_version_id=y.res_id\n                                             join REQUIREMENT_VERSION b on a.current_version_id=b.res_id\n                                        left join REQUIREMENT_VERSION_COVERAGE c on b.res_id=c.verified_req_version_id\n                                        left join TEST_CASE_LIBRARY_NODE d on c.verifying_test_case_id = d.tcln_id and d.deleted_on is null\n                                        left join TEST_PLAN_ITEM e on d.tcln_id=e.tcln_id\n                                             join HIGH_LEVEL_REQUIREMENT f on a.high_level_requirement_id=f.rln_id\n                                            where y.res_id in (:requirementVersionIds)  group by 1,2,3,4,5) aa\n                        left join TEST_PLAN_ITEM bb on aa.tcln_id=bb.tcln_id\n                                                             and aa.dataset_id=coalesce(bb.dataset_id,0)\n                                                             and aa.last_exec=coalesce(bb.last_executed_on, '1970-01-01')) a Where a.criticality = (:criticality) And a.status In (:validationStatus);", REQUIREMENT_VERSION_IDS);
    }

    private Collection<Long> doGatherRequirementIdsFromValidation(Collection<Long> reqIds, RequirementCriticality criticality, Collection<String> validationStatus, String queryString, String mainQueryParameter) {
        if (reqIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        List partitionsIds = Lists.partition(new ArrayList<Long>(reqIds), (int)6000);
        ArrayList<List> partitionResults = new ArrayList<List>();
        for (List partitionIds : partitionsIds) {
            Query query = this.entityManager.createNativeQuery(queryString);
            query.setParameter(mainQueryParameter, (Object)partitionIds);
            query.setParameter(CRITICALITY, (Object)criticality.toString());
            query.setParameter(VALIDATION_STATUS, validationStatus);
            partitionResults.add(query.getResultList());
        }
        HashSet reqIdsList = new HashSet();
        for (List ids : partitionResults) {
            reqIdsList.addAll(new HashSet(ids));
        }
        return new ArrayList<Long>(reqIdsList);
    }

    @Override
    public RequirementVersionBundleStat findSimplifiedCoverageStats(String remoteSynchronisationKind) {
        RequirementVersionBundleStat bundle = new RequirementVersionBundleStat();
        this.computeRedactionRate(remoteSynchronisationKind, bundle);
        this.computeItpiByStatusRate(remoteSynchronisationKind, bundle, ExecutionStatus.getTerminatedStatusSet(), EnumSet.allOf(ExecutionStatus.class), "VERIFICATION_RATE");
        this.computeItpiByStatusRate(remoteSynchronisationKind, bundle, ExecutionStatus.getSuccessStatusSet(), ExecutionStatus.getTerminatedStatusSet(), "VALIDATION_RATE");
        return bundle;
    }

    @Override
    public RequirementVersionBundleStatsDto findCoveragesStatsByRequirementVersionId(Long requirementVersionId) {
        List<Long> descendantResId = this.getNonObsoleteDescendantIds(requirementVersionId);
        return this.findCoveragesStats(requirementVersionId, descendantResId);
    }

    @Override
    public RequirementVersionBundleStatsDto findCoveragesStatsByHighLvlReqVersionId(Long requirementVersionId) {
        List<Long> descendantResId = this.getHighLvlReqNonObsoleteDescendantIds(requirementVersionId);
        return this.findCoveragesStats(requirementVersionId, descendantResId);
    }

    private RequirementVersionBundleStatsDto findCoveragesStats(Long requirementVersionId, List<Long> descendantResId) {
        RequirementVersionBundleStatsDto bundleStatsDto = new RequirementVersionBundleStatsDto();
        this.appendCoverageStats(bundleStatsDto, descendantResId);
        bundleStatsDto.setHaveChildren(!descendantResId.isEmpty());
        descendantResId.add(requirementVersionId);
        RequirementVersionStatsDto currentVersionStats = new RequirementVersionStatsDto();
        RequirementVersionStatsDto childrenStats = new RequirementVersionStatsDto();
        this.appendRedactionStats(requirementVersionId, descendantResId, currentVersionStats, childrenStats);
        this.appendItpiByStatusStats(requirementVersionId, descendantResId, ExecutionStatus.getTerminatedStatusSet(), EnumSet.allOf(ExecutionStatus.class), currentVersionStats, childrenStats, "VERIFICATION_RATE");
        this.appendItpiByStatusStats(requirementVersionId, descendantResId, ExecutionStatus.getSuccessStatusSet(), ExecutionStatus.getTerminatedStatusSet(), currentVersionStats, childrenStats, "VALIDATION_RATE");
        bundleStatsDto.setChildren(childrenStats);
        bundleStatsDto.setCurrentVersion(currentVersionStats);
        bundleStatsDto.setTotal(this.createTotalStats(currentVersionStats, childrenStats));
        return bundleStatsDto;
    }

    private void appendCoverageStats(RequirementVersionBundleStatsDto bundle, List<Long> descendantResId) {
        int[] numCovered = new int[1];
        this.dsl.select((SelectField)DSL.count((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(descendantResId)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).fetch().forEach(r -> {
            int testCaseCount = (Integer)r.component1();
            if (testCaseCount > 0) {
                nArray[0] = numCovered[0] + 1;
            }
        });
        bundle.setCoveredDescendantsCount(numCovered[0]);
        bundle.setNonObsoleteDescendantsCount(descendantResId.size());
    }

    @Override
    public RequirementVersionBundleStatsDto findCoveragesStatsByHighLvlReqId(Long requirementId) {
        org.squashtest.tm.domain.requirement.Requirement req = (org.squashtest.tm.domain.requirement.Requirement)this.entityManager.find(org.squashtest.tm.domain.requirement.Requirement.class, (Object)requirementId);
        return req != null ? this.findCoveragesStatsByHighLvlReqVersionId(req.getCurrentVersion().getId()) : new RequirementVersionBundleStatsDto();
    }

    private RequirementVersionStatsDto createTotalStats(RequirementVersionStatsDto currentVersionStats, RequirementVersionStatsDto childrenStats) {
        RequirementVersionStatsDto total = new RequirementVersionStatsDto();
        total.setPlannedTestCase(currentVersionStats.getPlannedTestCase() + childrenStats.getPlannedTestCase());
        total.setVerifiedTestCase(currentVersionStats.getVerifiedTestCase() + childrenStats.getVerifiedTestCase());
        total.setValidatedTestCases(currentVersionStats.getValidatedTestCases() + childrenStats.getValidatedTestCases());
        total.setExecutedTestCase(currentVersionStats.getExecutedTestCase() + childrenStats.getExecutedTestCase());
        total.setAllTestCaseCount(currentVersionStats.getAllTestCaseCount() + childrenStats.getAllTestCaseCount());
        total.setRedactedTestCase(currentVersionStats.getRedactedTestCase() + childrenStats.getRedactedTestCase());
        return total;
    }

    private void appendRedactionStats(Long requirementVersionId, List<Long> descendantResId, RequirementVersionStatsDto currentVersionStats, RequirementVersionStatsDto childrenStats) {
        TableOnConditionStep joinFromRequirementVersionToTestCase = Tables.REQUIREMENT_VERSION.innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN));
        Field reqIdAllTC = Tables.REQUIREMENT_VERSION.RES_ID.as("reqIdAllTC");
        Field countAllTC = DSL.count().as("countAllTC");
        Table allTestCase = this.dsl.select((SelectField)reqIdAllTC, (SelectField)countAllTC).from((TableLike)joinFromRequirementVersionToTestCase).where(Tables.REQUIREMENT_VERSION.RES_ID.in(descendantResId)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asTable("allTestCase");
        Field reqIdValidatedTC = Tables.REQUIREMENT_VERSION.RES_ID.as("reqIdValidatedTC");
        Field countValidatedTC = DSL.count().as("countValidatedTC");
        Table validatedTestCase = this.dsl.select((SelectField)reqIdValidatedTC, (SelectField)countValidatedTC).from((TableLike)joinFromRequirementVersionToTestCase).where(Tables.REQUIREMENT_VERSION.RES_ID.in(descendantResId)).and(Tables.TEST_CASE.TC_STATUS.in((Object[])new String[]{TestCaseStatus.UNDER_REVIEW.name(), TestCaseStatus.APPROVED.name()})).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asTable("verifiedTestCase");
        this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)allTestCase.field(countAllTC), (SelectField)validatedTestCase.field(countValidatedTC)).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)allTestCase).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(allTestCase.field(reqIdAllTC))).leftJoin((TableLike)validatedTestCase).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(validatedTestCase.field(reqIdValidatedTC))).where(Tables.REQUIREMENT_VERSION.RES_ID.in(descendantResId)).fetch().forEach(r -> {
            Long reqId = (Long)r.get((Field)Tables.REQUIREMENT_VERSION.RES_ID);
            Integer countAllTestCase = Optional.ofNullable((Integer)r.get(allTestCase.field(countAllTC))).orElse(0);
            Integer countValidatedTestCase = Optional.ofNullable((Integer)r.get(validatedTestCase.field(countValidatedTC))).orElse(0);
            if (reqId.equals(requirementVersionId)) {
                currentVersionStats.setAllTestCaseCount(countAllTestCase);
                currentVersionStats.setRedactedTestCase(countValidatedTestCase);
            } else {
                childrenStats.setAllTestCaseCount(childrenStats.getAllTestCaseCount() + countAllTestCase);
                childrenStats.setRedactedTestCase(childrenStats.getRedactedTestCase() + countValidatedTestCase);
            }
        });
    }

    private void appendItpiByStatusStats(Long requirementVersionId, List<Long> requirementVersionIds, Set<ExecutionStatus> matchingStatusSet, Set<ExecutionStatus> allStatusSet, RequirementVersionStatsDto currentVersionStats, RequirementVersionStatsDto childrenStats, String key) {
        TableOnConditionStep joinFromRequirementVersionToITPI = Tables.REQUIREMENT_VERSION.innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID));
        Field lastExecutionTC = Tables.TEST_PLAN_ITEM.TCLN_ID.as("lastExecutionTC");
        Field lastExecutionDS = DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, (Object)0L).as("lastExecutionDS");
        Field lastExecutionDate = DSL.coalesce((Field)DSL.max((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON), (Object)new Timestamp(0L)).as("lastExecutionDate");
        Table selectLastExecution = this.dsl.select((SelectField)lastExecutionTC, (SelectField)lastExecutionDS, (SelectField)lastExecutionDate).from((TableLike)joinFromRequirementVersionToITPI).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.DATASET_ID}).asTable("selectLastExecution");
        Field reqIdAll = Tables.REQUIREMENT_VERSION.RES_ID.as("reqIdAll");
        Field countAll = DSL.count().as("countAll");
        Table allITPI = this.dsl.select((SelectField)reqIdAll, (SelectField)countAll).from((TableLike)joinFromRequirementVersionToITPI).innerJoin((TableLike)selectLastExecution).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq(selectLastExecution.field(lastExecutionTC))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, (Object)0L).eq(selectLastExecution.field(lastExecutionDS))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, (Object)new Timestamp(0L)).eq(selectLastExecution.field(lastExecutionDate))).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(allStatusSet)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asTable("allITPI");
        Field reqIdMatch = Tables.REQUIREMENT_VERSION.RES_ID.as("reqIdMatch");
        Field countMatch = DSL.count().as("countMatch");
        Table matchITPI = this.dsl.select((SelectField)reqIdMatch, (SelectField)countMatch).from((TableLike)joinFromRequirementVersionToITPI).innerJoin((TableLike)selectLastExecution).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq(selectLastExecution.field(lastExecutionTC))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, (Object)0L).eq(selectLastExecution.field(lastExecutionDS))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, (Object)new Timestamp(0L)).eq(selectLastExecution.field(lastExecutionDate))).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(matchingStatusSet)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asTable("matchITPI");
        this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)allITPI.field(countAll), (SelectField)matchITPI.field(countMatch)).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)allITPI).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(allITPI.field(reqIdAll))).leftJoin((TableLike)matchITPI).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(matchITPI.field(reqIdMatch))).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).fetch().forEach(r -> {
            Long reqId = (Long)r.get((Field)Tables.REQUIREMENT_VERSION.RES_ID);
            Integer countAllITPI = Optional.ofNullable((Integer)r.get(allITPI.field(countAll))).orElse(0);
            Integer countValidatedITPI = Optional.ofNullable((Integer)r.get(matchITPI.field(countMatch))).orElse(0);
            if (key.equals("VALIDATION_RATE")) {
                if (reqId.equals(requirementVersionId)) {
                    currentVersionStats.setValidatedTestCases(countValidatedITPI);
                    currentVersionStats.setExecutedTestCase(countAllITPI);
                } else {
                    childrenStats.setValidatedTestCases(childrenStats.getValidatedTestCases() + countValidatedITPI);
                    childrenStats.setExecutedTestCase(childrenStats.getExecutedTestCase() + countAllITPI);
                }
            } else if (reqId.equals(requirementVersionId)) {
                currentVersionStats.setVerifiedTestCase(countValidatedITPI);
                currentVersionStats.setPlannedTestCase(countAllITPI);
            } else {
                childrenStats.setVerifiedTestCase(childrenStats.getVerifiedTestCase() + countValidatedITPI);
                childrenStats.setPlannedTestCase(childrenStats.getPlannedTestCase() + countAllITPI);
            }
        });
    }

    private void computeItpiByStatusRate(String remoteSynchronisationKind, RequirementVersionBundleStat bundle, Set<ExecutionStatus> matchingStatusSet, Set<ExecutionStatus> allStatusSet, String key) {
        TableOnConditionStep joinFromAncestorToITPI = Tables.RLN_RELATIONSHIP_CLOSURE.innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID));
        Field lastExecutionTC = Tables.TEST_PLAN_ITEM.TCLN_ID.as("lastExecutionTC");
        Field lastExecutionDS = DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, (Object)0L).as("lastExecutionDS");
        Field lastExecutionDate = DSL.coalesce((Field)DSL.max((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON), (Object)new Timestamp(0L)).as("lastExecutionDate");
        Table selectLastExecution = this.dsl.select((SelectField)lastExecutionTC, (SelectField)lastExecutionDS, (SelectField)lastExecutionDate).from((TableLike)Tables.TEST_PLAN_ITEM).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.DATASET_ID}).asTable("selectLastExecution");
        Field reqIdAll = Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.as("reqIdAll");
        Field countAll = DSL.count().as("countAll");
        Table allITPI = this.dsl.select((SelectField)reqIdAll, (SelectField)countAll).from((TableLike)joinFromAncestorToITPI).innerJoin((TableLike)selectLastExecution).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq(selectLastExecution.field(lastExecutionTC))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, (Object)0L).eq(selectLastExecution.field(lastExecutionDS))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, (Object)new Timestamp(0L)).eq(selectLastExecution.field(lastExecutionDate))).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)remoteSynchronisationKind)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(allStatusSet)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID}).asTable("allITPI");
        Field reqIdMatch = Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.as("reqIdMatch");
        Field countMatch = DSL.count().as("countMatch");
        Table matchITPI = this.dsl.select((SelectField)reqIdMatch, (SelectField)countMatch).from((TableLike)joinFromAncestorToITPI).innerJoin((TableLike)selectLastExecution).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq(selectLastExecution.field(lastExecutionTC))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, (Object)0L).eq(selectLastExecution.field(lastExecutionDS))).and(DSL.coalesce((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, (Object)new Timestamp(0L)).eq(selectLastExecution.field(lastExecutionDate))).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)remoteSynchronisationKind)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(matchingStatusSet)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID}).asTable("matchITPI");
        this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)allITPI.field(countAll), (SelectField)matchITPI.field(countMatch)).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).leftJoin((TableLike)allITPI).on(Tables.REQUIREMENT.RLN_ID.eq(allITPI.field(reqIdAll))).leftJoin((TableLike)matchITPI).on(Tables.REQUIREMENT.RLN_ID.eq(matchITPI.field(reqIdMatch))).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)remoteSynchronisationKind)).fetch().forEach(r -> {
            Long reqId = (Long)r.get((Field)Tables.REQUIREMENT.RLN_ID);
            Integer countAllITPI = (Integer)r.get(allITPI.field(countAll));
            Integer countValidatedITPI = (Integer)r.get(matchITPI.field(countMatch));
            bundle.computeRate(reqId, key, countAllITPI, countValidatedITPI);
        });
    }

    private void computeRedactionRate(String kind, RequirementVersionBundleStat bundle) {
        TableOnConditionStep joinFromAncestorToTestCase = Tables.RLN_RELATIONSHIP_CLOSURE.innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN));
        Field reqIdAllTC = Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.as("reqIdAllTC");
        Field countAllTC = DSL.count().as("countAllTC");
        Table allTestCase = this.dsl.select((SelectField)reqIdAllTC, (SelectField)countAllTC).from((TableLike)joinFromAncestorToTestCase).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)kind)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID}).asTable("allTestCase");
        Field reqIdValidatedTC = Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.as("reqIdValidatedTC");
        Field countValidatedTC = DSL.count().as("countValidatedTC");
        Table validatedTestCase = this.dsl.select((SelectField)reqIdValidatedTC, (SelectField)countValidatedTC).from((TableLike)joinFromAncestorToTestCase).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)kind)).and(Tables.TEST_CASE.TC_STATUS.in((Object[])new String[]{TestCaseStatus.UNDER_REVIEW.name(), TestCaseStatus.APPROVED.name()})).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID}).asTable("verifiedTestCase");
        this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)allTestCase.field(countAllTC), (SelectField)validatedTestCase.field(countValidatedTC)).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).leftJoin((TableLike)allTestCase).on(Tables.REQUIREMENT.RLN_ID.eq(allTestCase.field(reqIdAllTC))).leftJoin((TableLike)validatedTestCase).on(Tables.REQUIREMENT.RLN_ID.eq(validatedTestCase.field(reqIdValidatedTC))).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)kind)).fetch().forEach(r -> {
            Long reqId = (Long)r.get((Field)Tables.REQUIREMENT.RLN_ID);
            Integer countAllTestCase = (Integer)r.get(allTestCase.field(countAllTC));
            Integer countValidatedTestCase = (Integer)r.get(validatedTestCase.field(countValidatedTC));
            bundle.computeRate(reqId, "REDACTION_RATE", countAllTestCase, countValidatedTestCase);
        });
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object[]> retrieveAllRequirementCoverageStatisticsIntoMap(String queryString, boolean isNativeQuery, String parameterName, Collection<Long> entityIds, EntityManager entityManager) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object[]> mergeObjectValueMaps(Map<String, Object[]> tuples, Map<String, Object[]> partitionResultMap) {
        for (Map.Entry<String, Object[]> partitionResult : partitionResultMap.entrySet()) {
            if (tuples.containsKey(partitionResult.getKey())) {
                tuples.put(partitionResult.getKey(), new Object[]{(Long)tuples.get(partitionResult.getKey())[0] + (Long)partitionResult.getValue()[0], (Long)tuples.get(partitionResult.getKey())[1] + (Long)partitionResult.getValue()[1]});
                continue;
            }
            tuples.put(partitionResult.getKey(), partitionResult.getValue());
        }
        return tuples;
    }

    public static List<Object[]> retrieveAllRequirementValidationStatistics(String queryString, boolean isNativeQuery, String parameterName, Collection<Long> entityIds, EntityManager entityManager) {
        List<List<Object[]>> partitionsResults = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitions(entityManager, entityIds, queryString, isNativeQuery, parameterName);
        ArrayList<Object[]> statistics = new ArrayList<Object[]>();
        for (List<Object[]> partitionResults : partitionsResults) {
            for (Object[] statToAdd : partitionResults) {
                boolean isAlreadyInList = RequirementStatisticsServiceImpl.checkIfAlreadyInList(statistics, statToAdd);
                if (isAlreadyInList) continue;
                statistics.add(statToAdd);
            }
        }
        return statistics;
    }

    private static boolean checkIfAlreadyInList(List<Object[]> statistics, Object[] statToAdd) {
        for (Object[] statistic : statistics) {
            boolean statusIsEqual;
            String requirementCriticality = (String)statistic[0];
            String executionStatus = (String)statistic[1];
            boolean criticalityIsEqual = requirementCriticality.equals(statToAdd[0]);
            boolean bothStatusesAreNull = executionStatus == null && statToAdd[1] == null;
            boolean bl = statusIsEqual = executionStatus != null && executionStatus.equals(statToAdd[1]);
            if (!criticalityIsEqual || !bothStatusesAreNull && !statusIsEqual) continue;
            statistic[2] = (Long)statistic[2] + (Long)statToAdd[2];
            return true;
        }
        return false;
    }

    private List<Long> getNonObsoleteDescendantIds(Long requirementVersionId) {
        List descendantResId;
        Requirement requirement2 = Tables.REQUIREMENT.as("R2");
        RequirementVersion rv2 = Tables.REQUIREMENT_VERSION.as("RV2");
        SelectOnConditionStep baseRequest = this.dsl.select((SelectField)rv2.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)requirement2).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)requirement2.RLN_ID)).innerJoin((TableLike)rv2).on(requirement2.CURRENT_VERSION_ID.eq((Field)rv2.RES_ID));
        if (this.activeMilestoneHolder.getActiveMilestone().isPresent()) {
            Long activeMilestoneId = this.activeMilestoneHolder.getActiveMilestone().get().getId();
            descendantResId = baseRequest.innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(rv2.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).and(rv2.REQUIREMENT_STATUS.ne((Object)OBSOLETE)).and(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Object)activeMilestoneId))).fetch((Field)rv2.RES_ID);
        } else {
            descendantResId = baseRequest.where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).and(rv2.REQUIREMENT_STATUS.ne((Object)OBSOLETE))).fetch((Field)rv2.RES_ID);
        }
        return descendantResId;
    }

    private List<Long> getHighLvlReqNonObsoleteDescendantIds(Long requirementVersionId) {
        List descendantResId;
        RequirementVersion descendantRequirementVersion = Tables.REQUIREMENT_VERSION.as("DESC_RV");
        SelectOnConditionStep baseRequest = this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).innerJoin((TableLike)descendantRequirementVersion).on(Tables.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)descendantRequirementVersion.RES_ID));
        if (this.activeMilestoneHolder.getActiveMilestone().isPresent()) {
            Long activeMilestoneId = this.activeMilestoneHolder.getActiveMilestone().get().getId();
            descendantResId = baseRequest.innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(descendantRequirementVersion.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId).and(descendantRequirementVersion.REQUIREMENT_STATUS.ne((Object)OBSOLETE)).and(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Object)activeMilestoneId))).fetch((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID);
        } else {
            descendantResId = baseRequest.where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId).and(descendantRequirementVersion.REQUIREMENT_STATUS.ne((Object)OBSOLETE))).fetch((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID);
        }
        return descendantResId;
    }
}

