/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.InconsistentInfoListItemException;

public final class CategoryChainFixer
implements RequirementLibraryNodeVisitor {
    public void visit(Requirement visited) {
        CategoryChainFixer.replaceInfoListReferences(visited);
    }

    public void visit(RequirementFolder visited) {
        this.fix(visited);
    }

    public void fix(RequirementFolder folder) {
        for (RequirementLibraryNode node : folder.getContent()) {
            node.accept((RequirementLibraryNodeVisitor)this);
        }
    }

    public static void fix(Requirement req) {
        CategoryChainFixer.replaceInfoListReferences(req);
    }

    private static void replaceInfoListReferences(Requirement requirement) {
        InfoList projectCategories = requirement.getProject().getRequirementCategories();
        for (RequirementVersion version : requirement.getRequirementVersions()) {
            CategoryChainFixer.replaceInfoListReferences(version, projectCategories);
        }
        for (Requirement insider : requirement.getContent()) {
            CategoryChainFixer.replaceInfoListReferences(insider);
        }
    }

    private static void replaceInfoListReferences(RequirementVersion version, InfoList projectCategories) {
        RequirementVersion.PropertiesSetter ppt = version.getPropertySetter();
        InfoListItem category = version.getCategory();
        if (category == null) {
            ppt.setCategory(projectCategories.getDefaultItem());
        } else {
            if (!projectCategories.contains(category)) {
                throw new InconsistentInfoListItemException("category", category.getCode());
            }
            if (category instanceof ListItemReference) {
                ppt.setCategory(projectCategories.getItem(category));
            }
        }
    }
}

