/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.service.internal.repository.CustomTestSuiteDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;
import org.squashtest.tm.service.statistics.CountOnEnum;

public class TestSuiteDaoImpl
implements CustomTestSuiteDao {
    private static final String TEST_SUITE_COUNT_STATUS_BY_TPI_IDS = "TestSuite.countStatusesByTpiIds";
    private static final String TEST_SUITE_IDS = "testSuiteIds";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public TestPlanStatistics getTestSuiteStatistics(List<Long> tpiIds) {
        List result = this.entityManager.createNamedQuery(TEST_SUITE_COUNT_STATUS_BY_TPI_IDS, Object[].class).setParameter("tpiIds", tpiIds).getResultList();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public Map<Long, ExecutionStatusReport> getStatusReport(List<Long> ids) {
        HashMap<Long, ExecutionStatusReport> reportsMap = new HashMap<Long, ExecutionStatusReport>();
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.getReportsByIds", Object[].class);
        query.setParameter("ids", ids);
        List tuples = query.getResultList();
        if (tuples.isEmpty()) {
            ids.stream().forEach(id -> {
                ExecutionStatusReport executionStatusReport = reportsMap.put((Long)id, new ExecutionStatusReport());
            });
        } else {
            for (Object[] tuple : tuples) {
                Long testId = (Long)tuple[0];
                ExecutionStatus execution = (ExecutionStatus)tuple[1];
                Long count = (Long)tuple[2];
                ExecutionStatusReport report = reportsMap.computeIfAbsent(testId, k -> new ExecutionStatusReport());
                report.set(execution.getCanonicalStatus(), count.intValue());
            }
        }
        return reportsMap;
    }

    @Override
    public List<Long> findAllIdsByExecutionIds(List<Long> executionIds) {
        if (executionIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findAllIdsByExecutionIds", Long.class);
        query.setParameter("executionIds", executionIds);
        return query.getResultList();
    }

    @Override
    public List<TestSuite> findAllByIds(Collection<Long> suiteIds) {
        if (suiteIds.isEmpty()) {
            return new ArrayList<TestSuite>();
        }
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findAllByIds", TestSuite.class);
        query.setParameter("suiteIds", suiteIds);
        return query.getResultList();
    }

    @Override
    public List<TestSuite> findTestSuitesWhereMilestoneIsNotLocked(Collection<Long> suiteIds) {
        if (suiteIds.isEmpty()) {
            return new ArrayList<TestSuite>();
        }
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findTestSuitesWhereMilestoneIsNoteLocked", TestSuite.class);
        query.setParameter("suiteIds", suiteIds);
        return query.getResultList();
    }

    @Override
    public List<Long> findTestSuiteAttachmentListIds(Collection<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findAllAttachmentLists", Long.class);
            query.setParameter(TEST_SUITE_IDS, testSuiteIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> findTestSuitesAutomatedSuiteIds(Collection<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findTestSuitesAutomatedSuiteIds", Long.class);
            query.setParameter(TEST_SUITE_IDS, testSuiteIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public void removeTestSuites(Collection<Long> testSuiteIds) {
        Query query = this.entityManager.createNamedQuery("TestSuite.removeAll");
        query.setParameter(TEST_SUITE_IDS, testSuiteIds);
        query.executeUpdate();
    }

    @Override
    public TestSuite findByUUID(String targetUUID) {
        return (TestSuite)this.entityManager.createQuery("SELECT ts FROM TestSuite ts WHERE ts.uuid = :uuid", TestSuite.class).setParameter("uuid", (Object)targetUUID).getSingleResult();
    }

    @Override
    public List<TestSuite> loadNodeForPaste(Collection<Long> testSuiteIds) {
        return NestedEntityGraphQueryBuilder.of(this.entityManager, TestSuite.class, "SELECT DISTINCT ts FROM TestSuite ts WHERE ts.id IN :ids", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("attachmentList"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content"))), NestedEntityGraphQueryBuilder.GraphDefinition.attr("testPlanItems"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("testPlanItems", NestedEntityGraphQueryBuilder.GraphDefinition.attr("exploratorySessionOverview"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("exploratorySessionOverview", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content"))))))).executeDistinctList(Map.of("ids", testSuiteIds));
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long testSuiteId) {
        return (Boolean)this.entityManager.createQuery("select count(t) > 0\nfrom TestSuite t\njoin t.testPlanItems tp\nwhere t.id = :testSuiteId and tp.referencedTestCase is null", Boolean.class).setParameter("testSuiteId", (Object)testSuiteId).getSingleResult();
    }

    @Override
    public TestSuite loadForExecutionResume(long testSuiteId) {
        return (TestSuite)this.entityManager.createQuery("select ts\nfrom TestSuite ts\nleft join fetch ts.testPlanItems tp\nleft join fetch tp.referencedTestCase tc\nleft join fetch tc.steps\nleft join fetch tp.executions exec\nleft join fetch exec.steps\nleft join fetch exec.automatedExecutionExtender\nwhere ts.id = :id", TestSuite.class).setParameter("id", (Object)testSuiteId).getSingleResult();
    }

    @Override
    public List<TestSuite> loadForItemAddition(List<Long> testSuiteIds) {
        this.entityManager.createQuery("    select suite from TestSuite suite\n    left join fetch suite.testPlanItems tpi\n    left join fetch tpi.referencedTestCase\n    where suite.id in :ids\n", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
        return this.entityManager.createQuery("    select suite from TestSuite suite\n    join fetch suite.iteration it\n    join fetch it.testPlan tp\n    left join fetch tp.testPlanItems tpi\n    left join fetch tpi.referencedTestCase\n    where suite.id in :ids\n", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
    }

    @Override
    public TestSuite loadForItemAddition(@Param(value="id") Long testSuiteId) {
        return this.loadForItemAddition(List.of(testSuiteId)).get(0);
    }
}

