/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.Tuple;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.SuggestionStatus;
import org.squashtest.tm.domain.testcase.TestAutomationCandidate;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.testautomation.AlreadyDecidedTestCandidatesDto;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

@Repository
public class HibernateTestAutomationCandidateDao
extends HibernateEntityDao<TestAutomationCandidate>
implements TestAutomationCandidateDao {
    public static final String PROJECT_ID = "projectId";
    public static final String PROJECT_IDS = "projectIds";
    public static final String OBSOLETE_STATUS = "obsoleteStatus";
    public static final String MANUAL_AUTOMATABLE = "manualAutomatable";
    public static final String SUGGESTED_STATUS = "suggestedStatus";
    public static final String EXPLORATORY_MODE = "exploratoryMode";
    public static final String TEST_CASE_NAME = "testCaseName";
    public static final String TEST_CASE_ID = "testCaseId";
    public static final String TEST_CASE_IDS = "testCaseIds";
    private static final String EXCLUDED_EXECUTION_STATUSES_PARAM = "excludedExecutionStatuses";
    private static final List<ExecutionStatus> EXCLUDED_EXECUTION_STATUSES = List.of(ExecutionStatus.READY, ExecutionStatus.RUNNING);
    private final DSLContext dsl;

    public HibernateTestAutomationCandidateDao(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public int countEligibleTestCasesByProjectIds(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return 0;
        }
        String query = "SELECT COUNT(tc.id) FROM TestCase tc\nWHERE tc.project.id IN :projectIds\n  AND tc.status != :obsoleteStatus\n  AND tc.automatedTestReference IS NULL\n  AND tc.automatedTest IS NULL\n  AND tc.automatable = :manualAutomatable\n  AND tc.executionMode != :exploratoryMode\n  AND NOT EXISTS (\n    SELECT 1 FROM TestAutomationCandidate tac\n    WHERE tac.testCase.id = tc.id\n      AND tac.suggestionStatus != :suggestedStatus\n  )\n";
        Long count = (Long)this.entityManager.createQuery(query, Long.class).setParameter(PROJECT_IDS, projectIds).setParameter(OBSOLETE_STATUS, (Object)TestCaseStatus.OBSOLETE).setParameter(MANUAL_AUTOMATABLE, (Object)TestCaseAutomatable.M).setParameter(SUGGESTED_STATUS, (Object)SuggestionStatus.SUGGESTED).setParameter(EXPLORATORY_MODE, (Object)TestCaseExecutionMode.EXPLORATORY).getSingleResult();
        return count.intValue();
    }

    @Override
    public Map<Long, Long> findOneTestCaseIdPerProject(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyMap();
        }
        String query = "SELECT tc.project.id, MIN(tc.id)\nFROM TestCase tc\nWHERE tc.project.id IN :projectIds\nGROUP BY tc.project.id\n";
        List results = this.entityManager.createQuery(query, Tuple.class).setParameter(PROJECT_IDS, projectIds).getResultList();
        return results.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(0, Long.class), tuple -> (Long)tuple.get(1, Long.class), (existing, replacement) -> existing));
    }

    @Override
    public Map<Long, List<Long>> findEligibleTestCaseIdsByProjectIds(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyMap();
        }
        String query = "SELECT tc.project.id, tc.id FROM TestCase tc\nWHERE tc.project.id IN :projectIds\n  AND tc.status != :obsoleteStatus\n  AND tc.automatedTestReference IS NULL\n  AND tc.automatedTest IS NULL\n  AND tc.automatable = :manualAutomatable\n  AND tc.executionMode != :exploratoryMode\n  AND NOT EXISTS (\n    SELECT 1 FROM TestAutomationCandidate tac\n    WHERE tac.testCase.id = tc.id\n      AND tac.suggestionStatus != :suggestedStatus\n  )\n";
        List results = this.entityManager.createQuery(query, Tuple.class).setParameter(PROJECT_IDS, projectIds).setParameter(OBSOLETE_STATUS, (Object)TestCaseStatus.OBSOLETE).setParameter(MANUAL_AUTOMATABLE, (Object)TestCaseAutomatable.M).setParameter(SUGGESTED_STATUS, (Object)SuggestionStatus.SUGGESTED).setParameter(EXPLORATORY_MODE, (Object)TestCaseExecutionMode.EXPLORATORY).getResultList();
        return results.stream().collect(Collectors.groupingBy(tuple -> (Long)tuple.get(0, Long.class), Collectors.mapping(tuple -> (Long)tuple.get(1, Long.class), Collectors.toList())));
    }

    @Override
    public Map<Long, Integer> countExecutionsByTestCasesForProject(Long projectId) {
        String query = "SELECT e.referencedTestCase.id AS testCaseId,\n        COUNT(e) AS execCount\nFROM Execution e\nJOIN e.referencedTestCase tc\nWHERE tc.project.id = :projectId\n   AND tc.executionMode != :exploratoryMode\n   AND e.executionStatus NOT IN :excludedExecutionStatuses\nGROUP BY e.referencedTestCase.id\n";
        List results = this.entityManager.createQuery(query, Tuple.class).setParameter(PROJECT_ID, (Object)projectId).setParameter(EXPLORATORY_MODE, (Object)TestCaseExecutionMode.EXPLORATORY).setParameter(EXCLUDED_EXECUTION_STATUSES_PARAM, EXCLUDED_EXECUTION_STATUSES).getResultList();
        HashMap<Long, Integer> executionCounts = new HashMap<Long, Integer>();
        for (Tuple result : results) {
            Long testCaseId = (Long)result.get(TEST_CASE_ID, Long.class);
            Long count = (Long)result.get("execCount", Long.class);
            executionCounts.put(testCaseId, count.intValue());
        }
        return executionCounts;
    }

    @Override
    public Map<Long, Integer> countSuccessfulExecutionsInLastRunsByTestCase(Long projectId, int limit) {
        String query = "SELECT tc.id as testCaseId,\n       CAST(COUNT(CASE WHEN ranked.executionStatus = :successStatus THEN 1 END) AS INTEGER) as successCount\nFROM TestCase tc\nLEFT JOIN (\n    SELECT e.referencedTestCase.id as testCaseId,\n           e.executionStatus as executionStatus,\n           ROW_NUMBER() OVER (PARTITION BY e.referencedTestCase.id ORDER BY e.lastExecutedOn DESC) as row_num\n    FROM Execution e\n    WHERE e.referencedTestCase.project.id = :projectId\n    AND e.executionStatus NOT IN :excludedExecutionStatuses\n) ranked ON tc.id = ranked.testCaseId AND ranked.row_num <= :limit\nWHERE tc.project.id = :projectId\n  AND tc.status != :obsoleteStatus\n  AND tc.automatedTestReference IS NULL\n  AND tc.automatedTest IS NULL\n  AND tc.automatable = :manualAutomatable\n  AND tc.executionMode != :exploratoryMode\nGROUP BY tc.id\n";
        List results = this.entityManager.createQuery(query, Tuple.class).setParameter(PROJECT_ID, (Object)projectId).setParameter(OBSOLETE_STATUS, (Object)TestCaseStatus.OBSOLETE).setParameter(MANUAL_AUTOMATABLE, (Object)TestCaseAutomatable.M).setParameter(EXPLORATORY_MODE, (Object)TestCaseExecutionMode.EXPLORATORY).setParameter("successStatus", (Object)ExecutionStatus.SUCCESS).setParameter("limit", (Object)limit).setParameter(EXCLUDED_EXECUTION_STATUSES_PARAM, EXCLUDED_EXECUTION_STATUSES).getResultList();
        return results.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(TEST_CASE_ID, Long.class), tuple -> Optional.ofNullable((Integer)tuple.get("successCount", Integer.class)).orElse(0)));
    }

    @Override
    public List<TestAutomationCandidate> findSuggestedCandidatesByTestCaseIds(List<Long> testCaseIds) {
        if (testCaseIds == null || testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        String query = "SELECT tac\nFROM TestAutomationCandidate tac\nJOIN FETCH tac.testCase tc\nWHERE tc.id IN :testCaseIds\n  AND tac.suggestionStatus = :suggestedStatus\n";
        return this.entityManager.createQuery(query, TestAutomationCandidate.class).setParameter(TEST_CASE_IDS, testCaseIds).setParameter(SUGGESTED_STATUS, (Object)SuggestionStatus.SUGGESTED).getResultList();
    }

    @Override
    public void rejectCandidates(List<Long> testCaseIds, String decidedBy) {
        if (testCaseIds == null || testCaseIds.isEmpty()) {
            return;
        }
        String query = "UPDATE TestAutomationCandidate tac\nSET tac.suggestionStatus = :rejectedStatus,\n    tac.decidedBy = :decidedBy,\n    tac.decidedOn = :decidedOn\nWHERE tac.testCase.id IN :testCaseIds\n";
        this.entityManager.createQuery(query).setParameter("rejectedStatus", (Object)SuggestionStatus.REJECTED).setParameter("decidedBy", (Object)decidedBy).setParameter("decidedOn", (Object)new Date()).setParameter(TEST_CASE_IDS, testCaseIds).executeUpdate();
    }

    @Override
    public List<AlreadyDecidedTestCandidatesDto> findAlreadyDecidedTests(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as(TEST_CASE_NAME), (SelectField)Tables.TEST_AUTOMATION_CANDIDATE.SUGGESTION_STATUS, (SelectField)Tables.TEST_AUTOMATION_CANDIDATE.DECIDED_BY).from((TableLike)Tables.TEST_AUTOMATION_CANDIDATE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID.in(testCaseIds)).and(Tables.TEST_AUTOMATION_CANDIDATE.DECIDED_BY.isNotNull()).and(Tables.TEST_AUTOMATION_CANDIDATE.SUGGESTION_STATUS.ne((Object)SuggestionStatus.SUGGESTED.name())).fetchInto(AlreadyDecidedTestCandidatesDto.class);
    }

    @Override
    public List<TestAutomationCandidate> findCandidatesWithRelations(List<Long> tcIds) {
        if (tcIds == null || tcIds.isEmpty()) {
            return List.of();
        }
        String query = "SELECT tac\nFROM TestAutomationCandidate tac\nJOIN FETCH tac.testCase tc\nJOIN FETCH tc.project p\nLEFT JOIN FETCH tc.automationRequest ar\nWHERE tc.id IN :testCaseIds\n";
        return this.entityManager.createQuery(query, TestAutomationCandidate.class).setParameter(TEST_CASE_IDS, tcIds).getResultList();
    }

    @Override
    public Optional<TestAutomationCandidate> findCandidateByTestCaseId(long testCaseId) {
        String query = "SELECT tac FROM TestAutomationCandidate tac\nWHERE tac.testCase.id = :testCaseId\n";
        return this.entityManager.createQuery(query, TestAutomationCandidate.class).setParameter(TEST_CASE_ID, (Object)testCaseId).getResultStream().findFirst();
    }
}

