/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.MultipleBugtrackerImportException;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ServersPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ServerImporterService;

@Service
public class ServerImporterServiceImpl
extends AbstractPivotImport
implements ServerImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerImporterServiceImpl.class);
    private final BugTrackersService bugTrackersService;
    private final BugTrackerDao bugTrackerDao;

    public ServerImporterServiceImpl(BugTrackersService bugTrackersService, BugTrackerDao bugTrackerDao) {
        super(LOGGER);
        this.bugTrackersService = bugTrackersService;
        this.bugTrackerDao = bugTrackerDao;
    }

    @Override
    public <I extends InputStream> void validateServer(I zis, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        HashMap<ServersPivot.ServerKind, List<ServersPivot>> serversPivots = new HashMap<ServersPivot.ServerKind, List<ServersPivot>>();
        this.parseEntities(zis, JsonImportFile.SERVERS, JsonImportFile.SERVERS.getJsonFieldKind(), ServersPivot.class, (P serversPivot) -> {
            boolean bl = serversPivots.computeIfAbsent(serversPivot.getServerKind(), k -> new ArrayList()).add(serversPivot);
        });
        if (serversPivots.isEmpty()) {
            return;
        }
        this.checkConflictBugtracker(serversPivots, projectId, pivotMetaDataModel::addBugtrackerConflicts, pivotMetaDataModel::addBugtrackerConflicts, (bugtracker, projectBugtracker) -> {
            pivotMetaDataModel.addBugtrackerConflicts((BugTracker)bugtracker);
            pivotMetaDataModel.addBugtrackerConflicts((BugTracker)projectBugtracker);
        });
    }

    private Optional<BugtrackerCheckResult> checkConflictBugtracker(Map<ServersPivot.ServerKind, List<ServersPivot>> serversPivots, Long projectId, Consumer<ServersPivot> onPluginConflict, Consumer<ServersPivot> onNotExistingConflict, BiConsumer<BugTracker, BugTracker> onProjectConflict) {
        return this.checkPluginBugtracker(serversPivots, onPluginConflict).flatMap(bugtrackerPivot -> this.checkExistingBugtracker((ServersPivot)bugtrackerPivot, onNotExistingConflict).flatMap(bugtracker -> this.checkProjectBinding((BugTracker)bugtracker, projectId, onProjectConflict)).map(bugTracker -> new BugtrackerCheckResult((BugTracker)bugTracker, (ServersPivot)bugtrackerPivot)));
    }

    private Optional<ServersPivot> checkPluginBugtracker(Map<ServersPivot.ServerKind, List<ServersPivot>> serversPivots, Consumer<ServersPivot> conflictConsumer) {
        if (!serversPivots.containsKey((Object)ServersPivot.ServerKind.BUGTRACKER)) {
            return Optional.empty();
        }
        ServersPivot bugtrackerPivot = this.getBugtrackerPivot(serversPivots.get((Object)ServersPivot.ServerKind.BUGTRACKER));
        Set<String> providerKinds = this.bugTrackersService.getProviderKinds();
        if (!providerKinds.contains(bugtrackerPivot.getKind())) {
            conflictConsumer.accept(bugtrackerPivot);
            return Optional.empty();
        }
        return Optional.of(bugtrackerPivot);
    }

    private Optional<BugTracker> checkExistingBugtracker(ServersPivot bugtrackerPivot, Consumer<ServersPivot> conflictConsumer) {
        Optional<BugTracker> bugtrackerOpt = this.bugTrackerDao.findByKind(bugtrackerPivot.getKind()).stream().filter(bt -> this.isSameBugtracker((BugTracker)bt, bugtrackerPivot)).findFirst();
        if (bugtrackerOpt.isEmpty()) {
            conflictConsumer.accept(bugtrackerPivot);
        }
        return bugtrackerOpt;
    }

    private Optional<BugTracker> checkProjectBinding(BugTracker bugtracker, Long projectId, BiConsumer<BugTracker, BugTracker> conflictConsumer) {
        BugTracker bugtrackerProject = this.bugTrackerDao.findByProjectId(projectId);
        if (this.isConflictOnProjectBinding(bugtracker, bugtrackerProject)) {
            conflictConsumer.accept(bugtracker, bugtrackerProject);
            return Optional.empty();
        }
        return Optional.of(bugtracker);
    }

    private ServersPivot getBugtrackerPivot(List<ServersPivot> serversPivots) {
        if (serversPivots.size() > 1) {
            throw new MultipleBugtrackerImportException();
        }
        return serversPivots.getFirst();
    }

    private boolean isSameBugtracker(BugTracker bugtracker, ServersPivot bugtrackerPivot) {
        return Objects.nonNull(bugtracker) && bugtracker.getName().equals(bugtrackerPivot.getName()) && bugtracker.getUrl().equals(bugtrackerPivot.getUrl()) && bugtracker.getKind().equals(bugtrackerPivot.getKind());
    }

    private boolean isConflictOnProjectBinding(BugTracker bugtracker, BugTracker projectBugtracker) {
        return Objects.nonNull(projectBugtracker) && !projectBugtracker.equals(bugtracker);
    }

    @Override
    public void importServersFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.SERVERS, pivotFormatImport, pivotImportMetadata, "servers", "server", this.getServerImportStrategy(projectIdsReferences, pivotImportMetadata));
    }

    private PivotImportStrategy<ServersPivot> getServerImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata) {
        return new PivotImportStrategy<ServersPivot>(){

            @Override
            public Class<ServersPivot> getPivotClazz() {
                return ServersPivot.class;
            }

            @Override
            public void create(List<ServersPivot> entities) {
                ServerImporterServiceImpl.this.createServers(entities, projectIdsReferences, pivotImportMetadata);
            }
        };
    }

    private void createServers(List<ServersPivot> entities, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata) {
        Map<ServersPivot.ServerKind, List<ServersPivot>> serversPivots = entities.stream().collect(Collectors.groupingBy(ServersPivot::getServerKind));
        this.handleBugtracker(serversPivots, projectIdsReferences, pivotImportMetadata);
    }

    private void handleBugtracker(Map<ServersPivot.ServerKind, List<ServersPivot>> serversPivots, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata) {
        Long projectId = projectIdsReferences.getId();
        this.checkConflictBugtracker(serversPivots, projectId, bugtrackerPivot -> pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.bugtrackerNotInstalled(bugtrackerPivot)), bugtrackerPivot -> pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.bugtrackerNotInstalled(bugtrackerPivot)), (bugtracker, projectBugtracker) -> pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.bugtrackerBindingConflict(bugtracker, projectBugtracker))).ifPresent(bugtrackerResult -> {
            Long l = pivotImportMetadata.getBugtrackerIdByPivotId().put(bugtrackerResult.serversPivot().getPivotId(), bugtrackerResult.bugTracker().getId());
        });
    }

    private record BugtrackerCheckResult(BugTracker bugTracker, ServersPivot serversPivot) {
    }
}

