/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.FolderPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.FolderPivotImporterService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Service
public class FolderPivotImporterServiceImpl
extends AbstractPivotImport
implements FolderPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderPivotImporterServiceImpl.class);
    private final AdminPivotConverterService adminPivotConverterService;
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final FolderPivotConverterService folderPivotConverterService;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final AttachmentPivotImportService attachmentPivotImportService;
    @PersistenceContext
    private EntityManager entityManager;

    public FolderPivotImporterServiceImpl(AdminPivotConverterService adminPivotConverterService, RequirementLibraryNavigationService requirementLibraryNavigationService, TestCaseLibraryNavigationService testCaseLibraryNavigationService, CampaignLibraryNavigationService campaignLibraryNavigationService, FolderPivotConverterService folderPivotConverterService, PrivateCustomFieldValueService customFieldValueService, AttachmentPivotImportService attachmentPivotImportService) {
        super(LOGGER);
        this.adminPivotConverterService = adminPivotConverterService;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.folderPivotConverterService = folderPivotConverterService;
        this.customFieldValueService = customFieldValueService;
        this.attachmentPivotImportService = attachmentPivotImportService;
    }

    @Override
    public void importFoldersByJsonFileName(ZipFile zipFile, JsonImportFile jsonFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, jsonFile, pivotFormatImport, pivotImportMetadata, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, true), PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), this.getFolderPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<FolderPivot> getFolderPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<FolderPivot>(){

            @Override
            public Class<FolderPivot> getPivotClazz() {
                return FolderPivot.class;
            }

            @Override
            public void create(List<FolderPivot> entities) {
                FolderPivotImporterServiceImpl.this.createFolders(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createFolders(List<FolderPivot> folderPivotList, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Map folderPivotByParentType = folderPivotList.stream().collect(Collectors.groupingBy(AbstractPivotEntity::getParentType, LinkedHashMap::new, Collectors.toList()));
        folderPivotByParentType.forEach((parentType, folderPivots) -> this.createFoldersByParentType((EntityType)parentType, (List<FolderPivot>)folderPivots, projectIdsReferences, pivotImportMetadata, pivotFormatImport));
        folderPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createFoldersByParentType(EntityType parentType, List<FolderPivot> folderPivots, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        switch (parentType) {
            case REQUIREMENT_LIBRARY: {
                List<String> contentNames = this.requirementLibraryNavigationService.findContentNamesByLibraryId(projectIdsReferences.getRequirementLibraryId());
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> this.createFolderToLibrary(this.requirementLibraryNavigationService, (FolderPivot)folderPivot, projectIdsReferences.getRequirementLibraryId(), contentNames, pivotImportMetadata.getRequirementFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport)));
                break;
            }
            case TEST_CASE_LIBRARY: {
                List<String> contentNames = this.testCaseLibraryNavigationService.findContentNamesByLibraryId(projectIdsReferences.getRequirementLibraryId());
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> this.createFolderToLibrary(this.testCaseLibraryNavigationService, (FolderPivot)folderPivot, projectIdsReferences.getTestCaseLibraryId(), contentNames, pivotImportMetadata.getTestCaseFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport)));
                break;
            }
            case CAMPAIGN_LIBRARY: {
                List<String> contentNames = this.campaignLibraryNavigationService.findContentNamesByLibraryId(projectIdsReferences.getRequirementLibraryId());
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> {
                    if (EntityType.CAMPAIGN_FOLDER.equals((Object)folderPivot.getKind())) {
                        this.createFolderToLibrary(this.campaignLibraryNavigationService, (FolderPivot)folderPivot, projectIdsReferences.getCampaignLibraryId(), contentNames, pivotImportMetadata.getCampaignFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport);
                    } else if (EntityType.SPRINT_GROUP.equals((Object)folderPivot.getKind())) {
                        this.createSprintGroupToLibrary((FolderPivot)folderPivot, projectIdsReferences.getCampaignLibraryId(), contentNames, pivotImportMetadata.getCampaignFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport);
                    } else {
                        throw new IllegalArgumentException(String.format("Unsupported folder kind: %s to the parentType %s", folderPivot.getKind(), EntityType.CAMPAIGN_LIBRARY));
                    }
                }));
                break;
            }
            case REQUIREMENT_FOLDER: {
                Map<Long, List<String>> contentNamesByNodeIds = this.requirementLibraryNavigationService.findContentNamesByNodeIds(this.getSquashTargetIdByPivotId(folderPivots, pivotImportMetadata.getRequirementFolderIdByPivotId()));
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> this.createFolderToFolder(this.requirementLibraryNavigationService, (FolderPivot)folderPivot, contentNamesByNodeIds, pivotImportMetadata.getRequirementFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport)));
                break;
            }
            case TEST_CASE_FOLDER: {
                Map<Long, List<String>> contentNamesByNodeIds = this.testCaseLibraryNavigationService.findContentNamesByFolderIds(this.getSquashTargetIdByPivotId(folderPivots, pivotImportMetadata.getTestCaseFolderIdByPivotId()));
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> this.createFolderToFolder(this.testCaseLibraryNavigationService, (FolderPivot)folderPivot, contentNamesByNodeIds, pivotImportMetadata.getTestCaseFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport)));
                break;
            }
            case CAMPAIGN_FOLDER: {
                Map<Long, List<String>> contentNamesByNodeIds = this.campaignLibraryNavigationService.findContentNamesByNodeIds(this.getSquashTargetIdByPivotId(folderPivots, pivotImportMetadata.getCampaignFolderIdByPivotId()));
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> {
                    if (EntityType.CAMPAIGN_FOLDER.equals((Object)folderPivot.getKind())) {
                        this.createFolderToFolder(this.campaignLibraryNavigationService, (FolderPivot)folderPivot, contentNamesByNodeIds, pivotImportMetadata.getCampaignFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport);
                    } else if (EntityType.SPRINT_GROUP.equals((Object)folderPivot.getKind())) {
                        this.createSprintGroupToFolder((FolderPivot)folderPivot, contentNamesByNodeIds, pivotImportMetadata.getCampaignFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport);
                    } else {
                        throw new IllegalArgumentException(String.format("Unsupported folder kind: %s to the parentType %s", folderPivot.getKind(), EntityType.CAMPAIGN_FOLDER));
                    }
                }));
                break;
            }
            case SPRINT_GROUP: {
                Map<Long, List<String>> contentNamesByNodeIds = this.campaignLibraryNavigationService.findContentNamesByNodeIds(this.getSquashTargetIdByPivotId(folderPivots, pivotImportMetadata.getCampaignFolderIdByPivotId()));
                folderPivots.forEach(this.consumerEntity(pivotFormatImport, folderPivot -> {
                    if (EntityType.SPRINT_GROUP.equals((Object)folderPivot.getKind())) {
                        throw new IllegalArgumentException("Sprint group cannot be parent of another sprint group");
                    }
                    this.createFolderToSprintGroup((FolderPivot)folderPivot, contentNamesByNodeIds, pivotImportMetadata.getCampaignFolderIdByPivotId(), pivotImportMetadata, pivotFormatImport);
                }));
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity has a parent type that is not handled " + String.valueOf(parentType));
            }
        }
    }

    private List<Long> getSquashTargetIdByPivotId(List<FolderPivot> folderPivots, Map<String, Long> importMetaData) {
        return folderPivots.stream().map(AbstractPivotEntity::getParentId).distinct().filter(importMetaData::containsKey).map(importMetaData::get).toList();
    }

    private <LIBRARY extends Library<NODE>, FOLDER extends Folder<NODE> & AuditableMixin, NODE extends LibraryNode> void createFolderToLibrary(LibraryNavigationService<LIBRARY, FOLDER, NODE> dao, FolderPivot folderPivot, Long libraryId, List<String> contentNames, Map<String, Long> importMetaData, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        FolderPivotImporterServiceImpl.fixConflictNames(contentNames, folderPivot);
        Object folder = this.folderPivotConverterService.pivotToFolder(folderPivot);
        folder = dao.addFolderToLibrary((long)libraryId, folder);
        this.handleAttachmentsCufsAuditable(folderPivot, (BoundEntity & AttachmentHolder)folder, pivotFormatImport, pivotImportMetadata);
        importMetaData.put(folderPivot.getPivotId(), folder.getId());
        contentNames.add(folderPivot.getName());
    }

    private <LIBRARY extends Library<NODE>, FOLDER extends Folder<NODE> & AuditableMixin, NODE extends LibraryNode> void createFolderToFolder(LibraryNavigationService<LIBRARY, FOLDER, NODE> dao, FolderPivot folderPivot, Map<Long, List<String>> contentNamesByNodeIds, Map<String, Long> importMetaData, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long parentFolderId = FolderPivotImporterServiceImpl.getParentIdFromImportMetadata(importMetaData, folderPivot);
        List<String> contentNames = FolderPivotImporterServiceImpl.getContentNames(contentNamesByNodeIds, parentFolderId);
        FolderPivotImporterServiceImpl.fixConflictNames(contentNames, folderPivot);
        Object folder = this.folderPivotConverterService.pivotToFolder(folderPivot);
        folder = dao.addFolderToFolder((long)parentFolderId, folder);
        this.handleAttachmentsCufsAuditable(folderPivot, (BoundEntity & AttachmentHolder)folder, pivotFormatImport, pivotImportMetadata);
        importMetaData.put(folderPivot.getPivotId(), folder.getId());
        contentNames.add(folderPivot.getName());
    }

    private void createSprintGroupToLibrary(FolderPivot folderPivot, Long libraryId, List<String> contentNames, Map<String, Long> importMetaData, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        FolderPivotImporterServiceImpl.fixConflictNames(contentNames, folderPivot);
        SprintGroup sprintGroup = this.folderPivotConverterService.pivotToSprintGroup(folderPivot);
        this.campaignLibraryNavigationService.addSprintGroupToCampaignLibraryUnsecured(libraryId, sprintGroup);
        this.handleAttachmentsCufsAuditable(folderPivot, sprintGroup, pivotFormatImport, pivotImportMetadata);
        importMetaData.put(folderPivot.getPivotId(), sprintGroup.getId());
        contentNames.add(folderPivot.getName());
    }

    private <FOLDER extends Folder<NODE> & AuditableMixin, NODE extends LibraryNode> void createFolderToSprintGroup(FolderPivot folderPivot, Map<Long, List<String>> contentNamesByNodeIds, Map<String, Long> importMetaData, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long parentFolderId = FolderPivotImporterServiceImpl.getParentIdFromImportMetadata(importMetaData, folderPivot);
        List<String> contentNames = FolderPivotImporterServiceImpl.getContentNames(contentNamesByNodeIds, parentFolderId);
        FolderPivotImporterServiceImpl.fixConflictNames(contentNames, folderPivot);
        Object folder = this.folderPivotConverterService.pivotToFolder(folderPivot);
        this.campaignLibraryNavigationService.addFolderToSprintGroup((long)parentFolderId, (CampaignFolder)folder);
        this.handleAttachmentsCufsAuditable(folderPivot, (BoundEntity & AttachmentHolder)folder, pivotFormatImport, pivotImportMetadata);
        importMetaData.put(folderPivot.getPivotId(), folder.getId());
        contentNames.add(folderPivot.getName());
    }

    private void createSprintGroupToFolder(FolderPivot folderPivot, Map<Long, List<String>> contentNamesByNodeIds, Map<String, Long> importMetaData, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long parentFolderId = FolderPivotImporterServiceImpl.getParentIdFromImportMetadata(importMetaData, folderPivot);
        List<String> contentNames = FolderPivotImporterServiceImpl.getContentNames(contentNamesByNodeIds, parentFolderId);
        FolderPivotImporterServiceImpl.fixConflictNames(contentNames, folderPivot);
        SprintGroup sprintGroup = this.folderPivotConverterService.pivotToSprintGroup(folderPivot);
        sprintGroup = this.campaignLibraryNavigationService.addSprintGroupToCampaignFolderUnsecured(parentFolderId, sprintGroup);
        this.handleAttachmentsCufsAuditable(folderPivot, sprintGroup, pivotFormatImport, pivotImportMetadata);
        importMetaData.put(folderPivot.getPivotId(), sprintGroup.getId());
        contentNames.add(folderPivot.getName());
    }

    private <ENTITY extends BoundEntity & AttachmentHolder> void handleAttachmentsCufsAuditable(FolderPivot folderPivot, ENTITY entity, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        ((AuditableMixin)entity).setReadOnlyModifyAudit(folderPivot.getLastModifiedBy(), folderPivot.getLastModifiedOn());
        if (entity instanceof RequirementFolder) {
            RequirementFolder requirementFolder = (RequirementFolder)entity;
            requirementFolder.getResource().setReadOnlyModifyAudit(folderPivot.getLastModifiedBy(), folderPivot.getLastModifiedOn());
        }
        Map<Long, Long> attachmentsConversion = this.handleAttachment(entity, folderPivot, pivotFormatImport, pivotImportMetadata);
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(folderPivot, entity, attachmentsConversion, pivotImportMetadata);
        this.customFieldValueService.initCustomFieldValues(entity, customFields);
    }

    private <ENTITY extends AttachmentHolder> Map<Long, Long> handleAttachment(ENTITY entity, FolderPivot folderPivot, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<ENTITY, FolderPivot>(folderPivot, entity), pivotImportMetadata, pivotFormatImport);
        ENTITY ENTITY = entity;
        Objects.requireNonNull(ENTITY);
        ENTITY ENTITY2 = ENTITY;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Folder.class, SprintGroup.class}, ENTITY2, 0)) {
            case 0: {
                Folder folder = (Folder)ENTITY2;
                String description = folder.getDescription();
                folder.setDescription(this.attachmentPivotImportService.updateRichText(description, folder.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
                break;
            }
            case 1: {
                SprintGroup sprintGroup = (SprintGroup)ENTITY2;
                String description = sprintGroup.getDescription();
                sprintGroup.setDescription(this.attachmentPivotImportService.updateRichText(description, sprintGroup.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported entity type %s for folder pivot %s", entity.getClass().getSimpleName(), folderPivot));
            }
        }
        return attachmentsConversion;
    }

    private static Long getParentIdFromImportMetadata(Map<String, Long> importMetaData, FolderPivot folderPivot) {
        if (!importMetaData.containsKey(folderPivot.getParentId())) {
            throw new IllegalArgumentException("Parent folder not found for folder: " + folderPivot.getName());
        }
        return importMetaData.get(folderPivot.getParentId());
    }

    private static List<String> getContentNames(Map<Long, List<String>> contentNamesByNodeIds, Long parentFolderId) {
        if (!contentNamesByNodeIds.containsKey(parentFolderId)) {
            ArrayList<String> contentNames = new ArrayList<String>();
            contentNamesByNodeIds.put(parentFolderId, contentNames);
            return contentNames;
        }
        return contentNamesByNodeIds.get(parentFolderId);
    }

    private static void fixConflictNames(List<String> contentNames, FolderPivot folderPivot) {
        String newName = LibraryUtils.generateNonClashingName(folderPivot.getName(), contentNames, 255);
        if (!newName.equals(folderPivot.getName())) {
            folderPivot.setName(newName);
        }
        contentNames.add(newName);
    }

    private <T extends FolderPivot> Consumer<T> consumerEntity(PivotFormatImport pivotFormatImport, PivotFileManager.ConsumerThrowing<T, Exception> t) {
        return i -> {
            try {
                PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, i.getKind().name(), i.getPivotId(), pivotFormatImport);
                t.accept(i);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, i.getKind().name(), i.getName(), i.getPivotId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, i.getKind().name(), i.getName(), i.getPivotId(), pivotFormatImport, e);
            }
        };
    }
}

