/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;

public abstract class AbstractPivotDao<P extends AbstractPivotObject> {
    protected final DSLContext dsl;
    protected final AdminPivotConverterService adminPivotConverterService;

    AbstractPivotDao(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        this.dsl = dsl;
        this.adminPivotConverterService = adminPivotConverterService;
    }

    protected SubElementRecordProcessor<AttachmentPivot> getAttachmentPivotContainer(ResultQuery<? extends Record> query, Field<Long> mainEntityIdField) {
        return this.getAttachmentPivotContainer(query, mainEntityIdField, mainEntityIdField);
    }

    protected SubElementRecordProcessor<AttachmentPivot> getAttachmentPivotContainer(ResultQuery<? extends Record> query, Field<Long> mainEntityIdField, Field<Long> holderIdField) {
        return this.getAttachmentPivotContainer(query, mainEntityIdField, (Record record) -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, holderIdField));
    }

    protected SubElementRecordProcessor<AttachmentPivot> getAttachmentPivotContainer(ResultQuery<? extends Record> query, Field<Long> mainEntityIdField, Function<Record, AttachmentPivot> converterToPivot) {
        return new SubElementRecordProcessor<AttachmentPivot>(query, mainEntityIdField, (Field<Long>)Tables.ATTACHMENT.ATTACHMENT_ID, converterToPivot, AttachmentPivot.class);
    }

    protected void addAndWriteAttachmentPivot(List<AttachmentPivot> attachmentPivots, PivotAttachmentEntity pivotBoundEntity, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        if (attachmentPivots.isEmpty()) {
            return;
        }
        attachmentPivots.forEach(attachmentPivot -> this.addAndWriteAttachmentPivot((AttachmentPivot)attachmentPivot, pivotBoundEntity, writingAttachmentConsumer));
    }

    protected void addAndWriteAttachmentPivot(List<AttachmentPivot> attachmentPivots, PivotAttachmentEntity pivotEntity, AttachmentEntity mainAttachmentEntity, Map<AttachmentEntity, Map<Long, ? extends PivotAttachmentEntity>> subPivotEntities, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        if (attachmentPivots.isEmpty()) {
            return;
        }
        attachmentPivots.forEach(attachmentPivot -> {
            if (mainAttachmentEntity.equals((Object)attachmentPivot.getAttachmentEntity())) {
                this.addAndWriteAttachmentPivot((AttachmentPivot)attachmentPivot, pivotEntity, writingAttachmentConsumer);
                return;
            }
            if (subPivotEntities.containsKey(attachmentPivot.getAttachmentEntity())) {
                ((Map)subPivotEntities.get(attachmentPivot.getAttachmentEntity())).computeIfPresent(attachmentPivot.getHolderId(), (k, v) -> {
                    this.addAndWriteAttachmentPivot((AttachmentPivot)attachmentPivot, (PivotAttachmentEntity)v, writingAttachmentConsumer);
                    return v;
                });
            }
        });
    }

    protected void addAndWriteAttachmentPivot(AttachmentPivot attachmentPivot, PivotAttachmentEntity pivotBoundEntity, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        if (Objects.nonNull(attachmentPivot.getContent()) && attachmentPivot.getContent().length > 0) {
            writingAttachmentConsumer.accept(attachmentPivot);
            pivotBoundEntity.addAttachment(attachmentPivot);
        }
    }

    protected <R extends Record> void convertRecordAndWritingPivot(ResultQuery<R> mainQuery, Long projectId, EntityBindingField entityBindingField, Consumer<P> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        List<SubElementRecordProcessor<? extends AbstractPivotObject>> subElementRecordProcessors = null;
        Field<Long> mainEntityIdField = entityBindingField.getEntityIdField();
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (Stream mainQueryStream = mainQuery.fetchStream();){
                Iterator mainQueryIterator = mainQueryStream.iterator();
                AbstractPivotObject pivotObject = null;
                subElementRecordProcessors = this.getSubElementRecordProcessors(projectId, entityBindingField);
                while (mainQueryIterator.hasNext()) {
                    Record record = (Record)mainQueryIterator.next();
                    if (pivotObject == null) {
                        pivotObject = this.getNewPivotObject(record, projectId, entityBindingField);
                        continue;
                    }
                    Long mainEntityId = pivotObject.pivotIdToSquashId();
                    if (!mainEntityId.equals(record.get(mainEntityIdField))) {
                        this.appendSubElementsToPivotObject(pivotObject, this.getSubElementByClazz(subElementRecordProcessors, mainEntityId, false), writingAttachmentConsumer);
                        writingToJsonConsumer.accept(pivotObject);
                        pivotObject = this.getNewPivotObject(record, projectId, entityBindingField);
                        continue;
                    }
                    this.fillPivotObject(pivotObject, record);
                }
                if (pivotObject != null) {
                    Long mainEntityId = pivotObject.pivotIdToSquashId();
                    this.appendSubElementsToPivotObject(pivotObject, this.getSubElementByClazz(subElementRecordProcessors, mainEntityId, true), writingAttachmentConsumer);
                    writingToJsonConsumer.accept(pivotObject);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (subElementRecordProcessors != null) {
                subElementRecordProcessors.forEach(SubElementRecordProcessor::close);
            }
        }
    }

    private Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> getSubElementByClazz(List<SubElementRecordProcessor<? extends AbstractPivotObject>> subElementSubElementRecordProcessors, Long mainEntityId, boolean isLast) {
        return subElementSubElementRecordProcessors.stream().collect(Collectors.toMap(SubElementRecordProcessor::getSubElementClazz, processor -> processor.getSubElements(mainEntityId, isLast)));
    }

    protected <T extends AbstractPivotObject> List<T> getSubElement(Class<T> clazz, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz) {
        return subElementsByClazz.get(clazz);
    }

    protected abstract P getNewPivotObject(Record var1, Long var2, EntityBindingField var3);

    protected abstract void fillPivotObject(P var1, Record var2);

    protected abstract List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long var1, EntityBindingField var2);

    protected abstract void appendSubElementsToPivotObject(P var1, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> var2, Consumer<AttachmentPivot> var3);
}

