/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.service.internal.library.LibraryUtils;

public class CompareFieldStringEntity<T> {
    private final Map<String, FieldIndex<T>> fieldIndexes = new HashMap<String, FieldIndex<T>>();
    private final Map<String, Function<T, String>> fieldExtractors;
    private final boolean normalizeValues;

    public CompareFieldStringEntity(Collection<T> items, Map<String, Function<T, String>> fieldExtractors, boolean normalizeValues) {
        this.fieldExtractors = fieldExtractors;
        this.normalizeValues = normalizeValues;
        items.forEach(this::addItem);
    }

    public void addItem(T item) {
        this.fieldExtractors.forEach((fieldName, extractor) -> this.fieldIndexes.computeIfAbsent((String)fieldName, k -> new FieldIndex()).buildIndex(item, extractor));
    }

    public Comparison<T> checkField(String fieldName, String fieldValue) {
        FieldIndex<T> index = this.fieldIndexes.get(fieldName);
        if (index != null) {
            return index.checkSimilarities(fieldValue);
        }
        return new Comparison(false, Collections.emptySet(), Collections.emptySet());
    }

    public record Comparison<U>(boolean isMatched, Set<U> entities, Set<String> clashingNames) {
        private Comparison(Set<U> entities, Set<String> clashingNames) {
            this(!entities.isEmpty(), entities, clashingNames);
        }
    }

    private final class FieldIndex<U> {
        private final Map<String, Set<U>> exactMatches = new HashMap<String, Set<U>>();
        private final Map<String, Set<String>> clashingNamesMatches = new HashMap<String, Set<String>>();

        private FieldIndex() {
        }

        private void buildIndex(U item, Function<U, String> fieldExtractor) {
            String fieldValue = fieldExtractor.apply(item);
            if (fieldValue != null) {
                this.exactMatches.computeIfAbsent(this.normalizeValue(fieldValue), k -> new HashSet()).add(item);
                String baseName = LibraryUtils.removeTokenPart(fieldValue);
                this.addClashingName(this.normalizeValue(baseName), fieldValue);
            }
        }

        private void addClashingName(String baseName, String fullName) {
            if (this.clashingNamesMatches.containsKey(baseName)) {
                this.clashingNamesMatches.get(baseName).add(fullName);
                return;
            }
            Set<String> keyMatching = this.clashingNamesMatches.keySet().stream().filter(existingValues -> this.normalizeValue((String)existingValues).contains(baseName)).collect(Collectors.toSet());
            if (!keyMatching.isEmpty()) {
                keyMatching.forEach(existingKey -> {
                    boolean bl = this.clashingNamesMatches.get(this.normalizeValue((String)existingKey)).add(fullName);
                });
            }
            this.clashingNamesMatches.computeIfAbsent(this.normalizeValue(fullName), k -> new HashSet(keyMatching)).add(fullName);
        }

        private String normalizeValue(String value) {
            if (!CompareFieldStringEntity.this.normalizeValues) {
                return value;
            }
            return StringUtils.stripAccents((String)value).toLowerCase().trim();
        }

        private Comparison<U> checkSimilarities(String searchField) {
            String normalizedSearchField = this.normalizeValue(searchField);
            Set matchedLinks = this.exactMatches.getOrDefault(normalizedSearchField, new HashSet());
            Set similarities = this.clashingNamesMatches.getOrDefault(LibraryUtils.removeTokenPart(normalizedSearchField), new HashSet());
            return new Comparison(matchedLinks, similarities);
        }
    }
}

