/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.pivotdefinition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public abstract class AbstractPivotObject {
    protected static final String PIVOT_GENERATED = "%s%s-Project";
    @JsonProperty(value="id")
    protected String pivotId;

    public String getPivotId() {
        return this.pivotId;
    }

    public static String getPivotId(String basePivotId, Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return "%s%s".formatted(basePivotId, id);
    }

    public static String getPivotId(String basePivotId, Integer id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return AbstractPivotObject.getPivotId(basePivotId, (long)id);
    }

    public String getPivotId(Long id) {
        return AbstractPivotObject.getPivotId(this.getBasePivotId(), id);
    }

    public String getPivotIdOtherProject(String basePivotId, Long id) {
        return PIVOT_GENERATED.formatted(basePivotId, id);
    }

    public void setPivotId(String pivotId) {
        this.pivotId = pivotId;
    }

    public void setPivotId(Integer id) {
        if (Objects.isNull(id)) {
            return;
        }
        this.pivotId = this.getPivotId((long)id);
    }

    public void setPivotId(Long id) {
        this.pivotId = this.getPivotId(id);
    }

    public void setPivotIdGenerated(Long id) {
        this.pivotId = this.getPivotIdOtherProject(this.getBasePivotId(), id);
    }

    public Long pivotIdToSquashId() {
        return this.pivotIdToSquashId(this.getBasePivotId());
    }

    @JsonIgnore
    protected Long pivotIdToSquashId(String basePivotId) {
        return Long.parseLong(this.pivotId.replace(basePivotId, ""));
    }

    @JsonIgnore
    public abstract String getBasePivotId();
}

