/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.display.search.SearchGridDisplayService;
import org.squashtest.tm.service.grid.ColumnIds;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.display.SearchDisplayDao;
import org.squashtest.tm.service.plugin.PluginFinderService;

public abstract class AbstractSearchGridDisplayService
implements SearchGridDisplayService {
    private static final String REQUIREMENT_SEARCH = "requirement-search";
    private static final String TEST_CASE_SEARCH = "test-case-search";
    private static final String TC_BY_REQUIREMENT = "tc-by-requirement";
    private final SearchDisplayDao searchDisplayDao;
    @Inject
    private GridConfigurationService gridConfigurationService;
    @Inject
    private PluginFinderService pluginFinderService;

    protected AbstractSearchGridDisplayService(SearchDisplayDao searchDisplayDao) {
        this.searchDisplayDao = searchDisplayDao;
    }

    @Override
    public GridResponse fetchResearchRows(ResearchResult researchResult, GridRequest gridRequest) {
        String gridId = gridRequest.getGridId();
        List<String> activeColumnsIds = this.gridConfigurationService.findActiveColumnIdsForUser(gridId);
        if (this.pluginFinderService.isPremiumPluginInstalled()) {
            if (gridId.equals(REQUIREMENT_SEARCH) && !ColumnIds.COLUMNS_NOT_TRIGGERING_REQ_REQUEST.containsAll(activeColumnsIds)) {
                gridRequest.getSimplifiedColumnDisplayGridIds().remove(REQUIREMENT_SEARCH);
            } else if ((gridId.equals(TEST_CASE_SEARCH) || gridId.equals(TC_BY_REQUIREMENT)) && !ColumnIds.COLUMNS_NOT_TRIGGERING_TEST_CASE_REQUEST.containsAll(activeColumnsIds)) {
                gridRequest.getSimplifiedColumnDisplayGridIds().remove(TEST_CASE_SEARCH);
            }
        }
        GridResponse gridResponse = this.searchDisplayDao.getRows(researchResult.getIds(), gridRequest);
        gridResponse.setCount(researchResult.getCount());
        gridResponse.setPage(GridResponse.getPageNumberWithinBounds(gridRequest, researchResult.getCount()));
        this.reorderAccordingToResults(researchResult, gridResponse);
        gridResponse.setActiveColumnIds(this.gridConfigurationService.findActiveColumnIdsForUser(gridId));
        return gridResponse;
    }

    private void reorderAccordingToResults(ResearchResult researchResult, GridResponse gridResponse) {
        Map<Long, DataRow> dataRowMap = this.createDataRowMapById(gridResponse);
        List<DataRow> orderedRows = this.reorderRows(researchResult, dataRowMap);
        gridResponse.setDataRows(orderedRows);
    }

    private List<DataRow> reorderRows(ResearchResult researchResult, Map<Long, DataRow> dataRowMap) {
        return researchResult.getIds().stream().map(dataRowMap::get).collect(Collectors.toList());
    }

    private Map<Long, DataRow> createDataRowMapById(GridResponse gridResponse) {
        return gridResponse.getDataRows().stream().collect(Collectors.toMap(row -> Long.parseLong(row.getId()), Function.identity()));
    }
}

