/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record6;
import org.jooq.Record8;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.records.TestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class SprintOverallExecPlanGrid
extends AbstractTestPlanGrid<TestPlanItemRecord> {
    private final long sprintId;

    public SprintOverallExecPlanGrid(long sprintId, String userToRestrictTo) {
        super(userToRestrictTo);
        this.sprintId = sprintId;
    }

    @Override
    protected TableOnConditionStep<Record> getItemTable() {
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID));
    }

    @Override
    protected Condition getItemFilterCondition() {
        return Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Object)this.sprintId);
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID;
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.TEST_PLAN_ITEM.ASSIGNEE_ID;
    }

    @Override
    protected TableField<TestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.TEST_PLAN_ITEM.TCLN_ID;
    }

    @Override
    protected List<GridColumn> getSpecificColumns() {
        return List.of(new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"INFERRED_EXECUTION_MODE", "INFERRED_EXECUTION_MODE"})).as("INFERRED_EXECUTION_MODE")), new GridColumn((Field<?>)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID), new GridColumn(SprintOverallExecPlanGrid.getSprintReqNameWithRef()));
    }

    @Override
    protected Table<?> getTable() {
        Table<Record8<Long, String, Long, String, String, String, String, String>> testCaseTable = this.getTestCaseTable();
        CoreUser executorUser = this.getExecutorUser();
        CoreUser assigneeUser = this.getAssigneeUser();
        Table<Record2<Long, String>> inferredExecutionModeTable = this.getAutomationFields();
        Table<Record6<Long, Long, String, String, Timestamp, String>> lastestExecutionTable = this.getLatestExecutionTable();
        Table<Record1<Long>> hasExecutableSteps = this.getHasExecutableSteps();
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT.CLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin(testCaseTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(testCaseTable.field("ITEM_ID", Long.class))).leftJoin((TableLike)assigneeUser).on(Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.eq(assigneeUser.field("PARTY_ID", Long.class))).leftJoin((TableLike)executorUser).on(Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY.eq(executorUser.field("LOGIN", String.class))).leftJoin(inferredExecutionModeTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(inferredExecutionModeTable.field("ITEM_ID", Long.class))).leftJoin(lastestExecutionTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastestExecutionTable.field("ITEM_ID", Long.class))).leftJoin(hasExecutableSteps).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(hasExecutableSteps.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID).and(Tables.DATASET.TEST_CASE_ID.eq(testCaseTable.field("TEST_CASE_ID", Long.class)))).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID));
    }

    private static Field<String> getSprintReqNameWithRef() {
        return DSL.when((Condition)Tables.SPRINT_REQ_VERSION.NAME.isNull(), (Field)DSL.when((Condition)Tables.REQUIREMENT_VERSION.REFERENCE.isNull().or(Tables.REQUIREMENT_VERSION.REFERENCE.eq((Object)"")), (Field)Tables.RESOURCE.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.REQUIREMENT_VERSION.REFERENCE, DSL.inline((String)" - "), Tables.RESOURCE.NAME}))).otherwise(DSL.when((Condition)Tables.SPRINT_REQ_VERSION.REFERENCE.isNull(), (Field)Tables.SPRINT_REQ_VERSION.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.SPRINT_REQ_VERSION.REFERENCE, DSL.inline((String)" - "), Tables.SPRINT_REQ_VERSION.NAME}))).as("SPRINT_REQ_VERSION_NAME_WITH_REF");
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"TEST_PLAN_ITEM_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"TEST_PLAN_ITEM_ID").asc();
    }
}

