/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.annotation.CleanHtml;
import org.squashtest.tm.service.internal.display.dto.GlobalConfigurationDto$AjcClosure1;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public final class GlobalConfigurationDto {
    private boolean milestoneFeatureEnabled;
    private List<String> uploadFileExtensionWhitelist;
    private Long uploadFileSizeLimit;
    private String bannerMessage;
    private boolean searchActivationFeatureEnabled;
    private boolean unsafeAttachmentPreviewEnabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    private GlobalConfigurationDto() {
    }

    public boolean isMilestoneFeatureEnabled() {
        return this.milestoneFeatureEnabled;
    }

    private void setMilestoneFeatureEnabled(boolean milestoneFeatureEnabled) {
        this.milestoneFeatureEnabled = milestoneFeatureEnabled;
    }

    public List<String> getUploadFileExtensionWhitelist() {
        return this.uploadFileExtensionWhitelist;
    }

    private void setUploadFileExtensionWhitelist(String whiteList) {
        this.uploadFileExtensionWhitelist = Arrays.stream(whiteList.split(",")).filter(StringUtils::isNotBlank).map(StringUtils::trim).toList();
    }

    public Long getUploadFileSizeLimit() {
        return this.uploadFileSizeLimit;
    }

    private void setUploadFileSizeLimit(Long uploadFileSizeLimit) {
        this.uploadFileSizeLimit = uploadFileSizeLimit;
    }

    @CleanHtml
    public String getBannerMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        GlobalConfigurationDto$AjcClosure1 globalConfigurationDto$AjcClosure1 = new GlobalConfigurationDto$AjcClosure1(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(globalConfigurationDto$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void setBannerMessage(String bannerMessage) {
        this.bannerMessage = bannerMessage;
    }

    public boolean isSearchActivationFeatureEnabled() {
        return this.searchActivationFeatureEnabled;
    }

    public void setSearchActivationFeatureEnabled(boolean searchActivationFeatureEnabled) {
        this.searchActivationFeatureEnabled = searchActivationFeatureEnabled;
    }

    public boolean isUnsafeAttachmentPreviewEnabled() {
        return this.unsafeAttachmentPreviewEnabled;
    }

    public void setUnsafeAttachmentPreviewEnabled(boolean unsafeAttachmentPreviewEnabled) {
        this.unsafeAttachmentPreviewEnabled = unsafeAttachmentPreviewEnabled;
    }

    public static GlobalConfigurationDto create(Map<String, String> coreConfig) {
        GlobalConfigurationDto conf = new GlobalConfigurationDto();
        conf.setMilestoneFeatureEnabled(Boolean.parseBoolean(coreConfig.get("feature.milestone.enabled")));
        conf.setUploadFileExtensionWhitelist(coreConfig.get("uploadfilter.fileExtensions.whitelist"));
        conf.setUploadFileSizeLimit(Long.parseLong(coreConfig.get("uploadfilter.upload.sizeLimitInBytes")));
        conf.setBannerMessage(HTMLCleanupUtils.cleanHtml(coreConfig.get("BANNER_MESSAGE")));
        conf.setSearchActivationFeatureEnabled(Boolean.parseBoolean(coreConfig.get("feature.searchActivation.enabled")));
        conf.setUnsafeAttachmentPreviewEnabled(Boolean.parseBoolean(coreConfig.get("feature.unsafeAttachmentPreview.enabled")));
        return conf;
    }

    static {
        GlobalConfigurationDto.ajc$preClinit();
    }

    static final /* synthetic */ String getBannerMessage_aroundBody0(GlobalConfigurationDto ajc$this, JoinPoint joinPoint) {
        return ajc$this.bannerMessage;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GlobalConfigurationDto.java", GlobalConfigurationDto.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBannerMessage", "org.squashtest.tm.service.internal.display.dto.GlobalConfigurationDto", "", "", "", "java.lang.String"), 70);
    }
}

