/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Param;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectOrderByStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractJdbcDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class JdbcRequirementNodeDeletionHandler
extends AbstractJdbcDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcRequirementNodeDeletionHandler.class);
    private static final String REQUIREMENT_LABEL = "requirement";
    private final Collection<Long> nodeIds;
    private Map<Long, TestCaseImportance> concernedTestCases;
    private final Long currentMilestoneId;
    private final Map<Long, List<Long>> deletableVersionsByReq;
    private final Map<Long, List<Long>> unbindableVersionsByReq;

    public JdbcRequirementNodeDeletionHandler(Collection<Long> nodeIds, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
        this.nodeIds = nodeIds;
        this.currentMilestoneId = null;
        this.deletableVersionsByReq = Collections.emptyMap();
        this.unbindableVersionsByReq = Collections.emptyMap();
    }

    public JdbcRequirementNodeDeletionHandler(Collection<Long> nodeIds, Collection<Long> lockedRequirementIds, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, Long currentMilestoneId, String operationId) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
        this.nodeIds = nodeIds;
        this.currentMilestoneId = currentMilestoneId;
        this.deletableVersionsByReq = this.getRequirementVersionLinkToMilestone(lockedRequirementIds, currentMilestoneId, DSL.count((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).eq((Object)1));
        this.unbindableVersionsByReq = this.getRequirementVersionLinkToMilestone(lockedRequirementIds, currentMilestoneId, DSL.count((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).gt((Object)1));
    }

    public OperationReport delete() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.nullify();
        this.saveConcernedTestCases();
        this.performDeletions();
        this.reorderRequirementVersions();
        OperationReport report = this.makeReport();
        this.cleanWorkingTable();
        this.logEndProcess();
        return report;
    }

    private void saveConcernedTestCases() {
        this.concernedTestCases = this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.WORK_DELETE_ENTITIES).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.WORK_DELETE_ENTITIES.ENTITY_ID).and(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)"RESOURCE"))).fetchStream().collect(Collectors.groupingBy(Record2::value1, Collectors.collectingAndThen(Collectors.mapping(r -> RequirementCriticality.valueOf((String)((String)r.value2())), Collectors.toList()), TestCaseImportance::deduceTestCaseImportance)));
    }

    public Map<Long, TestCaseImportance> getConcernedTestCases() {
        return this.concernedTestCases == null ? Collections.emptyMap() : this.concernedTestCases;
    }

    private void reorderRequirementVersions() {
        if (this.deletableVersionsByReq.isEmpty()) {
            return;
        }
        Set<Long> requirementIds = this.deletableVersionsByReq.keySet();
        int startIndex = 1;
        this.reorderHelper.reorder(requirementIds, Tables.REQUIREMENT_VERSION.RES_ID, (Field<Long>)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (Field<Integer>)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, startIndex);
        this.resetRequirementCurrentVersion(requirementIds);
    }

    private void resetRequirementCurrentVersion(Set<Long> requirementIds) {
        Table subQuery = DSL.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)DSL.max((Field)Tables.REQUIREMENT_VERSION.VERSION_NUMBER).as("REQUIREMENT_VERSION_NUMBER")).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.REQUIREMENT_ID}).asTable("max_requirement_table");
        Map currentRequirementVersion = this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)subQuery).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq(subQuery.field("REQUIREMENT_ID", Long.class)).and(Tables.REQUIREMENT_VERSION.VERSION_NUMBER.eq(subQuery.field("REQUIREMENT_VERSION_NUMBER", Integer.class)))).fetchMap((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (Field)Tables.REQUIREMENT_VERSION.RES_ID);
        List<UpdateConditionStep> updates = currentRequirementVersion.entrySet().stream().map(entry -> this.dslContext.update((Table)Tables.REQUIREMENT).set((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID, (Object)((Long)entry.getValue())).where(Tables.REQUIREMENT.RLN_ID.eq((Object)((Long)entry.getKey())))).toList();
        this.dslContext.batch(updates).execute();
    }

    private void performDeletions() {
        this.deleteRequirementVersions();
        this.deleteRelationShips();
        this.deleteNodes();
        this.deleteResources();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
        this.deleteMilestoneLinks();
    }

    private void deleteResources() {
        this.workingTables.delete(Tables.RESOURCE.RES_ID, Tables.SIMPLE_RESOURCE.RES_ID);
        this.workingTables.delete(Tables.RESOURCE.RES_ID, Tables.RESOURCE.RES_ID);
    }

    private void deleteRelationShips() {
        this.deleteRootRelationships();
        this.deleteNodeRelationShips();
    }

    private void deleteNodeRelationShips() {
        Set parentIds = this.dslContext.selectDistinct((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.in(this.nodeIds)).fetchSet((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID);
        if (parentIds.isEmpty()) {
            return;
        }
        this.workingTables.delete(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.RLN_RELATIONSHIP.ANCESTOR_ID);
        this.workingTables.delete(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.RLN_RELATIONSHIP.DESCENDANT_ID);
        this.reorderHelper.reorder(parentIds, Tables.RLN_RELATIONSHIP);
    }

    private void deleteRootRelationships() {
        Set parentLibraryIds = this.dslContext.selectDistinct((SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).where(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.in(this.nodeIds)).fetchSet((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID);
        if (parentLibraryIds.isEmpty()) {
            return;
        }
        this.workingTables.delete(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID);
        this.reorderHelper.reorder(parentLibraryIds, Tables.REQUIREMENT_LIBRARY_CONTENT);
    }

    private void deleteNodes() {
        this.workingTables.delete(Tables.REQUIREMENT.RLN_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID);
        this.workingTables.delete(Tables.REQUIREMENT.RLN_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT.RLN_ID, Tables.REQUIREMENT.RLN_ID);
        this.workingTables.delete(Tables.REQUIREMENT_FOLDER.RLN_ID, Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID);
        this.workingTables.delete(Tables.REQUIREMENT_FOLDER.RLN_ID, Tables.REQUIREMENT_FOLDER.RLN_ID);
        this.workingTables.delete(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID);
    }

    private void deleteRequirementVersions() {
        this.workingTables.delete(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, Tables.REQUIREMENT_PROPERTY_CHANGE.EVENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, Tables.REQUIREMENT_LARGE_PROPERTY_CHANGE.EVENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, Tables.REQUIREMENT_CREATION.EVENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, Tables.SYNC_REQUIREMENT_CREATION.EVENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, Tables.SYNC_REQUIREMENT_UPDATE.EVENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID);
        this.workingTables.delete(Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID, Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID);
        this.workingTables.delete(Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID, Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID);
        this.workingTables.delete(Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID);
        this.workingTables.delete(Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID);
        this.workingTables.delete(Tables.RESOURCE.RES_ID, Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID);
        this.workingTables.delete(Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION.RES_ID);
    }

    private OperationReport makeReport() {
        OperationReport report = new OperationReport();
        report.addRemoved(this.workingTables.selectIds(Tables.REQUIREMENT_FOLDER.RLN_ID), "folder");
        report.addRemoved(this.workingTables.selectIds(Tables.REQUIREMENT.RLN_ID), REQUIREMENT_LABEL);
        if (!this.deletableVersionsByReq.isEmpty()) {
            report.addRemoved(this.deletableVersionsByReq.keySet(), REQUIREMENT_LABEL);
        }
        if (!this.unbindableVersionsByReq.isEmpty()) {
            report.addRemoved(this.unbindableVersionsByReq.keySet(), REQUIREMENT_LABEL);
        }
        return report;
    }

    private void nullify() {
        this.nullify(Tables.REQUIREMENT.RLN_ID, Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID);
        this.nullify(Tables.RESOURCE.RES_ID, Tables.REQUIREMENT.CURRENT_VERSION_ID);
        this.nullify(Tables.RESOURCE.RES_ID, Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.addLibraryNodes();
        this.addFolders();
        this.addRequirements();
        this.addResources();
        this.addCoverages();
        this.addAuditEvent();
        this.addCustomFieldValues();
        this.addAttachmentList();
    }

    private void addAuditEvent() {
        this.workingTables.addEntity(Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID, () -> this.makeSelectJoin(Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_AUDIT_EVENT.REQ_VERSION_ID, Tables.REQUIREMENT_AUDIT_EVENT.EVENT_ID));
    }

    private void addCoverages() {
        this.workingTables.addEntity(Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID, () -> this.makeSelectJoin(Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID, Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID));
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.makeSelectJoinAttachmentList(Tables.RESOURCE.RES_ID, Tables.RESOURCE.RES_ID, Tables.RESOURCE.ATTACHMENT_LIST_ID));
    }

    private void addFolders() {
        this.workingTables.addEntity(Tables.REQUIREMENT_FOLDER.RLN_ID, () -> this.makeSelectJoin(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT_FOLDER.RLN_ID, Tables.REQUIREMENT_FOLDER.RLN_ID));
    }

    private void addRequirements() {
        this.workingTables.addEntity(Tables.REQUIREMENT.RLN_ID, () -> this.makeSelectJoin(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT.RLN_ID, Tables.REQUIREMENT.RLN_ID));
    }

    private void addResources() {
        SelectOrderByStep<Record3<Long, String, String>> requirementResourceSelector = this.selectRequirementResourceRecords();
        this.workingTables.addEntity(Tables.RESOURCE.RES_ID, () -> requirementResourceSelector);
    }

    private SelectOrderByStep<Record3<Long, String, String>> selectRequirementResourceRecords() {
        SelectOrderByStep query = this.makeSelectJoin((TableField<?, Long>)Tables.REQUIREMENT.RLN_ID, (TableField<?, Long>)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (TableField<?, Long>)Tables.REQUIREMENT_VERSION.RES_ID, (Table<?>)Tables.RESOURCE).union(this.makeSelectJoin((TableField<?, Long>)Tables.REQUIREMENT_FOLDER.RLN_ID, (TableField<?, Long>)Tables.REQUIREMENT_FOLDER.RLN_ID, (TableField<?, Long>)Tables.REQUIREMENT_FOLDER.RES_ID, (Table<?>)Tables.RESOURCE));
        if (!this.deletableVersionsByReq.isEmpty()) {
            List versionIds = this.deletableVersionsByReq.values().stream().flatMap(Collection::stream).toList();
            query = query.union((Select)this.makeSelectClause(Tables.REQUIREMENT_VERSION.RES_ID, (Param<String>)DSL.val((String)Tables.RESOURCE.getName())).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.RES_ID.in(versionIds)));
        }
        return query;
    }

    private void addLibraryNodes() {
        this.workingTables.addEntity(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, () -> this.makeSelectClause(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(this.nodeIds)));
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, () -> this.makeSelectCustomFieldValues(Tables.REQUIREMENT_FOLDER.RLN_ID, BindableEntity.REQUIREMENT_FOLDER).union(this.makeSelectCustomFieldValues(Tables.RESOURCE.RES_ID, BindableEntity.REQUIREMENT_VERSION)));
    }

    private void deleteMilestoneLinks() {
        if (this.currentMilestoneId == null && this.unbindableVersionsByReq.isEmpty()) {
            return;
        }
        List unbindableVersions = this.unbindableVersionsByReq.values().stream().flatMap(Collection::stream).toList();
        this.dslContext.deleteFrom((Table)Tables.MILESTONE_REQ_VERSION).where(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Object)this.currentMilestoneId).and(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.in(unbindableVersions))).execute();
    }

    private Map<Long, List<Long>> getRequirementVersionLinkToMilestone(Collection<Long> requirementIds, Long milestoneId, Condition milestoneCountCondition) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in((Select)DSL.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).and(Tables.MILESTONE.STATUS.in((Collection)MilestoneStatus.MILESTONE_BLOCKING_STATUSES)).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).having(milestoneCountCondition.and(DSL.count((Field)Tables.MILESTONE.MILESTONE_ID).eq((Object)0)))).and(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Object)milestoneId))).fetchGroups((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (Field)Tables.REQUIREMENT_VERSION.RES_ID);
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init deletion process of requirement nodes %s. Operation:  %s", this.nodeIds, this.operationId), new Object[0]);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Deleted requirement nodes %s. Time elapsed %s", this.nodeIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

