/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.library.structures.GraphNode;
import org.squashtest.tm.domain.library.structures.LibraryGraph;

public class LockedFileInferenceGraph
extends LibraryGraph<NamedReference, Node> {
    private List<Long> candidatesToDeletion;

    public void init(LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> initialGraph) {
        this.mergeGraph(initialGraph, (LibraryGraph.NodeTransformer)new LibraryGraph.NodeTransformer<LibraryGraph.SimpleNode<NamedReference>, Node>(){

            public Node createFrom(LibraryGraph.SimpleNode<NamedReference> node) {
                return new Node((NamedReference)node.getKey());
            }

            public Object createKey(LibraryGraph.SimpleNode<NamedReference> node) {
                return node.getKey();
            }
        });
    }

    public void setCandidatesToDeletion(List<Long> candidates) {
        this.candidatesToDeletion = candidates;
    }

    public void reset() {
        for (Node node : this.getNodes()) {
            node.setDeletable(false);
            node.setCounter(0);
        }
    }

    protected void resolveLockedFiles() {
        LinkedList<Node> remainingNodes = new LinkedList<Node>();
        this.reset();
        for (Node orphan : this.getOrphans()) {
            if (!this.isCandidate(orphan)) continue;
            orphan.setDeletable(true);
            remainingNodes.add(orphan);
        }
        while (!remainingNodes.isEmpty()) {
            Node currentNode = (Node)((Object)remainingNodes.getFirst());
            for (Node child : currentNode.getOutbounds()) {
                child.increaseCounter();
                boolean childShouldBeDeleted = this.isCandidate(child);
                if (!child.areAllParentsDeletable() || !childShouldBeDeleted) continue;
                child.setDeletable(true);
                remainingNodes.add(child);
            }
            remainingNodes.removeFirst();
        }
    }

    public List<Node> collectLockedCandidates() {
        ArrayList<Node> lockedCandidates = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (node.isDeletable() || !this.isCandidate(node)) continue;
            lockedCandidates.add(node);
        }
        return lockedCandidates;
    }

    public List<Node> collectLockers() {
        ArrayList<Node> lockers = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (node.isDeletable() || this.isCandidate(node)) continue;
            lockers.add(node);
        }
        return lockers;
    }

    public List<Node> collectDeletableNodes() {
        ArrayList<Node> deletableNodes = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (!node.isDeletable()) continue;
            deletableNodes.add(node);
        }
        return deletableNodes;
    }

    public boolean hasLockedFiles() {
        for (Node node : this.getNodes()) {
            if (node.isDeletable()) continue;
            return true;
        }
        return false;
    }

    private boolean isCandidate(Node node) {
        return this.candidatesToDeletion.contains(((NamedReference)node.getKey()).getId());
    }

    static class Node
    extends GraphNode<NamedReference, Node> {
        private boolean deletable = true;
        private Integer parentDeletableCount = 0;

        public Node(NamedReference key) {
            super((Object)key);
        }

        public boolean isDeletable() {
            return this.deletable;
        }

        public void setDeletable(boolean isDeletable) {
            this.deletable = isDeletable;
        }

        public void increaseCounter() {
            this.parentDeletableCount = this.parentDeletableCount + 1;
        }

        public Integer getCounter() {
            return this.parentDeletableCount;
        }

        public void setCounter(Integer parentDeletableCount) {
            this.parentDeletableCount = parentDeletableCount;
        }

        public boolean areAllParentsDeletable() {
            return this.parentDeletableCount.intValue() == this.getInbounds().size();
        }

        public String getName() {
            return ((NamedReference)this.key).getName();
        }
    }
}

