/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOrderByStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractJdbcDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class JdbcTestCaseNodeDeletionHandler
extends AbstractJdbcDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTestCaseNodeDeletionHandler.class);
    private final NodeScope scope;

    public JdbcTestCaseNodeDeletionHandler(NodeScope scope, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
        this.scope = scope;
    }

    public OperationReport delete() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.nullify();
        this.performDeletions();
        OperationReport report = this.makeReport();
        this.cleanWorkingTable();
        this.logEndProcess();
        return report;
    }

    private OperationReport makeReport() {
        OperationReport report = new OperationReport();
        report.addRemoved(this.workingTables.selectIds(Tables.TEST_CASE_FOLDER.TCLN_ID), "folder");
        report.addRemoved(this.workingTables.selectIds(Tables.TEST_CASE.TCLN_ID), "test-case");
        return report;
    }

    private void performDeletions() {
        this.deleteCampaignItems();
        this.deleteTestPlanItems();
        this.deleteDatasetsAndParameters();
        this.deleteCoverage();
        this.deleteTestCaseMilestones();
        this.deleteSteps();
        this.deleteRelationShips();
        this.deleteTestAutomationCandidate();
        this.deleteNodes();
        this.deleteAutomationRequests();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
    }

    private void deleteCampaignItems() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID);
        List<Long> campaignIds = this.workingTables.selectIds(Tables.CAMPAIGN.CLN_ID);
        this.reorderHelper.reorder(campaignIds, Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID, (Field<Long>)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID, (Field<Integer>)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_PLAN_ORDER);
    }

    private void deleteTestPlanItems() {
        SelectConditionStep query = this.dslContext.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID, (SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).and(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_PLAN_ITEM.getName()))).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId));
        HashSet<Long> testPlanIds = new HashSet<Long>();
        HashSet<Long> suiteIds = new HashSet<Long>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = query.fetchStream();){
            stream.forEach(record -> {
                testPlanIds.add((Long)record.value1());
                Long suiteId = (Long)record.value2();
                if (suiteId != null) {
                    suiteIds.add(suiteId);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID);
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
        this.workingTables.delete(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID);
        this.reorderHelper.reorder(testPlanIds, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (Field<Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID, (Field<Integer>)Tables.TEST_PLAN_ITEM.ITEM_ORDER);
        this.reorderHelper.reorder((Collection<Long>)suiteIds, Tables.TEST_SUITE_TEST_PLAN_ITEM, (Field<Long>)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (Field<Long>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID, (Field<Integer>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER);
    }

    private void deleteDatasetsAndParameters() {
        this.workingTables.delete(Tables.DATASET.DATASET_ID, Tables.DATASET_PARAM_VALUE.DATASET_ID);
        this.workingTables.delete(Tables.DATASET.DATASET_ID, Tables.DATASET.DATASET_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.PARAMETER.TEST_CASE_ID);
    }

    private void deleteCoverage() {
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.VERIFYING_STEPS.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID);
    }

    private void deleteTestCaseMilestones() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.MILESTONE_TEST_CASE.TEST_CASE_ID);
        this.logDelete((Table<?>)Tables.MILESTONE_CAMPAIGN);
    }

    private void deleteSteps() {
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.ACTION_WORD_PARAMETER_VALUE.KEYWORD_TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.TEST_CASE_STEPS.STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.CALL_TEST_STEP.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.KEYWORD_TEST_STEP.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.TEST_STEP_ID);
        this.workingTables.delete(Tables.TEST_STEP.TEST_STEP_ID, Tables.TEST_STEP.TEST_STEP_ID);
    }

    private void deleteRelationShips() {
        this.deleteRootRelationships();
        this.deleteNodeRelationships();
    }

    private void deleteTestAutomationCandidate() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID);
        this.logDelete((Table<?>)Tables.TEST_AUTOMATION_CANDIDATE);
    }

    private void deleteRootRelationships() {
        Set parentLibraryIds = this.dslContext.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID)).where(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_CASE_LIBRARY_NODE.getName())).fetchSet((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID);
        if (parentLibraryIds.isEmpty()) {
            return;
        }
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID);
        this.reorderHelper.reorder(parentLibraryIds, Tables.TEST_CASE_LIBRARY_CONTENT);
        this.logDelete((Table<?>)Tables.TEST_CASE_LIBRARY_CONTENT);
    }

    private void deleteNodeRelationships() {
        Set parentIds = this.dslContext.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_CASE_LIBRARY_NODE.getName())).fetchSet((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID);
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TCLN_RELATIONSHIP.ANCESTOR_ID);
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TCLN_RELATIONSHIP.DESCENDANT_ID);
        this.logDelete((Table<?>)Tables.TCLN_RELATIONSHIP);
        if (!parentIds.isEmpty()) {
            this.reorderHelper.reorder(parentIds, Tables.TCLN_RELATIONSHIP);
        }
    }

    private void deleteNodes() {
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.EXPLORATORY_TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE.TCLN_ID, Tables.TEST_CASE.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE_FOLDER.TCLN_ID, Tables.TEST_CASE_FOLDER.TCLN_ID);
        this.workingTables.delete(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID);
    }

    private void deleteAutomationRequests() {
        this.workingTables.delete(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.AUTOMATION_REQUEST_LIBRARY_CONTENT.CONTENT_ID);
        this.workingTables.delete(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.AUTOMATION_REQUEST_ID);
        this.workingTables.delete(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID);
    }

    private void nullify() {
        this.nullifyTestPlanItems();
        this.nullifyExecutions();
    }

    private void nullifyTestPlanItems() {
        Table testPlanItemTable = DSL.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.WORK_DELETE_ENTITIES).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.WORK_DELETE_ENTITIES.ENTITY_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(Tables.WORK_DELETE_ENTITIES.ENTITY_TYPE.eq((Object)Tables.TEST_CASE.getName()))).innerJoin((TableLike)Tables.EXECUTION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).where(Tables.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId)).asTable();
        this.dslContext.update((Table)Tables.TEST_PLAN_ITEM).set((Field)Tables.TEST_PLAN_ITEM.TCLN_ID, null).set((Field)Tables.TEST_PLAN_ITEM.DATASET_ID, null).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in((Select)DSL.select((SelectField)testPlanItemTable.field("TEST_PLAN_ITEM_ID", Long.class)).from((TableLike)testPlanItemTable))).execute();
    }

    private void nullifyExecutions() {
        this.nullify(Tables.TEST_CASE.TCLN_ID, Tables.EXECUTION.TCLN_ID);
        this.nullify(Tables.TEST_STEP.TEST_STEP_ID, Tables.EXECUTION_STEP.TEST_STEP_ID);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.addLibraryNodes();
        this.addFolders();
        this.addTestCases();
        this.addTestAutomationCandidates();
        this.addTestSteps();
        this.addDatasets();
        this.addCampaigns();
        this.addTestPlanItems();
        this.addExploratorySessionOverview();
        this.addCustomFieldValues();
        this.addAttachmentList();
        this.addAutomationRequests();
    }

    private void addExploratorySessionOverview() {
        this.workingTables.addEntity(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (TableField<?, Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (TableField<?, Long>)Tables.TEST_PLAN_ITEM.OVERVIEW_ID, (Table<?>)Tables.EXPLORATORY_SESSION_OVERVIEW).where(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.isNotNull()));
    }

    private void addLibraryNodes() {
        this.workingTables.addEntity(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, this::getDeletableNodesQuery);
    }

    private void addFolders() {
        this.workingTables.addEntity(Tables.TEST_CASE_FOLDER.TCLN_ID, () -> this.makeSelectJoin(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_FOLDER.TCLN_ID, Tables.TEST_CASE_FOLDER.TCLN_ID));
    }

    private Select<Record3<Long, String, String>> getDeletableNodesQuery() {
        SelectConditionStep<Record3<Long, String, String>> query = null;
        if (this.scope.hasLibraries()) {
            query = this.getLibrariesDeletedContent(this.scope.getLibraryIds());
        }
        if (this.scope.hasNodes()) {
            Select folderQuery = this.getNodesDeletedContent(this.scope.getNodeIds());
            query = query == null ? folderQuery : query.union(folderQuery);
        }
        return query;
    }

    private SelectConditionStep<Record3<Long, String, String>> getLibrariesDeletedContent(Set<Long> libraryIds) {
        return this.makeSelectClause(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.TCL_ID.in(libraryIds).and(ConditionsConstants.TCLN_IN_BIN));
    }

    private SelectOrderByStep<Record3<Long, String, String>> getNodesDeletedContent(Set<Long> nodeIds) {
        return this.makeSelectClause(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(ConditionsConstants.TCLN_IN_BIN));
    }

    private void addTestCases() {
        this.workingTables.addEntity(Tables.TEST_CASE.TCLN_ID, () -> this.makeSelectJoin(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE.TCLN_ID, Tables.TEST_CASE.TCLN_ID));
    }

    private void addTestAutomationCandidates() {
        this.workingTables.addEntity(Tables.TEST_AUTOMATION_CANDIDATE.TEST_AUTOMATION_CANDIDATE_ID, () -> this.makeSelectJoin(Tables.TEST_CASE.TCLN_ID, Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID, Tables.TEST_AUTOMATION_CANDIDATE.TEST_AUTOMATION_CANDIDATE_ID));
    }

    private void addTestPlanItems() {
        this.workingTables.addEntity(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, () -> this.makeSelectJoin(Tables.TEST_CASE.TCLN_ID, Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).leftJoin((TableLike)Tables.EXECUTION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.isNull()));
    }

    private void addCampaigns() {
        this.workingTables.addEntity(Tables.CAMPAIGN.CLN_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID, (TableField<?, Long>)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID, (Table<?>)Tables.CAMPAIGN));
    }

    private void addAutomationRequests() {
        this.workingTables.addEntity(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.TEST_CASE.AUTOMATION_REQUEST_ID, (Table<?>)Tables.AUTOMATION_REQUEST).where(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.isNotNull()));
    }

    private void addTestSteps() {
        this.workingTables.addEntity(Tables.TEST_STEP.TEST_STEP_ID, () -> this.makeSelectJoin((TableField<?, Long>)Tables.TEST_CASE.TCLN_ID, (TableField<?, Long>)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (TableField<?, Long>)Tables.TEST_CASE_STEPS.STEP_ID, (Table<?>)Tables.TEST_STEP));
    }

    private void addDatasets() {
        this.workingTables.addEntity(Tables.DATASET.DATASET_ID, () -> this.makeSelectJoin(Tables.TEST_CASE.TCLN_ID, Tables.DATASET.TEST_CASE_ID, Tables.DATASET.DATASET_ID));
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, () -> this.makeSelectCustomFieldValues(Tables.TEST_CASE.TCLN_ID, BindableEntity.TEST_CASE).union(this.makeSelectCustomFieldValues(Tables.TEST_STEP.TEST_STEP_ID, BindableEntity.TEST_STEP)).union(this.makeSelectCustomFieldValues(Tables.TEST_CASE_FOLDER.TCLN_ID, BindableEntity.TESTCASE_FOLDER)));
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.makeSelectJoinAttachmentList(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID).union(this.makeSelectJoinAttachmentList(Tables.TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.ATTACHMENT_LIST_ID)).union(this.makeSelectJoinAttachmentList(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID)));
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init deletion process of test case nodes. Scope %s. Operation:  %s", this.scope.getIds(), this.operationId), new Object[0]);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Deleted test case nodes in scope %s. Time elapsed %s", this.scope.getIds(), this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

