/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.scripted;

import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.testcase.ConsumerForScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.internal.testcase.scripted.gherkin.GherkinStepGenerator;
import org.squashtest.tm.service.internal.testcase.scripted.gherkin.GherkinTestCaseParser;

@Component
public class ScriptedTestCaseExecutionHelper {
    public void createExecutionStepsForScriptedTestCase(ScriptedExecution scriptedExecution) {
        TestCase referencedTestCase = scriptedExecution.getReferencedTestCase();
        if (Objects.nonNull(referencedTestCase)) {
            Consumer<ScriptedTestCase> consumer = scriptedTestCase -> {
                GherkinTestCaseParser testCaseParser = new GherkinTestCaseParser(new GherkinStepGenerator());
                testCaseParser.populateExecution(scriptedExecution);
            };
            ConsumerForScriptedTestCaseVisitor testCaseVisitor = new ConsumerForScriptedTestCaseVisitor(consumer, (RuntimeException)new IllegalArgumentException("ScriptedTestCaseExecutionHelper is dedicated to ScriptedTestCase."));
            referencedTestCase.accept((TestCaseVisitor)testCaseVisitor);
        }
    }
}

