/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.campaign.export.CampaignExportCSVModel;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.campaign.export.AbstractCampaignExportCSVModel;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportCSVModelImpl$DataIterator$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportCSVModelImpl$DataIterator$AjcClosure3;
import org.squashtest.tm.service.internal.campaign.export.CellImpl;
import org.squashtest.tm.service.internal.campaign.export.RowImpl;
import org.squashtest.tm.service.internal.dto.CampaignDto;
import org.squashtest.tm.service.internal.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.ExecutionDto;
import org.squashtest.tm.service.internal.dto.ExecutionStepDto;
import org.squashtest.tm.service.internal.dto.ITPIDto;
import org.squashtest.tm.service.internal.dto.IterationDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.dto.TestCaseDto;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Component
@Scope(value="prototype")
public class CampaignExportCSVModelImpl
extends AbstractCampaignExportCSVModel {
    @Override
    void initIterationsAndCustomFields() {
        Iterator<Record> iterator = this.getIterationJooqQueryIterator();
        ArrayList<Long> allTestCaseIds = new ArrayList<Long>();
        ArrayList<Long> allExecutionIds = new ArrayList<Long>();
        this.populateCampaignDto(iterator, allTestCaseIds, allExecutionIds);
        Set<Long> allIterationIds = this.campaignDto.getIterationMap().keySet();
        this.populateCampCUFModelAndCampCUFValues();
        this.populateCUFModelAndCufValues("ITERATION", this.iterCUFModel, this.iterCUFValues, allIterationIds);
        this.populateCUFModelAndCufValues("TEST_CASE", this.tcCUFModel, this.tcCUFValues, allTestCaseIds);
        this.populateCUFModelAndCufValues("EXECUTION", this.execCUFModel, this.execCUFValues, allExecutionIds);
        this.nbColumns = 28 + this.campCUFModel.size() + this.iterCUFModel.size() + this.tcCUFModel.size() + this.execCUFModel.size();
    }

    @Override
    Iterator<Record> getIterationJooqQueryIterator() {
        return this.dsl.select(new SelectFieldOrAsterisk[]{AbstractCampaignExportCSVModel.ITERATION_ID, AbstractCampaignExportCSVModel.ITERATION_NAME.as("ITERATION_NAME"), AbstractCampaignExportCSVModel.ITERATION_SCHEDULED_END_DATE, AbstractCampaignExportCSVModel.ITERATION_SCHEDULED_START_DATE, AbstractCampaignExportCSVModel.ITERATION_ACTUAL_END_DATE, AbstractCampaignExportCSVModel.ITERATION_ACTUAL_START_DATE, AbstractCampaignExportCSVModel.ITPI_ID, AbstractCampaignExportCSVModel.ITPI_STATUS.as("ITPI_EXECUTION_STATUS"), AbstractCampaignExportCSVModel.USER_LOGIN, AbstractCampaignExportCSVModel.ITPI_LAST_EXECUTED_ON, AbstractCampaignExportCSVModel.EXECUTION_ID, AbstractCampaignExportCSVModel.DATASET_NAME, AbstractCampaignExportCSVModel.IT_MILESTONE.LABEL, AbstractCampaignExportCSVModel.TC_ID, AbstractCampaignExportCSVModel.TC_IMPORTANCE, AbstractCampaignExportCSVModel.TC_REFERENCE, AbstractCampaignExportCSVModel.TC_NATURE, AbstractCampaignExportCSVModel.TC_TYPE, AbstractCampaignExportCSVModel.TC_STATUS, AbstractCampaignExportCSVModel.TC_REQUIREMENT_VERIFIED, AbstractCampaignExportCSVModel.TC_NAME, AbstractCampaignExportCSVModel.TC_PREREQUISITE, AbstractCampaignExportCSVModel.TC_DESCRIPTION, AbstractCampaignExportCSVModel.PROJECT_ID, AbstractCampaignExportCSVModel.PROJECT_NAME, AbstractCampaignExportCSVModel.ITPI_ISSUE, AbstractCampaignExportCSVModel.TSu_NAME, AbstractCampaignExportCSVModel.TC_MILESTONE.LABEL, AbstractCampaignExportCSVModel.EXECUTION_ID, AbstractCampaignExportCSVModel.EXECUTION_MODE, AbstractCampaignExportCSVModel.EXECUTION_STATUS, AbstractCampaignExportCSVModel.EXECUTION_STEP_ID, AbstractCampaignExportCSVModel.EXECUTION_STEP_STATUS}).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(AbstractCampaignExportCSVModel.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(AbstractCampaignExportCSVModel.TC_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(AbstractCampaignExportCSVModel.TC_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(AbstractCampaignExportCSVModel.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE.as("tc_rvc")).on(Tables.REQUIREMENT_VERSION_COVERAGE.as((String)"tc_rvc").VERIFYING_TEST_CASE_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID).and(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID))).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(AbstractCampaignExportCSVModel.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE.as("exec_issue")).on(Tables.EXECUTION_ISSUES_CLOSURE.as((String)"exec_issue").EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq(AbstractCampaignExportCSVModel.ITPI_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq(AbstractCampaignExportCSVModel.TC_ID)).leftJoin((TableLike)AbstractCampaignExportCSVModel.TC_MILESTONE).on(AbstractCampaignExportCSVModel.TC_MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)AbstractCampaignExportCSVModel.IT_MILESTONE).on(AbstractCampaignExportCSVModel.IT_MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as("info_list_1")).on(Tables.INFO_LIST_ITEM.as((String)"info_list_1").ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as("info_list_2")).on(Tables.INFO_LIST_ITEM.as((String)"info_list_2").ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).where(Tables.CAMPAIGN.CLN_ID.eq((Object)this.campaign.getId())).orderBy(AbstractCampaignExportCSVModel.ITERATION_ID, AbstractCampaignExportCSVModel.ITPI_ID, AbstractCampaignExportCSVModel.EXECUTION_ID, AbstractCampaignExportCSVModel.EXECUTION_STEP_ID).fetch().iterator();
    }

    private void populateCampaignDto(Iterator<Record> iterator, List<Long> allTestCaseIds, List<Long> allExecutionIds) {
        IterationDto currentIteration = new IterationDto();
        ITPIDto currentItpi = new ITPIDto();
        TestCaseDto currentTestCase = new TestCaseDto();
        ExecutionDto currentExecution = new ExecutionDto();
        while (iterator.hasNext()) {
            Record r = iterator.next();
            currentIteration = this.populateIterationInCampaignDto(r, currentIteration);
            CampaignExportCSVModelImpl.populateIterationMilestoneForCampaignDto(r, currentIteration);
            if (currentIteration.getTestPlan((Long)r.get(AbstractCampaignExportCSVModel.ITPI_ID)) == null) {
                ITPIDto newItpi = this.createNewItpiDto(r);
                TestCaseDto newTestCase = this.createNewTestCaseDto(r);
                allTestCaseIds.add((Long)r.get(AbstractCampaignExportCSVModel.TC_ID));
                newItpi.setTestCase(newTestCase);
                currentIteration.addTestPlan(newItpi);
                currentItpi = currentIteration.getTestPlan((Long)r.get(AbstractCampaignExportCSVModel.ITPI_ID));
                currentTestCase = currentItpi.getTestCase();
                currentExecution = this.populateExecutionOrCreateNewOne(allExecutionIds, r, currentItpi, currentExecution);
                continue;
            }
            this.populateItpi(r, currentItpi);
            this.populateTestCase(r, currentTestCase);
            if (r.get(AbstractCampaignExportCSVModel.EXECUTION_ID) != null && !currentExecution.getId().equals(r.get(AbstractCampaignExportCSVModel.EXECUTION_ID))) {
                ExecutionDto newExecution = this.createNewExecutionDto(r);
                currentItpi.addExecution(newExecution);
                currentExecution = currentItpi.getExecution((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
                allExecutionIds.add((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
            }
            CampaignExportCSVModelImpl.addIssueForExecution(r, currentExecution);
            CampaignExportCSVModelImpl.addExecutionStepsToExecution(r, currentExecution);
        }
    }

    private ExecutionDto populateExecutionOrCreateNewOne(List<Long> allExecutionIds, Record r, ITPIDto currentItpi, ExecutionDto currentExecution) {
        if (r.get(AbstractCampaignExportCSVModel.EXECUTION_ID) != null) {
            ExecutionDto execution = currentItpi.getExecution((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
            if (execution == null) {
                execution = this.createNewExecutionDto(r);
            }
            CampaignExportCSVModelImpl.addIssueForExecution(r, currentExecution);
            currentItpi.addExecution(execution);
            currentExecution = currentItpi.getExecution((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
            allExecutionIds.add((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID));
        }
        return currentExecution;
    }

    private static void addExecutionStepsToExecution(Record r, ExecutionDto currentExecution) {
        if (r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID) != null && currentExecution.getStep((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID)) == null) {
            currentExecution.addStep(new ExecutionStepDto((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID), (String)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_STATUS)));
        }
    }

    @Override
    protected void populateItpi(Record r, ITPIDto itpi) {
        if (r.get(AbstractCampaignExportCSVModel.TSu_NAME) != null) {
            itpi.getTestSuiteSet().add((String)r.get(AbstractCampaignExportCSVModel.TSu_NAME));
        }
    }

    private TestCaseDto createNewTestCaseDto(Record r) {
        TestCaseDto newTestCase = new TestCaseDto((Long)r.get(AbstractCampaignExportCSVModel.TC_ID), (String)r.get(AbstractCampaignExportCSVModel.TC_REFERENCE), (String)r.get(AbstractCampaignExportCSVModel.TC_NAME), (String)r.get(AbstractCampaignExportCSVModel.TC_IMPORTANCE), (String)r.get(AbstractCampaignExportCSVModel.TC_NATURE), (String)r.get(AbstractCampaignExportCSVModel.TC_TYPE), (String)r.get(AbstractCampaignExportCSVModel.TC_STATUS), (Long)r.get(AbstractCampaignExportCSVModel.PROJECT_ID), (String)r.get(AbstractCampaignExportCSVModel.PROJECT_NAME));
        if (r.get(AbstractCampaignExportCSVModel.TC_DESCRIPTION) != null) {
            newTestCase.setDescription((String)r.get(AbstractCampaignExportCSVModel.TC_DESCRIPTION));
        }
        if (r.get(AbstractCampaignExportCSVModel.TC_PREREQUISITE) != null) {
            newTestCase.setPrerequisite((String)r.get(AbstractCampaignExportCSVModel.TC_PREREQUISITE));
        }
        this.populateTestCase(r, newTestCase);
        return newTestCase;
    }

    private ExecutionDto createNewExecutionDto(Record r) {
        boolean automated = "AUTOMATED".equals(r.get(AbstractCampaignExportCSVModel.EXECUTION_MODE));
        ExecutionDto newExecution = new ExecutionDto((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_ID), (String)r.get(AbstractCampaignExportCSVModel.EXECUTION_STATUS), automated);
        if (r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID) != null) {
            newExecution.addStep(new ExecutionStepDto((Long)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_ID), (String)r.get(AbstractCampaignExportCSVModel.EXECUTION_STEP_STATUS)));
        }
        return newExecution;
    }

    public CampaignExportCSVModel.Row getHeader() {
        ArrayList<CellImpl> headerCells = new ArrayList<CellImpl>(this.nbColumns);
        headerCells.add(new CellImpl("CPG_SCHEDULED_START_ON"));
        headerCells.add(new CellImpl("CPG_SCHEDULED_END_ON"));
        headerCells.add(new CellImpl("CPG_ACTUAL_START_ON"));
        headerCells.add(new CellImpl("CPG_ACTUAL_END_ON"));
        this.campCUFModel.sort(Comparator.comparing(CustomFieldDto::getId));
        for (CustomFieldDto cufModel : this.campCUFModel) {
            headerCells.add(new CellImpl("CPG_CUF_" + cufModel.getCode()));
        }
        headerCells.add(new CellImpl("ITERATION"));
        if (this.milestonesEnabled) {
            headerCells.add(new CellImpl("IT_MILESTONE"));
        }
        headerCells.add(new CellImpl("IT_SCHEDULED_START_ON"));
        headerCells.add(new CellImpl("IT_SCHEDULED_END_ON"));
        headerCells.add(new CellImpl("IT_ACTUAL_START_ON"));
        headerCells.add(new CellImpl("IT_ACTUAL_END_ON"));
        for (CustomFieldDto cufModel : this.iterCUFModel) {
            headerCells.add(new CellImpl("IT_CUF_" + cufModel.getCode()));
        }
        headerCells.add(new CellImpl("TEST_CASE"));
        headerCells.add(new CellImpl("TC_PROJECT"));
        if (this.milestonesEnabled) {
            headerCells.add(new CellImpl("TC_MILESTONE"));
        }
        headerCells.add(new CellImpl("TC_WEIGHT"));
        headerCells.add(new CellImpl("TEST_SUITE"));
        headerCells.add(new CellImpl("#_EXECUTIONS"));
        headerCells.add(new CellImpl("#_REQUIREMENTS"));
        headerCells.add(new CellImpl("#_ISSUES"));
        headerCells.add(new CellImpl("DATASET"));
        headerCells.add(new CellImpl("EXEC_STATUS"));
        headerCells.add(new CellImpl("EXEC_SUCCESS_RATE"));
        headerCells.add(new CellImpl("EXEC_LOGIN"));
        headerCells.add(new CellImpl("EXECUTION_DATE"));
        headerCells.add(new CellImpl("DESCRIPTION"));
        headerCells.add(new CellImpl("TC_REF"));
        headerCells.add(new CellImpl("TC_NATURE"));
        headerCells.add(new CellImpl("TC_TYPE"));
        headerCells.add(new CellImpl("TC_STATUS"));
        headerCells.add(new CellImpl("PREREQUISITE"));
        for (CustomFieldDto cufModel : this.tcCUFModel) {
            headerCells.add(new CellImpl("TC_CUF_" + cufModel.getCode()));
        }
        for (CustomFieldDto cufModel : this.execCUFModel) {
            headerCells.add(new CellImpl("HEADER_EXEC_CUF_" + cufModel.getCode()));
        }
        return new RowImpl(headerCells, this.separator);
    }

    public void setCampaignDto(CampaignDto campaignDto) {
        this.campaignDto = campaignDto;
    }

    public Iterator<CampaignExportCSVModel.Row> dataIterator() {
        return new DataIterator();
    }

    private class DataIterator
    implements Iterator<CampaignExportCSVModel.Row> {
        private int iterIndex = -1;
        private int itpIndex = -1;
        private IterationDto iteration = new IterationDto();
        private ITPIDto itp;
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss");
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public DataIterator() {
            this.moveNext();
        }

        @Override
        public boolean hasNext() {
            return this.itp != null;
        }

        @Override
        public CampaignExportCSVModel.Row next() {
            ArrayList<CellImpl> dataCells = new ArrayList<CellImpl>(CampaignExportCSVModelImpl.this.nbColumns);
            this.populateCampaignRowData(dataCells);
            this.populateIterationRowData(dataCells);
            this.populateTestCaseRowData(dataCells);
            this.populateExecutionCUFRowData(dataCells);
            this.moveNext();
            return new RowImpl(dataCells, CampaignExportCSVModelImpl.this.separator);
        }

        private void populateExecutionCUFRowData(List<CellImpl> dataCells) {
            ExecutionDto exe = this.itp.getLatestExecution();
            if (exe != null) {
                Collection execValues = (Collection)CampaignExportCSVModelImpl.this.execCUFValues.get((Object)exe.getId());
                for (CustomFieldDto model : CampaignExportCSVModelImpl.this.execCUFModel) {
                    String strValue = this.getValue(execValues, model);
                    dataCells.add(new CellImpl(strValue));
                }
            }
        }

        private void populateTestCaseRowData(List<CellImpl> dataCells) {
            TestCaseDto testCase = this.itp.getTestCase();
            ExecutionDto execution = this.itp.getLatestExecution();
            int issueNumber = execution != null ? execution.getIssueSet().size() : 0;
            dataCells.add(new CellImpl(testCase.getName()));
            dataCells.add(new CellImpl(testCase.getProjectName()));
            if (CampaignExportCSVModelImpl.this.milestonesEnabled) {
                dataCells.add(new CellImpl(this.formatMilestone(testCase.getMilestoneSet())));
            }
            dataCells.add(new CellImpl(testCase.getImportance()));
            dataCells.add(new CellImpl(this.itp.getTestSuiteNames()));
            dataCells.add(new CellImpl(Integer.toString(this.itp.getExecutionMap().size())));
            dataCells.add(new CellImpl(Integer.toString(testCase.getRequirementSet().size())));
            dataCells.add(new CellImpl(Integer.toString(issueNumber)));
            dataCells.add(new CellImpl(this.itp.getDataset()));
            dataCells.add(new CellImpl(this.itp.getStatus()));
            dataCells.add(new CellImpl(this.formatLongText(this.calculateSuccessRate() + " %")));
            dataCells.add(new CellImpl(this.itp.getUserName()));
            dataCells.add(new CellImpl(this.formatDate(this.itp.getLastExecutedOn())));
            TestCaseDto testCaseDto = testCase;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCaseDto);
            Object[] objectArray = new Object[]{this, testCaseDto, joinPoint};
            CampaignExportCSVModelImpl$DataIterator$AjcClosure1 campaignExportCSVModelImpl$DataIterator$AjcClosure1 = new CampaignExportCSVModelImpl$DataIterator$AjcClosure1(objectArray);
            dataCells.add(new CellImpl(this.formatLongText((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(campaignExportCSVModelImpl$DataIterator$AjcClosure1.linkClosureAndJoinPoint(4112)))));
            dataCells.add(new CellImpl(testCase.getReference()));
            dataCells.add(new CellImpl(testCase.getNature()));
            dataCells.add(new CellImpl(testCase.getType()));
            dataCells.add(new CellImpl(testCase.getStatus()));
            TestCaseDto testCaseDto2 = testCase;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)testCaseDto2);
            Object[] objectArray2 = new Object[]{this, testCaseDto2, joinPoint2};
            CampaignExportCSVModelImpl$DataIterator$AjcClosure3 campaignExportCSVModelImpl$DataIterator$AjcClosure3 = new CampaignExportCSVModelImpl$DataIterator$AjcClosure3(objectArray2);
            dataCells.add(new CellImpl(this.formatLongText((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(campaignExportCSVModelImpl$DataIterator$AjcClosure3.linkClosureAndJoinPoint(4112)))));
            Collection tcValues = (Collection)CampaignExportCSVModelImpl.this.tcCUFValues.get((Object)testCase.getId());
            for (CustomFieldDto model : CampaignExportCSVModelImpl.this.tcCUFModel) {
                String strValue = this.getValue(tcValues, model);
                dataCells.add(new CellImpl(strValue));
            }
        }

        private void populateIterationRowData(List<CellImpl> dataCells) {
            dataCells.add(new CellImpl("#" + (this.iterIndex + 1) + " " + this.iteration.getName()));
            if (CampaignExportCSVModelImpl.this.milestonesEnabled) {
                dataCells.add(new CellImpl(this.formatMilestone(this.iteration.getMilestoneSet())));
            }
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getScheduledStartDate())));
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getScheduledEndDate())));
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getActualStartDate())));
            dataCells.add(new CellImpl(this.formatDate(this.iteration.getActualEndDate())));
            Collection iValues = (Collection)CampaignExportCSVModelImpl.this.iterCUFValues.get((Object)this.iteration.getId());
            for (CustomFieldDto model : CampaignExportCSVModelImpl.this.iterCUFModel) {
                String strValue = this.getValue(iValues, model);
                dataCells.add(new CellImpl(strValue));
            }
        }

        private String formatMilestone(Set<String> milestones) {
            StringBuilder sb = new StringBuilder();
            for (String m : milestones) {
                sb.append(m);
                sb.append("|");
            }
            sb.setLength(Math.max(sb.length() - 1, 0));
            return sb.toString();
        }

        private void populateCampaignRowData(List<CellImpl> dataCells) {
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVModelImpl.this.campaign.getScheduledStartDate())));
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVModelImpl.this.campaign.getScheduledEndDate())));
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVModelImpl.this.campaign.getActualStartDate())));
            dataCells.add(new CellImpl(this.formatDate(CampaignExportCSVModelImpl.this.campaign.getActualEndDate())));
            for (CustomFieldDto model : CampaignExportCSVModelImpl.this.campCUFModel) {
                String strValue = this.getCampaignCufValue((CustomFieldValueDto)CampaignExportCSVModelImpl.this.campCUFValues.get(model.getId()), model);
                dataCells.add(new CellImpl(strValue));
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String getCampaignCufValue(CustomFieldValueDto customFieldValueDto, CustomFieldDto model) {
            if (customFieldValueDto != null && customFieldValueDto.getValue() != null) {
                if ("NUMERIC".equals(model.getInputType())) {
                    return NumericCufHelper.formatOutputNumericCufValue(customFieldValueDto.getValue());
                }
                return customFieldValueDto.getValue();
            }
            return "";
        }

        private String getValue(Collection<CustomFieldValueDto> values, CustomFieldDto model) {
            if (values != null) {
                return this.formatOutputValue(values, model);
            }
            return "--";
        }

        private String formatOutputValue(Collection<CustomFieldValueDto> values, CustomFieldDto model) {
            for (CustomFieldValueDto value : values) {
                Long customFieldId = value.getCufId();
                if (customFieldId != model.getId()) continue;
                if ("NUMERIC".equals(model.getInputType())) {
                    return NumericCufHelper.formatOutputNumericCufValue(value.getValue());
                }
                return value.getValue();
            }
            return "";
        }

        private String formatDate(Date date) {
            return date == null ? "--" : this.dateFormat.format(date);
        }

        private String formatLongText(String text) {
            return text == null ? "--" : text;
        }

        private void moveNext() {
            boolean moveITPSuccess = this.moveToNextTestCase();
            if (!moveITPSuccess) {
                boolean moveIterSuccess = this.moveToNextIteration();
                if (moveIterSuccess) {
                    this.moveNext();
                } else {
                    this.itp = null;
                }
            }
        }

        private boolean moveToNextIteration() {
            ++this.iterIndex;
            if (CampaignExportCSVModelImpl.this.campaignDto.getIterationList().size() > this.iterIndex) {
                this.iteration = CampaignExportCSVModelImpl.this.campaignDto.getIterationList().get(this.iterIndex);
                this.itpIndex = -1;
                return true;
            }
            return false;
        }

        private boolean moveToNextTestCase() {
            ITPIDto nextITP = null;
            List<ITPIDto> items = this.iteration.getTestPlanList();
            int nbItems = items.size();
            do {
                ++this.itpIndex;
                if (nbItems <= this.itpIndex) break;
                ITPIDto item = items.get(this.itpIndex);
                if (item.isTestCaseDeleted()) continue;
                nextITP = item;
            } while (nextITP == null && nbItems > this.itpIndex);
            this.itp = nextITP;
            return this.itp != null;
        }

        private int calculateSuccessRate() {
            int successRate = 0;
            ExecutionDto lastExec = this.itp.getLatestExecution();
            if (lastExec != null) {
                if (lastExec.isAutomated()) {
                    successRate = "SUCCESS".equals(lastExec.getStatus()) ? 100 : 0;
                } else if (!lastExec.getSteps().isEmpty()) {
                    Predicate<ExecutionStepDto> predicate = step -> "SUCCESS".equals(step.getStatus());
                    Collection<ExecutionStepDto> steps = this.itp.getLatestExecution().getSteps().values();
                    int success = (int)steps.stream().filter(predicate).count();
                    successRate = success * 100 / steps.size();
                }
            }
            return successRate;
        }

        static {
            DataIterator.ajc$preClinit();
        }

        static final /* synthetic */ String getDescription_aroundBody0(DataIterator dataIterator, TestCaseDto testCaseDto, JoinPoint joinPoint) {
            return testCaseDto.getDescription();
        }

        static final /* synthetic */ String getPrerequisite_aroundBody2(DataIterator dataIterator, TestCaseDto testCaseDto, JoinPoint joinPoint) {
            return testCaseDto.getPrerequisite();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("CampaignExportCSVModelImpl.java", DataIterator.class);
            ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.TestCaseDto", "", "", "", "java.lang.String"), 504);
            ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getPrerequisite", "org.squashtest.tm.service.internal.dto.TestCaseDto", "", "", "", "java.lang.String"), 509);
        }
    }
}

