/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.campaign.IterationStatisticsService;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.internal.repository.IterationStatisticsDao;
import org.squashtest.tm.service.statistics.CountOnEnum;
import org.squashtest.tm.service.statistics.campaign.CampaignTestCaseSuccessRateStatistics;
import org.squashtest.tm.service.statistics.campaign.ProgressionStatistics;
import org.squashtest.tm.service.statistics.campaign.ScheduledIteration;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.service.statistics.iteration.TestSuiteTestInventoryStatistics;

@Transactional(readOnly=true)
@Service
public class IterationStatisticsServiceImpl
implements IterationStatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IterationStatisticsServiceImpl.class);
    private final CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao;
    private final IterationStatisticsDao iterationStatisticsDao;

    public IterationStatisticsServiceImpl(CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao, IterationStatisticsDao iterationStatisticsDao) {
        this.itpiLastExecutionFilterDao = itpiLastExecutionFilterDao;
        this.iterationStatisticsDao = iterationStatisticsDao;
    }

    private Map<ExecutionStatus, Integer> gatherIterationTestCaseStatusStatistics(List<Long> iterationIds) {
        List<Object[]> res = this.iterationStatisticsDao.getIterationTestCaseStatusStatistics(iterationIds);
        return CountOnEnum.fromTuples(res, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private Map<ExecutionStatus, Integer> gatherIterationTestCaseStatusStatisticsForTCLastExecScope(List<Long> testPlanItemIds) {
        List<Object[]> res = this.iterationStatisticsDao.getTestPlanItemsTestCaseStatusStatistics(testPlanItemIds);
        return CountOnEnum.fromTuples(res, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private Map<TestCaseImportance, Integer> gatherIterationNonExecutedTestCaseImportanceStatistics(List<Long> iterationIds) {
        List<Object[]> res = this.iterationStatisticsDao.getNonExecutedTestCaseImportanceStatistics(iterationIds);
        return CountOnEnum.fromTuples(res, TestCaseImportance.class).getStatistics();
    }

    private Map<TestCaseImportance, Integer> gatherIterationNonExecutedTestCaseImportanceStatisticsForTCLastExecScope(List<Long> testPlanItemIds) {
        List<Object[]> res = this.iterationStatisticsDao.getTestPlanItemsNonExecutedTestCaseImportanceStatistics(testPlanItemIds);
        return CountOnEnum.fromTuples(res, TestCaseImportance.class).getStatistics();
    }

    private CampaignTestCaseSuccessRateStatistics gatherIterationTestCaseSuccessRateStatistics(List<Long> iterationIds) {
        List<Object[]> res = this.iterationStatisticsDao.getIterationTestCaseStatistics(iterationIds);
        return CampaignTestCaseSuccessRateStatistics.fromTuples(res);
    }

    private CampaignTestCaseSuccessRateStatistics gatherIterationTestCaseSuccessRateStatisticsForTCLastExecScope(List<Long> testPlanItemIds) {
        List<Object[]> res = this.iterationStatisticsDao.getTestPlanItemsTestCaseStatistics(testPlanItemIds);
        return CampaignTestCaseSuccessRateStatistics.fromTuples(res);
    }

    private List<TestSuiteTestInventoryStatistics> gatherSingleTestSuiteTestInventoryStatistics(long iterationId) {
        List<Object[]> withTestSuiteStats = this.iterationStatisticsDao.getIterationTestSuitesStatistics(iterationId);
        List<Object[]> withoutTestSuiteStats = this.iterationStatisticsDao.getIterationsStatistics(List.of(Long.valueOf(iterationId)));
        List<Object[]> res = this.mergeQueryResultLists(withTestSuiteStats, withoutTestSuiteStats);
        LinkedList<TestSuiteTestInventoryStatistics> result = new LinkedList<TestSuiteTestInventoryStatistics>();
        this.processTestSuiteTestInventoryStatistics(res, result);
        return result;
    }

    private List<TestSuiteTestInventoryStatistics> gatherManyTestSuiteTestInventoryStatistics(List<Long> iterationIds) {
        LinkedList<TestSuiteTestInventoryStatistics> result = new LinkedList<TestSuiteTestInventoryStatistics>();
        List<Object[]> withTestSuiteStats = this.iterationStatisticsDao.getMultipleIterationTestSuitesStatistics(iterationIds);
        List<Object[]> withoutTestSuiteStats = this.iterationStatisticsDao.getIterationsStatistics(iterationIds);
        List<Object[]> res = this.mergeQueryResultLists(withTestSuiteStats, withoutTestSuiteStats);
        this.processTestSuiteTestInventoryStatistics(res, result);
        return result;
    }

    private List<Object[]> mergeQueryResultLists(List<Object[]> queryResult, List<Object[]> leftoverQueryResult) {
        for (Object[] retuple : leftoverQueryResult) {
            retuple[0] = null;
            queryResult.add(retuple);
        }
        return queryResult;
    }

    private void processTestSuiteTestInventoryStatistics(List<Object[]> res, List<TestSuiteTestInventoryStatistics> result) {
        TestSuiteTestInventoryStatistics newStatistics = new TestSuiteTestInventoryStatistics();
        String previousSuiteName = "";
        for (Object[] tuple : res) {
            String suiteName = (String)tuple[0];
            Date scheduledStart = (Date)tuple[4];
            Date scheduledEnd = (Date)tuple[5];
            if (!this.sameSuite(previousSuiteName, suiteName)) {
                newStatistics = new TestSuiteTestInventoryStatistics();
                newStatistics.setTestsuiteName(suiteName);
                newStatistics.setScheduledStart(scheduledStart);
                newStatistics.setScheduledEnd(scheduledEnd);
                result.add(newStatistics);
            }
            previousSuiteName = suiteName;
            ExecutionStatus status = (ExecutionStatus)tuple[1];
            TestCaseImportance importance = (TestCaseImportance)tuple[2];
            Long howmany = (Long)tuple[3];
            if (status == null || importance == null) continue;
            newStatistics.addExecutionCount(howmany.intValue(), status.getCanonicalStatus(), importance);
        }
        this.sortTestSuiteTestInventoryStatisticsByTestSuiteName(result);
    }

    private boolean sameSuite(String name1, String name2) {
        return name1 == null && name2 == null || name1 != null && name1.equals(name2);
    }

    private void sortTestSuiteTestInventoryStatisticsByTestSuiteName(List<TestSuiteTestInventoryStatistics> result) {
        result.sort((t1, t2) -> {
            String t1SuiteName = t1.getTestsuiteName();
            String t2SuiteName = t2.getTestsuiteName();
            if (t1SuiteName != null && t2SuiteName != null) {
                return t1SuiteName.compareToIgnoreCase(t2SuiteName);
            }
            if (t1SuiteName == null) {
                return 1;
            }
            return -1;
        });
    }

    @Override
    public StatisticsBundle gatherIterationStatisticsBundle(List<Long> iterationIds, boolean lastExecScope) {
        StatisticsBundle bundle = this.initializeStatisticsBundle(iterationIds, lastExecScope);
        boolean isSolitaryIteration = iterationIds.size() == 1;
        List<TestSuiteTestInventoryStatistics> testSuiteTestInventoryStatistics = isSolitaryIteration ? this.gatherSingleTestSuiteTestInventoryStatistics(iterationIds.get(0)) : this.gatherManyTestSuiteTestInventoryStatistics(iterationIds);
        ProgressionStatistics iterationProgressionStatistics = isSolitaryIteration ? this.gatherIterationProgressionStatistics(iterationIds.get(0)) : new ProgressionStatistics();
        bundle.setTestsuiteTestInventoryStatisticsList(testSuiteTestInventoryStatistics);
        bundle.setProgressionStatistics(iterationProgressionStatistics);
        bundle.setSelectedIds(iterationIds);
        return bundle;
    }

    private StatisticsBundle initializeStatisticsBundle(List<Long> iterationIds, boolean lastExecScope) {
        CampaignTestCaseSuccessRateStatistics testCaseSuccessRate;
        Map<TestCaseImportance, Integer> testcaseImportance;
        Map<ExecutionStatus, Integer> testcaseStatuses;
        StatisticsBundle bundle = new StatisticsBundle();
        if (lastExecScope) {
            List<Long> testPlanItemIdsInScope = this.itpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInScopeForIteration(iterationIds);
            testcaseStatuses = this.gatherIterationTestCaseStatusStatisticsForTCLastExecScope(testPlanItemIdsInScope);
            testcaseImportance = this.gatherIterationNonExecutedTestCaseImportanceStatisticsForTCLastExecScope(testPlanItemIdsInScope);
            testCaseSuccessRate = this.gatherIterationTestCaseSuccessRateStatisticsForTCLastExecScope(testPlanItemIdsInScope);
        } else {
            testcaseStatuses = this.gatherIterationTestCaseStatusStatistics(iterationIds);
            testcaseImportance = this.gatherIterationNonExecutedTestCaseImportanceStatistics(iterationIds);
            testCaseSuccessRate = this.gatherIterationTestCaseSuccessRateStatistics(iterationIds);
        }
        bundle.setTestCaseStatusStatistics(testcaseStatuses);
        bundle.setNonExecutedTestCaseImportanceStatistics(testcaseImportance);
        bundle.setTestCaseSuccessRateStatistics(testCaseSuccessRate);
        return bundle;
    }

    private ProgressionStatistics gatherIterationProgressionStatistics(long iterationId) {
        ScheduledIteration scheduledIteration = this.iterationStatisticsDao.getScheduledIteration(iterationId);
        List<Date> executionHistory = this.iterationStatisticsDao.getIterationExecutionHistory(iterationId);
        ProgressionStatistics progression = new ProgressionStatistics();
        try {
            progression.setScheduledIterations(Collections.singletonList(scheduledIteration));
            ScheduledIteration.checkIterationDatesAreSet(scheduledIteration);
            progression.computeSchedule();
            progression.computeCumulativeTestPerDate(executionHistory);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("CampaignStatistics : could not generate iteration progression statistics for iteration{} : some dates are wrong", new Object[]{iterationId});
            progression.addi18nErrorMessage(ex.getMessage());
        }
        return progression;
    }
}

