/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.campaign.AutomatedSuiteDeletionImpl$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.AutomatedSuiteDeletionService;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcExecutionDeletionHandlerFactory;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;

@Service
public class AutomatedSuiteDeletionImpl
implements AutomatedSuiteDeletionService {
    public static final int BIND_VARIABLES_LIMIT = 25000;
    private final ExecutionDao executionDao;
    private final AutomatedSuiteDao autoSuiteDao;
    private final AutomatedTestDao autoTestDao;
    private final AttachmentManagerService attachmentManager;
    private final TestSuiteDao suiteDao;
    private final JdbcExecutionDeletionHandlerFactory jdbcExecutionDeletionHandler;
    private final EntityManager entityManager;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final DSLContext dslContext;
    private final DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService;
    private final DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService;
    private final CampaignDeletionDao deletionDao;
    private final FailureDetailDao failureDetailDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AutomatedSuiteDeletionImpl(ExecutionDao executionDao, AutomatedSuiteDao autoSuiteDao, AutomatedTestDao autoTestDao, AttachmentManagerService attachmentManager, TestSuiteDao suiteDao, JdbcExecutionDeletionHandlerFactory jdbcExecutionDeletionHandler, EntityManager entityManager, CustomTestSuiteModificationService customTestSuiteModificationService, DSLContext dslContext, DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService, DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService, CampaignDeletionDao deletionDao, FailureDetailDao failureDetailDao) {
        this.executionDao = executionDao;
        this.autoSuiteDao = autoSuiteDao;
        this.autoTestDao = autoTestDao;
        this.attachmentManager = attachmentManager;
        this.suiteDao = suiteDao;
        this.jdbcExecutionDeletionHandler = jdbcExecutionDeletionHandler;
        this.entityManager = entityManager;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.dslContext = dslContext;
        this.denormalizedEnvironmentVariableManagerService = denormalizedEnvironmentVariableManagerService;
        this.denormalizedEnvironmentTagManagerService = denormalizedEnvironmentTagManagerService;
        this.deletionDao = deletionDao;
        this.failureDetailDao = failureDetailDao;
    }

    @Override
    public void processAutomatedSuitesDeletion(List<Long> automatedSuiteIds) {
        List<Long> list = automatedSuiteIds;
        ExecutionDao executionDao = this.executionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)executionDao, list);
        Object[] objectArray = new Object[]{this, executionDao, list, joinPoint};
        AutomatedSuiteDeletionImpl$AjcClosure1 automatedSuiteDeletionImpl$AjcClosure1 = new AutomatedSuiteDeletionImpl$AjcClosure1(objectArray);
        List executionIds = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automatedSuiteDeletionImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        if (!executionIds.isEmpty()) {
            this.bulkDeleteExecutions(executionIds);
        }
        List<Long> attachmentListIds = this.autoSuiteDao.findAttachmentListIdsByIds(automatedSuiteIds);
        List<ExternalContentCoordinates> externalContentCoordinates = this.attachmentManager.getListPairContentIDListIDForAutomatedSuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteAutomatedSuiteWorkflowsBySuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteApiTokensMatchingSuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteAllByIds(automatedSuiteIds);
        this.autoTestDao.pruneOrphans();
        this.attachmentManager.removeAttachmentsAndLists(attachmentListIds);
        this.attachmentManager.deleteContents(externalContentCoordinates);
    }

    @Override
    public void deleteAutomatedExecutionExtenderAndDenormalizedEnvironments(Execution execution, Long projectId) {
        if (execution.getAutomatedExecutionExtender() == null) {
            return;
        }
        AutomatedExecutionExtender extender = execution.getAutomatedExecutionExtender();
        this.removeExtenderAssociationFromFailureDetails(extender);
        this.deleteDenormalizedEnvironments(execution, projectId);
        this.autoTestDao.removeIfUnused(extender.getAutomatedTest());
        this.deletionDao.removeEntity(extender);
        execution.setAutomatedExecutionExtender(null);
    }

    private void bulkDeleteExecutions(List<Long> executionIds) {
        List executionIdPartitions = Lists.partition(executionIds, (int)25000);
        HashSet testSuiteIds = new HashSet();
        executionIdPartitions.forEach(executionIdPartition -> {
            testSuiteIds.addAll(this.suiteDao.findAllIdsByExecutionIds((List)executionIdPartition));
            List itpiIds = this.executionDao.findItpiIdsByExecutionIds(executionIds);
            this.jdbcExecutionDeletionHandler.build(executionIds).deleteExecutions();
            this.batchUpdateItpiExecutionStatusAfterExecutionsDeletion(itpiIds);
            this.entityManager.flush();
        });
        List testSuites = this.suiteDao.findAllByIds(testSuiteIds);
        this.customTestSuiteModificationService.updateExecutionStatus(testSuites);
        this.entityManager.clear();
    }

    private void batchUpdateItpiExecutionStatusAfterExecutionsDeletion(List<Long> iterationTestPlanItemIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("TEST_PLAN_ITEM_ID", "EXECUTION_STATUS", "POSITION").as((ResultQuery)DSL.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID, (SelectField)Tables.EXECUTION.EXECUTION_STATUS, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.EXECUTION.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()})).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.in(iterationTestPlanItemIds)));
        Map itemTestPlanIdsByExecutionStatus = this.dslContext.with(new CommonTableExpression[]{cte}).select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.when((Condition)cte.field("EXECUTION_STATUS").isNull(), (Object)ExecutionStatus.READY.name()).otherwise(cte.field("EXECUTION_STATUS", String.class)).as("EXECUTION_STATUS")).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)cte).on(cte.field("TEST_PLAN_ITEM_ID", Long.class).eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(iterationTestPlanItemIds).and(cte.field("POSITION", Integer.class).eq((Object)1).or(cte.field("TEST_PLAN_ITEM_ID", Integer.class).isNull().and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.notEqual((Object)ExecutionStatus.READY.name()))))).fetchGroups(DSL.field((String)"EXECUTION_STATUS", String.class), (Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
        org.squashtest.tm.jooq.domain.tables.Execution execution2 = Tables.EXECUTION.as("e2");
        Condition compareByOrderAndId = execution2.EXECUTION_ORDER.lessThan((Field)Tables.EXECUTION.EXECUTION_ORDER).or(execution2.EXECUTION_ORDER.eq((Field)Tables.EXECUTION.EXECUTION_ORDER).and(execution2.EXECUTION_ID.lessOrEqual((Field)Tables.EXECUTION.EXECUTION_ID)));
        this.dslContext.update((Table)Tables.EXECUTION).set((Field)Tables.EXECUTION.EXECUTION_ORDER, (Select)DSL.select((SelectField)DSL.count().minus((Number)1)).from((TableLike)execution2).where(execution2.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID).and(compareByOrderAndId))).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.in(iterationTestPlanItemIds)).execute();
        for (Map.Entry entry : itemTestPlanIdsByExecutionStatus.entrySet()) {
            this.dslContext.update((Table)Tables.TEST_PLAN_ITEM).set((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (Object)((String)entry.getKey())).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in((Collection)entry.getValue())).execute();
        }
    }

    private void removeExtenderAssociationFromFailureDetails(AutomatedExecutionExtender extender) {
        List failureDetails = extender.getFailureDetailList();
        for (FailureDetail failureDetail : failureDetails) {
            failureDetail.getAutomatedExecutions().remove(extender);
            failureDetail.updateLastModificationWithCurrentUser();
            this.failureDetailDao.save(failureDetail);
        }
    }

    private void deleteDenormalizedEnvironments(Execution execution, Long projectId) {
        if (this.isProjectUsingSquashOrchestrator(projectId)) {
            this.denormalizedEnvironmentVariableManagerService.removeDenormalizedEnvironmentVariablesOnExecutionDelete(execution.getAutomatedExecutionExtender());
            this.denormalizedEnvironmentTagManagerService.removeDenormalizedTagsOnExecutionDelete(execution.getAutomatedExecutionExtender());
            this.entityManager.flush();
        }
    }

    private boolean isProjectUsingSquashOrchestrator(Long projectId) {
        TestAutomationServerKind serverKind = this.executionDao.getTestAutomationServerKindByProjectId(projectId);
        return Objects.nonNull(serverKind) && TestAutomationServerKind.squashOrchestrator.equals((Object)serverKind);
    }

    static {
        AutomatedSuiteDeletionImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllIdsByAutomatedSuiteIds_aroundBody0(AutomatedSuiteDeletionImpl automatedSuiteDeletionImpl, ExecutionDao executionDao, List list, JoinPoint joinPoint) {
        return executionDao.findAllIdsByAutomatedSuiteIds(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AutomatedSuiteDeletionImpl.java", AutomatedSuiteDeletionImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllIdsByAutomatedSuiteIds", "org.squashtest.tm.service.internal.repository.ExecutionDao", "java.util.List", "arg0", "", "java.util.List"), 114);
    }
}

