/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.server.custom;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.jdk.JdkHttpClientBuilder;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.tools.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerJsonResponseParsingException;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.CustomChatModelBuilder;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.MessageRound;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.RequestPayloadGenerator;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.Role;
import org.squashtest.tm.service.internal.jsonpathextractor.JsonPathExtractorImpl;

public class CustomChatModel
implements ChatModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomChatModel.class);
    private static final Duration readTimeout = Duration.ofSeconds(60L);
    private static final Duration connectTimeout = Duration.ofSeconds(30L);
    private final String apiKey;
    private final String url;
    private final Map<String, String> httpHeaders;
    private final String payloadTemplate;
    private final String answerPath;
    private final boolean logRequests;
    private final boolean logResponses;
    private final HttpClient httpClient;

    public CustomChatModel(CustomChatModelBuilder builder) {
        this.apiKey = builder.getApiKey();
        this.url = builder.getBaseUrl();
        this.payloadTemplate = builder.getPayloadTemplate();
        this.httpHeaders = builder.getHttpHeaders();
        this.answerPath = builder.getAnswerPath();
        this.logRequests = builder.isLogRequests();
        this.logResponses = builder.isLogResponses();
        this.httpClient = this.buildHttpClient();
    }

    private HttpClient buildHttpClient() {
        JdkHttpClientBuilder httpClientBuilder = new JdkHttpClientBuilder();
        HttpClient client = httpClientBuilder.connectTimeout(connectTimeout).readTimeout(readTimeout).build();
        if (this.logRequests || this.logResponses) {
            return new LoggingHttpClient(client, Boolean.valueOf(this.logRequests), Boolean.valueOf(this.logResponses));
        }
        return client;
    }

    public static CustomChatModelBuilder builder() {
        return new CustomChatModelBuilder();
    }

    public ChatResponse doChat(ChatRequest chatRequest) throws HttpException {
        String requestBody = this.buildRequestBody(chatRequest);
        HttpRequest request = this.buildRequest(chatRequest, requestBody);
        try {
            SuccessfulHttpResponse response = this.httpClient.execute(request);
            return this.parseApiResponse(response.body());
        }
        catch (IOException e) {
            String message = String.format("Failed to parse API response: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new AiServerJsonResponseParsingException(message);
        }
    }

    private String buildRequestBody(ChatRequest chatRequest) {
        return RequestPayloadGenerator.generate(this.payloadTemplate, this.convertMessages(chatRequest.messages()), this.apiKey);
    }

    private HttpRequest buildRequest(ChatRequest chatRequest, String requestBody) {
        HttpRequest.Builder httpRequestBuilder = HttpRequest.builder().method(HttpMethod.POST).url(this.url).addHeader("Content-Type", new String[]{"application/json"}).body(requestBody);
        for (Map.Entry<String, String> entry : this.httpHeaders.entrySet()) {
            String valueTemplate = entry.getValue();
            String value = !StringUtils.isBlank((String)valueTemplate) ? RequestPayloadGenerator.generate(valueTemplate, this.convertMessages(chatRequest.messages()), this.apiKey) : "";
            httpRequestBuilder.addHeader(entry.getKey(), new String[]{value});
            if (!this.logRequests) continue;
            LOGGER.info("Header: {}, Value: {}", new Object[]{entry.getKey(), value});
        }
        return httpRequestBuilder.build();
    }

    private List<MessageRound> convertMessages(List<ChatMessage> messages) {
        return messages.stream().map(this::convertMessage).toList();
    }

    private MessageRound convertMessage(ChatMessage message) {
        ChatMessage chatMessage = message;
        Objects.requireNonNull(chatMessage);
        ChatMessage chatMessage2 = chatMessage;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserMessage.class, AiMessage.class, SystemMessage.class}, (Object)chatMessage2, 0)) {
            case 0 -> {
                UserMessage userMessage = (UserMessage)chatMessage2;
                yield new MessageRound(Role.USER, userMessage.singleText());
            }
            case 1 -> {
                AiMessage aiMessage = (AiMessage)chatMessage2;
                yield new MessageRound(Role.MODEL, aiMessage.text());
            }
            case 2 -> {
                SystemMessage systemMessage = (SystemMessage)chatMessage2;
                yield new MessageRound(Role.SYSTEM, systemMessage.text());
            }
            default -> throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getClass()));
        };
    }

    private ChatResponse parseApiResponse(String responseBody) throws IOException {
        String generatedText = JsonPathExtractorImpl.extract(responseBody, this.answerPath);
        AiMessage aiMessage = AiMessage.from((String)generatedText);
        return ChatResponse.builder().aiMessage(aiMessage).build();
    }
}

