/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.bdd.KeywordTestStepActionWordParser;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.InconsistentInfoListItemException;
import org.squashtest.tm.exception.UnallowedTestAssociationException;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.exception.testautomation.MalformedScriptPathException;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.ActionStepImportData;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.display.dto.AutomatedTestDto;
import org.squashtest.tm.service.internal.display.dto.AutomationRequestDto;
import org.squashtest.tm.service.internal.display.dto.testcase.AbstractTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.KeywordTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.PasteTestStepOperationReport;
import org.squashtest.tm.service.internal.display.testcase.teststep.TestStepActionWordOperationReport;
import org.squashtest.tm.service.internal.library.NodeManagementService;
import org.squashtest.tm.service.internal.repository.ActionTestStepDao;
import org.squashtest.tm.service.internal.repository.ActionWordDao;
import org.squashtest.tm.service.internal.repository.ActionWordParamValueDao;
import org.squashtest.tm.service.internal.repository.AutomationRequestDao;
import org.squashtest.tm.service.internal.repository.KeywordTestCaseDao;
import org.squashtest.tm.service.internal.repository.KeywordTestStepDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.ScmRepositoryDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.display.KeywordTestStepDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RemoteAutomationRequestExtenderDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestStepDisplayDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testautomation.UnsecuredAutomatedTestManagerService;
import org.squashtest.tm.service.internal.testcase.CustomTestCaseModificationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.internal.testcase.event.TestCaseNameChangeEvent;
import org.squashtest.tm.service.internal.testcase.event.TestCaseReferenceChangeEvent;
import org.squashtest.tm.service.internal.testcase.event.TestCaseScriptAutoChangeEvent;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedTestTechnologyFinderService;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;
import org.squashtest.tm.service.testcase.CustomTestCaseModificationService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.tf.AutomationRequestFinderService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="CustomTestCaseModificationService")
@Transactional
public class CustomTestCaseModificationServiceImpl
implements CustomTestCaseModificationService {
    private static final Logger LOGGER;
    private static final int STEP_FIRST_POS = 0;
    private static final int STEP_LAST_POS = -1;
    private static final Long NO_ACTIVE_MILESTONE_ID;
    private static final String WRITE_AS_AUTOMATION = "WRITE_AS_AUTOMATION";
    private static final String MILESTONES = "milestones";
    private static final String SLASH_SEPARATOR = "/";
    private static final String LOCKED_MILESTONE_MESSAGE = "This element is bound to a locked milestone. It can't be modified";
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private KeywordTestCaseDao keywordTestCaseDao;
    @Inject
    private ActionWordDao actionWordDao;
    @Inject
    private ActionWordLibraryNodeService actionWordLibraryNodeService;
    @Inject
    private AutomationRequestDao requestDao;
    @Inject
    private RemoteAutomationRequestExtenderDisplayDao rareDisplayDao;
    @Inject
    private ActionTestStepDao actionStepDao;
    @Inject
    private ActionWordParamValueDao actionWordParamValueDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private TestStepDao testStepDao;
    @Inject
    private KeywordTestStepDao keywordTestStepDao;
    @Inject
    @Named(value="squashtest.tm.service.internal.TestCaseManagementService")
    private NodeManagementService<TestCase, TestCaseLibraryNode, TestCaseFolder> testCaseManagementService;
    @Inject
    private TestCaseNodeDeletionHandler deletionHandler;
    @Inject
    private UnsecuredAutomatedTestManagerService taService;
    @Inject
    protected PrivateCustomFieldValueService customFieldValuesService;
    @Inject
    private ParameterModificationService parameterModificationService;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private TestCaseLibraryNavigationService libraryService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private AutomationRequestFinderService automationRequestFinderService;
    @Inject
    private AutomationRequestModificationService automationRequestModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ApplicationEventPublisher eventPublisher;
    @Inject
    private TestCaseFolderDao testCaseFolderDao;
    @Inject
    private TestCaseLibraryDao testCaseLibraryDao;
    @Inject
    private TestStepDisplayDao testStepDisplayDao;
    @Inject
    private TestCaseDisplayService testCaseDisplayService;
    @Inject
    private DatasetModificationService datasetModificationService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private ScmRepositoryDao scmRepositoryDao;
    @Inject
    private AutomatedTestTechnologyFinderService automatedTestTechnologyFinderService;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private KeywordTestStepDisplayDao keywordTestStepDisplayDao;
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private TestCaseLoader testCaseLoader;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        CustomTestCaseModificationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(CustomTestCaseModificationServiceImpl.class);
        NO_ACTIVE_MILESTONE_ID = -9000L;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public String getPrerequisite(long testCaseId) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        return testCase.getPrerequisite();
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void rename(@Id long testCaseId, String newName) throws DuplicateNameException {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        LOGGER.debug("changing test case #{} name from '{}' to '{}' ", new Object[]{testCase.getId(), testCase.getName(), newName});
        this.testCaseManagementService.renameNode(testCaseId, newName);
        this.eventPublisher.publishEvent((ApplicationEvent)new TestCaseNameChangeEvent(testCaseId, newName));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeReference(@Id long testCaseId, String reference) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        LOGGER.debug("changing test case #{} reference from '{}' to '{}' ", new Object[]{testCase.getId(), testCase.getReference(), reference});
        testCase.setReference(reference);
        this.eventPublisher.publishEvent((ApplicationEvent)new TestCaseReferenceChangeEvent(testCaseId, reference));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public String changeSourceCodeRepository(@Id long testCaseId, long scmRepositoryId) {
        ScmRepository scmRepository = (ScmRepository)this.scmRepositoryDao.getReferenceById(scmRepositoryId);
        String repositoryFriendlyUrl = scmRepository.getFriendlyUrl();
        LOGGER.debug("changing test case #{} git repository to '{}' ", new Object[]{testCaseId, repositoryFriendlyUrl});
        this.testCaseDao.bindScmRepository(testCaseId, scmRepositoryId);
        return repositoryFriendlyUrl;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void unbindSourceCodeRepository(@Id long testCaseId) {
        this.testCaseDao.unbindScmRepository(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeAutomatedTestReference(@Id long testCaseId, String automatedTestReference) {
        if (automatedTestReference != null && automatedTestReference.length() > 512) {
            throw new WrongStringSizeException("automatedTestReference", 0, 512);
        }
        if (automatedTestReference != null && automatedTestReference.isEmpty()) {
            automatedTestReference = null;
        }
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        LOGGER.debug("changing test case #{} automated test reference from '{}' to '{}' ", new Object[]{testCase.getId(), testCase.getAutomatedTestReference(), automatedTestReference});
        testCase.setAutomatedTestReference(automatedTestReference);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeAutomatedTestTechnology(@Id long testCaseId, long automatedTestTechnologyId) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        AutomatedTestTechnology technology = this.automatedTestTechnologyFinderService.findById(automatedTestTechnologyId);
        LOGGER.debug("changing test case #{} automated test technology to '{}' ", new Object[]{testCase.getId(), technology.getName()});
        testCase.setAutomatedTestTechnology(technology);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void unbindAutomatedTestTechnology(@Id long testCaseId) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        testCase.setAutomatedTestTechnology(null);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeAutomationPriority(@Id long testCaseId, Integer automationPriority) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_AUTOMATION_REQUEST));
        LOGGER.debug("changing test case #{} automation priority to '{}' ", new Object[]{testCase.getId(), automationPriority});
        testCase.getAutomationRequest().setAutomationPriority(automationPriority);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeImportance(@Id long testCaseId, TestCaseImportance importance) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        LOGGER.debug("changing test case #{} importance from '{}' to '{}' ", new Object[]{testCase.getId(), testCase.getImportance(), importance});
        testCase.setImportance(importance);
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public KeywordTestStep addKeywordTestStep(@Id long parentTestCaseId, @NotNull String keyword, @NotNull String word) {
        String string = word;
        String string2 = keyword;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string2);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$3$e2ae1e40((Object)string);
        return this.addKeywordTestStep(parentTestCaseId, keyword, word, -1);
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public KeywordTestStep addKeywordTestStep(@Id long parentTestCaseId, @NotNull String keyword, @NotNull String word, int index) {
        String string = word;
        String string2 = keyword;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string2);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$3$e2ae1e40((Object)string);
        Keyword givenKeyword = Keyword.valueOf((String)keyword);
        KeywordTestStepActionWordParser parser = new KeywordTestStepActionWordParser();
        ActionWord inputActionWord = parser.createActionWordFromKeywordTestStep(word.trim());
        List parameterValues = parser.getParameterValues();
        KeywordTestStep newKeyword = new KeywordTestStep(givenKeyword, inputActionWord);
        newKeyword.setParamValues(parameterValues);
        return this.addCompleteKeywordTestStep(parentTestCaseId, newKeyword, index);
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public KeywordTestStep addKeywordTestStep(@Id long parentTestCaseId, @NotNull String keyword, @NotNull String word, @NotNull Long actionWordId, int index) {
        String string = word;
        String string2 = keyword;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string2);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$3$e2ae1e40((Object)string);
        ActionWord actionWord = (ActionWord)this.actionWordDao.getReferenceById(actionWordId);
        KeywordTestCase parentTestCase = (KeywordTestCase)this.keywordTestCaseDao.getReferenceById(parentTestCaseId);
        Keyword inputKeyword = Keyword.valueOf((String)keyword);
        KeywordTestStepActionWordParser parser = new KeywordTestStepActionWordParser();
        parser.createActionWordFromKeywordTestStep(word.trim());
        List parameterValues = parser.getParameterValues();
        KeywordTestStep newTestStep = new KeywordTestStep();
        newTestStep.setKeyword(inputKeyword);
        newTestStep.setTestCase((TestCase)parentTestCase);
        if (index == 0) {
            index = -1;
        }
        return this.addActionWordToKeywordTestStep(newTestStep, actionWord, parentTestCase, parameterValues, index);
    }

    @Override
    public KeywordTestStep addKeywordTestStep(long parentTestCaseId, KeywordTestStep sourceTestStep, int index) {
        KeywordTestStepActionWordParser parser = new KeywordTestStepActionWordParser();
        ActionWord inputActionWord = parser.createActionWordFromKeywordTestStep(sourceTestStep.getActionWord().createWord().trim());
        KeywordTestStep newTestStep = (KeywordTestStep)sourceTestStep.createCopy();
        newTestStep.setActionWord(inputActionWord);
        LOGGER.debug("adding a new keyword test step to test case #{}", new Object[]{parentTestCaseId});
        return this.addCompleteKeywordTestStep(parentTestCaseId, newTestStep, index);
    }

    private KeywordTestStep addCompleteKeywordTestStep(long parentTestCaseId, KeywordTestStep sourceTestStep, int index) {
        KeywordTestCase parentTestCase = (KeywordTestCase)this.keywordTestCaseDao.getReferenceById(parentTestCaseId);
        sourceTestStep.setTestCase((TestCase)parentTestCase);
        KeywordTestStep newTestStep = (KeywordTestStep)sourceTestStep.createCopy();
        newTestStep.setParamValues(new ArrayList());
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIds();
        Project currentProject = parentTestCase.getProject();
        ActionWord inputActionWord = sourceTestStep.getActionWord();
        ActionWord actionWord = this.getActionWordFromDB(inputActionWord.getToken(), currentProject.getId(), readableProjectIds);
        if (Objects.isNull(actionWord) || !actionWord.getProject().getId().equals(currentProject.getId())) {
            LOGGER.debug("adding test step with new action word", new Object[0]);
            inputActionWord.setProject(currentProject);
            this.actionWordDao.save(inputActionWord);
            this.addNewActionWordNodeInLibrary(inputActionWord, currentProject);
            return this.addActionWordToKeywordTestStep(newTestStep, inputActionWord, parentTestCase, sourceTestStep.getParamValues(), index);
        }
        LOGGER.debug("Action word exists in database.", new Object[0]);
        return this.addActionWordToKeywordTestStep(newTestStep, actionWord, parentTestCase, sourceTestStep.getParamValues(), index);
    }

    private ActionWord getActionWordFromDB(String inputToken, long currentProjectId, List<Long> readableProjectIds) {
        List<ActionWord> matchingActionWords = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS) ? this.actionWordDao.findByTokenInProjectsIgnoreCase(inputToken, readableProjectIds) : this.actionWordDao.findByTokenInProjects(inputToken, readableProjectIds);
        if (matchingActionWords.isEmpty()) {
            return null;
        }
        Optional<ActionWord> actionWordFromCurrentProject = this.getMatchingActionWordFromCurrentProject(currentProjectId, matchingActionWords);
        if (actionWordFromCurrentProject.isPresent()) {
            return actionWordFromCurrentProject.get();
        }
        Optional<ActionWord> actionWordFromOtherProjectWithSmallestId = this.getMatchingActionWordFromProjectWithSmallestId(matchingActionWords);
        if (actionWordFromOtherProjectWithSmallestId.isPresent()) {
            return actionWordFromOtherProjectWithSmallestId.get();
        }
        return null;
    }

    private Optional<ActionWord> getMatchingActionWordFromCurrentProject(long currentProjectId, List<ActionWord> matchingActionWords) {
        return matchingActionWords.stream().filter(actionWord -> currentProjectId == actionWord.getProject().getId()).findAny();
    }

    private Optional<ActionWord> getMatchingActionWordFromProjectWithSmallestId(List<ActionWord> matchingActionWords) {
        return matchingActionWords.stream().min(Comparator.comparing(actionWord -> actionWord.getProject().getId()));
    }

    private void insertNewValuesToDataBase(KeywordTestCase parentTestCase, ActionWord inputActionWord, KeywordTestStep newTestStep, List<ActionWordParameterValue> parameterValueMap) {
        List inputActionWordParameters = inputActionWord.getActionWordParams();
        int i = 0;
        while (i < inputActionWordParameters.size()) {
            ActionWordParameter parameter = (ActionWordParameter)inputActionWordParameters.get(i);
            ActionWordParameterValue newValue = new ActionWordParameterValue();
            newValue.setValue(parameterValueMap.get(i).getValue());
            newValue.setActionWordParam(parameter);
            newValue.setKeywordTestStep(newTestStep);
            if ((parameter.getDefaultValue() == null || parameter.getDefaultValue().isEmpty()) && newValue.isLinkedToTestCaseParam()) {
                String valueStr = newValue.getValue().trim();
                String newValueValue = this.insertNewTestCaseParamIfNeeded(parentTestCase, valueStr);
                newValue.setValue(newValueValue);
            }
            this.actionWordParamValueDao.persist(newValue);
            newTestStep.addParamValues(newValue);
            ++i;
        }
    }

    private String insertNewTestCaseParamIfNeeded(KeywordTestCase parentTestCase, String valueStr) {
        String newParamName = ActionWordUtil.generateTestCaseParameter((String)valueStr);
        Set testCaseParameters = parentTestCase.getParameters();
        boolean existed = testCaseParameters.stream().anyMatch(param -> newParamName.equals(param.getName()));
        if (!existed) {
            new Parameter(newParamName, (TestCase)parentTestCase);
            this.datasetModificationService.cascadeDatasetsUpdate(parentTestCase.getId());
        }
        return "<" + newParamName + ">";
    }

    private KeywordTestStep addActionWordToKeywordTestStep(KeywordTestStep newTestStep, ActionWord inputActionWord, KeywordTestCase parentTestCase, List<ActionWordParameterValue> parameterValues, int index) {
        newTestStep.setActionWord(inputActionWord);
        this.testStepDao.persist(newTestStep);
        this.insertNewValuesToDataBase(parentTestCase, inputActionWord, newTestStep, parameterValues);
        this.addStepToTestCase((TestStep)newTestStep, (TestCase)parentTestCase, index);
        this.addActionWordToItsFragment(inputActionWord);
        inputActionWord.addStep(newTestStep);
        return newTestStep;
    }

    private void addActionWordToItsFragment(ActionWord inputActionWord) {
        List fragments = inputActionWord.getFragments();
        fragments.forEach(actionWordFragment -> actionWordFragment.setActionWord(inputActionWord));
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public KeywordTestStep addKeywordTestStep(@Id long parentTestCaseId, KeywordTestStep newTestStep) {
        return this.addKeywordTestStep(parentTestCaseId, newTestStep, -1);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateKeywordTestStep(long testStepId, KeywordTestStep updatedKeywordTestStep) {
        this.updateKeywordTestStep(testStepId, updatedKeywordTestStep.getKeyword());
        this.updateKeywordTestStep(testStepId, updatedKeywordTestStep.getActionWord().createWord());
    }

    @Override
    @Deprecated
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateKeywordTestStep(long testStepId, Keyword updatedKeyword) {
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        if (updatedKeyword != null && !updatedKeyword.equals((Object)testStep.getKeyword())) {
            LOGGER.debug("changing step #{} keyword to '{}'", new Object[]{testStepId, updatedKeyword});
            testStep.setKeyword(updatedKeyword);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateKeywordTestStepDatatable(long testStepId, String updatedDatatable) {
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        if (updatedDatatable != null && !updatedDatatable.equals(testStep.getDatatable())) {
            LOGGER.debug("changing step #{} datatable to '{}'", new Object[]{testStepId, updatedDatatable});
            testStep.setDatatable(updatedDatatable);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateKeywordTestStepDocstring(long testStepId, String updatedDocstring) {
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        if (updatedDocstring != null && !updatedDocstring.equals(testStep.getDocstring())) {
            LOGGER.debug("changing step #{} docstring to '{}'", new Object[]{testStepId, updatedDocstring});
            testStep.setDocstring(updatedDocstring);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateKeywordTestStepComment(long testStepId, String updatedComment) {
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        if (updatedComment != null && !updatedComment.equals(testStep.getComment())) {
            LOGGER.debug("changing step #{} comment to '{}'", new Object[]{testStepId, updatedComment});
            testStep.setComment(updatedComment);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public TestStepActionWordOperationReport updateKeywordTestStep(long testStepId, String updatedWord) {
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        KeywordTestCase parentTestCase = (KeywordTestCase)this.keywordTestCaseDao.getReferenceById(testStep.getTestCase().getId());
        String token = testStep.getActionWord().getToken();
        if (updatedWord != null) {
            this.updateActionWordWithNotNullInput(testStepId, updatedWord, testStep, parentTestCase, token);
            return this.generateStepActionOperationReport(testStepId);
        }
        throw new IllegalArgumentException("Action word cannot be null.");
    }

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public TestStepActionWordOperationReport updateKeywordTestStep(long testStepId, @NotNull String updatedWord, long actionWordId) {
        String string = updatedWord;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        ActionWord actionWord = (ActionWord)this.actionWordDao.getReferenceById(actionWordId);
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        KeywordTestCase parentTestCase = (KeywordTestCase)this.keywordTestCaseDao.getReferenceById(testStep.getTestCase().getId());
        String trimmedWord = updatedWord.trim();
        KeywordTestStepActionWordParser parser = new KeywordTestStepActionWordParser();
        parser.createActionWordFromKeywordTestStep(trimmedWord);
        List parameterValues = parser.getParameterValues();
        String token = testStep.getActionWord().getToken();
        String inputToken = actionWord.getToken();
        if (!inputToken.equals(token)) {
            List valueList = testStep.getParamValues();
            if (!valueList.isEmpty()) {
                valueList.clear();
            }
            this.updateKeywordTestStepWithExistingActionWord(parentTestCase, testStep, actionWord, parameterValues);
        } else {
            testStep.setActionWord(actionWord);
            this.updateActionWordWithoutChangingToken(testStep, parentTestCase, parameterValues);
        }
        return this.generateStepActionOperationReport(testStepId);
    }

    private void updateActionWordWithNotNullInput(long testStepId, String updatedWord, KeywordTestStep testStep, KeywordTestCase parentTestCase, String token) {
        String trimmedWord = updatedWord.trim();
        KeywordTestStepActionWordParser parser = new KeywordTestStepActionWordParser();
        ActionWord inputActionWord = parser.createActionWordFromKeywordTestStep(trimmedWord);
        List parameterValues = parser.getParameterValues();
        String inputToken = inputActionWord.getToken();
        LOGGER.debug("changing step #{} action word to '{}'", new Object[]{testStepId, inputActionWord.createWord()});
        if (!inputToken.equals(token)) {
            this.updateActionWordWithChangingToken(testStep, parentTestCase, inputActionWord, parameterValues, inputToken);
        } else {
            this.updateActionWordWithoutChangingToken(testStep, parentTestCase, parameterValues);
        }
    }

    private TestStepActionWordOperationReport generateStepActionOperationReport(long stepId) {
        KeywordTestStepDto stepDto;
        KeywordTestStepDto keywordTestStepDto = stepDto = (KeywordTestStepDto)this.findTestStep(stepId);
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)keywordTestStepDto);
        Object[] objectArray = new Object[]{this, keywordTestStepDto, joinPoint};
        CustomTestCaseModificationServiceImpl$AjcClosure1 customTestCaseModificationServiceImpl$AjcClosure1 = new CustomTestCaseModificationServiceImpl$AjcClosure1(objectArray);
        return new TestStepActionWordOperationReport(stepDto.getAction(), (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(customTestCaseModificationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)), stepDto.getActionWordId(), this.testCaseDisplayService.findParametersDataByTestStepId(stepId));
    }

    private void updateActionWordWithChangingToken(KeywordTestStep testStep, KeywordTestCase parentTestCase, ActionWord inputActionWord, List<ActionWordParameterValue> parameterValues, String token) {
        Long projectId = testStep.getTestCase().getProject().getId();
        ActionWord existingActionWord = this.actionWordDao.findByTokenInCurrentProject(token, projectId);
        List valueList = testStep.getParamValues();
        if (!valueList.isEmpty()) {
            valueList.clear();
        }
        if (Objects.isNull(existingActionWord)) {
            this.updateKeywordTestStepWithNewActionWord(parentTestCase, testStep, inputActionWord, parameterValues);
        } else {
            this.updateKeywordTestStepWithExistingActionWord(parentTestCase, testStep, existingActionWord, parameterValues);
        }
    }

    private void updateActionWordWithoutChangingToken(KeywordTestStep testStep, KeywordTestCase parentTestCase, List<ActionWordParameterValue> parameterValues) {
        List<ActionWordParameterValue> values = this.reorderParamValuesFromTestStepIfNeeded(testStep);
        int i = 0;
        while (i < values.size()) {
            ActionWordParameterValue oldValue = values.get(i);
            ActionWordParameterValue newValue = parameterValues.get(i);
            this.doUpdateParamValuesAndInsertNewTcParamIfNeeded(oldValue, newValue, parentTestCase);
            ++i;
        }
    }

    private void doUpdateParamValuesAndInsertNewTcParamIfNeeded(ActionWordParameterValue oldValue, ActionWordParameterValue newValue, KeywordTestCase parentTestCase) {
        String newValueStr = newValue.getValue();
        if (!oldValue.getValue().equals(newValueStr)) {
            if (newValueStr.startsWith("<") && newValueStr.endsWith(">")) {
                String paramValue = this.insertNewTestCaseParamIfNeeded(parentTestCase, newValueStr);
                oldValue.setValue(paramValue);
            } else {
                oldValue.setValue(newValueStr);
            }
        }
    }

    @Override
    public void updateKeywordTestStepWithNewActionWord(KeywordTestCase parentTestCase, KeywordTestStep testStep, ActionWord inputActionWord, List<ActionWordParameterValue> parameterValues) {
        Project currentProject = testStep.getTestCase().getProject();
        inputActionWord.setProject(currentProject);
        this.insertNewValuesToDataBase(parentTestCase, inputActionWord, testStep, parameterValues);
        this.addNewActionWordNodeInLibrary(inputActionWord, currentProject);
        testStep.setActionWord(inputActionWord);
    }

    @Override
    public void updateKeywordTestStepWithExistingActionWord(KeywordTestCase parentTestCase, KeywordTestStep testStep, ActionWord actionWord, List<ActionWordParameterValue> parameterValues) {
        testStep.setActionWord(actionWord);
        this.insertNewValuesToDataBase(parentTestCase, actionWord, testStep, parameterValues);
    }

    private List<ActionWordParameterValue> reorderParamValuesFromTestStepIfNeeded(KeywordTestStep testStep) {
        List values = testStep.getParamValues();
        if (values.size() < 2) {
            return values;
        }
        return this.reorderParamValuesFromTestStep(values, testStep);
    }

    private List<ActionWordParameterValue> reorderParamValuesFromTestStep(List<ActionWordParameterValue> values, KeywordTestStep testStep) {
        ArrayList<ActionWordParameterValue> orderedValues = new ArrayList<ActionWordParameterValue>();
        for (ActionWordParameter orderedParam : testStep.getActionWord().getActionWordParams()) {
            int index = 0;
            while (index < values.size() && !values.get(index).getActionWordParam().getId().equals(orderedParam.getId())) {
                ++index;
            }
            if (index >= values.size()) continue;
            orderedValues.add((ActionWordParameterValue)testStep.getParamValues().get(index));
        }
        return orderedValues;
    }

    private void addNewActionWordNodeInLibrary(ActionWord newActionWord, Project currentProject) {
        ActionWordLibrary actionWordLibrary = currentProject.getActionWordLibrary();
        ActionWordLibraryNode parentLibraryNode = this.actionWordLibraryNodeService.findNodeFromEntity((ActionWordTreeEntity)actionWordLibrary);
        this.actionWordLibraryNodeService.createNewNode(parentLibraryNode.getId(), (ActionWordTreeEntity)newActionWord);
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public ActionTestStep addActionTestStep(@Id long parentTestCaseId, ActionTestStep newTestStep) {
        return this.addActionTestStep(parentTestCaseId, newTestStep, -1);
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public ActionTestStep addActionTestStep(@Id long parentTestCaseId, ActionTestStep newTestStep, int index) {
        TestCase parentTestCase = (TestCase)this.testCaseLoader.load(parentTestCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS, TestCaseLoader.Options.FETCH_PARAMETERS));
        this.doAddActionTestStep(parentTestCase, newTestStep, index);
        return newTestStep;
    }

    @Override
    public void addImportActionSteps(Project project, List<Long> testCaseIds, List<Batch<ActionStepImportData>> batches) {
        Map<Long, TestCase> testCaseById = this.testCaseLoader.load(testCaseIds, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS, TestCaseLoader.Options.FETCH_PARAMETERS)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        List<Batch<ActionTestStep>> addedStepsBatches = this.batchActionStepsAddition(batches, testCaseById);
        this.initializeCustomFieldValues(project, batches);
        this.parameterModificationService.createParamsForSteps(testCaseById, addedStepsBatches);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void initializeCustomFieldValues(Project project, List<Batch<ActionStepImportData>> batches) {
        List<ActionTestStep> testSteps = batches.stream().flatMap(b -> b.getEntities().stream()).map(ActionStepImportData::getActionTestStep).toList();
        this.customFieldValuesService.createAllCustomFieldValues(testSteps, (GenericProject)project);
        Map<ActionTestStep, Map> actionStepCustomFields = batches.stream().flatMap(b -> b.getEntities().stream()).filter(data -> !data.getCustomFields().isEmpty()).collect(Collectors.toMap(ActionStepImportData::getActionTestStep, ActionStepImportData::getCustomFields));
        this.customFieldValuesService.initBatchCustomFieldValues(actionStepCustomFields);
    }

    private List<Batch<ActionTestStep>> batchActionStepsAddition(List<Batch<ActionStepImportData>> batches, Map<Long, TestCase> testCaseById) {
        ArrayList<Batch<ActionTestStep>> addedStepsBatches = new ArrayList<Batch<ActionTestStep>>();
        for (Batch<ActionStepImportData> batch : batches) {
            List<ActionStepImportData> steps = batch.getEntities();
            steps.sort(Comparator.comparing(ActionStepImportData::getIndex, Comparator.nullsLast(Comparator.naturalOrder())));
            TestCase testCase = testCaseById.get(batch.getTargetId());
            Batch<ActionTestStep> actionTestStepBatch = new Batch<ActionTestStep>(testCase.getId());
            for (ActionStepImportData importData : steps) {
                ActionTestStep step = importData.getActionTestStep();
                Integer index = importData.getIndex();
                if (index != null && index >= 0 && index < testCase.getSteps().size()) {
                    testCase.addStep(index.intValue(), (TestStep)step);
                } else {
                    testCase.addStep((TestStep)step);
                }
                this.testStepDao.persist(step);
                actionTestStepBatch.addEntity(step);
            }
            addedStepsBatches.add(actionTestStepBatch);
        }
        return addedStepsBatches;
    }

    private void doAddActionTestStep(TestCase parentTestCase, ActionTestStep newTestStep, int index) {
        LOGGER.debug("adding a new action step to test case #{}", new Object[]{parentTestCase.getId()});
        newTestStep.setTestCase(parentTestCase);
        this.testStepDao.persist(newTestStep);
        this.addStepToTestCase((TestStep)newTestStep, parentTestCase, index);
        LOGGER.trace("creating custom field values", new Object[0]);
        this.customFieldValuesService.createAllCustomFieldValues((BoundEntity)newTestStep, (GenericProject)newTestStep.getProject());
        LOGGER.trace("processing parameters", new Object[0]);
        this.parameterModificationService.createParamsForStep(newTestStep.getId());
    }

    private void createAttachments(ActionTestStep actionTestStep) {
        if (actionTestStep.getId() == null) {
            return;
        }
        AttachmentList attachmentList = actionTestStep.getAttachmentList();
        this.createAttachmentFromAction(actionTestStep, attachmentList);
        this.createAttachmentFromExpectedResult(actionTestStep, attachmentList);
    }

    private void createAttachmentFromExpectedResult(ActionTestStep actionTestStep, AttachmentList attachmentList) {
        String expectedResult = actionTestStep.getExpectedResult();
        if (expectedResult == null || expectedResult.isEmpty()) {
            return;
        }
        String newExpectedResult = this.attachmentManagerService.handleRichTextAttachments(expectedResult, attachmentList);
        if (!expectedResult.equals(newExpectedResult)) {
            actionTestStep.setExpectedResult(newExpectedResult);
        }
    }

    private void createAttachmentFromAction(ActionTestStep actionTestStep, AttachmentList attachmentList) {
        String action = actionTestStep.getAction();
        if (action == null || action.isEmpty()) {
            return;
        }
        String newAction = this.attachmentManagerService.handleRichTextAttachments(action, attachmentList);
        if (!action.equals(newAction)) {
            actionTestStep.setAction(newAction);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public ActionTestStep addActionTestStep(@Id long parentTestCaseId, ActionTestStep newTestStep, Map<Long, RawValue> customFieldValues) {
        ActionTestStep step = this.addActionTestStep(parentTestCaseId, newTestStep);
        this.customFieldValuesService.initCustomFieldValues((BoundEntity)step, customFieldValues);
        this.createAttachments(newTestStep);
        return step;
    }

    @Override
    public ActionTestStep addActionTestStepUnsecured(TestCase parentTestCase, ActionTestStep newTestStep, Map<Long, RawValue> customFieldValues) {
        this.doAddActionTestStep(parentTestCase, newTestStep, -1);
        this.customFieldValuesService.initCustomFieldValues((BoundEntity)newTestStep, customFieldValues);
        this.createAttachments(newTestStep);
        return newTestStep;
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public ActionTestStep addActionTestStep(@Id long parentTestCaseId, ActionTestStep newTestStep, Map<Long, RawValue> customFieldValues, int index) {
        ActionTestStep step = this.addActionTestStep(parentTestCaseId, newTestStep, index);
        this.customFieldValuesService.initCustomFieldValues((BoundEntity)step, customFieldValues);
        this.createAttachments(newTestStep);
        return step;
    }

    @Override
    public AbstractTestStepDto findTestStep(Long testStepId) {
        List<AbstractTestStepDto> testSteps = this.testStepDisplayDao.getTestSteps(Collections.singleton(testStepId));
        return testSteps.get(0);
    }

    @Override
    public List<String> retrieveFullNameByTestCaseLibraryNodeIds(List<Long> testCaseLibraryNodeIds, List<Long> projectIds) {
        return this.testCaseDao.retrieveFullNameByTestCaseLibraryNodeIds(testCaseLibraryNodeIds, projectIds);
    }

    @Override
    @CheckBlockingMilestone(entityType=TestStep.class)
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateTestStepAction(@Id long testStepId, String newAction) {
        ActionTestStep testStep = this.actionStepDao.findById(testStepId);
        LOGGER.debug("changing step #{} action to '{}'", new Object[]{testStepId, newAction.substring(0, Math.min(newAction.length(), 25))});
        testStep.setAction(newAction);
        this.parameterModificationService.createParamsForStep(testStepId);
    }

    @Override
    @CheckBlockingMilestone(entityType=TestStep.class)
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateTestStepExpectedResult(@Id long testStepId, String newExpectedResult) {
        ActionTestStep testStep = this.actionStepDao.findById(testStepId);
        LOGGER.debug("changing step #{} expected result to '{}'", new Object[]{testStepId, newExpectedResult.substring(0, Math.min(newExpectedResult.length(), 25))});
        testStep.setExpectedResult(newExpectedResult);
        this.parameterModificationService.createParamsForStep(testStepId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeTestStepsPosition(@Id long testCaseId, int newPosition, List<Long> stepIds) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        List<TestStep> steps = this.testStepDao.findListById(stepIds);
        LOGGER.debug("moving steps #{} to position {}", new Object[]{stepIds, newPosition});
        testCase.moveSteps(newPosition, steps);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void removeStepFromTestCase(@Id long testCaseId, long testStepId) {
        LOGGER.debug("deleting step #{} from test case #{}", new Object[]{testStepId, testCaseId});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        TestStep testStep = (TestStep)this.testStepDao.findById(testStepId);
        this.deletionHandler.deleteStep(testCase, testStep);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void removeStepFromTestCaseByIndex(@Id long testCaseId, int index) {
        LOGGER.debug("deleting step at index {} from test case #{}", new Object[]{index, testCaseId});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        TestStep testStep = (TestStep)testCase.getSteps().get(index);
        this.deletionHandler.deleteStep(testCase, testStep);
    }

    private void addStepToTestCase(TestStep testStep, TestCase parentTestCase, int index) {
        if (index == -1) {
            parentTestCase.addStep(testStep);
        } else {
            parentTestCase.addStep(index, testStep);
        }
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public TestCase findTestCaseWithSteps(long testCaseId) {
        LOGGER.debug("loading test case #{}", new Object[]{testCaseId});
        return (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public List<TestStep> removeListOfSteps(@Id long testCaseId, List<Long> testStepIds) {
        LOGGER.debug("deleting {} steps from test case #{}", new Object[]{testStepIds.size(), testCaseId});
        LOGGER.trace("deleted steps : {}", new Object[]{testStepIds});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        List<TestStep> steps = this.testStepDao.findListById(testStepIds);
        for (TestStep step : steps) {
            this.deletionHandler.deleteStep(testCase, step);
        }
        return testCase.getSteps();
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public PasteTestStepOperationReport pasteCopiedTestStep(@Id long testCaseId, long idInsertion, long copiedTestStepId) {
        Integer position = this.testStepDao.findPositionOfStep(idInsertion) + 1;
        LOGGER.debug("copying step #{} of test case #{} and inserting at position {}", new Object[]{copiedTestStepId, testCaseId, position});
        return this.pasteTestStepAtPosition(testCaseId, Collections.singletonList(copiedTestStepId), position);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public PasteTestStepOperationReport pasteCopiedTestSteps(@Id long testCaseId, long idInsertion, List<Long> copiedTestStepIds, boolean isAssignedToCurrentProject) {
        Integer position = this.testStepDao.findPositionOfStep(idInsertion) + 1;
        LOGGER.debug("copying {} steps of test case #{} and inserting at position {}", new Object[]{copiedTestStepIds.size(), testCaseId, position});
        LOGGER.trace("copied step ids : {}", new Object[]{copiedTestStepIds});
        if (isAssignedToCurrentProject) {
            return this.createKeywordTestStepsFromCopiedOnes(testCaseId, copiedTestStepIds, position);
        }
        return this.pasteTestStepAtPosition(testCaseId, copiedTestStepIds, position);
    }

    private PasteTestStepOperationReport createKeywordTestStepsFromCopiedOnes(long testCaseId, List<Long> copiedTestStepIds, Integer position) {
        HashSet<Long> createdTestStepIds = new HashSet<Long>();
        List copiedTestSteps = this.keywordTestStepDao.findAllById(copiedTestStepIds);
        for (KeywordTestStep step : copiedTestSteps) {
            KeywordTestStep keywordTestStep = this.addKeywordTestStep(testCaseId, step, position);
            createdTestStepIds.add(keywordTestStep.getId());
        }
        PasteTestStepOperationReport operationReport = new PasteTestStepOperationReport();
        operationReport.addTestSteps(this.testStepDisplayDao.getTestSteps(createdTestStepIds));
        TestCase targetTestCase = (TestCase)this.testCaseLoader.load(testCaseId);
        operationReport.setTestCaseImportance(targetTestCase.getImportance().name());
        return operationReport;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public PasteTestStepOperationReport pasteCopiedTestStepToLastIndex(@Id long testCaseId, long copiedTestStepId) {
        LOGGER.debug("copying step #{} into test case #{} at last position", new Object[]{copiedTestStepId, testCaseId});
        return this.pasteTestStepAtPosition(testCaseId, List.of(Long.valueOf(copiedTestStepId)), null);
    }

    @Override
    public Long fetchTargetProjectId(Long testCaseId) {
        TestCase targetTestCase = (TestCase)this.testCaseLoader.load(testCaseId);
        return targetTestCase.getProject().getId();
    }

    @Override
    public Boolean areCopiedTestStepsProjectsIdsEqualToTargetProjectId(List<Long> copiedTestStepsProjectsIds, Long targetProjectId) {
        for (Long projectId : copiedTestStepsProjectsIds) {
            if (Objects.equals(projectId, targetProjectId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Long> fetchProjectsIdsByTestStepsIds(List<Long> testStepsIds) {
        return new ArrayList<Long>(this.keywordTestStepDisplayDao.displayProjectsIdsByKeywordStepIds(testStepsIds));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    @CheckBlockingMilestone(entityType=TestCase.class)
    public PasteTestStepOperationReport pasteCopiedTestStepToLastIndex(@Id long testCaseId, List<Long> copiedTestStepIds, boolean isAssignedToCurrentProject) {
        LOGGER.debug("copying {} steps into test case #{} at last position", new Object[]{copiedTestStepIds.size(), testCaseId});
        LOGGER.trace("step ids are : {}", new Object[]{copiedTestStepIds});
        if (isAssignedToCurrentProject) {
            return this.createKeywordTestStepsFromCopiedOnes(testCaseId, copiedTestStepIds, -1);
        }
        return this.pasteTestStepAtPosition(testCaseId, copiedTestStepIds, null);
    }

    private PasteTestStepOperationReport pasteTestStepAtPosition(long testCaseId, List<Long> copiedStepIds, Integer position) {
        boolean hasCallStep = false;
        List<TestStep> originals = this.testStepDao.findByIdOrderedByIndex(copiedStepIds);
        ArrayList<TestStep> copies = new ArrayList<TestStep>();
        if (position != null) {
            Collections.reverse(originals);
        }
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        TestStepVisitor visitor = new TestStepVisitor(){

            public void visit(ActionTestStep visited) {
                CustomTestCaseModificationServiceImpl.this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)visited);
            }

            public void visit(CallTestStep visited) {
            }

            public void visit(KeywordTestStep visited) {
            }
        };
        for (TestStep original : originals) {
            LOGGER.trace("copying step #{}", new Object[]{original.getId()});
            TestStep copyStep = original.createCopy();
            this.testStepDao.persist(copyStep);
            LOGGER.trace("new step #{} created", new Object[]{copyStep.getId()});
            copyStep.accept(visitor);
            LOGGER.trace("adding step", new Object[0]);
            if (position != null && position < testCase.getSteps().size()) {
                testCase.addStep(position.intValue(), copyStep);
            } else {
                testCase.addStep(copyStep);
            }
            if (!testCase.getSteps().contains(original)) {
                LOGGER.trace("this step originates from a different test case : #{}", new Object[]{original.getTestCase().getId()});
                LOGGER.trace("checking whether the importance of the receiving test case needs reevaluation", new Object[0]);
                this.updateImportanceIfCallStep(testCase, copyStep);
                LOGGER.trace("checking for potential new parameters for the receiving test case", new Object[0]);
                this.parameterModificationService.createParamsForStep(copyStep);
            }
            LOGGER.trace("copying custom fields", new Object[0]);
            copyStep.accept((TestStepVisitor)new TestStepCustomFieldCopier(original));
            copies.add(copyStep);
            boolean bl = hasCallStep = hasCallStep || CallTestStep.class.isAssignableFrom(copyStep.getClass());
        }
        this.entityManager.flush();
        Set<Long> ids = copies.stream().map(TestStep::getId).collect(Collectors.toSet());
        LOGGER.trace("job done, with callStepFlag #{} fetching new steps #{}", new Object[]{hasCallStep, ids});
        return this.craftOperationReport(hasCallStep, testCase, ids);
    }

    private PasteTestStepOperationReport craftOperationReport(boolean hasCallStep, TestCase testCase, Set<Long> ids) {
        PasteTestStepOperationReport operationReport = new PasteTestStepOperationReport();
        List<AbstractTestStepDto> testSteps = this.testStepDisplayDao.getTestSteps(ids);
        operationReport.addTestSteps(testSteps);
        if (hasCallStep) {
            operationReport.setTestCaseImportance(testCase.getImportance().name());
        }
        return operationReport;
    }

    private void updateImportanceIfCallStep(TestCase parentTestCase, TestStep copyStep) {
        if (CallTestStep.class.isAssignableFrom(copyStep.getClass())) {
            TestCase called = ((CallTestStep)copyStep).getCalledTestCase();
            LOGGER.trace("reevaluating importance for test case #{}", new Object[]{parentTestCase.getId()});
            this.testCaseImportanceManagerService.changeImportanceIfCallStepAddedToTestCases(called, parentTestCase);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeImportanceAuto(long testCaseId, boolean auto) {
        LOGGER.debug("changing test case #{} importance auto flag to : {}", new Object[]{testCaseId, auto});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        testCase.setImportanceAuto(Boolean.valueOf(auto));
        LOGGER.trace("recalculating test case importance if required", new Object[0]);
        this.testCaseImportanceManagerService.changeImportanceIfIsAuto(testCase, testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    @Transactional(readOnly=true)
    public Collection<TestAutomationProjectContent> findAssignableAutomationTests(long testCaseId) {
        LOGGER.debug("looking for assignable automated tests for test case #{}", new Object[]{testCaseId});
        List taProjects = this.entityManager.createQuery("select tap from TestAutomationProject tap where tap.tmProject.id = (select tc.project.id from TestCase tc where tc.id = :id) ", TestAutomationProject.class).setParameter("id", (Object)testCaseId).getResultList();
        if (LOGGER.isTraceEnabled()) {
            List taProjectIds = IdCollector.collect((Collection)taProjects);
            LOGGER.trace("involved test automation projects are : {}", new Object[]{taProjectIds});
        }
        return this.taService.listTestsInProjects(taProjects);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public AutomatedTest bindAutomatedTest(Long testCaseId, Long taProjectId, String testName) {
        LOGGER.debug("binding test case #{} to automated test '{}' (project #{}", new Object[]{testCaseId, testName, taProjectId});
        TestAutomationProject project = this.taService.findProjectById(taProjectId);
        AutomatedTest newTest = new AutomatedTest(testName, project);
        AutomatedTest persisted = this.taService.persistOrAttach(newTest);
        LOGGER.trace("created persistent automated test #{}", new Object[]{persisted.getId()});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_AUTOMATED_TEST));
        AutomatedTest previousTest = testCase.getAutomatedTest();
        testCase.setAutomatedTest(persisted);
        if (previousTest != null) {
            LOGGER.trace("deleting previous automated test if exists and unused", new Object[0]);
            this.taService.removeIfUnused(previousTest);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new TestCaseScriptAutoChangeEvent(testCaseId, newTest.getFullName()));
        return newTest;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public AutomatedTest bindAutomatedTest(Long testCaseId, String testPath) {
        LOGGER.debug("binding test case #{} to automated test (path '{}')", new Object[]{testCaseId, testPath});
        if (StringUtils.isBlank((CharSequence)testPath)) {
            LOGGER.trace("path is blank -> resetting binding to null", new Object[0]);
            this.removeAutomation(testCaseId);
            return null;
        }
        Couple<Long, String> projectAndTestname = this.extractAutomatedProjectAndTestName(testCaseId, testPath);
        AutomationRequest automationRequest = this.automationRequestFinderService.findRequestByTestCaseId(testCaseId);
        if (automationRequest != null && automationRequest.getProject().isAllowAutomationWorkflow() && TestCaseAutomatable.Y.equals((Object)automationRequest.getTestCase().getAutomatable())) {
            this.requestDao.updateIsManual(testCaseId, true);
        }
        return this.bindAutomatedTest(testCaseId, (Long)projectAndTestname.getA1(), (String)projectAndTestname.getA2());
    }

    @Override
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void removeAutomation(@Id long testCaseId) {
        LOGGER.debug("unbinding test case #{} from automated test", new Object[]{testCaseId});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_AUTOMATED_TEST));
        AutomatedTest previousTest = testCase.getAutomatedTest();
        testCase.removeAutomatedScript();
        LOGGER.trace("deleting unbound automated test if exists and unused", new Object[0]);
        this.taService.removeIfUnused(previousTest);
    }

    @Override
    public TestCase addNewTestCaseVersion(@Id long originalTcId, TestCase newVersionData) throws MilestoneForbidModificationException {
        if (this.checkIfBoundToBlockingMilestone(originalTcId)) {
            throw new MilestoneForbidModificationException(LOCKED_MILESTONE_MESSAGE);
        }
        LOGGER.debug("creating new version of test case #{}", new Object[]{originalTcId});
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            Milestone milestone = activeMilestone.get();
            LOGGER.trace("active milestone detected : #{}", new Object[]{milestone.getId()});
            milestoneIds.add(milestone.getId());
        }
        LOGGER.trace("copying test case", new Object[0]);
        TestCase orig = (TestCase)this.testCaseLoader.load(originalTcId, EnumSet.of(TestCaseLoader.Options.FETCH_DATASETS, TestCaseLoader.Options.FETCH_STEPS, TestCaseLoader.Options.FETCH_PARAMETERS, TestCaseLoader.Options.FETCH_MILESTONES, TestCaseLoader.Options.FETCH_ATTACHMENT_LIST));
        TestCase newTC = orig.createCopy();
        LOGGER.trace("created new test case #{}", new Object[]{newTC.getId()});
        LOGGER.trace("updating with new attributes", new Object[0]);
        newTC.setName(newVersionData.getName());
        newTC.setReference(newVersionData.getReference());
        newTC.setDescription(newVersionData.getDescription());
        newTC.clearMilestones();
        TestCaseLibrary library = (TestCaseLibrary)this.libraryService.findLibraryOfRootNodeIfExist(orig);
        if (library != null) {
            LOGGER.trace("inserting new test case in library #{}", new Object[]{library.getId()});
            this.libraryService.addTestCaseToLibrary(library.getId(), newTC, null);
        } else {
            TestCaseFolder folder = (TestCaseFolder)this.libraryService.findParentIfExists((LibraryNode)orig);
            LOGGER.trace("inserting new test case in folder #{}", new Object[]{folder.getId()});
            this.libraryService.addTestCaseToFolder(folder.getId(), newTC, null);
        }
        LOGGER.trace("copying the custom field values from original test case #{} into new test case #{}", new Object[]{orig.getId(), newTC.getId()});
        this.customFieldValuesService.copyCustomFieldValuesContent((BoundEntity)orig, (BoundEntity)newTC);
        LinkedList origSteps = new LinkedList(orig.getActionSteps());
        LinkedList newSteps = new LinkedList(newTC.getActionSteps());
        while (!origSteps.isEmpty()) {
            ActionTestStep oStep = (ActionTestStep)origSteps.remove();
            ActionTestStep nStep = (ActionTestStep)newSteps.remove();
            LOGGER.trace("copying custom field values from step #{} into new step #{}", new Object[]{oStep.getId(), nStep.getId()});
            this.customFieldValuesService.copyCustomFieldValuesContent((BoundEntity)oStep, (BoundEntity)nStep);
        }
        LOGGER.trace("rebinding milestones", new Object[0]);
        this.milestoneService.bindTestCaseToMilestones(newTC.getId(), milestoneIds);
        this.milestoneService.unbindTestCaseFromMilestones(originalTcId, milestoneIds);
        return newTC;
    }

    private boolean checkIfBoundToBlockingMilestone(Long id) {
        boolean isEntityBoundToBlockingMilestone = this.milestoneDao.isTestCaseMilestoneModifiable(id);
        if (isEntityBoundToBlockingMilestone && this.activeMilestoneHolder.getActiveMilestone().isPresent()) {
            Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
            Milestone milestone = activeMilestone.get();
            return this.milestoneDao.isActiveMilestoneABlockingMilestone(milestone.getId());
        }
        return isEntityBoundToBlockingMilestone;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changePrerequisite(@Id long testCaseId, String newPrerequisite) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_PARAMETERS));
        testCase.setPrerequisite(newPrerequisite);
        this.addParametersFromPrerequisite(testCase);
    }

    private void addParametersFromPrerequisite(TestCase testCase) {
        LOGGER.debug("adding test case #{} parameters from its attribute 'prerequisite'", new Object[]{testCase.getId()});
        List parameters = testCase.findUsedParamsNamesInPrerequisite();
        for (String name : parameters) {
            Parameter parameter = testCase.findParameterByName(name);
            if (parameter != null) continue;
            LOGGER.trace("found new parameter '{}', adding it to test case", new Object[]{name});
            this.parameterModificationService.addNewParameterToTestCase(new Parameter(name), testCase.getId());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeNature(@Id long testCaseId, String natureCode) {
        InfoListItem nature = this.infoListItemService.findByCode(natureCode);
        this.changeNature(testCaseId, nature);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeNature(long testCaseId, long natureId) {
        InfoListItem nature = this.infoListItemService.findById(natureId);
        this.changeNature(testCaseId, nature);
    }

    private void changeNature(long testCaseId, InfoListItem nature) {
        LOGGER.debug("changing test case #{} nature to '{}'", new Object[]{testCaseId, nature.getCode()});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        if (!this.infoListItemService.isNatureConsistent(testCase.getProject().getId(), nature.getCode())) {
            throw new InconsistentInfoListItemException("nature", nature.getCode());
        }
        testCase.setNature(nature);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void changeType(@Id long testCaseId, String typeCode) {
        InfoListItem type = this.infoListItemService.findByCode(typeCode);
        this.changeType(testCaseId, type);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeType(long testCaseId, long typeId) {
        InfoListItem type = this.infoListItemService.findById(typeId);
        this.changeType(testCaseId, type);
    }

    private void changeType(long testCaseId, InfoListItem type) {
        LOGGER.trace("changing test case #{} type to : '{}'", new Object[]{testCaseId, type.getCode()});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        if (!this.infoListItemService.isTypeConsistent(testCase.getProject().getId(), type.getCode())) {
            throw new InconsistentInfoListItemException("type", type.getCode());
        }
        testCase.setType(type);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public AutomatedTest bindAutomatedTestByAutomationProgrammer(@Id Long testCaseId, String testPath) {
        LOGGER.debug("binding test case #{} to automated test (path '{}')", new Object[]{testCaseId, testPath});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        if (testCase.getProject().isAllowAutomationWorkflow() && TestCaseAutomatable.Y.equals((Object)testCase.getAutomatable())) {
            this.permissionEvaluationService.checkPermission(Collections.singletonList(testCaseId), WRITE_AS_AUTOMATION, TestCase.class.getName());
            if (StringUtils.isBlank((CharSequence)testPath)) {
                LOGGER.trace("path is blank -> resetting binding to null", new Object[0]);
                this.removeAutomation(testCaseId);
                return null;
            }
            Couple<Long, String> projectAndTestname = this.extractAutomatedProjectAndTestName(testCaseId, testPath);
            this.requestDao.updateIsManual(testCaseId, true);
            return this.bindAutomatedTest(testCaseId, (Long)projectAndTestname.getA1(), (String)projectAndTestname.getA2());
        }
        throw new IllegalArgumentException();
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public AutomatedTest bindAutomatedTestAutomatically(Long testCaseId, Long taProjectId, String testName) {
        return this.bindAutomatedTest(testCaseId, taProjectId, testName);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<TestAutomationProjectContent> findAssignableAutomationTestsToAutomationProgramer(long testCaseId) {
        Collection taProjects;
        LOGGER.debug("looking for assignable automated tests for test case #{}", new Object[]{testCaseId});
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        if (testCase.getProject().isAllowAutomationWorkflow() && TestCaseAutomatable.Y.equals((Object)testCase.getAutomatable())) {
            this.permissionEvaluationService.checkPermission(Collections.singletonList(testCaseId), WRITE_AS_AUTOMATION, TestCase.class.getName());
            taProjects = testCase.getProject().getTestAutomationProjects();
            if (LOGGER.isTraceEnabled()) {
                List taProjectIds = IdCollector.collect((Collection)taProjects);
                LOGGER.trace("involved test automation projects are : {}", new Object[]{taProjectIds});
            }
        } else {
            throw new IllegalArgumentException();
        }
        return this.taService.listTestsInProjects(taProjects);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN') or hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE_AS_AUTOMATION')")
    public AutomatedTestDto bindAutomatedTestToTC(Long testCaseId, String testPath) {
        AutomatedTest automatedTest = this.bindAutomatedTest(testCaseId, testPath);
        AutomatedTestDto automatedTestDto = null;
        if (automatedTest != null) {
            automatedTestDto = new AutomatedTestDto(automatedTest.getId(), automatedTest.getName(), automatedTest.getFullLabel());
        }
        return automatedTestDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void bindMilestones(long testCaseId, Collection<Long> milestoneIds) {
        LOGGER.debug("binding test case #{} to milestones {}", new Object[]{testCaseId, milestoneIds});
        this.milestoneService.bindTestCaseToMilestones(testCaseId, milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void unbindMilestones(long testCaseId, Collection<Long> milestoneIds) {
        LOGGER.debug("unbinding test case #{} from milestones {}", new Object[]{testCaseId, milestoneIds});
        this.milestoneService.unbindTestCaseFromMilestones(testCaseId, milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAssociableMilestones(long testCaseId) {
        LOGGER.debug("searching milestones that test case #{} can bind to", new Object[]{testCaseId});
        Collection<Milestone> milestones = this.milestoneService.findAssociableMilestonesToTestCase(testCaseId);
        this.traceResult(milestones, MILESTONES);
        return milestones;
    }

    @Override
    public Collection<Milestone> findAssociableMilestonesForMassModif(List<Long> testCaseIds) {
        LOGGER.debug("searching milestones that all the following test cases can bind to : {}", new Object[]{testCaseIds});
        List<Milestone> milestones = this.getMilestonesByTestCaseIds(testCaseIds);
        LOGGER.trace("found {} candidates, now filtering according to status", new Object[]{milestones.size()});
        this.filterLockedAndPlannedStatus(milestones);
        this.traceResult(milestones, MILESTONES);
        return milestones;
    }

    private List<Milestone> getMilestonesByTestCaseIds(List<Long> testCaseIds) {
        List results = this.entityManager.createQuery("select m.id, tc.id from TestCase tc join tc.project p join p.milestones m where tc.id in :ids", Object[].class).setParameter("ids", testCaseIds).getResultList();
        Map<Long, Long> milestoneCounts = results.stream().collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.counting()));
        List<Long> commonMilestoneIds = milestoneCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() == (long)testCaseIds.size()).map(Map.Entry::getKey).toList();
        return this.entityManager.createQuery("select m from Milestone m where m.id in :ids", Milestone.class).setParameter("ids", commonMilestoneIds).getResultList();
    }

    private void filterLockedAndPlannedStatus(Collection<Milestone> milestones) {
        CollectionUtils.filter(milestones, (Predicate)new Predicate(){

            public boolean evaluate(Object milestone) {
                return ((Milestone)milestone).getStatus() != MilestoneStatus.LOCKED && ((Milestone)milestone).getStatus() != MilestoneStatus.PLANNED;
            }
        });
    }

    @Override
    public Collection<Long> findBindedMilestonesIdForMassModif(List<Long> testCaseIds) {
        LOGGER.debug("searching for milestone ids that are bound to all the following test cases : {}", new Object[]{testCaseIds});
        LOGGER.trace("gathering the milestones", new Object[0]);
        ArrayList milestones = null;
        Object testCases = this.testCaseLoader.load(testCaseIds, EnumSet.of(TestCaseLoader.Options.FETCH_MILESTONES));
        for (TestCase testCase : testCases) {
            Set mil = testCase.getMilestones();
            if (milestones != null) {
                milestones.retainAll(mil);
                continue;
            }
            milestones = new ArrayList(mil);
        }
        LOGGER.trace("filtering by status", new Object[0]);
        this.filterLockedAndPlannedStatus(milestones);
        List milestoneIds = IdCollector.collect(milestones);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("found {} milestones, ids are : {}", new Object[]{milestoneIds.size(), milestoneIds});
        }
        return milestoneIds;
    }

    @Override
    public boolean haveSamePerimeter(List<Long> testCaseIds) {
        LOGGER.debug("testing whether the following test cases have the same milestone perimeter : {}", new Object[]{testCaseIds});
        if (testCaseIds.size() <= 1) {
            return true;
        }
        Map<Long, List<Long>> milestoneIdsByTcId = this.getProjectMilestoneIdsByTestCaseId(testCaseIds);
        HashSet<ArrayList<Long>> set = new HashSet<ArrayList<Long>>();
        for (List<Long> milestoneIds : milestoneIdsByTcId.values()) {
            ArrayList<Long> sortedList = new ArrayList<Long>(milestoneIds);
            Collections.sort(sortedList);
            if (set.add(sortedList)) continue;
            return true;
        }
        return false;
    }

    private Map<Long, List<Long>> getProjectMilestoneIdsByTestCaseId(List<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id, m.id from TestCase tc inner join tc.project.milestones m where tc.id in :ids", Object[].class).setParameter("ids", testCaseIds).getResultList().stream().collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (Long)result[1], Collectors.toList())));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public AutomationRequestDto changeAutomatable(TestCaseAutomatable automatable, @Id Long testCaseId) {
        TestCase tc = (TestCase)this.testCaseLoader.load(testCaseId);
        if (!TestCaseExecutionMode.EXPLORATORY.equals((Object)tc.getExecutionMode())) {
            if (tc.getProject().isAllowAutomationWorkflow()) {
                if (!automatable.equals((Object)tc.getAutomatable())) {
                    tc.setAutomatable(automatable);
                }
                if (automatable.equals((Object)TestCaseAutomatable.Y) && tc.getAutomationRequest() == null) {
                    this.createRequestForTestCase(tc, null);
                }
            }
            AutomationRequestDto automationRequestDto = null;
            if (tc.getAutomationRequest() != null) {
                automationRequestDto = new AutomationRequestDto(tc.getAutomationRequest());
                this.rareDisplayDao.addRemoteExtender(automationRequestDto);
            }
            return automationRequestDto;
        }
        throw new IllegalArgumentException("Exploratory test case cannot be automated.");
    }

    @Override
    public Map<String, Object> transmitEligibleNodes(Map<String, List<Long>> selectedNodes) {
        Optional<Long> activeMilestoneId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List testCaseIds = selectedNodes.get("testcases");
        List<Long> folderIds = selectedNodes.get("folders");
        List<Long> libraryIds = selectedNodes.get("libraries");
        if (!libraryIds.isEmpty()) {
            ArrayList rootLibraryNodes = new ArrayList();
            for (Long libraryId : libraryIds) {
                rootLibraryNodes.addAll(this.testCaseLibraryDao.findAllRootContentById(libraryId));
            }
            for (TestCaseLibraryNode node : rootLibraryNodes) {
                if (node instanceof TestCase) {
                    testCaseIds.add(node.getId());
                    continue;
                }
                folderIds.add(node.getId());
            }
        }
        if (!folderIds.isEmpty()) {
            testCaseIds.addAll(this.testCaseFolderDao.findAllTestCaseIdsFromFolderIds(folderIds));
        }
        if ((activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId()).isPresent() && !NO_ACTIVE_MILESTONE_ID.equals(activeMilestoneId.get())) {
            testCaseIds = this.testCaseDao.findAllTCIdsForActiveMilestoneInList(activeMilestoneId.get(), testCaseIds);
        }
        AutomationRequestModificationService.ChangeAutomatedRequestStatusResult changeStatusResult = this.automationRequestModificationService.changeAutomationRequestStatus(testCaseIds, AutomationRequestStatus.TRANSMITTED);
        result.put("areAllEligible", changeStatusResult.wereAllChanged());
        result.put("eligibleTcIds", changeStatusResult.transmittedAutomationRequestIds);
        return result;
    }

    private void traceResult(Collection<? extends Identified> collection, String qualifier) {
        if (LOGGER.isTraceEnabled()) {
            List ids = IdCollector.collect(collection);
            LOGGER.trace("found {} {}, ids are : {}", new Object[]{collection.size(), qualifier, ids});
        }
    }

    private Couple<Long, String> extractAutomatedProjectAndTestName(Long testCaseId, String testPath) {
        Optional<TestAutomationProject> tap;
        LOGGER.debug("extracting project and test name for automated test path '{}', in the context of test case #{}", new Object[]{testPath, testCaseId});
        if (!PathUtils.isPathWellFormed((String)testPath)) {
            LOGGER.error("automated test path '{}' is malformed !", new Object[]{testPath});
            throw new MalformedScriptPathException();
        }
        String path = testPath.replaceFirst("^/", "");
        TestCase tc = (TestCase)this.testCaseLoader.load(testCaseId);
        Project tmProject = tc.getProject();
        Collection taProjects = tmProject.getTestAutomationProjects();
        String projectLabel = this.retrieveProjectLabelFromPath(path, taProjects);
        String testName = path.replaceFirst(projectLabel + SLASH_SEPARATOR, "");
        if (LOGGER.isTraceEnabled()) {
            List<String> taProjectNames = taProjects.stream().map(TestAutomationProject::getJobName).toList();
            LOGGER.trace("available automation projects for test case #{} : {}", new Object[]{testCaseId, taProjectNames});
        }
        if ((tap = taProjects.stream().filter(taProj -> taProj.getLabel().equals(projectLabel)).findAny()).isEmpty()) {
            LOGGER.error("expected testautomation project '{}' but it appears that it doesn't belong to the TA projects within the scope of test case #{} ", new Object[]{projectLabel});
            throw new UnallowedTestAssociationException();
        }
        return new Couple((Object)tap.get().getId(), (Object)testName);
    }

    private String retrieveProjectLabelFromPath(String path, Collection<TestAutomationProject> taProjects) {
        String projectLabel;
        String updatedPath = path;
        do {
            int index = updatedPath.lastIndexOf(SLASH_SEPARATOR);
            String pathToCheck = updatedPath = updatedPath.substring(0, index);
            projectLabel = taProjects.stream().map(TestAutomationProject::getLabel).filter(p -> p.equals(pathToCheck)).findFirst().orElse("");
        } while (updatedPath.contains(SLASH_SEPARATOR) && projectLabel.equals(""));
        return projectLabel;
    }

    @Override
    public void createRequestForTestCase(TestCase testCase, AutomationRequestStatus automationRequestStatus) {
        Project project = testCase.getProject();
        AutomationRequest request = new AutomationRequest();
        testCase.setAutomationRequest(request);
        request.setTestCase(testCase);
        request.setProject(project);
        if (automationRequestStatus != null) {
            request.setRequestStatus(automationRequestStatus);
        }
        User currentUser = this.userAccountService.findCurrentUser();
        request.setCreatedBy(currentUser);
        if (testCase.getAutomatedTest() != null) {
            request.setManual(true);
        }
        this.requestDao.save(request);
        project.getAutomationRequestLibrary().addContent(request);
    }

    static final /* synthetic */ String getStyledAction_aroundBody0(CustomTestCaseModificationServiceImpl customTestCaseModificationServiceImpl, KeywordTestStepDto keywordTestStepDto, JoinPoint joinPoint) {
        return keywordTestStepDto.getStyledAction();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CustomTestCaseModificationServiceImpl.java", CustomTestCaseModificationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getStyledAction", "org.squashtest.tm.service.internal.display.dto.testcase.KeywordTestStepDto", "", "", "", "java.lang.String"), 746);
    }

    private final class TestStepCustomFieldCopier
    implements TestStepVisitor {
        TestStep original;

        private TestStepCustomFieldCopier(TestStep original) {
            this.original = original;
        }

        public void visit(ActionTestStep visited) {
            CustomTestCaseModificationServiceImpl.this.customFieldValuesService.copyCustomFieldValues((BoundEntity)((ActionTestStep)this.original), (BoundEntity)visited);
            Project origProject = this.original.getTestCase().getProject();
            Project newProject = visited.getTestCase().getProject();
            if (!origProject.equals(newProject)) {
                CustomTestCaseModificationServiceImpl.this.customFieldValuesService.migrateCustomFieldValues((BoundEntity)visited);
            }
        }

        public void visit(CallTestStep visited) {
        }

        public void visit(KeywordTestStep visited) {
        }
    }
}

