/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.model.messages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.internal.testautomation.model.messages.Metadata;

@JsonIgnoreProperties(ignoreUnknown=true)
public record WorkflowData(String apiVersion, String kind, Metadata metadata, Map<String, WorkflowStatus> status) {
    private static final String PHASE_KEY = "phase";

    public WorkflowDto toWorkflowDto() {
        return new WorkflowDto(this.metadata.workflowId(), this.metadata().name(), this.metadata.namespace(), this.metadata.creationTimestamp(), this.convertStatus(this.status.get(PHASE_KEY)), this.metadata.completionTimestamp());
    }

    private String convertStatus(WorkflowStatus workflowStatus) {
        return switch (workflowStatus) {
            case WorkflowStatus.DONE -> ExecutionStatus.SUCCESS.name();
            case WorkflowStatus.FAILED -> ExecutionStatus.FAILURE.name();
            case WorkflowStatus.RUNNING -> ExecutionStatus.RUNNING.name();
            case WorkflowStatus.PENDING -> ExecutionStatus.READY.name();
            default -> throw new MatchException(null, null);
        };
    }

    public static enum WorkflowStatus {
        DONE,
        FAILED,
        RUNNING,
        PENDING;

    }
}

