/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.scmserver;

import jakarta.persistence.EntityNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.internal.repository.ScmRepositoryDao;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.internal.repository.display.ScmServerDisplayDao;
import org.squashtest.tm.service.scmserver.ScmRepositoryFilesystemService;
import org.squashtest.tm.service.scmserver.ScmServerManagerService;

@Service
@Transactional
public class ScmServerManagerServiceImpl
implements ScmServerManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmServerManagerServiceImpl.class);
    private final ScmServerDao scmServerDao;
    private final ScmRepositoryDao scmRepositoryDao;
    private final ScmServerDisplayDao scmServerDisplayDao;
    private final ScmRepositoryFilesystemService scmRepositoryFilesystemService;

    public ScmServerManagerServiceImpl(ScmServerDao scmServerDao, ScmRepositoryDao scmRepositoryDao, ScmServerDisplayDao scmServerDisplayDao, ScmRepositoryFilesystemService scmRepositoryFilesystemService) {
        this.scmServerDao = scmServerDao;
        this.scmRepositoryDao = scmRepositoryDao;
        this.scmServerDisplayDao = scmServerDisplayDao;
        this.scmRepositoryFilesystemService = scmRepositoryFilesystemService;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmServer createNewScmServer(ScmServer newScmServer) {
        if (this.scmServerDao.isServerNameAlreadyInUse(newScmServer.getName())) {
            throw new NameAlreadyInUseException("ScmServer", newScmServer.getName());
        }
        newScmServer.setAuthenticationPolicy(AuthenticationPolicy.APP_LEVEL);
        return (ScmServer)this.scmServerDao.save(newScmServer);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String updateName(long scmServerId, String newName) {
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById(scmServerId);
        String formerName = scmServer.getName();
        if (formerName.equals(newName)) {
            LOGGER.debug("Did not update the ScmServer name because the submitted name is identical to the former one.", new Object[0]);
            return formerName;
        }
        if (this.scmServerDao.isServerNameAlreadyInUse(newName)) {
            throw new NameAlreadyInUseException("ScmServer", newName);
        }
        scmServer.setName(newName);
        this.scmServerDao.save(scmServer);
        return newName;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String updateUrl(long scmServerId, String newUrl) {
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById(scmServerId);
        String formerUrl = scmServer.getUrl();
        if (formerUrl.equals(newUrl)) {
            LOGGER.debug("Did not update the ScmServer Url because the submitted Url is identical to the former one.", new Object[0]);
            return formerUrl;
        }
        scmServer.setUrl(newUrl);
        this.scmServerDao.save(scmServer);
        return newUrl;
    }

    @Override
    public String updateCommitterMail(long scmServerId, String newCommitterMail) {
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById(scmServerId);
        String formerCommitterMail = scmServer.getCommitterMail();
        if (formerCommitterMail.equals(newCommitterMail)) {
            LOGGER.debug("Did not update the ScmServer committer mail because the submitted mail is identical to the former one.", new Object[0]);
            return formerCommitterMail;
        }
        scmServer.setCommitterMail(newCommitterMail);
        this.scmServerDao.save(scmServer);
        return newCommitterMail;
    }

    @Override
    public boolean getCredentialsNotShared(long scmServerId) {
        Optional optionalScmServer = this.scmServerDao.findById(scmServerId);
        if (optionalScmServer.isEmpty()) {
            throw new EntityNotFoundException("ScmServer not found with ID: " + scmServerId);
        }
        ScmServer scmServer = (ScmServer)optionalScmServer.get();
        return scmServer.isCredentialsNotShared();
    }

    @Override
    public boolean updateCredentialsNotShared(long scmServerId, boolean credentialsNotShared) {
        Optional optionalScmServer = this.scmServerDao.findById(scmServerId);
        if (optionalScmServer.isEmpty()) {
            throw new EntityNotFoundException("ScmServer not found with ID: " + scmServerId);
        }
        ScmServer scmServer = (ScmServer)optionalScmServer.get();
        boolean formerCredentialsNotShared = scmServer.isCredentialsNotShared();
        if (formerCredentialsNotShared == credentialsNotShared) {
            LOGGER.info("Did not update the ScmServer credentialsNotShared because the submitted credentialsNotShared is identical to the former one.", new Object[0]);
            return formerCredentialsNotShared;
        }
        scmServer.setCredentialsNotShared(credentialsNotShared);
        return credentialsNotShared;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteScmServers(Collection<Long> scmServerIds) {
        this.scmServerDao.releaseContainedScmRepositoriesFromProjects(scmServerIds);
        this.scmServerDao.releaseScmServerReferencesFromAllTestCases(scmServerIds);
        for (Long serverId : scmServerIds) {
            ScmServer server = (ScmServer)this.scmServerDao.getReferenceById(serverId);
            this.scmRepositoryFilesystemService.deleteLocalRepositories(server.getRepositories());
            this.scmServerDao.delete(server);
        }
    }

    @Override
    public boolean areServerRepositoriesBoundToProjectOrTestCases(List<Long> scmServerIds) {
        List<Long> repositoryIds = this.scmServerDisplayDao.findAllRepositoriesByServerIds(scmServerIds);
        return this.scmRepositoryDao.isOneRepositoryBoundToProjectOrTestCase(repositoryIds);
    }

    @Override
    public void updateDescription(long scmServerId, String description) {
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById(scmServerId);
        scmServer.setDescription(description);
    }
}

