/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.library.NameAlreadyExistsAtDestinationException;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.RequirementWorkspaceStrategyCopierService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.XlsImportLimitationHandler;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.requirement.RequirementExcelBatchImporter;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.library.AbstractLibraryNavigationService;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;
import org.squashtest.tm.service.internal.requirement.CategoryChainFixer;
import org.squashtest.tm.service.internal.requirement.RequirementFactory;
import org.squashtest.tm.service.internal.requirement.RequirementNodeDeletionHandler;
import org.squashtest.tm.service.internal.requirement.coercers.RLNAndParentIdsCoercerForArray;
import org.squashtest.tm.service.internal.requirement.coercers.RLNAndParentIdsCoercerForList;
import org.squashtest.tm.service.internal.requirement.coercers.RequirementLibraryIdsCoercerForArray;
import org.squashtest.tm.service.internal.requirement.coercers.RequirementLibraryIdsCoercerForList;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.statistics.requirement.RequirementStatisticsBundle;

@Service(value="squashtest.tm.service.RequirementLibraryNavigationService")
@Transactional
public class RequirementLibraryNavigationServiceImpl
extends AbstractLibraryNavigationService<RequirementLibrary, RequirementFolder, RequirementLibraryNode>
implements RequirementLibraryNavigationService,
RequirementLibraryFinderService {
    private static final String REQUIREMENT_ID = "requirementId";
    private static final String SOURCE_NODES_IDS = "sourceNodesIds";
    private static final String DESTINATION_ID = "destinationId";
    private static final String TARGET_ID = "targetId";
    private static final String NODE_IDS = "nodeIds";
    @Inject
    private RequirementLibraryDao requirementLibraryDao;
    @Inject
    private RequirementFolderDao requirementFolderDao;
    @Inject
    private RequirementLibraryNodeDao requirementLibraryNodeDao;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private RequirementNodeDeletionHandler deletionHandler;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToRequirementFolderStrategy")
    private Provider<PasteStrategy<RequirementFolder, RequirementLibraryNode>> pasteToRequirementFolderStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToRequirementLibraryStrategy")
    private Provider<PasteStrategy<RequirementLibrary, RequirementLibraryNode>> pasteToRequirementLibraryStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToRequirementStrategy")
    private Provider<PasteStrategy<Requirement, Requirement>> pasteToRequirementStrategyProvider;
    @Inject
    private RequirementWorkspaceStrategyCopierService requirementWorkspaceStrategyCopierService;
    @Inject
    private RequirementStatisticsService statisticsService;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private RequirementExcelBatchImporter batchImporter;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private RequirementFactory requirementFactory;
    @Inject
    private HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;
    @Inject
    private XlsImportLimitationHandler xlsImportLimitationHandler;

    @Override
    protected NodeDeletionHandler getDeletionHandler() {
        return this.deletionHandler;
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject,'READ')  or hasRole('ROLE_ADMIN')")
    public Requirement findRequirement(long reqId) {
        return (Requirement)this.requirementDao.findById(reqId);
    }

    protected RequirementLibraryDao getLibraryDao() {
        return this.requirementLibraryDao;
    }

    protected RequirementFolderDao getFolderDao() {
        return this.requirementFolderDao;
    }

    protected RequirementLibraryNodeDao getLibraryNodeDao() {
        return this.requirementLibraryNodeDao;
    }

    @Override
    protected PasteStrategy<RequirementFolder, RequirementLibraryNode> getPasteToFolderStrategy() {
        return (PasteStrategy)this.pasteToRequirementFolderStrategyProvider.get();
    }

    @Override
    protected PasteStrategy<RequirementLibrary, RequirementLibraryNode> getPasteToLibraryStrategy() {
        return (PasteStrategy)this.pasteToRequirementLibraryStrategyProvider.get();
    }

    private PasteStrategy<Requirement, Requirement> getPasteToRequirementStrategy() {
        return (PasteStrategy)this.pasteToRequirementStrategyProvider.get();
    }

    @Override
    @UsedInPlugin(names={PluginName.XSQUASH4JIRA, PluginName.XSQUASH4GITLAB})
    public String getPathAsString(long entityId) {
        RequirementLibraryNode node = (RequirementLibraryNode)this.getLibraryNodeDao().findById(entityId);
        this.permissionService.checkPermission(new SecurityCheckableObject(node, Permissions.READ.name()));
        List<String> names = this.getLibraryNodeDao().getParentsName(entityId);
        String projectName = node.getProject().getName();
        if (projectName.contains("/")) {
            projectName = projectName.replace("/", "\\/");
        }
        return "/" + projectName + "/" + this.formatPath(names);
    }

    private String formatPath(List<String> names) {
        StringBuilder builder = new StringBuilder();
        for (String name : names) {
            builder.append("/").append(name);
        }
        return builder.toString();
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public RequirementFolder addFolderToLibrary(@Id long destinationId, RequirementFolder newFolder) {
        RequirementLibrary container = (RequirementLibrary)this.getLibraryDao().findById(destinationId);
        container.addContent((LibraryNode)newFolder);
        this.replaceAllInfoListReferences(newFolder);
        this.getFolderDao().persist(newFolder);
        this.createAllCustomFieldValues(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        this.generateCuf(newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public RequirementFolder addFolderToLibrary(@Id long destinationId, NewFolderDto folderDto) {
        RequirementFolder newFolder = (RequirementFolder)folderDto.toFolder(EntityType.REQUIREMENT_FOLDER);
        return this.addFolderToLibrary(destinationId, newFolder, folderDto.getCustomFields());
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public RequirementFolder addFolderToFolder(@Id long destinationId, RequirementFolder newFolder) {
        RequirementFolder container = (RequirementFolder)this.getFolderDao().findById(destinationId);
        container.addContent((RequirementLibraryNode)newFolder);
        this.replaceAllInfoListReferences(newFolder);
        this.getFolderDao().persist(newFolder);
        this.createAllCustomFieldValues(newFolder);
        this.generateCuf(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public RequirementFolder addFolderToFolder(@Id long destinationId, NewFolderDto folderDto) {
        RequirementFolder newFolder = (RequirementFolder)folderDto.toFolder(EntityType.REQUIREMENT_FOLDER);
        return this.addFolderToFolder(destinationId, newFolder, folderDto.getCustomFields());
    }

    private void generateCuf(RequirementFolder newFolder) {
        List<CustomFieldBinding> projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(newFolder.getProject().getId(), BindableEntity.REQUIREMENT_FOLDER);
        for (CustomFieldBinding binding : projectsBindings) {
            this.customFieldValueService.cascadeCustomFieldValuesCreationNotCreatedFolderYet(binding, (BoundEntity)newFolder);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public Requirement addRequirementToRequirementLibrary(@Id long libraryId, @NotNull NewRequirementVersionDto newVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        return this.addRequirementToRequirementLibraryUnsecured(libraryId, newVersion, milestoneIds);
    }

    @Override
    public Requirement addRequirementToRequirementLibraryUnsecured(@Id long libraryId, @NotNull NewRequirementVersionDto newVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        RequirementLibrary library = (RequirementLibrary)this.requirementLibraryDao.findById(libraryId);
        Requirement newReq = this.createRequirement(newVersion);
        library.addContent((LibraryNode)newReq);
        this.replaceAllInfoListReferences(newReq);
        this.requirementDao.persist(newReq);
        this.createCustomFieldValues((BoundEntity)newReq.getCurrentVersion());
        this.customFieldValueService.initCustomFieldValues((BoundEntity)newReq.getCurrentVersion(), newVersion.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)newReq, (BoundEntity)newReq.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(newReq.getCurrentVersion().getId(), milestoneIds);
        return newReq;
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public Requirement addRequirementToRequirementLibrary(@Id long libraryId, @NotNull Requirement requirement, List<Long> milestoneIds) {
        Requirement requirement2 = requirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement2);
        RequirementLibrary library = (RequirementLibrary)this.requirementLibraryDao.findById(libraryId);
        if (!library.isContentNameAvailable(requirement.getName())) {
            throw new DuplicateNameException(requirement.getName(), requirement.getName());
        }
        library.addContent((LibraryNode)requirement);
        this.replaceAllInfoListReferences(requirement);
        this.requirementDao.persist(requirement);
        this.createCustomFieldValues((BoundEntity)requirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)requirement, (BoundEntity)requirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(requirement.getCurrentVersion().getId(), milestoneIds);
        return requirement;
    }

    private Requirement createRequirement(NewRequirementVersionDto newVersionData) {
        return this.requirementFactory.createRequirement(newVersionData);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToRequirementFolder(@Id long folderId, @NotNull NewRequirementVersionDto firstVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = firstVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        return this.addRequirementToRequirementFolderUnsecured(folderId, firstVersion, milestoneIds);
    }

    @Override
    public Requirement addRequirementToRequirementFolderUnsecured(@Id long folderId, @NotNull NewRequirementVersionDto firstVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = firstVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        RequirementFolder folder = this.requirementFolderDao.findByIdWithContent(folderId);
        Requirement newReq = this.createRequirement(firstVersion);
        folder.addContent((RequirementLibraryNode)newReq);
        this.replaceAllInfoListReferences(newReq);
        this.requirementDao.persist(newReq);
        RequirementVersion currentVersion = newReq.getCurrentVersion();
        this.createCustomFieldValues((BoundEntity)currentVersion);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)currentVersion, firstVersion.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)newReq, (BoundEntity)newReq.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(currentVersion.getId(), milestoneIds);
        return newReq;
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToRequirementFolder(@Id long folderId, @NotNull Requirement requirement, List<Long> milestoneIds) {
        Requirement requirement2 = requirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement2);
        RequirementFolder folder = this.requirementFolderDao.findByIdWithContent(folderId);
        if (!folder.isContentNameAvailable(requirement.getName())) {
            throw new DuplicateNameException(requirement.getName(), requirement.getName());
        }
        folder.addContent((RequirementLibraryNode)requirement);
        this.replaceAllInfoListReferences(requirement);
        this.requirementDao.persist(requirement);
        this.createCustomFieldValues((BoundEntity)requirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)requirement, (BoundEntity)requirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(requirement.getCurrentVersion().getId(), milestoneIds);
        return requirement;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    @CheckBlockingMilestone(entityType=Requirement.class)
    public Requirement addRequirementToRequirement(@Id long requirementId, @NotNull NewRequirementVersionDto newRequirement, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        return this.addRequirementToRequirementUnsecured(requirementId, newRequirement, milestoneIds);
    }

    @Override
    public Requirement addRequirementToRequirementUnsecured(@Id long requirementId, @NotNull NewRequirementVersionDto newRequirement, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        Requirement parent = this.requirementDao.findByIdWithChildren(requirementId);
        Requirement child = this.createRequirement(newRequirement);
        parent.addContent(child);
        this.replaceAllInfoListReferences(child);
        this.requirementDao.persist(child);
        this.createCustomFieldValues((BoundEntity)child.getCurrentVersion());
        this.customFieldValueService.initCustomFieldValues((BoundEntity)child.getCurrentVersion(), newRequirement.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)child, (BoundEntity)child.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(child.getCurrentVersion().getId(), milestoneIds);
        return child;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    @CheckBlockingMilestone(entityType=Requirement.class)
    public Requirement addRequirementToHighLevelRequirement(@Id long requirementId, @NotNull NewRequirementVersionDto newRequirement, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        HighLevelRequirement parent = (HighLevelRequirement)this.requirementDao.findById(requirementId);
        Requirement child = this.createRequirement(newRequirement);
        parent.addContent(child);
        this.replaceAllInfoListReferences(child);
        this.requirementDao.persist(child);
        this.createCustomFieldValues((BoundEntity)child.getCurrentVersion());
        this.customFieldValueService.initCustomFieldValues((BoundEntity)child.getCurrentVersion(), newRequirement.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)child, (BoundEntity)child.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(child.getCurrentVersion().getId(), milestoneIds);
        return child;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToRequirement(@Id long requirementId, @NotNull Requirement newRequirement, List<Long> milestoneIds) {
        Requirement requirement = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement);
        Requirement parent = this.requirementDao.findByIdWithChildren(requirementId);
        parent.addContent(newRequirement);
        this.replaceAllInfoListReferences(newRequirement);
        this.requirementDao.persist(newRequirement);
        this.createCustomFieldValues((BoundEntity)newRequirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)newRequirement, (BoundEntity)newRequirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(newRequirement.getCurrentVersion().getId(), milestoneIds);
        return newRequirement;
    }

    private Requirement addRequirementToHighLevelRequirement(long requirementId, Requirement newRequirement, List<Long> milestoneIds) {
        HighLevelRequirement parent = (HighLevelRequirement)this.requirementDao.findById(requirementId);
        parent.addContent(newRequirement);
        this.replaceAllInfoListReferences(newRequirement);
        this.requirementDao.persist(newRequirement);
        this.createCustomFieldValues((BoundEntity)newRequirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)newRequirement, (BoundEntity)newRequirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(newRequirement.getCurrentVersion().getId(), milestoneIds);
        return newRequirement;
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="sourceNodesIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="sourceNodesIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void copyNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.requirementWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.requirementWorkspaceStrategyCopierService.copyNode(requirementId, Requirement.class, clipboardPayload, nodePastes);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="nodeIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="nodeIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void moveNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="nodeIds") Long[] nodeIds, ClipboardPayload clipboardPayload) {
        if (nodeIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<Requirement, Requirement> pasteStrategy = this.getPasteToRequirementStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(requirementId, clipboardPayload);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="nodeIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="nodeIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void moveNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="nodeIds") Long[] nodeIds) {
        this.moveNodesToRequirement(requirementId, nodeIds, ClipboardPayload.withWhiteListIgnored(Arrays.asList(nodeIds)));
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="nodeIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="nodeIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void moveNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="nodeIds") Long[] nodeIds, int position, ClipboardPayload clipboardPayload) {
        if (nodeIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<Requirement, Requirement> pasteStrategy = this.getPasteToRequirementStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(requirementId, clipboardPayload, position);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    public List<Requirement> findChildrenRequirements(long requirementId) {
        return this.requirementDao.findChildrenRequirements(requirementId);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="sourceNodesIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="sourceNodesIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void copyNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.requirementWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.requirementWorkspaceStrategyCopierService.copyNode(destinationId, RequirementFolder.class, clipboardPayload, nodePastes);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void copyNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.requirementWorkspaceStrategyCopierService.verifyPermission(clipboardPayload);
        this.requirementWorkspaceStrategyCopierService.copyNode(destinationId, RequirementLibrary.class, clipboardPayload, nodePastes);
    }

    private void replaceAllInfoListReferences(RequirementFolder folder) {
        new CategoryChainFixer().fix(folder);
    }

    private void replaceAllInfoListReferences(Requirement requirement) {
        CategoryChainFixer.fix(requirement);
    }

    private void createAllCustomFieldValues(RequirementFolder folder) {
        new CustomFieldValuesFixer().fix(folder);
    }

    @Override
    public ImportLog simulateImportExcelRequirement(File xls) {
        this.xlsImportLimitationHandler.checkMaxNumberOfRequirementsInsideXlsFile(xls);
        return this.batchImporter.simulateImport(xls);
    }

    @Override
    public ImportLog importExcelRequirement(File xls) {
        try {
            this.xlsImportLimitationHandler.incrementImportProcessCounter();
            this.xlsImportLimitationHandler.checkMaxNumberOfRequirementsInsideXlsFile(xls);
            this.xlsImportLimitationHandler.checkIfImportSlotIsAvailable();
            ImportLog importLog = this.batchImporter.performImport(xls);
            return importLog;
        }
        finally {
            this.xlsImportLimitationHandler.decrementImportProcessCounter();
        }
    }

    @Override
    public List<Long> findNodeIdsByPath(List<String> paths) {
        return this.requirementLibraryNodeDao.findNodeIdsByPath(paths);
    }

    @Override
    public Long findNodeIdByPath(String path) {
        return StringUtils.isBlank((CharSequence)path) ? null : this.requirementLibraryNodeDao.findNodeIdByPath(path);
    }

    @Override
    public Long findNodeIdByRemoteKey(String remoteKey, String projectName) {
        return this.requirementDao.findNodeIdByRemoteKey(remoteKey, projectName);
    }

    @Override
    public Long findNodeIdByRemoteKeyAndSynchronisationId(String remoteKey, Long remoteSyncId) {
        return this.requirementDao.findNodeIdByRemoteKeyAndRemoteSyncId(remoteKey, remoteSyncId);
    }

    @Override
    public List<Long> findNodeIdsByRemoteKeys(List<String> remoteKeys, String projectName) {
        Map<String, Long> idsByKeys = this.requirementDao.findNodeIdsByRemoteKeys(remoteKeys, projectName);
        ArrayList<Long> res = new ArrayList<Long>(remoteKeys.size());
        for (String key : remoteKeys) {
            Long id = idsByKeys.get(key);
            res.add(id);
        }
        return res;
    }

    @Override
    public Collection<Long> findRequirementIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        return this.findRequirementIdsFromSelection(libraryIds, nodeIds, false);
    }

    @Override
    public Collection<Long> findRequirementIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds, boolean isExtendedHighLvlReqScope) {
        Set<Long> readLibIds = this.securityFilterIds(libraryIds, RequirementLibrary.class.getName(), "READ");
        Set<Long> readNodeIds = this.securityFilterIds(nodeIds, RequirementLibraryNode.class.getName(), "READ");
        HashSet<Long> reqIds = new HashSet<Long>();
        if (!readLibIds.isEmpty()) {
            reqIds.addAll(this.highLevelRequirementDisplayDao.findRequirementIdsByLibraryIds(readLibIds, isExtendedHighLvlReqScope));
        }
        if (!readNodeIds.isEmpty()) {
            reqIds.addAll(this.highLevelRequirementDisplayDao.findRequirementIdsByNodeIds(readNodeIds, isExtendedHighLvlReqScope));
        }
        return reqIds;
    }

    @Override
    public Long mkdirs(String folderpath) {
        RequirementFolder folderTree;
        List paths = PathUtils.scanPath((String)folderpath);
        String[] splits = PathUtils.splitPath((String)folderpath);
        Project project = this.projectDao.findByName(PathUtils.unescapePathPartSlashes((String)splits[0]));
        if (splits.length < 2) {
            throw new IllegalArgumentException("Folder path for mkdir must contains at least a valid /projectName/folder");
        }
        if (project == null) {
            throw new IllegalArgumentException("Folder path for mkdir must concern an existing project");
        }
        List<Long> ids = this.findNodeIdsByPath(paths);
        int position = ids.indexOf(null);
        switch (position) {
            case -1: {
                return ids.get(ids.size() - 1);
            }
            case 0: {
                folderTree = this.makeFolderTree(project, 1, splits);
                this.addFolderToLibrary((long)project.getRequirementLibrary().getId(), folderTree);
                break;
            }
            default: {
                return this.createReqOrFolderIfSomethingAlreadyExists(splits, project, ids, position);
            }
        }
        RequirementFolder lastfolder = folderTree;
        while (lastfolder.hasContent()) {
            lastfolder = (RequirementFolder)lastfolder.getContent().get(0);
        }
        return lastfolder.getId();
    }

    private Long createReqOrFolderIfSomethingAlreadyExists(String[] splits, Project project, List<Long> ids, int position) {
        Requirement requirement = this.findRequirement(ids.get(position - 1));
        if (requirement == null) {
            return this.createFolderTree(project, position, ids.get(position - 1), splits);
        }
        return this.createRequirementTree(project, position, ids.get(position - 1), splits, requirement.isHighLevel());
    }

    private Long createRequirementTree(Project project, int position, Long idBaseRequirement, String[] splits, boolean isHighLevel) {
        Requirement requirementTree = this.makeRequirementTree(project, position + 1, splits);
        List<Long> emptyIds = Collections.emptyList();
        if (isHighLevel) {
            this.addRequirementToHighLevelRequirement((long)idBaseRequirement, requirementTree, emptyIds);
        } else {
            this.addRequirementToRequirement((long)idBaseRequirement, requirementTree, emptyIds);
        }
        Requirement lastRequirement = requirementTree;
        while (lastRequirement.hasContent()) {
            lastRequirement = (Requirement)lastRequirement.getContent().get(0);
        }
        return lastRequirement.getId();
    }

    private Long createFolderTree(Project project, int position, Long idBaseFolder, String[] splits) {
        RequirementFolder folderTree = this.makeFolderTree(project, position + 1, splits);
        this.addFolderToFolder((long)idBaseFolder, folderTree);
        RequirementFolder lastfolder = folderTree;
        while (lastfolder.hasContent()) {
            lastfolder = (RequirementFolder)lastfolder.getContent().get(0);
        }
        return lastfolder.getId();
    }

    private RequirementFolder makeFolderTree(Project project, int startIndex, String[] names) {
        RequirementFolder baseFolder = null;
        RequirementFolder parentFolder = null;
        int i = startIndex;
        while (i < names.length) {
            RequirementFolder childFolder = new RequirementFolder();
            childFolder.setName(PathUtils.unescapePathPartSlashes((String)names[i]));
            childFolder.setDescription("");
            childFolder.notifyAssociatedWithProject(project);
            if (baseFolder == null) {
                baseFolder = childFolder;
            } else {
                parentFolder.addContent((RequirementLibraryNode)childFolder);
            }
            parentFolder = childFolder;
            ++i;
        }
        return baseFolder;
    }

    private Requirement makeRequirementTree(Project project, int startIndex, String[] names) {
        Requirement baseRequirement = null;
        Requirement parentRequirement = null;
        int i = startIndex;
        while (i < names.length) {
            Requirement childRequirement = new Requirement(new RequirementVersion());
            childRequirement.setName(PathUtils.unescapePathPartSlashes((String)names[i]));
            childRequirement.setDescription("");
            childRequirement.setCategory(this.infoListItemService.findDefaultRequirementCategory(project.getId()));
            childRequirement.notifyAssociatedWithProject(project);
            if (baseRequirement == null) {
                baseRequirement = childRequirement;
            } else {
                parentRequirement.addContent(childRequirement);
            }
            parentRequirement = childRequirement;
            ++i;
        }
        return baseRequirement;
    }

    @Override
    public void changeCurrentVersionNumber(Requirement requirement, Integer noVersion) {
        if (requirement.getCurrentVersion().getVersionNumber() == noVersion.intValue()) {
            return;
        }
        if (requirement.findRequirementVersion(noVersion.intValue()) != null) {
            throw new IllegalArgumentException("RequirementVersion with version number " + String.valueOf(noVersion) + " already exist in this Requirement, id : " + String.valueOf(requirement.getId()));
        }
        RequirementVersion lastCreatedReqVersion = requirement.getCurrentVersion();
        lastCreatedReqVersion.setVersionNumber(noVersion.intValue());
        requirement.setCurrentVersion(requirement.findLastNonObsoleteVersionAfterImport());
    }

    @Override
    public void initCUFvalues(RequirementVersion reqVersion, Map<Long, RawValue> initialCustomFieldValues) {
        this.customFieldValueService.initCustomFieldValues((BoundEntity)reqVersion, initialCustomFieldValues);
    }

    @Override
    public RequirementLibraryNode findRequirementLibraryNodeById(Long id) {
        return (RequirementLibraryNode)this.requirementLibraryNodeDao.findById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#rlnId, 'org.squashtest.tm.domain.requirement.RequirementLibraryNode', 'READ') or hasRole('ROLE_ADMIN')")
    public List<String> findNamesInNodeStartingWith(long rlnId, String nameStart) {
        return this.requirementFolderDao.findNamesInNodeStartingWith(rlnId, nameStart);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary', 'READ') or hasRole('ROLE_ADMIN')")
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        return this.requirementFolderDao.findNamesInLibraryStartingWith(libraryId, nameStart);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, clipboardPayload);
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetId) {
        super.moveNodesToLibrary(destinationId, targetId, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetId)));
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetId, int position) {
        super.moveNodesToLibrary(destinationId, targetId, position, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetId)));
    }

    @Override
    @PreventConcurrents(batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetIds", coercer=RLNAndParentIdsCoercerForList.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetIds", coercer=RequirementLibraryIdsCoercerForList.class)})
    @CheckBlockingMilestones(entityType=Requirement.class)
    public OperationReport deleteNodes(@Ids(value="targetIds") List<Long> targetIds) {
        return super.deleteNodes(targetIds);
    }

    @Override
    public RequirementStatisticsBundle getStatisticsForSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        return this.getStatisticsForSelection(libraryIds, nodeIds, false);
    }

    @Override
    public RequirementStatisticsBundle getStatisticsForSelection(Collection<Long> libraryIds, Collection<Long> nodeIds, boolean isExtendedHighLvlReqScope) {
        Collection<Long> reqIds = this.findRequirementIdsFromSelection(libraryIds, nodeIds, isExtendedHighLvlReqScope);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            return this.statisticsService.gatherRequirementStatisticsBundleForActiveMilestone(reqIds, activeMilestone.get());
        }
        return this.statisticsService.gatherRequirementStatisticsBundle(reqIds);
    }

    @Override
    public List<Long> findAllRequirementIdsInMilestone(Milestone activeMilestone) {
        if (activeMilestone != null) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            milestoneIds.add(activeMilestone.getId());
            return this.requirementDao.findAllRequirementIdsFromMilestones(milestoneIds);
        }
        return new ArrayList<Long>();
    }

    @Override
    public Requirement findRequirement(Long nodeId) {
        return (Requirement)this.requirementDao.findById(nodeId);
    }

    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.requirementLibraryDao.findContentNamesByLibraryId(libraryId);
    }

    @Override
    public Map<Long, List<String>> findContentNamesByNodeIds(Collection<Long> folderIds) {
        if (folderIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.requirementLibraryNodeDao.findContentNames(folderIds);
    }

    private class CustomFieldValuesFixer
    implements RequirementLibraryNodeVisitor {
        private CustomFieldValuesFixer() {
        }

        private void fix(RequirementFolder folder) {
            for (RequirementLibraryNode node : folder.getContent()) {
                node.accept((RequirementLibraryNodeVisitor)this);
            }
        }

        private void fix(Requirement req) {
            req.accept((RequirementLibraryNodeVisitor)this);
        }

        public void visit(Requirement requirement) {
            RequirementLibraryNavigationServiceImpl.this.createCustomFieldValues((BoundEntity)requirement.getCurrentVersion());
            for (Requirement req : requirement.getContent()) {
                this.fix(req);
            }
        }

        public void visit(RequirementFolder folder) {
            this.fix(folder);
        }
    }
}

