/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.Record5;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOrderByStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.repository.NodeRestoreNameResolverDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository(value="TestCaseRestoreNameResolverDao")
public class TestCaseRestoreNameResolverDaoImpl
implements NodeRestoreNameResolverDao {
    private final DSLContext dsl;

    public TestCaseRestoreNameResolverDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public Map<NodeReference, List<Long>> findAncestorsWithDeletedChild(Set<Long> nodeIds) {
        return this.dsl.select((SelectField)DSL.coalesce((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field[])new Field[]{Tables.PROJECT.TCL_ID}).as("ANCESTOR_ID"), (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.isNull().as("IS_LIBRARY_CHILD"), (SelectField)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.as("TCLN_ID")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds).and(ConditionsConstants.TCLN_IN_BIN)).fetch().stream().collect(Collectors.groupingBy(tuple -> new NodeReference((Boolean)tuple.get("IS_LIBRARY_CHILD", Boolean.class) != false ? NodeType.TEST_CASE_LIBRARY : NodeType.TEST_CASE_FOLDER, (Long)tuple.get("ANCESTOR_ID", Long.class)), Collectors.mapping(tuple -> (Long)tuple.get("TCLN_ID", Long.class), Collectors.toList())));
    }

    @Override
    public Map<Long, NodeRenaming> getNodeNamesByIds(Collection<Long> nodeIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)DSL.when((Condition)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull(), (Field)DSL.val((String)"folder")).otherwise((Field)DSL.val((String)"test-case")).as("NODE_TYPE")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).fetch().stream().map(tuple -> new NodeRenaming((Long)tuple.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), (String)tuple.get("NODE_TYPE", String.class), (String)tuple.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME))).collect(Collectors.toMap(NodeRenaming::getNodeId, n -> n));
    }

    @Override
    public Map<NodeReference, List<Long>> findParentsWithDuplicateChildNames(NodeScope scope) {
        CommonTableExpression<Record2<Long, Boolean>> parentWithDeletedNodes = this.buildParentWithDeletedNodeTable(scope);
        CommonTableExpression<Record5<Long, Boolean, Long, String, Boolean>> parentWithDeletedNodesContent = this.buildParentWithDeletedNodeContentTable(parentWithDeletedNodes);
        CommonTableExpression duplicateNodesTable = DSL.name((String)"duplicate_nodes_table").fields("ANCESTOR_ID", "IS_LIBRARY_CHILD", "NAME").as((ResultQuery)DSL.select((SelectField)parentWithDeletedNodesContent.field("ANCESTOR_ID"), (SelectField)parentWithDeletedNodesContent.field("IS_LIBRARY_CHILD", Boolean.class), (SelectField)parentWithDeletedNodesContent.field("NAME")).from(parentWithDeletedNodesContent).groupBy(new GroupField[]{parentWithDeletedNodesContent.field("ANCESTOR_ID"), parentWithDeletedNodesContent.field("IS_LIBRARY_CHILD", Boolean.class), parentWithDeletedNodesContent.field("NAME")}).having(DSL.count().gt((Object)1)));
        SelectSeekStep1 query = this.dsl.with(new CommonTableExpression[]{parentWithDeletedNodes, parentWithDeletedNodesContent, duplicateNodesTable}).select((SelectField)parentWithDeletedNodesContent.field("ANCESTOR_ID", Long.class), (SelectField)parentWithDeletedNodesContent.field("IS_LIBRARY_CHILD", Boolean.class), (SelectField)parentWithDeletedNodesContent.field("TCLN_ID", Long.class)).from(parentWithDeletedNodesContent).innerJoin((TableLike)duplicateNodesTable).on(parentWithDeletedNodesContent.field("ANCESTOR_ID", Long.class).eq(duplicateNodesTable.field("ANCESTOR_ID", Long.class)).and(parentWithDeletedNodesContent.field("IS_LIBRARY_CHILD", Boolean.class).eq(duplicateNodesTable.field("IS_LIBRARY_CHILD", Boolean.class))).and(parentWithDeletedNodesContent.field("NAME", String.class).eq(duplicateNodesTable.field("NAME", String.class)))).where(parentWithDeletedNodesContent.field("DELETED", Boolean.class).isTrue()).orderBy((OrderField)parentWithDeletedNodesContent.field("TCLN_ID").desc());
        HashMap<NodeReference, List<Long>> result = new HashMap<NodeReference, List<Long>>();
        Throwable throwable = null;
        Object var8_9 = null;
        try (Stream stream = query.fetchStream();){
            stream.forEach(tuple -> {
                Long ancestorId = (Long)tuple.get("ANCESTOR_ID", Long.class);
                NodeType ancestorType = (Boolean)tuple.get("IS_LIBRARY_CHILD", Boolean.class) != false ? NodeType.TEST_CASE_LIBRARY : NodeType.TEST_CASE_FOLDER;
                Long nodeId = (Long)tuple.get("TCLN_ID", Long.class);
                NodeReference nodeRef = new NodeReference(ancestorType, ancestorId);
                result.computeIfAbsent(nodeRef, k -> new ArrayList()).add(nodeId);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private CommonTableExpression<Record2<Long, Boolean>> buildParentWithDeletedNodeTable(NodeScope scope) {
        SelectConditionStep query = null;
        if (scope.hasLibraries()) {
            query = DSL.selectDistinct((SelectField)DSL.coalesce((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field[])new Field[]{Tables.PROJECT.TCL_ID}).as("ANCESTOR_ID"), (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.isNull().as("IS_LIBRARY_CHILD")).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).and(ConditionsConstants.TCLN_IN_BIN)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.PROJECT.TCL_ID.in(scope.getLibraryIds()));
        }
        if (scope.hasNodes()) {
            Set<Long> nodeIds = scope.getNodeIds();
            SelectOrderByStep nodeQuery = DSL.selectDistinct((SelectField)DSL.coalesce((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field[])new Field[]{Tables.PROJECT.TCL_ID}).as("ANCESTOR_ID"), (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.isNull().as("IS_LIBRARY_CHILD")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.notIn(nodeIds))).union((Select)DSL.selectDistinct((SelectField)DSL.coalesce((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field[])new Field[]{Tables.PROJECT.TCL_ID}).as("ANCESTOR_ID"), (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.isNull().as("IS_LIBRARY_CHILD")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds).and(ConditionsConstants.TCLN_IN_BIN)));
            query = query == null ? nodeQuery : query.union((Select)nodeQuery);
        }
        return DSL.name((String)"parent_with_deleted_nodes").fields("ANCESTOR_ID", "IS_LIBRARY_CHILD").as(query);
    }

    private CommonTableExpression<Record5<Long, Boolean, Long, String, Boolean>> buildParentWithDeletedNodeContentTable(CommonTableExpression<Record2<Long, Boolean>> parentWithDeletedNodesTable) {
        return DSL.name((String)"parent_content").fields("ANCESTOR_ID", "IS_LIBRARY_CHILD", "TCLN_ID", "NAME", "DELETED").as((ResultQuery)TestCaseRestoreNameResolverDaoImpl.selectNodeWithParent(parentWithDeletedNodesTable).from(parentWithDeletedNodesTable).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(parentWithDeletedNodesTable.field("ANCESTOR_ID", Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(parentWithDeletedNodesTable.field("IS_LIBRARY_CHILD").isTrue()).union((Select)TestCaseRestoreNameResolverDaoImpl.selectNodeWithParent(parentWithDeletedNodesTable).from(parentWithDeletedNodesTable).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(parentWithDeletedNodesTable.field("ANCESTOR_ID", Long.class).eq((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(parentWithDeletedNodesTable.field("IS_LIBRARY_CHILD").isFalse())));
    }

    private static SelectSelectStep<Record5<Long, Boolean, Long, String, Boolean>> selectNodeWithParent(CommonTableExpression<Record2<Long, Boolean>> parentWithDeletedNodesTable) {
        return DSL.select((SelectField)parentWithDeletedNodesTable.field("ANCESTOR_ID", Long.class), (SelectField)parentWithDeletedNodesTable.field("IS_LIBRARY_CHILD", Boolean.class), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON.isNotNull().as("DELETED"));
    }

    @Override
    public Map<Long, List<String>> findContentNames(NodeType parentType, Collection<Long> parentIds) {
        return switch (parentType) {
            case NodeType.TEST_CASE_LIBRARY -> this.findContentNamesByLibraryIds(parentIds);
            case NodeType.TEST_CASE_FOLDER -> this.findContentNamesByFolderIds(parentIds);
            default -> throw new IllegalArgumentException("Unknown parent type: " + String.valueOf(parentType));
        };
    }

    private Map<Long, List<String>> findContentNamesByFolderIds(Collection<Long> nodeIds) {
        return this.dsl.select((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TCLN_RELATIONSHIP).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(nodeIds)).fetchGroups((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME);
    }

    private Map<Long, List<String>> findContentNamesByLibraryIds(Collection<Long> librariesIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(librariesIds)).fetchGroups((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME);
    }

    @Override
    public Map<Long, List<String>> findActiveContentNames(NodeType parentType, Collection<Long> parentIds, Collection<Long> deletedIds) {
        return switch (parentType) {
            case NodeType.TEST_CASE_LIBRARY -> this.findActiveContentNamesByLibraryIds(parentIds, deletedIds);
            case NodeType.TEST_CASE_FOLDER -> this.findActiveContentNamesByFolderIds(parentIds, deletedIds);
            default -> throw new IllegalArgumentException("Unknown parent type: " + String.valueOf(parentType));
        };
    }

    private Map<Long, List<String>> findActiveContentNamesByLibraryIds(Collection<Long> libraryIds, Collection<Long> deletedIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(libraryIds)).and(ConditionsConstants.TCLN_NOT_IN_BIN.or(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(deletedIds))).fetchGroups((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME);
    }

    private Map<Long, List<String>> findActiveContentNamesByFolderIds(Collection<Long> nodeIds, Collection<Long> deletedIds) {
        return this.dsl.select((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TCLN_RELATIONSHIP).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(nodeIds)).and(ConditionsConstants.TCLN_NOT_IN_BIN.or(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(deletedIds))).fetchGroups((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME);
    }
}

