/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.testcase.TestCaseBinGrid;
import org.squashtest.tm.service.internal.repository.hibernate.TestCaseBinDao;

@Repository
public class TestCaseBinDaoImpl
implements TestCaseBinDao {
    private final DSLContext dsl;

    public TestCaseBinDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public GridResponse getDeletedNodesGrid(GridRequest request, Set<Long> libraryIds, Set<Long> nodeIds) {
        TestCaseBinGrid grid = new TestCaseBinGrid(libraryIds, nodeIds);
        return grid.getRows(request, this.dsl);
    }

    @Override
    public List<Long> getProjectIdsFromScope(NodeScope scope) {
        SelectConditionStep query = null;
        if (scope.hasLibraries()) {
            query = this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.TCL_ID.in(scope.getLibraryIds()));
        }
        if (scope.hasNodes()) {
            SelectConditionStep nodeQuery = this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(scope.getNodeIds()));
            Object object = query = query == null ? nodeQuery : query.union((Select)nodeQuery);
        }
        if (query == null) {
            return List.of();
        }
        return query.fetchInto(Long.class);
    }

    @Override
    public Map<Long, Long> findFirstAncestorsWithDeletedDescendants(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Map.of();
        }
        TclnRelationshipClosure ancestorClosure = Tables.TCLN_RELATIONSHIP_CLOSURE.as("ancestor_closure");
        CommonTableExpression ancestorWithDeletedTables = DSL.name((String)"ancestor_with_deleted_node").fields("ANCESTOR_ID", "TCLN_ID", "DEPTH").as((ResultQuery)DSL.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds)).and(DSL.exists((Select)DSL.selectOne().from((TableLike)ancestorClosure).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(ancestorClosure.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(ancestorClosure.ANCESTOR_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).and(Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON.isNotNull().and(ancestorClosure.DEPTH.ne((Object)0)))))));
        CommonTableExpression rankedAncestor = DSL.name((String)"ranked_ancestor").fields("ANCESTOR_ID", "TCLN_ID", "DEPTH", "RANK").as((ResultQuery)DSL.select((SelectField)ancestorWithDeletedTables.field("ANCESTOR_ID"), (SelectField)ancestorWithDeletedTables.field("TCLN_ID"), (SelectField)ancestorWithDeletedTables.field("DEPTH"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{ancestorWithDeletedTables.field("TCLN_ID")}).orderBy(new OrderField[]{ancestorWithDeletedTables.field("DEPTH")})).as("RANK")).from((TableLike)ancestorWithDeletedTables));
        return this.dsl.with(new CommonTableExpression[]{ancestorWithDeletedTables, rankedAncestor}).select((SelectField)rankedAncestor.field("TCLN_ID", Long.class), (SelectField)rankedAncestor.field("ANCESTOR_ID", Long.class)).from((TableLike)rankedAncestor).where(rankedAncestor.field("RANK", Integer.class).eq((Object)1)).fetchMap(rankedAncestor.field("TCLN_ID", Long.class), rankedAncestor.field("ANCESTOR_ID", Long.class));
    }

    @Override
    public List<Long> findLibraryIdsByNodeIds(Collection<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.TCL_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).fetchInto(Long.class);
    }

    @Override
    public Set<NodeReference> getParentReferences(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptySet();
        }
        return this.dsl.selectDistinct((SelectField)DSL.coalesce((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field[])new Field[]{Tables.PROJECT.TCL_ID}), (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.isNotNull()).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).fetch().stream().map(tuple -> new NodeReference((Boolean)tuple.value2() != false ? NodeType.TEST_CASE_FOLDER : NodeType.TEST_CASE_LIBRARY, (Long)tuple.value1())).collect(Collectors.toSet());
    }
}

