/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReferencePair;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.repository.JooqCallTestCaseDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.testcase.dto.TestCaseImportanceDto;

@Repository
public class JooqCallTestCaseDaoImpl
implements JooqCallTestCaseDao {
    private final DSLContext dslContext;

    public JooqCallTestCaseDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public List<Long> findCalledTestCaseIdsByCallerId(Long callerTestCaseId) {
        return this.dslContext.selectDistinct((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Object)callerTestCaseId)).fetch((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID);
    }

    @Override
    public List<Long> findCalledTestCaseIdsByCallTestStepIds(Collection<Long> testStepIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.CALL_TEST_STEP).where(Tables.CALL_TEST_STEP.TEST_STEP_ID.in(testStepIds)).fetch((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID);
    }

    @Override
    public Map<Long, List<Long>> findRecursiveCalledIdsByCallerIds(Collection<Long> callerTestCaseIds) {
        if (callerTestCaseIds == null || callerTestCaseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        CommonTableExpression cte = DSL.name((String)"CALLED_TABLE").fields("source_id", "called_id").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(callerTestCaseIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"CALLED_TABLE", "source_id"}), Long.class), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"CALLED_TABLE")).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field((Name)DSL.name((String[])new String[]{"CALLED_TABLE", "called_id"})).eq((Object)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"called_id", Long.class));
    }

    @Override
    public Map<Long, List<Long>> findRecursiveCallerIdsByCalledIds(Collection<Long> calledTestCaseIds) {
        if (calledTestCaseIds == null || calledTestCaseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        CommonTableExpression cte = DSL.name((String)"CALLING_TABLE").fields("source_id", "caller_id").as((ResultQuery)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(calledTestCaseIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"CALLING_TABLE", "source_id"}), Long.class), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from(DSL.name((String)"CALLING_TABLE")).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(DSL.field((Name)DSL.name((String[])new String[]{"CALLING_TABLE", "caller_id"})).eq((Object)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"caller_id", Long.class));
    }

    @Override
    public Map<Long, List<Long>> findTestCasesThatDelegatesParameters(Collection<Long> testCaseIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("source_id", "called_id").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.eq((Object)Boolean.TRUE))).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "source_id"}), Long.class), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"cte")).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "called_id"})).eq((Object)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.eq((Object)Boolean.TRUE)))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"called_id", Long.class));
    }

    @Override
    public Map<Long, List<Long>> findTestCaseIdsInheritParameters(Collection<Long> testCaseIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("source_id", "caller_id").as((ResultQuery)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(testCaseIds).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.eq((Object)Boolean.TRUE))).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "source_id"}), Long.class), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from(DSL.name((String)"cte")).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "caller_id"})).eq((Object)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"caller_id", Long.class));
    }

    @Override
    public Map<Long, List<TestCaseImportanceDto>> findRecursiveCallerImportanceByCalledIds(Collection<Long> calledTestCaseIds) {
        CommonTableExpression cte = DSL.name((String)"CALLING_TABLE").fields("called_id", "caller_id", "IS_IMPORTANCE_AUTO", "IMPORTANCE").as((ResultQuery)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.TEST_CASE.IMPORTANCE_AUTO, (SelectField)Tables.TEST_CASE.IMPORTANCE).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(calledTestCaseIds)).union((Select)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.TEST_CASE.IMPORTANCE_AUTO, (SelectField)Tables.TEST_CASE.IMPORTANCE).from(DSL.name((String)"CALLING_TABLE")).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(DSL.field((Name)DSL.name((String[])new String[]{"CALLING_TABLE", "caller_id"})).eq((Object)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchStream().collect(Collectors.groupingBy(result -> (Long)result.get("called_id", Long.class), Collectors.mapping(result -> new TestCaseImportanceDto((Long)result.get("caller_id", Long.class), (Boolean)result.get("IS_IMPORTANCE_AUTO", Boolean.class), TestCaseImportance.valueOf((String)((String)result.get("IMPORTANCE", String.class)))), Collectors.toList())));
    }

    @Override
    public List<NamedReferencePair> findRecursiveTestCasesCalls(Collection<Long> sourceIds) {
        TestCaseLibraryNode calledTestCase = Tables.TEST_CASE_LIBRARY_NODE.as("CALLED_NODE");
        TestCaseLibraryNode callerTestCase = Tables.TEST_CASE_LIBRARY_NODE.as("CALLER_NODE");
        CommonTableExpression cte = DSL.name((String)"CALL_TREE").fields("CALLER", "CALLED").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(sourceIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String)"CALLED"), Long.class), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"CALL_TREE")).join((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field((Name)DSL.name((String)"CALLED"), Long.class).eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).select((SelectField)cte.field(DSL.name((String[])new String[]{"CALL_TREE", "CALLER"}), Long.class), (SelectField)callerTestCase.NAME.as("CALLER_NAME"), (SelectField)cte.field(DSL.name((String[])new String[]{"CALL_TREE", "CALLED"}), Long.class), (SelectField)calledTestCase.NAME.as("CALLED_NAME")).from((TableLike)cte).innerJoin((TableLike)callerTestCase).on(callerTestCase.TCLN_ID.eq(cte.field(DSL.name((String[])new String[]{"CALL_TREE", "CALLER"}), Long.class))).innerJoin((TableLike)calledTestCase).on(calledTestCase.TCLN_ID.eq(cte.field(DSL.name((String[])new String[]{"CALL_TREE", "CALLED"}), Long.class))).union((Select)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID.as("CALLER"), (SelectField)callerTestCase.NAME.as("CALLER_NAME"), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as("CALLED"), (SelectField)calledTestCase.NAME.as("CALLED_NAME")).from((TableLike)Tables.CALL_TEST_STEP).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).innerJoin((TableLike)callerTestCase).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)callerTestCase.TCLN_ID)).innerJoin((TableLike)calledTestCase).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)calledTestCase.TCLN_ID)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(sourceIds))).fetchStream().map(r -> new NamedReferencePair((Long)r.get("CALLER", Long.class), (String)r.get("CALLER_NAME", String.class), (Long)r.get("CALLED", Long.class), (String)r.get("CALLED_NAME", String.class))).toList();
    }
}

