/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.collection.DefaultSorting;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NamedReferencePair;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.foundation.collection.PagingUtils;
import org.squashtest.tm.service.internal.foundation.collection.SortingUtils;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;
import org.squashtest.tm.service.internal.repository.JooqCallTestCaseDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;
import org.squashtest.tm.service.internal.testcase.dto.TestCaseImportanceDto;

public class TestCaseDaoImpl
extends HibernateEntityDao<TestCase>
implements CustomTestCaseDao {
    private static final String UNCHECKED = "unchecked";
    private static final List<DefaultSorting> defaultVerifiedTcSorting = new LinkedList<DefaultSorting>();
    @Inject
    private DSLContext dsl;
    @Inject
    private JooqCallTestCaseDao jooqCallTestCaseDao;

    static {
        defaultVerifiedTcSorting.add(new DefaultSorting("TestCase.reference"));
        defaultVerifiedTcSorting.add(new DefaultSorting("TestCase.name"));
        ListUtils.unmodifiableList(defaultVerifiedTcSorting);
    }

    @Override
    public void safePersist(TestCase testCase) {
        if (testCase.getSteps().isEmpty()) {
            super.persist(testCase);
        } else {
            this.persistTestCaseAndSteps(testCase);
        }
    }

    @Override
    public void persistTestCaseAndSteps(TestCase testCase) {
        this.persistEntity(testCase);
    }

    @Override
    public List<TestCase> findAllCallingTestCases(long testCaseId, PagingAndSorting sorting) {
        Object orderBy = "";
        if (sorting != null) {
            orderBy = " order by " + sorting.getSortedAttribute() + " " + sorting.getSortOrder().getCode();
        }
        TypedQuery query = this.entityManager.createQuery("select distinct TestCase\nfrom CallTestStep callStep\ninner join callStep.testCase as TestCase\nwhere callStep.calledTestCase.id = :id" + (String)orderBy, TestCase.class).setParameter("id", (Object)testCaseId);
        if (sorting != null) {
            query.setMaxResults(sorting.getPageSize());
            query.setFirstResult(sorting.getFirstItemIndex());
        }
        return query.getResultList();
    }

    private List<NamedReference> findTestCaseDetails(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE.TCLN_ID.in(ids)).fetchInto(NamedReference.class);
    }

    @Override
    public List<NamedReferencePair> findTestCaseCallsUpstream(Collection<Long> testCaseIds) {
        List<NamedReferencePair> result = this.findTestCaseCallsDetails(testCaseIds, Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(testCaseIds));
        HashSet<Long> remainingIds = new HashSet<Long>(testCaseIds);
        for (NamedReferencePair pair : result) {
            remainingIds.remove(pair.getCalled().getId());
        }
        List<NamedReference> nonCalledReferences = this.findTestCaseDetails(remainingIds);
        for (NamedReference ref : nonCalledReferences) {
            result.add(new NamedReferencePair(null, null, ref.getId(), ref.getName()));
        }
        return result;
    }

    private List<NamedReferencePair> findTestCaseCallsDetails(Collection<Long> testCaseIds, Condition condition) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode callerLibraryNode = Tables.TEST_CASE_LIBRARY_NODE.as("caller_library_node");
        return this.dsl.select((SelectField)callerLibraryNode.TCLN_ID.as("caller_id"), (SelectField)callerLibraryNode.NAME.as("CALLER_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("called_id"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("CALLED_NAME")).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).innerJoin((TableLike)callerLibraryNode).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)callerLibraryNode.TCLN_ID)).where(condition).fetchInto(NamedReferencePair.class);
    }

    @Override
    public List<TestCase> findAllByVerifiedRequirementVersion(long verifiedId, PagingAndSorting sorting) {
        List<Sorting> effectiveSortings = this.createEffectiveSorting((Sorting)sorting);
        TypedQuery namedQuery = this.entityManager.createQuery("select TestCase, (\n    select min(m.endDate)\n    from TestCase tc\n    left join tc.milestones m\n    where tc.id = TestCase.id\n) as endDate\nfrom TestCase TestCase\ninner join TestCase.requirementVersionCoverages rvc\ninner join rvc.verifiedRequirementVersion RequirementVersion\ninner join RequirementVersion.requirement Requirement\njoin TestCase.project Project\nwhere RequirementVersion.id = :versionId", TestCase.class);
        String hql = ((org.hibernate.query.Query)namedQuery.unwrap(org.hibernate.query.Query.class)).getQueryString();
        hql = SortingUtils.addOrders(hql, effectiveSortings);
        Query q = this.entityManager.createQuery(hql);
        if (!sorting.shouldDisplayAll()) {
            PagingUtils.addPaging(q, (Paging)sorting);
        }
        q.setParameter("versionId", (Object)verifiedId);
        List raw = q.getResultList();
        ArrayList<TestCase> res = new ArrayList<TestCase>(raw.size());
        for (Object[] tuple : raw) {
            res.add((TestCase)tuple[0]);
        }
        if ("endDate".equals(sorting.getSortedAttribute())) {
            Collections.sort(res, new Comparator<TestCase>(){

                @Override
                public int compare(TestCase tc1, TestCase tc2) {
                    return TestCaseDaoImpl.this.compareTcMilestoneDate(tc1, tc2);
                }
            });
            if (sorting.getSortOrder() == SortOrder.ASCENDING) {
                Collections.reverse(res);
            }
        }
        return res;
    }

    @Override
    public List<Long> findAllTestCaseAssociatedToTAScriptByProject(Long projectId) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId).and(Tables.TEST_CASE.TA_TEST.isNotNull()).and(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.isNull())).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public Integer countScriptedTestCaseAssociatedToTAScriptByProject(Long projectId) {
        return (Integer)((Record1)this.dsl.selectCount().from((TableLike)Tables.SCRIPTED_TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.TEST_CASE.TA_TEST.isNotNull()).fetchOne()).value1();
    }

    @Override
    public List<TestCase> findTestCaseByAutomationRequestIds(List<Long> requestIds) {
        return this.entityManager.createQuery("select tc from TestCase tc\njoin fetch tc.automationRequest ar\ninner join fetch ar.project pr\nwhere ar.id in :ids", TestCase.class).setParameter("ids", requestIds).getResultList();
    }

    @Override
    public TestCase findTestCaseByUuid(String uuid) {
        try {
            return (TestCase)this.entityManager.createQuery("select tc\nfrom TestCase tc\nwhere tc.uuid = :uuid", TestCase.class).setParameter("uuid", (Object)uuid).getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public List<String> retrieveFullNameByTestCaseLibraryNodeIds(List<Long> testCaseLibrayNodeIds, List<Long> projectIds) {
        Field fullName = DSL.when((Condition)Tables.TEST_CASE.REFERENCE.isNull().or(Tables.TEST_CASE.REFERENCE.eq((Object)"")), (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.TEST_CASE.REFERENCE, DSL.val((String)" - "), Tables.TEST_CASE_LIBRARY_NODE.NAME}));
        return this.dsl.select((SelectField)fullName).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(testCaseLibrayNodeIds)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)fullName).fetch(fullName);
    }

    @Override
    public List<TestCase> findAllByIdsWithProject(List<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc\nfrom TestCase tc\ninner join fetch tc.project pr\nleft join fetch pr.testAutomationProjects\nwhere tc.id in :ids", TestCase.class).setParameter("ids", testCaseIds).getResultList();
    }

    private int compareTcMilestoneDate(TestCase tc1, TestCase tc2) {
        boolean isEmpty1 = tc1.getMilestones().isEmpty();
        boolean isEmpty2 = tc2.getMilestones().isEmpty();
        if (isEmpty1 && isEmpty2) {
            return 0;
        }
        if (isEmpty1) {
            return 1;
        }
        if (isEmpty2) {
            return -1;
        }
        return this.getMinDate(tc1).before(this.getMinDate(tc2)) ? (this.getMinDate(tc1).after(this.getMinDate(tc2)) ? 0 : 1) : -1;
    }

    private Date getMinDate(TestCase tc) {
        return Collections.min(tc.getMilestones(), new Comparator<Milestone>(){

            @Override
            public int compare(Milestone m1, Milestone m2) {
                return m1.getEndDate().before(m2.getEndDate()) ? -1 : 1;
            }
        }).getEndDate();
    }

    private List<Sorting> createEffectiveSorting(Sorting userSorting) {
        LinkedList<DefaultSorting> sortings = new LinkedList<DefaultSorting>(defaultVerifiedTcSorting);
        ListIterator iterator = sortings.listIterator();
        while (iterator.hasNext()) {
            Sorting defaultSorting = (Sorting)iterator.next();
            if (!defaultSorting.getSortedAttribute().equals(userSorting.getSortedAttribute())) continue;
            iterator.remove();
            break;
        }
        sortings.addFirst((DefaultSorting)userSorting);
        return sortings;
    }

    @Override
    public long countByVerifiedRequirementVersion(long verifiedId) {
        return this.dsl.fetchCount((Select)DSL.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Object)verifiedId)));
    }

    @Override
    public List<TestCase> findUnsortedAllByVerifiedRequirementVersion(long requirementVersionId) {
        return this.entityManager.createQuery("select tc from TestCase tc\njoin tc.requirementVersionCoverages rvc\njoin rvc.verifiedRequirementVersion vr\nwhere vr.id = :id", TestCase.class).setParameter("id", (Object)requirementVersionId).getResultList();
    }

    @Override
    public List<Long> findAllTestCaseIdsByLibraries(Collection<Long> libraryIds) {
        if (libraryIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.TCL_ID.in(libraryIds)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public List<Long> findAllTestCaseIdsByNodeIds(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public List<TestCase> findAllLinkedToIteration(List<Long> nodeIds) {
        return this.entityManager.createQuery("select tc\nfrom TestPlanItem item\njoin item.referencedTestCase tc\nwhere tc.id in :ids", TestCase.class).setParameter("ids", nodeIds).getResultList();
    }

    @Override
    public List<Long> findAllEligibleTestCaseIds(List<Long> testCaseIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE.TCLN_ID.in(testCaseIds)).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public Map<Long, String> findAllAutomatableTestCasesByProjectId(long projectId) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.AUTOMATION_REQUEST.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.AUTOMATION_REQUEST_ID)).where(Tables.AUTOMATION_REQUEST.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).fetchMap((Field)Tables.TEST_CASE.TCLN_ID, (Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS);
    }

    @Override
    public List<Long> findAllTCIdsForActiveMilestoneInList(Long activeMilestoneId, List<Long> testCaseIds) {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID).from((TableLike)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Object)activeMilestoneId)).and(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds)).fetch((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID);
    }

    @Override
    public Map<Long, String> findTestCaseExecutionModesByTestCaseIds(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.TEST_CASE.EXECUTION_MODE).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE.TCLN_ID.in(testCaseIds)).fetchMap((Field)Tables.TEST_CASE.TCLN_ID, (Field)Tables.TEST_CASE.EXECUTION_MODE);
    }

    @Override
    public List<Long> filterTestCaseIdsWithLockedMilestone(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID).from((TableLike)Tables.MILESTONE_TEST_CASE).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name()))).union((Select)DSL.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name())))).fetchInto(Long.class);
    }

    @Override
    public Map<TestCase, List<Dataset>> findTestCaseAndDatasets(Map<Long, List<Long>> datasetIdsByTestCaseId) {
        ArrayList<Long> testCaseIds = new ArrayList<Long>(datasetIdsByTestCaseId.keySet());
        List datasetIds = datasetIdsByTestCaseId.values().stream().flatMap(Collection::stream).distinct().toList();
        return this.entityManager.createQuery("select tc, ds\nfrom TestCase tc\nleft join tc.datasets ds\nwhere tc.id in :ids and (ds is null or ds.id in :datasetIds)", Object[].class).setParameter("ids", testCaseIds).setParameter("datasetIds", datasetIds).getResultStream().collect(Collectors.groupingBy(objects -> (TestCase)objects[0], Collectors.mapping(objects -> (Dataset)objects[1], Collectors.toList())));
    }

    @Override
    public Map<Long, TestCase> findTestCasesWithDatasetsByIds(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc from TestCase tc left join fetch tc.datasets where tc.id in :ids", TestCase.class).setParameter("ids", testCaseIds).getResultStream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
    }

    @Override
    public List<String> filterExistingTestCaseUuids(Collection<String> uuids) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.UUID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE.UUID.in(uuids)).fetchInto(String.class);
    }

    @Override
    public Map<Long, List<TestCase>> findRecursiveCallerTestCasesByCalledId(Collection<Long> calledIds) {
        Map<Long, List<Long>> callerIdsByCalledId = this.jooqCallTestCaseDao.findRecursiveCallerIdsByCalledIds(calledIds);
        Set allCallerIds = callerIdsByCalledId.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (allCallerIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map callerTestCaseById = this.entityManager.createQuery("SELECT DISTINCT tc FROM TestCase tc WHERE tc.id IN :ids", TestCase.class).setParameter("ids", allCallerIds).getResultStream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        return callerIdsByCalledId.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(callerId -> Map.entry((Long)entry.getKey(), (TestCase)callerTestCaseById.get(callerId))).filter(e -> e.getValue() != null)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    @Override
    public Map<Long, String> findNameByTestCaseId(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id, tc.name from TestCase tc where tc.id in :ids", Object[].class).setParameter("ids", testCaseIds).getResultStream().collect(Collectors.toMap(r -> (Long)r[0], r -> (String)r[1]));
    }

    @Override
    public List<TestCaseImportanceDto> findTestCaseImportanceDto(Collection<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.TEST_CASE.IMPORTANCE_AUTO, (SelectField)Tables.TEST_CASE.IMPORTANCE).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE.TCLN_ID.in(testCaseIds)).fetchStream().map(r -> new TestCaseImportanceDto((Long)r.get((Field)Tables.TEST_CASE.TCLN_ID), (Boolean)r.get((Field)Tables.TEST_CASE.IMPORTANCE_AUTO), TestCaseImportance.valueOf((String)((String)r.get((Field)Tables.TEST_CASE.IMPORTANCE))))).toList();
    }

    @Override
    public Pair<EntityType, Long> findParentTypeByTestCaseId(Long testCaseId) {
        Record2 result = (Record2)this.dsl.select((SelectField)Tables.PROJECT.TCL_ID, (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Object)testCaseId)).fetchOne();
        if (Objects.isNull(result)) {
            throw new EntityNotFoundException("Test case with id %s not found.".formatted(testCaseId));
        }
        if (result.get((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID) == null) {
            return Pair.of((Object)EntityType.TEST_CASE_FOLDER, (Object)((Long)result.get((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)));
        }
        return Pair.of((Object)EntityType.TEST_CASE_LIBRARY, (Object)((Long)result.get((Field)Tables.PROJECT.TCL_ID)));
    }

    @Override
    public List<TestCase> loadNodeForPaste(Collection<Long> ids) {
        List<TestCase> testCases = NestedEntityGraphQueryBuilder.of(this.entityManager, TestCase.class, "select tc from TestCase tc where tc.id in :ids", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("project"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("attachmentList"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content"))), NestedEntityGraphQueryBuilder.GraphDefinition.attr("nature"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("type"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("scmRepository"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("automatedTestTechnology"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("automatedTest"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("automatedTest", NestedEntityGraphQueryBuilder.GraphDefinition.attr("project")))).executeDistinctList(Map.of("ids", ids));
        this.entityManager.createQuery("select tc\nfrom TestCase tc\nleft join fetch tc.steps s\nleft join fetch treat(s as ActionTestStep).attachmentList al\nleft join fetch al.attachments a\nleft join fetch a.content\nwhere tc.id in :ids\n", TestCase.class).setParameter("ids", ids).getResultList();
        List<Long> keywordTcIds = testCases.stream().filter(KeywordTestCase.class::isInstance).map(TestCaseLibraryNode::getId).toList();
        if (!keywordTcIds.isEmpty()) {
            this.entityManager.createQuery("select tc\nfrom TestCase tc\nleft join fetch tc.steps s\nleft join fetch treat(s as KeywordTestStep).paramValues pv\nleft join fetch pv.actionWordParam ap\nleft join fetch ap.actionWord\nwhere tc.id in :ids\n", TestCase.class).setParameter("ids", keywordTcIds).getResultList();
        }
        this.entityManager.createQuery("select tc\nfrom TestCase tc\nleft join fetch tc.parameters\nwhere tc.id in :ids\n", TestCase.class).setParameter("ids", ids).getResultList();
        this.entityManager.createQuery("select tc\nfrom TestCase tc\nleft join fetch tc.datasets d\nleft join fetch d.parameterValues\nwhere tc.id in :ids\n", TestCase.class).setParameter("ids", ids).getResultList();
        NestedEntityGraphQueryBuilder.of(this.entityManager, TestCase.class, "select tc from TestCase tc where tc.id in :ids", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("milestones"))).executeDistinctList(Map.of("ids", ids));
        this.entityManager.createQuery("select tc\nfrom TestCase tc\nleft join fetch tc.requirementVersionCoverages c\nleft join fetch c.verifiedRequirementVersion rv\nleft join fetch c.verifyingSteps cs\nwhere tc.id in :ids\n", TestCase.class).setParameter("ids", ids).getResultList();
        boolean hasAutomatedTest = testCases.stream().anyMatch(tc -> tc.getAutomatedTest() != null);
        if (hasAutomatedTest) {
            NestedEntityGraphQueryBuilder.of(this.entityManager, Project.class, "select p from Project p where p = :id", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("testAutomationProjects"))).executeDistinctList(Map.of("id", testCases.getFirst().getProject()));
        }
        return testCases;
    }
}

