/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.exception.requirement.RequirementVersionNotLinkableException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.foundation.collection.PagingUtils;
import org.squashtest.tm.service.internal.foundation.collection.SortingUtils;
import org.squashtest.tm.service.internal.repository.CustomRequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

public class RequirementVersionCoverageDaoImpl
extends HibernateEntityDao<RequirementVersionCoverage>
implements CustomRequirementVersionCoverageDao {
    private static final String COVIDS = "covIds";
    @Inject
    private DSLContext dslContext;

    @Override
    public List<RequirementVersionCoverage> findAllByTestCaseId(long testCaseId, PagingAndSorting pas) {
        TypedQuery namedquery = this.entityManager.createNamedQuery("RequirementVersionCoverage.findAllByTestCaseId", Object.class);
        String hql = ((org.hibernate.query.Query)namedquery.unwrap(org.hibernate.query.Query.class)).getQueryString();
        hql = SortingUtils.addOrder(hql, (Sorting)pas);
        Query q = this.entityManager.createQuery(hql);
        if (!pas.shouldDisplayAll()) {
            PagingUtils.addPaging(q, (Paging)pas);
        }
        q.setParameter("testCaseId", (Object)testCaseId);
        List raw = q.getResultList();
        ArrayList<RequirementVersionCoverage> res = new ArrayList<RequirementVersionCoverage>(raw.size());
        for (Object[] tuple : raw) {
            res.add((RequirementVersionCoverage)tuple[0]);
        }
        return res;
    }

    @Override
    public List<RequirementVersion> findDistinctRequirementVersionsByTestCases(Collection<Long> testCaseIds, PagingAndSorting pagingAndSorting) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery namedquery = this.entityManager.createNamedQuery("RequirementVersion.findDistinctRequirementVersionsByTestCases", Object.class);
        String hql = ((org.hibernate.query.Query)namedquery.unwrap(org.hibernate.query.Query.class)).getQueryString();
        hql = SortingUtils.addOrder(hql, (Sorting)pagingAndSorting);
        Query q = this.entityManager.createQuery(hql);
        if (!pagingAndSorting.shouldDisplayAll()) {
            PagingUtils.addPaging(q, (Paging)pagingAndSorting);
        }
        q.setParameter("testCaseIds", testCaseIds);
        List raw = q.getResultList();
        ArrayList<RequirementVersion> res = new ArrayList<RequirementVersion>(raw.size());
        for (Object[] tuple : raw) {
            res.add((RequirementVersion)tuple[0]);
        }
        if ("endDate".equals(pagingAndSorting.getSortedAttribute())) {
            Collections.sort(res, new Comparator<RequirementVersion>(){

                @Override
                public int compare(RequirementVersion req1, RequirementVersion req2) {
                    return RequirementVersionCoverageDaoImpl.this.compareReqMilestoneDate(req1, req2);
                }
            });
            if (pagingAndSorting.getSortOrder() == SortOrder.ASCENDING) {
                Collections.reverse(res);
            }
        }
        return res;
    }

    private int compareReqMilestoneDate(RequirementVersion req1, RequirementVersion req2) {
        boolean isEmpty1 = req1.getMilestones().isEmpty();
        boolean isEmpty2 = req2.getMilestones().isEmpty();
        if (isEmpty1 && isEmpty2) {
            return 0;
        }
        if (isEmpty1) {
            return 1;
        }
        if (isEmpty2) {
            return -1;
        }
        return this.getMinDate(req1).before(this.getMinDate(req2)) ? (this.getMinDate(req1).after(this.getMinDate(req2)) ? 0 : 1) : -1;
    }

    private Date getMinDate(RequirementVersion req) {
        return Collections.min(req.getMilestones(), new Comparator<Milestone>(){

            @Override
            public int compare(Milestone m1, Milestone m2) {
                return m1.getEndDate().before(m2.getEndDate()) ? -1 : 1;
            }
        }).getEndDate();
    }

    @Override
    @Transactional(readOnly=true)
    public List<RequirementVersion> findDistinctRequirementVersionsByTestCases(Collection<Long> testCaseIds) {
        DefaultPagingAndSorting pas = new DefaultPagingAndSorting("RequirementVersion.name", true);
        return this.findDistinctRequirementVersionsByTestCases(testCaseIds, (PagingAndSorting)pas);
    }

    @Override
    public void delete(List<Long> requirementVersionCoverageIds) {
        this.removeTestSTepByCoverageIds(requirementVersionCoverageIds);
        this.entityManager.createNamedQuery("requirementDeletionDao.deleteVersionCoverages").setParameter(COVIDS, requirementVersionCoverageIds).executeUpdate();
    }

    @Override
    public void removeTestSTepByCoverageIds(List<Long> requirementVersionCoverageIds) {
        String sql = "delete from VERIFYING_STEPS where requirement_version_coverage_id in :covIds";
        this.entityManager.createNativeQuery(sql).setParameter(COVIDS, requirementVersionCoverageIds).executeUpdate();
        this.entityManager.flush();
    }

    @Override
    public void removeTestStepCoverageByCoverageIdsAndTestStepId(List<Long> requirementVersionCoverageIds, Long testStepId) {
        String sql = "DELETE FROM VERIFYING_STEPS\nWHERE requirement_version_coverage_id IN (:covIds)\n  AND test_step_id = :testStepId\n";
        this.entityManager.createNativeQuery(sql).setParameter(COVIDS, requirementVersionCoverageIds).setParameter("testStepId", (Object)testStepId).executeUpdate();
        this.entityManager.flush();
    }

    @Override
    public List<Long> byTestCaseAndRequirementVersions(Collection<Long> reqVerCovIds, long testCaseId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Object)testCaseId).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(reqVerCovIds))).fetchInto(Long.class);
    }

    @Override
    public List<Long> byRequirementVersionAndTestCases(Collection<Long> testCaseIds, long resourceId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Object)resourceId))).fetchInto(Long.class);
    }

    @Override
    public void checkIfReqVersionIsLinkable(long reqVersionId) {
        RequirementStatus status;
        String result = (String)this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)reqVersionId)).fetchOneInto(String.class);
        if (result != null && !(status = RequirementStatus.valueOf((String)result)).isRequirementLinkable()) {
            throw new RequirementVersionNotLinkableException(Long.valueOf(reqVersionId));
        }
    }

    @Override
    public List<Long> byRequirementVersionsAndTestStep(Collection<Long> rvIds, long stepId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).join((TableLike)Tables.VERIFYING_STEPS).on(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).where(Tables.VERIFYING_STEPS.TEST_STEP_ID.eq((Object)stepId).and(Tables.REQUIREMENT_VERSION.RES_ID.in(rvIds))).fetchInto(Long.class);
    }

    @Override
    public Map<Long, List<Long>> findVerifiedTestCaseIdsByVersionIds(Set<Long> versionIds) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(versionIds)).fetchGroups((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID, (Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID);
    }

    @Override
    public Map<Long, Map<Long, Long>> findExistingCoveragesByRequirementIds(Collection<Long> requirementIds) {
        Table sub = this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID.as("COVERAGE_ID"), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.as("TEST_CASE_ID"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.REQUIREMENT_VERSION.REQUIREMENT_ID}).orderBy(new OrderField[]{Tables.REQUIREMENT_VERSION.VERSION_NUMBER.desc()})).as("ROW_NUMBER")).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementIds)).asTable();
        return this.dslContext.select((SelectField)sub.field("REQUIREMENT_ID"), (SelectField)sub.field("COVERAGE_ID"), (SelectField)sub.field("TEST_CASE_ID")).from((TableLike)sub).where(sub.field("ROW_NUMBER", Integer.class).eq((Object)1)).fetchStream().collect(Collectors.groupingBy(r -> (Long)r.get(sub.field("REQUIREMENT_ID", Long.class)), Collectors.toMap(r -> (Long)r.get(sub.field("TEST_CASE_ID", Long.class)), r -> (Long)r.get(sub.field("COVERAGE_ID", Long.class)))));
    }
}

