/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.milestone.QMilestone;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.BindableProjectToMilestoneDto;
import org.squashtest.tm.service.internal.repository.CustomMilestoneDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.AttachmentListQueryBuilder;

public class MilestoneDaoImpl
implements CustomMilestoneDao {
    private static final String FIND_TEST_CASES_WITH_MILESTONES_HAVING_STATUSES = "testCase.findTestCasesWithMilestonesHavingStatuses";
    private static final String CAMPAIGN_ID = "campaignId";
    private static final String VERSION_ID = "versionId";
    private static final String VALID_STATUS = "validStatus";
    private static final String MILESTONE_IDS = "milestoneIds";
    private static final String MILESTONE_ID = "milestoneId";
    private static final String PROJECT_IDS = "projectIds";
    private static final String PROJECT_ID = "projectId";
    private static final Logger LOGGER = LoggerFactory.getLogger(MilestoneDaoImpl.class);
    private static final int BATCH_UPDATE_SIZE = 50;
    private static final String UNCHECKED = "unchecked";
    private static final String TESTCASE_ID = "testCaseId";
    private static final String TESTCASE_IDS = "testCaseIds";
    private static final String ABOUT_TO_FETCH_ENTITIES = "About to fetch entities {}";
    private static final String FETCHING_BOUND_ENTITIES = "Fetching bound entities with query named {}";
    private static final String STATUSES = "statuses";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;

    @Override
    public Collection<Milestone> findAssociableMilestonesForTestCase(long testCaseId) {
        Query query = this.entityManager.createNamedQuery("milestone.findAssociableMilestonesForTestCase");
        query.setParameter(TESTCASE_ID, (Object)testCaseId);
        query.setParameter(VALID_STATUS, (Object)MilestoneStatus.getAllStatusAllowingObjectBind());
        return query.getResultList();
    }

    @Override
    public void checkBlockingMilestonesOnAttachmentList(EntityType holderType, long attachmentListId) {
        boolean containLockedMilestones;
        AttachmentListQueryBuilder builder = new AttachmentListQueryBuilder();
        if (!builder.isLockedMilestonesQuerySupported(holderType)) {
            return;
        }
        String baseQuery = builder.getLockedMilestonesQuery(holderType);
        Query query = this.entityManager.createQuery(baseQuery);
        query.setParameter("attachmentListId", (Object)attachmentListId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        boolean bl = containLockedMilestones = !query.getResultList().isEmpty();
        if (containLockedMilestones) {
            throw new MilestoneForbidModificationException("This element is bound to a locked milestone. It can't be modified");
        }
    }

    @Override
    public List<Long> findAllMilestoneIds() {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE.MILESTONE_ID).from((TableLike)Tables.MILESTONE).fetch((Field)Tables.MILESTONE.MILESTONE_ID, Long.class);
    }

    @Override
    public List<String> findMilestoneLabelByIds(List<Long> milestoneIds, List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_BINDING).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_BINDING.MILESTONE_ID)).where(Tables.MILESTONE.MILESTONE_ID.in(milestoneIds)).and(Tables.MILESTONE_BINDING.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.MILESTONE.LABEL).fetch((Field)Tables.MILESTONE.LABEL);
    }

    @Override
    public List<Long> findMilestoneIdsForUsers(Collection<Long> partyIds) {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE_BINDING.MILESTONE_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_CLASS.ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.CLASS_ID)).join((TableLike)Tables.MILESTONE_BINDING).on(Tables.ACL_OBJECT_IDENTITY.IDENTITY.eq((Field)Tables.MILESTONE_BINDING.PROJECT_ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)"org.squashtest.tm.domain.project.Project"))).fetch((Field)Tables.MILESTONE_BINDING.MILESTONE_ID, Long.class);
    }

    @Override
    public Collection<Milestone> findAllMilestonesForTestCase(long testCaseId) {
        Query query1 = this.entityManager.createNamedQuery("milestone.findTestCaseMilestones");
        query1.setParameter(TESTCASE_ID, (Object)testCaseId);
        return query1.getResultList();
    }

    @Override
    public boolean isTestCaseMilestoneDeletable(long testCaseId) {
        return this.doesTestCaseBelongToMilestonesWithStatus(testCaseId, MilestoneStatus.PLANNED, MilestoneStatus.LOCKED);
    }

    @Override
    public boolean isTestCaseMilestoneModifiable(long testCaseId) {
        return this.doesTestCaseBelongToMilestonesWithStatus(testCaseId, MilestoneStatus.PLANNED, MilestoneStatus.LOCKED);
    }

    @Override
    public List<Long> findTestCaseIdsBoundToBlockingMilestone(Collection<Long> testCaseIds) {
        return this.entityManager.createNamedQuery(FIND_TEST_CASES_WITH_MILESTONES_HAVING_STATUSES, Long.class).setParameter(TESTCASE_IDS, testCaseIds).setParameter(STATUSES, Arrays.asList(MilestoneStatus.PLANNED, MilestoneStatus.LOCKED)).getResultList();
    }

    @Override
    public boolean isActiveMilestoneABlockingMilestone(long activeMilestoneId) {
        return this.doesActiveMilestoneBelongToMilestoneWithStatus(activeMilestoneId, MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
    }

    @Override
    public boolean areTestCasesBoundToBlockingMilestone(Collection<Long> testCaseIds) {
        Query query = this.entityManager.createNamedQuery(FIND_TEST_CASES_WITH_MILESTONES_HAVING_STATUSES);
        query.setParameter(TESTCASE_IDS, testCaseIds);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    private boolean doesTestCaseBelongToMilestonesWithStatus(long testCaseId, MilestoneStatus ... statuses) {
        TypedQuery query = this.entityManager.createNamedQuery(FIND_TEST_CASES_WITH_MILESTONES_HAVING_STATUSES, Long.class);
        query.setParameter(TESTCASE_IDS, Collections.singletonList(testCaseId));
        query.setParameter(STATUSES, Arrays.asList(statuses));
        List ids = query.getResultList();
        return ids.contains(testCaseId);
    }

    private boolean doesActiveMilestoneBelongToMilestoneWithStatus(long activeMilestoneId, List<MilestoneStatus> statuses) {
        TypedQuery query = this.entityManager.createNamedQuery("milestone.findAllByStatus", Long.class);
        query.setParameter(MILESTONE_IDS, Collections.singletonList(activeMilestoneId));
        query.setParameter(STATUSES, statuses);
        List ids = query.getResultList();
        return ids.contains(activeMilestoneId);
    }

    @Override
    public Collection<Milestone> findAssociableMilestonesForRequirementVersion(long versionId) {
        Query q = this.entityManager.createNamedQuery("milestone.findAssociableMilestonesForRequirementVersion");
        q.setParameter(VERSION_ID, (Object)versionId);
        q.setParameter(VALID_STATUS, (Object)MilestoneStatus.getAllStatusAllowingObjectBind());
        return q.getResultList();
    }

    @Override
    public Collection<Milestone> findAssociableMilestonesForCampaign(long campaignId) {
        Query q = this.entityManager.createNamedQuery("milestone.findAssociableMilestonesForCampaign");
        q.setParameter(VALID_STATUS, (Object)MilestoneStatus.getAllStatusAllowingObjectBind());
        q.setParameter(CAMPAIGN_ID, (Object)campaignId);
        return q.getResultList();
    }

    @Override
    public void bindMilestoneToProjectTestCases(long projectId, long milestoneId) {
        Session session = (Session)this.entityManager.unwrap(Session.class);
        org.hibernate.query.Query query = session.createNamedQuery("BoundEntityDao.findAllTestCasesForProject", TestCase.class);
        query.setParameter(PROJECT_ID, (Object)projectId);
        ScrollableResults tcs = this.scrollableResults(query);
        this.bindTestCases(milestoneId, tcs);
    }

    @Override
    public void bindMilestoneToProjectRequirementVersions(long projectId, long milestoneId) {
        Session session = (Session)this.entityManager.unwrap(Session.class);
        org.hibernate.query.Query query = session.createNamedQuery("milestone.findLastNonObsoleteReqVersionsForProject", RequirementVersion.class);
        query.setParameter(PROJECT_ID, (Object)projectId);
        ScrollableResults reqVersions = this.scrollableResults(query);
        this.bindRequirementVersions(milestoneId, reqVersions);
    }

    private void bindRequirementVersions(long milestoneId, ScrollableResults<RequirementVersion> reqVersions) {
        Milestone milestone = (Milestone)this.entityManager.find(Milestone.class, (Object)milestoneId);
        int count = 0;
        while (reqVersions.next()) {
            RequirementVersion reqV = (RequirementVersion)reqVersions.get();
            milestone.bindRequirementVersion(reqV);
            if (++count % 50 != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
            milestone = (Milestone)this.entityManager.find(Milestone.class, (Object)milestoneId);
        }
    }

    @Override
    public void synchronizeRequirementVersions(long source, long target, List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return;
        }
        Session session = (Session)this.entityManager.unwrap(Session.class);
        org.hibernate.query.Query query = session.createNamedQuery("milestone.findAllRequirementVersionsForProjectAndMilestone", RequirementVersion.class);
        query.setParameterList(PROJECT_IDS, projectIds);
        query.setParameter(MILESTONE_ID, (Object)source);
        ScrollableResults reqVersions = this.scrollableResults(query);
        this.bindRequirementVersions(target, reqVersions);
    }

    @Override
    public void synchronizeTestCases(long source, long target, List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return;
        }
        Session session = (Session)this.entityManager.unwrap(Session.class);
        org.hibernate.query.Query query = session.createNamedQuery("milestone.findAllTestCasesForProjectAndMilestone", TestCase.class);
        query.setParameterList(PROJECT_IDS, projectIds);
        query.setParameter(MILESTONE_ID, (Object)source);
        ScrollableResults tcs = this.scrollableResults(query);
        this.bindTestCases(target, tcs);
    }

    private void bindTestCases(long targetMilestone, ScrollableResults<TestCase> testCases) {
        Milestone milestone = (Milestone)this.entityManager.find(Milestone.class, (Object)targetMilestone);
        int count = 0;
        while (testCases.next()) {
            TestCase tc = (TestCase)testCases.get();
            milestone.bindTestCase(tc);
            if (++count % 50 != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
            milestone = (Milestone)this.entityManager.find(Milestone.class, (Object)targetMilestone);
        }
    }

    private <T> ScrollableResults<T> scrollableResults(org.hibernate.query.Query<T> query) throws HibernateException {
        return query.setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
    }

    @Override
    public void performBatchUpdate(CustomMilestoneDao.HolderConsumer consumer) {
        LOGGER.info("About to perform a Milestone Holder batch update", new Object[0]);
        String[] entities = new String[]{"TestCase", "RequirementVersion", "Campaign"};
        Session session = (Session)this.entityManager.unwrap(Session.class);
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            LOGGER.info(ABOUT_TO_FETCH_ENTITIES, new Object[]{entity});
            String namedQuery = entity + ".findAllWithMilestones";
            LOGGER.debug(FETCHING_BOUND_ENTITIES, new Object[]{namedQuery});
            ScrollableResults holders = this.scrollableResults(session.createNamedQuery(namedQuery, MilestoneHolder.class));
            int count = 0;
            while (holders.next()) {
                MilestoneHolder holder = (MilestoneHolder)holders.get();
                consumer.consume(holder);
                if (++count % 50 != 0) continue;
                session.flush();
                session.clear();
            }
            ++n2;
        }
        LOGGER.info("Done with Milestone Holder batch update", new Object[0]);
    }

    @Override
    public boolean isBoundToAtleastOneObject(long milestoneId) {
        Query query = this.entityManager.createNamedQuery("milestone.countBoundObject");
        query.setParameter(MILESTONE_ID, (Object)milestoneId);
        int count = (Integer)query.getSingleResult();
        return count != 0;
    }

    @Override
    public void unbindAllObjectsForProject(Long milestoneId, Long projectId) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        this.unbindAllObjectsForProjects(milestoneId, projectIds);
    }

    @Override
    public void unbindAllObjectsForProjects(Long milestoneId, List<Long> projectIds) {
        String[] entities = new String[]{"TestCases", "RequirementVersions", "Campaigns"};
        Session session = (Session)this.entityManager.unwrap(Session.class);
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            LOGGER.info(ABOUT_TO_FETCH_ENTITIES, new Object[]{entity});
            String namedQuery = "milestone.findAll" + entity + "ForProjectAndMilestone";
            LOGGER.debug(FETCHING_BOUND_ENTITIES, new Object[]{namedQuery});
            org.hibernate.query.Query query = session.createNamedQuery(namedQuery, MilestoneHolder.class);
            query.setParameter(MILESTONE_ID, (Object)milestoneId);
            query.setParameterList(PROJECT_IDS, projectIds);
            ScrollableResults holders = this.scrollableResults(query);
            this.unbindFromMilestone(milestoneId, session, holders);
            ++n2;
        }
    }

    private void unbindFromMilestone(Long milestoneId, Session session, ScrollableResults<MilestoneHolder> holders) {
        int count = 0;
        while (holders.next()) {
            MilestoneHolder holder = (MilestoneHolder)holders.get();
            holder.unbindMilestone(milestoneId);
            if (++count % 50 != 0) continue;
            this.flushAndClearSession(session);
        }
        this.flushAndClearSession(session);
    }

    private void flushAndClearSession(Session session) {
        session.flush();
    }

    @Override
    public void unbindAllObjects(long milestoneId) {
        String[] entities = new String[]{"TestCase", "RequirementVersion", "Campaign"};
        Session session = (Session)this.entityManager.unwrap(Session.class);
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            LOGGER.info(ABOUT_TO_FETCH_ENTITIES, new Object[]{entity});
            String namedQuery = entity + ".findAllBoundToMilestone";
            LOGGER.debug(FETCHING_BOUND_ENTITIES, new Object[]{namedQuery});
            org.hibernate.query.Query query = session.createNamedQuery(namedQuery, MilestoneHolder.class);
            query.setParameter(MILESTONE_ID, (Object)milestoneId);
            ScrollableResults holders = this.scrollableResults(query);
            this.unbindFromMilestone(milestoneId, session, holders);
            ++n2;
        }
    }

    @Override
    public boolean isMilestoneBoundToACampainInProjects(Long milestoneId, List<Long> projectIds) {
        Query query = this.entityManager.createNamedQuery("milestone.countCampaignsForProjectAndMilestone");
        query.setParameter(PROJECT_IDS, projectIds);
        query.setParameter(MILESTONE_ID, (Object)milestoneId);
        return (Long)query.getSingleResult() > 0L;
    }

    @Override
    public boolean isMilestoneBoundToOneObjectOfProject(Long milestoneId, Long projectId) {
        return this.isMilestoneBoundToOneTestCaseOfProject(milestoneId, projectId) || this.isMilestoneBoundToOneCampaignOfProject(milestoneId, projectId) || this.isMilestoneBoundToOneReqVersionOfProject(milestoneId, projectId);
    }

    private boolean isMilestoneBoundToOneTestCaseOfProject(Long milestoneId, Long projectId) {
        return this.dsl.fetchCount((Select)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.MILESTONE_BINDING).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Object)projectId)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Object)milestoneId))) > 0;
    }

    private boolean isMilestoneBoundToOneCampaignOfProject(Long milestoneId, Long projectId) {
        return this.dsl.fetchCount((Select)this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).from((TableLike)Tables.MILESTONE_BINDING).join((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Object)projectId)).and(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Object)milestoneId))) > 0;
    }

    private boolean isMilestoneBoundToOneReqVersionOfProject(Long milestoneId, Long projectId) {
        return this.dsl.fetchCount((Select)this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.MILESTONE_BINDING).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Object)projectId)).and(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Object)milestoneId))) > 0;
    }

    @Override
    public boolean isOneMilestoneAlreadyBindToAnotherRequirementVersion(List<Long> reqVIds, List<Long> milestoneIds) {
        if (reqVIds.isEmpty() || milestoneIds.isEmpty()) {
            return false;
        }
        Query query = this.entityManager.createNamedQuery("milestone.otherRequirementVersionBindToOneMilestone");
        query.setParameter("reqVIds", reqVIds);
        query.setParameter(MILESTONE_IDS, milestoneIds);
        return !query.getResultList().isEmpty();
    }

    @Override
    public Collection<Long> findTestCaseIdsBoundToMilestones(Collection<Long> milestoneIds) {
        QTestCase tc = QTestCase.testCase;
        QMilestone ms = QMilestone.milestone;
        return ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.entityManager).select((Expression)tc.id).from((EntityPath)tc)).innerJoin((CollectionExpression)tc.milestones, (Path)ms)).where((com.querydsl.core.types.Predicate)ms.id.in(milestoneIds))).fetch();
    }

    @Override
    public Collection<Long> findRequirementVersionIdsBoundToMilestones(Collection<Long> milestoneIds) {
        QRequirementVersion v = QRequirementVersion.requirementVersion;
        QMilestone ms = QMilestone.milestone;
        return ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.entityManager).select((Expression)v.id).from((EntityPath)v)).innerJoin((CollectionExpression)v.milestones, (Path)ms)).where((com.querydsl.core.types.Predicate)ms.id.in(milestoneIds))).fetch();
    }

    @Override
    public boolean isTestStepBoundToBlockingMilestone(long testStepId) {
        List<String> blockStatuses = MilestoneStatus.MILESTONE_BLOCKING_STATUSES.stream().map(Enum::name).toList();
        return this.dsl.fetchCount((Select)DSL.select((SelectField)Tables.MILESTONE.MILESTONE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.TEST_CASE_STEPS.STEP_ID.eq((Object)testStepId).and(Tables.MILESTONE.STATUS.in(blockStatuses)))) > 0;
    }

    @Override
    public boolean isParameterBoundToBlockingMilestone(long paramId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForParameter");
        query.setParameter("paramId", (Object)paramId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isDatasetBoundToBlockingMilestone(long datasetId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForDataset");
        query.setParameter("datasetId", (Object)datasetId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isDatasetParamValueBoundToBlockingMilestone(long datasetParamValueId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForDatasetParamValue");
        query.setParameter("datasetParamValueId", (Object)datasetParamValueId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isAttachmentListBoundToBlockingMilestone(long attachmentListId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForAttachmentList");
        query.setParameter("attachmentListId", (Object)attachmentListId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isAttachmentBoundToBlockingMilestone(long attachmentId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForAttachment");
        query.setParameter("attachmentId", (Object)attachmentId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isRequirementVersionBoundToBlockingMilestone(long requirementVersionId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForRequirementVersion");
        query.setParameter("requirementVersionId", (Object)requirementVersionId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean areRequirementsBoundToBlockingMilestone(Collection<Long> requirementIds) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForRequirements");
        query.setParameter("requirementIds", requirementIds);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isRequirementBoundToBlockingMilestone(long requirementId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForRequirement");
        query.setParameter("requirementId", (Object)requirementId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isCampaignBoundToBlockingMilestone(long campaignId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForCampaign");
        query.setParameter(CAMPAIGN_ID, (Object)campaignId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isIterationBoundToBlockingMilestone(long iterationId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForIteration");
        query.setParameter("iterationId", (Object)iterationId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isTestSuiteBoundToBlockingMilestone(long testSuiteId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForTestSuite");
        query.setParameter("testSuiteId", (Object)testSuiteId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean areCampaignsBoundToBlockingMilestone(Collection<Long> campaignIds) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForCampaigns");
        query.setParameter("campaignIds", campaignIds);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isCampaignTestPlanItemBoundToBlockingMilestone(long itemId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForCampaignTestPlanItems");
        query.setParameter("itemId", (Object)itemId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isExecutionBoundToBlockingMilestone(long executionId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForExecution");
        query.setParameter("executionId", (Object)executionId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean areExecutionsBoundToBlockingMilestone(List<Long> executionIds) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForExecutions");
        query.setParameter("executionIds", executionIds);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isExecutionStepBoundToBlockingMilestone(long executionStepId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForExecutionStep");
        query.setParameter("executionStepId", (Object)executionStepId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean isTestPlanItemBoundToBlockingMilestone(long itemId) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForTestPlanItem");
        query.setParameter("itemId", (Object)itemId);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean areTestSuitesBoundToBlockingMilestone(Collection<Long> testSuiteIds) {
        Query query = this.entityManager.createNamedQuery("Milestone.findLockedMilestonesForTestSuites");
        query.setParameter("testSuiteIds", testSuiteIds);
        query.setParameter(STATUSES, (Object)MilestoneStatus.MILESTONE_BLOCKING_STATUSES);
        return !query.getResultList().isEmpty();
    }

    @Override
    public void removeProjectFromAllPerimeters(Long projectId) {
        this.dsl.delete((Table)Tables.MILESTONE_BINDING_PERIMETER).where(Tables.MILESTONE_BINDING_PERIMETER.PROJECT_ID.eq((Object)projectId)).execute();
    }

    @Override
    public List<BindableProjectToMilestoneDto> findBindableProjectByMilestoneId(Long milestoneId, List<Long> manageableProjectIds) {
        List perimeterProjectsIds = this.dsl.selectDistinct((SelectField)Tables.MILESTONE_BINDING_PERIMETER.PROJECT_ID).from((TableLike)Tables.MILESTONE_BINDING_PERIMETER).where(Tables.MILESTONE_BINDING_PERIMETER.MILESTONE_ID.eq((Object)milestoneId)).fetch((Field)Tables.MILESTONE_BINDING_PERIMETER.PROJECT_ID);
        manageableProjectIds.removeAll(perimeterProjectsIds);
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.LABEL).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(manageableProjectIds)).orderBy((OrderField)DSL.lower((Field)Tables.PROJECT.NAME)).fetchInto(BindableProjectToMilestoneDto.class);
    }

    @Override
    public Map<Long, List<String>> findRequirementMilestoneLabelsByReqIds(Collection<Long> requirementIds) {
        if (requirementIds == null || requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.REQUIREMENT).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).fetchGroups((Field)Tables.REQUIREMENT.RLN_ID, (Field)Tables.MILESTONE.LABEL);
    }

    @Override
    public List<Milestone> findByLabelLike(List<String> labels) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(Milestone.class);
        Root root = criteriaQuery.from(Milestone.class);
        List<Predicate> predicates = labels.stream().map(label -> builder.like((jakarta.persistence.criteria.Expression)root.get("label"), label + "%")).toList();
        Predicate orPredicate = builder.or(predicates.toArray(new Predicate[0]));
        criteriaQuery.where((jakarta.persistence.criteria.Expression)orPredicate);
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }
}

