/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jooq.AggregateFunction;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

@Repository(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
public class HibernateTestCaseLibraryNodeDao
extends HibernateEntityDao<TestCaseLibraryNode>
implements TestCaseLibraryNodeDao {
    @Inject
    private DSLContext dsl;

    @Override
    public List<String> getParentsName(long entityId) {
        return this.entityManager.createNamedQuery("TestCasePathEdge.findSortedParentNames", String.class).setParameter("nodeId", (Object)entityId).getResultList();
    }

    @Override
    public List<Long> getParentsIds(long entityId) {
        return this.entityManager.createNamedQuery("TestCasePathEdge.findSortedParentIds", Long.class).setParameter("nodeId", (Object)entityId).getResultList();
    }

    @Override
    public List<TestCaseLibraryNode> findNodesByPath(List<String> path) {
        List<Long> ids = this.findNodeIdsByPath(path);
        List result = this.findAllByIds(ids);
        TestCaseLibraryNode[] toReturn = new TestCaseLibraryNode[ids.size()];
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            TestCaseLibraryNode node;
            toReturn[ids.indexOf((Object)node.getId())] = node = (TestCaseLibraryNode)iterator.next();
        }
        return Arrays.asList(toReturn);
    }

    @Override
    public List<Long> findNodeIdsByPath(List<String> paths) {
        this.entityManager.flush();
        if (!paths.isEmpty()) {
            List<String> effectiveParameters = this.unescapeSlashes(paths);
            List<String> tclnNames = paths.stream().map(PathUtils::splitPath).map(stringArray -> Arrays.asList(stringArray)).filter(pathParts -> pathParts.size() > 1).map(pathParts -> (String)pathParts.get(pathParts.size() - 1)).map(this::unescapeSlashes).toList();
            if (tclnNames.isEmpty()) {
                return Collections.emptyList();
            }
            org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode ancestor = Tables.TEST_CASE_LIBRARY_NODE.as("ancestor");
            org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode descendant = Tables.TEST_CASE_LIBRARY_NODE.as("descendant");
            AggregateFunction groupConcatFunction = DSL.groupConcat((Field)ancestor.NAME).orderBy(new OrderField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/");
            Field concatPath = DSL.concat((Field[])new Field[]{DSL.concat((String)"/", (Field)Tables.PROJECT.NAME), DSL.concat((String)"/", (Field)groupConcatFunction)});
            Map<String, Long> idByPath = this.dsl.select((SelectField)concatPath.as("path"), (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)ancestor).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)ancestor.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(ancestor.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)descendant).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)descendant.TCLN_ID)).where(descendant.NAME.in(tclnNames)).groupBy(new GroupField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.PROJECT.NAME}).having(concatPath.in(effectiveParameters)).fetch().stream().collect(Collectors.toMap(r -> (String)r.get("path", String.class), r -> (Long)r.get((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)));
            return effectiveParameters.stream().map(idByPath::get).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public Long findNodeIdByPath(String path) {
        return this.findNodeIdsByPath(Collections.singletonList(path)).get(0);
    }

    @Override
    public TestCaseLibraryNode findNodeByPath(String path) {
        Long id = this.findNodeIdByPath(path);
        return id != null ? (TestCaseLibraryNode)this.entityManager.getReference(TestCaseLibraryNode.class, (Object)id) : null;
    }

    @Override
    public TreeMap<String, Long> buildNodePathsTree(String projectName) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("id", "path").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)"/"), Tables.TEST_CASE_LIBRARY_NODE.NAME}).cast(SQLDataType.LONGVARCHAR)).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.PROJECT.TCL_ID.eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.PROJECT.NAME.eq((Object)projectName)).union((Select)DSL.select((SelectField)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "path"})).concat(new String[]{"/"}).concat(new Field[]{Tables.TEST_CASE_LIBRARY_NODE.NAME}).cast(SQLDataType.LONGVARCHAR)).from(DSL.name((String)"cte")).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "id"})).eq((Object)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).and(ConditionsConstants.TCLN_NOT_IN_BIN)));
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).orderBy((OrderField)cte.field("path")).fetchStream().collect(Collectors.toMap(r -> (String)r.get("path", String.class), r -> (Long)r.get("id", Long.class), (key1, key2) -> key1, TreeMap::new));
    }

    @Override
    public int countSiblingsOfNode(long nodeId) {
        Integer count = this.entityManager.createNamedQuery("testCase.countSiblingsInFolder", Integer.class).setParameter("nodeId", (Object)nodeId).getResultStream().findFirst().orElse(null);
        if (count == null) {
            count = this.entityManager.createNamedQuery("testCase.countSiblingsInLibrary", Integer.class).setParameter("nodeId", (Object)nodeId).getResultStream().findFirst().orElse(null);
        }
        return count != null ? count + 1 : 0;
    }

    private List<String> unescapeSlashes(List<String> paths) {
        ArrayList<String> unescaped = new ArrayList<String>(paths.size());
        for (String orig : paths) {
            unescaped.add(orig.replace("\\/", "/"));
        }
        return unescaped;
    }

    private String unescapeSlashes(String path) {
        return path.replace("\\/", "/");
    }

    @Override
    public Map<Long, List<Long>> findContentIdsByNodeIds(List<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        CommonTableExpression cte = DSL.name((String)"TCLN_HIERARCHY").fields("ANCESTOR_ID", "DESCENDANT_ID", "CONTENT_ORDER").as((ResultQuery)DSL.select((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)Tables.TCLN_RELATIONSHIP.CONTENT_ORDER).from((TableLike)Tables.TCLN_RELATIONSHIP).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(nodeIds)).union((Select)DSL.select((SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)Tables.TCLN_RELATIONSHIP.CONTENT_ORDER).from(DSL.name((String)"TCLN_HIERARCHY")).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(DSL.field((Name)DSL.name((String[])new String[]{"TCLN_HIERARCHY", "DESCENDANT_ID"})).eq((Object)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN))));
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).orderBy((OrderField)DSL.field((String)"CONTENT_ORDER")).fetchGroups(DSL.field((String)"ANCESTOR_ID", Long.class), DSL.field((String)"DESCENDANT_ID", Long.class));
    }
}

