/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.TeamAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TeamMemberDto;
import org.squashtest.tm.service.internal.repository.display.TeamDisplayDao;

@Repository
public class TeamDisplayDaoImpl
implements TeamDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public TeamAdminViewDto getTeamById(Long teamId) {
        return (TeamAdminViewDto)this.getBaseRequest().where(Tables.CORE_TEAM.PARTY_ID.eq((Object)teamId)).fetchOne().into(TeamAdminViewDto.class);
    }

    @Override
    public List<TeamMemberDto> getMembersByTeam(Long teamId) {
        return this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID, (SelectField)Tables.CORE_USER.FIRST_NAME, (SelectField)Tables.CORE_USER.ACTIVE, (SelectField)Tables.CORE_USER.LAST_NAME, (SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).leftJoin((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.CORE_TEAM_MEMBER.USER_ID)).where(Tables.CORE_TEAM_MEMBER.TEAM_ID.eq((Object)teamId)).fetchInto(TeamMemberDto.class);
    }

    private SelectJoinStep<?> getBaseRequest() {
        return this.dsl.select((SelectField)Tables.CORE_TEAM.PARTY_ID.as("ID"), (SelectField)Tables.CORE_TEAM.NAME, (SelectField)Tables.CORE_TEAM.DESCRIPTION, (SelectField)Tables.CORE_TEAM.CREATED_BY, (SelectField)Tables.CORE_TEAM.CREATED_ON, (SelectField)Tables.CORE_TEAM.LAST_MODIFIED_BY, (SelectField)Tables.CORE_TEAM.LAST_MODIFIED_ON).from((TableLike)Tables.CORE_TEAM);
    }
}

