/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.TestPlanStatus;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.SprintReqVersion;
import org.squashtest.tm.service.internal.display.dto.PathNodeDto;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemDto;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemIdsDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionView;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.repository.display.SprintReqVersionDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
@Transactional(readOnly=true)
public class SprintReqVersionDisplayDaoImpl
implements SprintReqVersionDisplayDao {
    private final EntityPathHeaderDao entityPathHeaderDao;
    private final DSLContext dslContext;

    public SprintReqVersionDisplayDaoImpl(EntityPathHeaderDao entityPathHeaderDao, DSLContext dslContext) {
        this.entityPathHeaderDao = entityPathHeaderDao;
        this.dslContext = dslContext;
    }

    @Override
    public SprintReqVersionView findSprintReqVersionViewById(long sprintReqVersionId) {
        SprintReqVersionView sprintReqVersionDto = (SprintReqVersionView)this.dslContext.select(new SelectFieldOrAsterisk[]{Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as("ID"), Tables.PROJECT.NAME.as("PROJECT_NAME"), Tables.PROJECT.PROJECT_ID, Tables.PROJECT.CL_ID.as("CAMPAIGN_LIBRARY_ID"), this.getReferenceBasedOnReqVersionId().as("REFERENCE"), this.getNameBasedOnReqVersionId().as("NAME"), Tables.REQUIREMENT_VERSION.CATEGORY.as("CATEGORY_ID"), Tables.SPRINT_REQ_VERSION.CATEGORY.as("CATEGORY_LABEL"), this.getCriticalityBasedOnReqVersionId().as("CRITICALITY"), this.getStatusBasedOnReqVersionId().as("STATUS"), Tables.REQUIREMENT_VERSION.RES_ID.as("VERSION_ID"), Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), Tables.SPRINT_REQ_VERSION.SPRINT_ID, this.getDescriptionBasedOnReqVersionId().as("DESCRIPTION"), Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("SPRINT_NAME"), Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID, Tables.SPRINT_REQ_VERSION.MODE, Tables.SPRINT_REQ_VERSION.CREATED_BY, Tables.SPRINT_REQ_VERSION.CREATED_ON, Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_BY, Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_ON, Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS, Tables.SPRINT.STATUS.as("SPRINT_STATUS"), Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_URL, Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE}).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchOneInto(SprintReqVersionView.class);
        Long sprintId = sprintReqVersionDto.getSprintId();
        List<PathNodeDto> crumbs = this.entityPathHeaderDao.getCampaignBreadcrumbNodes(sprintId, false);
        sprintReqVersionDto.setBreadcrumbs(crumbs);
        return sprintReqVersionDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<SprintReqVersionDto> findSprintReqVersionDtosBySprintId(long sprintId) {
        Project requirementVersionProject = Tables.PROJECT.as("REQUIREMENT_VERSION_PROJECT");
        Field reqVersionProjectId = requirementVersionProject.field("PROJECT_ID", Long.class);
        Field reqVersionProjectName = requirementVersionProject.field("NAME", String.class);
        SprintReqVersion sprintReqVersion = Tables.SPRINT_REQ_VERSION.as("SPRINT_REQ_VERSION_ALIAS");
        return this.dslContext.select(new SelectFieldOrAsterisk[]{Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as("ID"), Tables.PROJECT.NAME.as("PROJECT_NAME"), Tables.PROJECT.PROJECT_ID, reqVersionProjectId.as("REQUIREMENT_VERSION_PROJECT_ID"), reqVersionProjectName.as("REQUIREMENT_VERSION_PROJECT_NAME"), this.getReferenceBasedOnReqVersionId().as("REFERENCE"), this.getNameBasedOnReqVersionId().as("NAME"), this.getCategoryBasedOnReqVersionId().as("CATEGORY_ID"), this.getCategoryLabelIfSprintNotClosed().as("CATEGORY_LABEL"), this.getDescriptionBasedOnReqVersionId().as("DESCRIPTION"), this.getCriticalityBasedOnReqVersionId().as("CRITICALITY"), this.getStatusBasedOnReqVersionId().as("STATUS"), Tables.REQUIREMENT_VERSION.RES_ID.as("VERSION_ID"), Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), Tables.SPRINT_REQ_VERSION.SPRINT_ID, Tables.SPRINT_REQ_VERSION.MODE, Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS, Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_PERIMETER_STATUS, Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_URL, DSL.selectCount().from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)sprintReqVersion).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)sprintReqVersion.TEST_PLAN_ID)).where(sprintReqVersion.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).asField("NB_EXECUTIONS"), this.getExecutionStatus().as("TEST_PLAN_EXECUTION_STATUS"), DSL.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)sprintReqVersion).on(Tables.TEST_PLAN.TEST_PLAN_ID.eq((Field)sprintReqVersion.TEST_PLAN_ID)).where(sprintReqVersion.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).asField("NB_TESTS"), this.getRemoteReqStatusAndState().as("REMOTE_REQ_STATUS_AND_STATE")}).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)requirementVersionProject).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq(reqVersionProjectId)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Object)sprintId)).orderBy((OrderField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID).fetchInto(SprintReqVersionDto.class);
    }

    @Override
    public List<SprintReqVersionDto> findSprintReqVersionDtosForDenormalization(long sprintId) {
        return this.dslContext.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as("ID"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REFERENCE"), (SelectField)Tables.RESOURCE.NAME.as("NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as("CRITICALITY"), (SelectField)this.getCategoryLabelforDenormalization().as("CATEGORY_LABEL"), (SelectField)Tables.RESOURCE.DESCRIPTION.as("DESCRIPTION")).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Object)sprintId)).and(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.isNotNull()).and(Tables.SPRINT_REQ_VERSION.MODE.eq((Object)ManagementMode.NATIVE.toString())).orderBy((OrderField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID).fetchInto(SprintReqVersionDto.class);
    }

    private Field<String> getCategoryLabelforDenormalization() {
        return this.dslContext.select((SelectField)Tables.INFO_LIST_ITEM.LABEL).from((TableLike)Tables.INFO_LIST_ITEM).where(Tables.INFO_LIST_ITEM.ITEM_ID.eq((Select)this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.CATEGORY))).asField();
    }

    private Field<String> getCategoryLabelIfSprintNotClosed() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.CATEGORY);
    }

    private SelectField<Long> getCategoryBasedOnReqVersionId() {
        return DSL.when((Condition)DSL.not((Condition)this.shouldNotDisplayReqVersionData()), (Field)Tables.REQUIREMENT_VERSION.CATEGORY);
    }

    private Field<String> getReferenceBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.REFERENCE).otherwise((Field)Tables.REQUIREMENT_VERSION.REFERENCE);
    }

    private Field<String> getNameBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.NAME).otherwise((Field)Tables.RESOURCE.NAME);
    }

    private Field<String> getCriticalityBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.CRITICALITY).otherwise((Field)Tables.REQUIREMENT_VERSION.CRITICALITY);
    }

    private Field<String> getStatusBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.STATUS).otherwise((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS);
    }

    private Field<String> getDescriptionBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.DESCRIPTION).otherwise((Field)Tables.RESOURCE.DESCRIPTION);
    }

    private Field<String> getRemoteReqStatusAndState() {
        return DSL.when((Condition)Tables.SPRINT_REQ_VERSION.STATUS.isNull().or(Tables.SPRINT_REQ_VERSION.STATUS.eq((Object)"")), (Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE).otherwise(DSL.when((Condition)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE.isNull(), (Field)Tables.SPRINT_REQ_VERSION.STATUS).otherwise(Tables.SPRINT_REQ_VERSION.STATUS.concat(new Field[]{DSL.inline((String)", "), Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE})));
    }

    private Condition shouldNotDisplayReqVersionData() {
        return Tables.SPRINT_REQ_VERSION.MODE.eq((Object)ManagementMode.SYNCHRONIZED.name()).or(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.isNull()).or(Tables.SPRINT_REQ_VERSION.MODE.eq((Object)ManagementMode.NATIVE.name()).and(Tables.SPRINT.STATUS.eq((Object)SprintStatus.CLOSED.name())));
    }

    @Override
    public List<AvailableTestPlanItemDto> findAvailableTestPlanItems(long sprintReqVersionId) {
        List alreadyPlannedItems = this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_PLAN_ITEM.DATASET_ID, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchInto(AvailableTestPlanItemDto.class);
        List coverageItems = this.dslContext.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchInto(AvailableTestPlanItemDto.class);
        coverageItems.removeIf(coverageItem -> SprintReqVersionDisplayDaoImpl.isAlreadyPlanned(coverageItem, alreadyPlannedItems));
        return coverageItems;
    }

    @Override
    public List<AvailableTestPlanItemIdsDto> findAvailableTestPlanItemIds(long sprintReqVersionId) {
        return this.dslContext.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.DATASET.DATASET_ID).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchInto(AvailableTestPlanItemIdsDto.class);
    }

    private static boolean isAlreadyPlanned(AvailableTestPlanItemDto coverageItem, List<AvailableTestPlanItemDto> alreadyPlannedItems) {
        return alreadyPlannedItems.stream().anyMatch(alreadyPlannedItem -> SprintReqVersionDisplayDaoImpl.compareItems(coverageItem, alreadyPlannedItem));
    }

    private static boolean compareItems(AvailableTestPlanItemDto coverageItem, AvailableTestPlanItemDto alreadyPlannedItem) {
        if (alreadyPlannedItem.testCaseId() == null) {
            return false;
        }
        if (!alreadyPlannedItem.testCaseId().equals(coverageItem.testCaseId())) {
            return false;
        }
        if (alreadyPlannedItem.datasetId() == null && coverageItem.datasetId() == null) {
            return true;
        }
        if (alreadyPlannedItem.datasetId() == null || coverageItem.datasetId() == null) {
            return false;
        }
        return alreadyPlannedItem.datasetId().equals(coverageItem.datasetId());
    }

    private Field<String> getExecutionStatus() {
        SprintReqVersion srvAlias = Tables.SPRINT_REQ_VERSION.as("SPRINT_REQ_VERSION_ALIAS");
        Field totalCount = DSL.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)srvAlias).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)srvAlias.TEST_PLAN_ID)).where(srvAlias.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).asField();
        Field finishedCount = DSL.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)srvAlias).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)srvAlias.TEST_PLAN_ID)).where(srvAlias.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.notIn((Object[])new String[]{ExecutionStatus.READY.name(), ExecutionStatus.RUNNING.name()})).asField();
        Field readyCount = DSL.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)srvAlias).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)srvAlias.TEST_PLAN_ID)).where(srvAlias.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.eq((Object)ExecutionStatus.READY.name())).asField();
        return DSL.when((Condition)readyCount.eq(totalCount), (Field)DSL.val((String)ExecutionStatus.READY.name())).when(finishedCount.eq(totalCount), (Field)DSL.val((String)TestPlanStatus.DONE.name())).otherwise((Object)ExecutionStatus.RUNNING.name());
    }
}

