/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.ScmRepositoryDto;
import org.squashtest.tm.service.internal.display.dto.ScmServerAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.ScmServerDto;
import org.squashtest.tm.service.internal.repository.display.ScmServerDisplayDao;
import org.squashtest.tm.service.spi.ScmConnector;
import org.squashtest.tm.service.spi.ScmServerKind;

@Repository
public class ScmServerDisplayDaoImpl
implements ScmServerDisplayDao {
    private final DSLContext dslContext;
    @Autowired(required=false)
    private final Collection<ScmConnector> connectors = Collections.emptyList();

    public ScmServerDisplayDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public ScmServerAdminViewDto getScmServerViewById(long scmServerId) {
        return (ScmServerAdminViewDto)((Record12)this.dslContext.select((SelectField)Tables.SCM_SERVER.SERVER_ID, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL, (SelectField)Tables.SCM_SERVER.KIND, (SelectField)Tables.SCM_SERVER.COMMITTER_MAIL, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_POLICY, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_PROTOCOL, (SelectField)Tables.THIRD_PARTY_SERVER.DESCRIPTION, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_BY).from((TableLike)Tables.SCM_SERVER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.SCM_SERVER.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).where(Tables.SCM_SERVER.SERVER_ID.eq((Object)scmServerId)).fetchOne()).into(ScmServerAdminViewDto.class);
    }

    @Override
    public List<ScmServerDto> findAll() {
        ArrayList<ScmServerDto> scmServers = new ArrayList<ScmServerDto>();
        Map record = this.dslContext.select((SelectField)Tables.SCM_SERVER.SERVER_ID, (SelectField)Tables.SCM_SERVER.KIND, (SelectField)Tables.SCM_SERVER.COMMITTER_MAIL, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL, (SelectField)Tables.SCM_REPOSITORY.SERVER_ID, (SelectField)Tables.SCM_REPOSITORY.NAME, (SelectField)Tables.SCM_REPOSITORY.REPOSITORY_PATH, (SelectField)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID, (SelectField)Tables.SCM_REPOSITORY.WORKING_BRANCH, (SelectField)Tables.SCM_REPOSITORY.WORKING_FOLDER_PATH).from((TableLike)Tables.SCM_SERVER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.SCM_SERVER.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).innerJoin((TableLike)Tables.SCM_REPOSITORY).on(Tables.SCM_SERVER.SERVER_ID.eq((Field)Tables.SCM_REPOSITORY.SERVER_ID)).orderBy((OrderField)Tables.THIRD_PARTY_SERVER.SERVER_ID, (OrderField)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID).fetch().intoGroups(Arrays.asList(Tables.SCM_SERVER.SERVER_ID, Tables.SCM_SERVER.KIND, Tables.SCM_SERVER.COMMITTER_MAIL, Tables.THIRD_PARTY_SERVER.NAME, Tables.THIRD_PARTY_SERVER.URL).toArray(new Field[0]));
        record.entrySet().forEach(recordEntry -> {
            ScmServerDto scmServerDto = new ScmServerDto();
            scmServerDto.setServerId((Long)((Record)recordEntry.getKey()).get((Field)Tables.SCM_SERVER.SERVER_ID));
            scmServerDto.setName((String)((Record)recordEntry.getKey()).get((Field)Tables.THIRD_PARTY_SERVER.NAME));
            scmServerDto.setCommitterMail((String)((Record)recordEntry.getKey()).get((Field)Tables.SCM_SERVER.COMMITTER_MAIL));
            scmServerDto.setKind((String)((Record)recordEntry.getKey()).get((Field)Tables.SCM_SERVER.KIND));
            scmServerDto.setUrl((String)((Record)recordEntry.getKey()).get((Field)Tables.THIRD_PARTY_SERVER.URL));
            scmServers.add(scmServerDto);
            ((Result)recordEntry.getValue()).forEach(value -> {
                ScmRepositoryDto scmRepositoryDto = new ScmRepositoryDto();
                scmRepositoryDto.setScmRepositoryId((Long)value.get((Field)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID));
                scmRepositoryDto.setServerId((Long)value.get((Field)Tables.SCM_REPOSITORY.SERVER_ID));
                scmRepositoryDto.setName((String)value.get((Field)Tables.SCM_REPOSITORY.NAME));
                scmRepositoryDto.setRepositoryPath((String)value.get((Field)Tables.SCM_REPOSITORY.REPOSITORY_PATH));
                scmRepositoryDto.setWorkingBranch((String)value.get((Field)Tables.SCM_REPOSITORY.WORKING_BRANCH));
                scmRepositoryDto.setWorkingFolderPath((String)value.get((Field)Tables.SCM_REPOSITORY.WORKING_FOLDER_PATH));
                scmServerDto.getRepositories().add(scmRepositoryDto);
            });
        });
        return scmServers;
    }

    @Override
    public List<Long> findAllRepositoriesByServerIds(List<Long> scmServerIds) {
        if (scmServerIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dslContext.select((SelectField)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID).from((TableLike)Tables.SCM_REPOSITORY).where(Tables.SCM_REPOSITORY.SERVER_ID.in(scmServerIds)).fetchInto(Long.class);
    }

    @Override
    public Set<ScmServerKind> findAllAvailableKinds() {
        return this.connectors.stream().map(ScmConnector::getConnectorKind).collect(Collectors.toSet());
    }
}

